/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.util.JiraUrlCodec;
import io.swagger.v3.oas.annotations.media.Schema;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="resolution")
public class ResolutionBean {
    @XmlElement
    @Schema(example="http://www.example.com/jira/rest/api/2/resolution/1")
    private URI self;
    @XmlElement
    @Schema(example="A fix for this issue is checked into the tree and tested.")
    private String description;
    @XmlElement
    @Schema(example="http://www.example.com/jira/images/icons/statuses/resolved.png")
    private String iconUrl;
    @XmlElement
    @Schema(example="Fixed")
    private String name;
    @XmlElement
    @Schema(example="1")
    private String id;

    public static ResolutionBean shortBean(Resolution resolution, JiraBaseUrls urls) {
        ResolutionBean bean = new ResolutionBean();
        bean.self = URI.create(urls.restApi2BaseUrl() + "resolution/" + JiraUrlCodec.encode((String)resolution.getId()));
        bean.name = resolution.getNameTranslation();
        bean.id = resolution.getId();
        return bean;
    }

    public static ResolutionBean fullBean(Resolution resolution, JiraBaseUrls urls) {
        ResolutionBean bean = ResolutionBean.shortBean(resolution, urls);
        bean.description = resolution.getDescTranslation();
        return bean;
    }

    public static Collection<ResolutionBean> asBeans(Collection<? extends Resolution> priorities, JiraBaseUrls urls) {
        ArrayList<ResolutionBean> list = new ArrayList<ResolutionBean>(priorities.size());
        for (Resolution resolution : priorities) {
            list.add(ResolutionBean.shortBean(resolution, urls));
        }
        return list;
    }
}

