/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.rest.api.common.IconBean;
import io.swagger.v3.oas.annotations.media.Schema;
import java.net.URI;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="remotelink")
public class RemoteIssueLinkBean {
    @XmlElement
    @Schema(example="10000")
    private Long id;
    @XmlElement
    @Schema(example="http://www.example.com/jira/rest/api/2/issue/10000/remotelink/10000")
    private URI self;
    @XmlElement
    @Schema(example="system=http://www.mycompany.com/support&id=1")
    private String globalId;
    @XmlElement
    private Application application;
    @XmlElement
    @Schema(example="causes")
    private String relationship;
    @XmlElement
    private RemoteObject object;

    public RemoteIssueLinkBean(Long id, URI self, String globalId, String applicationType, String applicationName, String relationship, String url, String title, String summary, String iconUrl, String iconTitle, Boolean resolved, String statusIconUrl, String statusIconTitle, String statusIconLink) {
        this.id = id;
        this.self = self;
        this.globalId = globalId;
        this.application = new Application(applicationType, applicationName);
        this.relationship = relationship;
        this.object = new RemoteObject(url, title, summary, iconUrl, iconTitle, resolved, statusIconUrl, statusIconTitle, statusIconLink);
    }

    private static class Application {
        @XmlElement
        @Schema(example="com.acme.app")
        private String type;
        @XmlElement
        @Schema(example="My Acme Tracker")
        private String name;

        private Application(String type, String name) {
            this.type = type;
            this.name = name;
        }
    }

    private static class RemoteObject {
        @XmlElement
        @Schema(example="http://www.mycompany.com/support?id=1")
        private String url;
        @XmlElement
        @Schema(example="TSTSUP-111")
        private String title;
        @XmlElement
        @Schema(example="Crazy customer support issue")
        private String summary;
        @XmlElement
        private IconBean icon;
        @XmlElement
        private Status status;

        private RemoteObject(String url, String title, String summary, String iconUrl, String iconTitle, Boolean resolved, String statusIconUrl, String statusIconTitle, String statusIconLink) {
            this.url = url;
            this.title = title;
            this.summary = summary;
            this.icon = new IconBean(iconUrl, iconTitle, null);
            this.status = new Status(resolved, statusIconUrl, statusIconTitle, statusIconLink);
        }

        private static class Status {
            @XmlElement
            @Schema(example="true")
            private Boolean resolved;
            @XmlElement
            private IconBean icon;

            private Status(Boolean resolved, String iconUrl, String iconTitle, String iconLink) {
                this.resolved = resolved;
                this.icon = new IconBean(iconUrl, iconTitle, iconLink);
            }
        }
    }
}

