/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.jira.workflow.migration.AssignableWorkflowSchemeMigrationHelper;
import com.atlassian.jira.workflow.migration.MigrationHelperFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class ProjectWorkflowSchemeAssignor {
    private final Logger logger = LoggerFactory.getLogger(ProjectWorkflowSchemeAssignor.class);
    private final WorkflowSchemeManager workflowSchemeManager;
    private final WorkflowManager workflowManager;
    private final MigrationHelperFactory migrationHelperFactory;
    private final I18nHelper.BeanFactory i18nFactory;
    private final ProjectService projectService;

    @Autowired
    ProjectWorkflowSchemeAssignor(@ComponentImport WorkflowSchemeManager workflowSchemeManager, WorkflowManager workflowManager, @ComponentImport MigrationHelperFactory migrationHelperFactory, I18nHelper.BeanFactory i18nFactory, ProjectService projectService) {
        this.workflowSchemeManager = workflowSchemeManager;
        this.workflowManager = workflowManager;
        this.migrationHelperFactory = migrationHelperFactory;
        this.i18nFactory = i18nFactory;
        this.projectService = projectService;
    }

    ServiceOutcome<Boolean> validateWorkflowScheme(Long requestedWorkflowSchemeId, ApplicationUser user) {
        if (this.isOptionalWorkflowSchemeNotRequested(requestedWorkflowSchemeId)) {
            return ServiceOutcomeImpl.ok((Object)false);
        }
        I18nHelper i18nBean = this.i18nFactory.getInstance(user);
        try {
            Scheme scheme = this.workflowSchemeManager.getSchemeObject(requestedWorkflowSchemeId);
            if (scheme == null) {
                this.logger.debug("Validation WorkflowScheme failed, requestedWorkflowSchemeId={} not retrieved", (Object)requestedWorkflowSchemeId);
                return ServiceOutcomeImpl.error((String)i18nBean.getText("admin.errors.project.validation.workflowScheme.scheme.not.exist"), (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED);
            }
        }
        catch (DataAccessException e) {
            this.logger.debug("Validation WorkflowScheme failed, requestedWorkflowSchemeId={} Error happen during getting it, ", (Object)requestedWorkflowSchemeId, (Object)e);
            return ServiceOutcomeImpl.error((String)i18nBean.getText("admin.errors.project.validation.workflowScheme.scheme.not.retrieved.error"), (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED);
        }
        return ServiceOutcomeImpl.ok((Object)true);
    }

    private boolean isOptionalWorkflowSchemeNotRequested(Long requestedWorkflowSchemeId) {
        return requestedWorkflowSchemeId == null || requestedWorkflowSchemeId == -1L;
    }

    ServiceOutcome<Boolean> assignWorkflowSchemeIfRequestedForNewProject(Project newProject, Long requestedWorkflowSchemeId, ApplicationUser user) {
        if (this.isOptionalWorkflowSchemeNotRequested(requestedWorkflowSchemeId)) {
            return ServiceOutcomeImpl.ok((Object)false);
        }
        Scheme currentWorkflowScheme = this.workflowSchemeManager.getSchemeFor(newProject);
        if (currentWorkflowScheme != null && currentWorkflowScheme.getId().equals(requestedWorkflowSchemeId)) {
            return ServiceOutcomeImpl.ok((Object)false);
        }
        this.logger.info("Assigning requestedWorkflowSchemeId={} into new project with projectId={}", (Object)requestedWorkflowSchemeId, (Object)newProject.getId());
        try {
            AssignableWorkflowScheme targetScheme = this.workflowSchemeManager.getWorkflowSchemeObj(requestedWorkflowSchemeId.longValue());
            AssignableWorkflowSchemeMigrationHelper migrationHelper = this.migrationHelperFactory.createMigrationHelper(newProject, targetScheme);
            boolean isAssigned = this.assignNewWorkflowScheme(migrationHelper);
            if (!isAssigned) {
                this.logger.info("WorkflowSchemeId={} could not be assigned to projectId={}", (Object)requestedWorkflowSchemeId, (Object)newProject.getId());
                return ServiceOutcomeImpl.error((String)"admin.errors.project.assign.workflowscheme.not.possible", (ErrorCollection.Reason)ErrorCollection.Reason.CONFLICT);
            }
            this.removeDefaultWorkflowAndWorkflowSchemesFromProject(currentWorkflowScheme);
            return ServiceOutcomeImpl.ok((Object)true);
        }
        catch (Exception e) {
            this.logger.error("Assigning workflowScheme to createdProject failed with error, ", (Throwable)e);
            this.rollbackCreatedProjectAndDelete(newProject, user);
            return ServiceOutcomeImpl.error((String)("admin.errors.project.assign.workflowscheme.failed" + (String)(e.getMessage() == null ? "" : "." + e.getMessage())), (ErrorCollection.Reason)ErrorCollection.Reason.SERVER_ERROR);
        }
        catch (Error e) {
            this.logger.error("Fatal error during assigning workflowScheme to createdProject failed with error, ", (Throwable)e);
            this.rollbackCreatedProjectAndDelete(newProject, user);
            throw e;
        }
    }

    private void rollbackCreatedProjectAndDelete(Project newProject, ApplicationUser user) {
        this.logger.info("Doing rollback and deleting projectId={}", (Object)newProject.getId());
        ProjectService.DeleteProjectValidationResult deleteProjectValidationResult = this.projectService.validateDeleteProject(user, newProject.getKey());
        if (!deleteProjectValidationResult.isValid()) {
            this.logger.info("Deleting projectId={} validation failed, project cannot be rollback, result={}", (Object)newProject.getId(), (Object)deleteProjectValidationResult);
            return;
        }
        ProjectService.DeleteProjectResult deleteProjectResult = this.projectService.deleteProject(user, deleteProjectValidationResult);
        if (!deleteProjectResult.isValid()) {
            this.logger.info("ProjectId={} could not deleted, result={}", (Object)deleteProjectValidationResult);
            return;
        }
        this.logger.debug("Deleted project successfully={}", (Object)deleteProjectResult.isValid());
    }

    private boolean assignNewWorkflowScheme(AssignableWorkflowSchemeMigrationHelper migrationHelper) throws Exception {
        try {
            boolean isAutomaticMigrationWorked = migrationHelper.doQuickMigrate();
            this.logger.debug("isAutomaticMigrationWorked={}", (Object)isAutomaticMigrationWorked);
            return isAutomaticMigrationWorked;
        }
        catch (RuntimeException e) {
            this.logger.error("assigning newWorkflowScheme failed", (Throwable)e);
            throw e;
        }
    }

    private void removeDefaultWorkflowAndWorkflowSchemesFromProject(Scheme previousDefaultWorkflowScheme) throws Exception {
        if (previousDefaultWorkflowScheme != null) {
            this.logger.debug("Removing previousDefaultWorkflowScheme={}", (Object)previousDefaultWorkflowScheme);
            AssignableWorkflowScheme previousDefaultWorkflowSchemeObj = this.workflowSchemeManager.getWorkflowSchemeObj(previousDefaultWorkflowScheme.getId().longValue());
            Iterable workflowsFromScheme = this.workflowManager.getWorkflowsFromScheme(previousDefaultWorkflowScheme);
            workflowsFromScheme.forEach(jiraWorkflow -> {
                AssignableWorkflowScheme newWScheme = ((AssignableWorkflowScheme.Builder)previousDefaultWorkflowSchemeObj.builder().removeWorkflow(jiraWorkflow.getName())).build();
                this.workflowSchemeManager.updateWorkflowScheme(newWScheme);
                this.workflowManager.deleteWorkflow(jiraWorkflow);
            });
            this.workflowSchemeManager.deleteScheme(previousDefaultWorkflowScheme.getId());
            this.logger.debug("Removed previousDefaultWorkflowScheme={} successfully", (Object)previousDefaultWorkflowScheme);
        }
    }
}

