/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="projectvalidate")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@LicensedOnly
public class ProjectValidateResource {
    private ProjectService projectService;
    private JiraAuthenticationContext authContext;

    private ProjectValidateResource() {
    }

    @Inject
    public ProjectValidateResource(ProjectService projectService, JiraAuthenticationContext authContext) {
        this.projectService = projectService;
        this.authContext = authContext;
    }

    @GET
    @Path(value="key")
    @Operation(summary="Get project key validation", description="Validates a project key.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="key", description="The project key", required=true)
    @ApiResponses(value={@ApiResponse(description="Returns an ErrorCollection containing any validation errors for the project key. If the project key is valid, the ErrorCollection will be empty.", responseCode="200", content={@Content(schema=@Schema(implementation=ErrorCollection.class), mediaType="application/json")}), @ApiResponse(description="Returned if the user is not logged in.", responseCode="401")})
    public Response getProject(@QueryParam(value="key") String key) {
        JiraServiceContext context = this.getContext();
        this.projectService.isValidProjectKey(context, key);
        ErrorCollection errors = ErrorCollection.of(context.getErrorCollection());
        return Response.ok((Object)errors).cacheControl(CacheControl.never()).build();
    }

    private JiraServiceContext getContext() {
        return new JiraServiceContextImpl(this.authContext.getUser());
    }
}

