/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarPickerHelper;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectCreationData;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.project.component.ProjectComponentService;
import com.atlassian.jira.bc.project.version.VersionService;
import com.atlassian.jira.blueprint.core.api.CoreProjectConfigurator;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.StatusJsonBean;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.archiving.ArchivedProjectService;
import com.atlassian.jira.project.template.ProjectTemplateKey;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.rest.api.issue.IssueTypeWithStatusJsonBean;
import com.atlassian.jira.rest.api.pagination.PageBean;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.BadRequestWebException;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.util.AttachmentHelper;
import com.atlassian.jira.rest.util.ProjectFinder;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.util.StatusHelper;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.rest.v2.EndpointUsageEvent;
import com.atlassian.jira.rest.v2.issue.AvatarBean;
import com.atlassian.jira.rest.v2.issue.AvatarCroppingBean;
import com.atlassian.jira.rest.v2.issue.AvatarResourceHelper;
import com.atlassian.jira.rest.v2.issue.IssueTypeResource;
import com.atlassian.jira.rest.v2.issue.ProjectWorkflowSchemeAssignor;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.rest.v2.issue.ResourceUriBuilder;
import com.atlassian.jira.rest.v2.issue.StatusResource;
import com.atlassian.jira.rest.v2.issue.component.ComponentBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectBeanFactory;
import com.atlassian.jira.rest.v2.issue.project.ProjectIdentity;
import com.atlassian.jira.rest.v2.issue.project.ProjectInputBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectUpdateBean;
import com.atlassian.jira.rest.v2.issue.version.VersionBean;
import com.atlassian.jira.rest.v2.issue.version.VersionBeanFactory;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.XsrfCheckResult;
import com.atlassian.jira.security.xsrf.XsrfInvocationChecker;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollections;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.OrderByRequest;
import com.atlassian.jira.util.OrderByRequestParser;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import com.atlassian.jira.util.PageRequests;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.multipart.FilePart;
import com.atlassian.plugins.rest.api.multipart.MultipartFormParam;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.plugins.rest.api.security.annotation.CorsAllowed;
import com.atlassian.plugins.rest.api.security.exception.XsrfCheckFailedException;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;

@Path(value="project")
@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@CorsAllowed
public class ProjectResource {
    public static final int MAX_RECENT_PROJECTS = 20;
    private final ProjectService projectService;
    private final UserManager userManager;
    private final JiraAuthenticationContext authContext;
    private final UriInfo uriInfo;
    private final ProjectManager projectManager;
    private final AvatarResourceHelper avatarResourceHelper;
    private final VersionService versionService;
    private final ProjectComponentService projectComponentService;
    private final ProjectBeanFactory projectBeanFactory;
    private final VersionBeanFactory versionBeanFactory;
    private final PermissionManager permissionManager;
    private final AvatarService avatarService;
    private final JiraBaseUrls jiraBaseUrls;
    private final WorkflowManager workflowManager;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final PermissionSchemeManager permissionSchemeManager;
    private final NotificationSchemeManager notificationSchemeManager;
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    private final ResourceUriBuilder uriBuilder;
    private final StatusHelper statusHelper;
    private final ProjectFinder projectFinder;
    private final XsrfInvocationChecker xsrfChecker;
    private final ResponseFactory responses;
    private final UserProjectHistoryManager projectHistoryManager;
    private final I18nHelper i18nHelper;
    private final CoreProjectConfigurator coreProjectConfigurator;
    private final ArchivedProjectService archivedProjectService;
    private final OrderByRequestParser orderByRequestParser;
    private final GlobalPermissionManager globalPermissionManager;
    private final ProjectWorkflowSchemeAssignor projectWorkflowSchemeAssignor;
    private final EventPublisher eventPublisher;

    @Inject
    public ProjectResource(ProjectService projectService, JiraAuthenticationContext authContext, UriInfo uriInfo, VersionService versionService, ProjectComponentService projectComponentService, AvatarService avatarService, UserManager userManager, ProjectBeanFactory projectBeanFactory, VersionBeanFactory versionBeanFactory, PermissionManager permissionManager, ProjectManager projectManager, AvatarManager avatarManager, AvatarPickerHelper avatarPickerHelper, AttachmentHelper attachmentHelper, JiraBaseUrls jiraBaseUrls, WorkflowManager workflowManager, IssueTypeSchemeManager issueTypeSchemeManager, PermissionSchemeManager permissionSchemeManager, NotificationSchemeManager notificationSchemeManager, IssueSecuritySchemeManager issueSecuritySchemeManager, ResourceUriBuilder uriBuilder, StatusHelper statusHelper, ProjectFinder projectFinder, XsrfInvocationChecker xsrfChecker, UserProjectHistoryManager projectHistoryManager, ResponseFactory responses, I18nHelper i18nHelper, CoreProjectConfigurator coreProjectConfigurator, @ComponentImport ArchivedProjectService archivedProjectService, OrderByRequestParser orderByRequestParser, ProjectWorkflowSchemeAssignor projectWorkflowSchemeAssignor, EventPublisher eventPublisher) {
        this.workflowManager = workflowManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.permissionSchemeManager = permissionSchemeManager;
        this.notificationSchemeManager = notificationSchemeManager;
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.uriBuilder = uriBuilder;
        this.statusHelper = statusHelper;
        this.projectFinder = projectFinder;
        this.responses = responses;
        this.projectHistoryManager = projectHistoryManager;
        this.i18nHelper = i18nHelper;
        this.archivedProjectService = archivedProjectService;
        this.orderByRequestParser = orderByRequestParser;
        this.projectWorkflowSchemeAssignor = projectWorkflowSchemeAssignor;
        this.eventPublisher = eventPublisher;
        this.avatarResourceHelper = new AvatarResourceHelper(authContext, avatarManager, avatarService, avatarPickerHelper, attachmentHelper, userManager);
        this.permissionManager = permissionManager;
        this.avatarService = avatarService;
        this.projectService = projectService;
        this.authContext = authContext;
        this.versionService = versionService;
        this.projectComponentService = projectComponentService;
        this.userManager = userManager;
        this.projectBeanFactory = projectBeanFactory;
        this.versionBeanFactory = versionBeanFactory;
        this.uriInfo = uriInfo;
        this.projectManager = projectManager;
        this.jiraBaseUrls = jiraBaseUrls;
        this.xsrfChecker = xsrfChecker;
        this.coreProjectConfigurator = coreProjectConfigurator;
        this.globalPermissionManager = ComponentAccessor.getGlobalPermissionManager();
    }

    @GET
    @Path(value="{projectIdOrKey}")
    @Operation(summary="Get a project by ID or key", description="Returns a full representation of a project in JSON format. All project keys associated with the project will only be returned if <code>expand=projectKeys</code>.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="projectIdOrKey", description="Project id or project key", required=true), @Parameter(name="expand", description="Parameters to expand")})
    @ApiResponses(value={@ApiResponse(description="Project data", responseCode="200", content={@Content(schema=@Schema(implementation=ProjectBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the project is not found, or the calling user does not have permission to view it", responseCode="404")})
    public Response getProject(@PathParam(value="projectIdOrKey") String projectIdOrKey, @QueryParam(value="expand") String expand) {
        return (Response)this.getProjectForView(projectIdOrKey, ProjectAction.VIEW_ARCHIVED_PROJECT).left().on(project -> Response.ok((Object)this.projectBeanFactory.fullProject((Project)project, StringUtils.defaultString((String)expand))).cacheControl(com.atlassian.jira.rest.api.http.CacheControl.never()).build());
    }

    @POST
    @Operation(summary="Create a new project", description="Creates a new project", security={@SecurityRequirement(name="basic")})
    @RequestBody(description="Project data", required=true, content={@Content(schema=@Schema(implementation=ProjectInputBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Created project data", responseCode="201", content={@Content(schema=@Schema(implementation=ProjectIdentity.class), mediaType="application/json")}), @ApiResponse(description="Returned if the request is not valid and the project could not be created", responseCode="400"), @ApiResponse(description="Returned if the user is not authenticated", responseCode="401"), @ApiResponse(description="Returned if the user does not have rights to create projects", responseCode="403"), @ApiResponse(description="Returned if requested workflowScheme could not be assigned to created project", responseCode="409")})
    public Response createProject(ProjectInputBean project) {
        ProjectCreationData projectCreationData;
        if (!this.authContext.isLoggedInUser()) {
            return this.responses.notLoggedInResponse();
        }
        ApplicationUser loggedInUser = this.authContext.getLoggedInUser();
        ProjectService.CreateProjectValidationResult validationResult = this.projectService.validateCreateProject(loggedInUser, projectCreationData = this.toProjectCreationData().apply(project));
        if (!validationResult.isValid()) {
            return this.responses.errorResponse(validationResult.getErrorCollection());
        }
        ProjectService.UpdateProjectSchemesValidationResult schemesValidationResult = this.projectService.validateUpdateProjectSchemes(loggedInUser, project.getPermissionScheme(), project.getNotificationScheme(), project.getIssueSecurityScheme());
        if (!schemesValidationResult.isValid()) {
            return this.responses.errorResponse(schemesValidationResult.getErrorCollection());
        }
        ServiceOutcome<Boolean> validateWorkflowSchemeOutcome = this.projectWorkflowSchemeAssignor.validateWorkflowScheme(project.getWorkflowSchemeId(), loggedInUser);
        if (!validateWorkflowSchemeOutcome.isValid()) {
            return this.responses.errorResponse(validateWorkflowSchemeOutcome.getErrorCollection());
        }
        return (Response)this.loadProjectCategory(project.getCategoryId()).left().on(maybeCategory -> {
            Project createdProject = this.projectService.createProject(validationResult);
            this.projectService.updateProjectSchemes(schemesValidationResult, createdProject);
            ServiceOutcome<Boolean> assignWorkflowSchemeInProjectCreation = this.projectWorkflowSchemeAssignor.assignWorkflowSchemeIfRequestedForNewProject(createdProject, project.getWorkflowSchemeId(), loggedInUser);
            if (!assignWorkflowSchemeInProjectCreation.isValid()) {
                return this.responses.errorResponse(assignWorkflowSchemeInProjectCreation.getErrorCollection());
            }
            if (this.shouldApplyCoreProjectConfiguration(projectCreationData)) {
                this.coreProjectConfigurator.configure(createdProject);
            }
            ProjectIdentity responseEntity = this.projectBeanFactory.projectIdentity(createdProject);
            if (maybeCategory.isDefined()) {
                this.projectManager.setProjectCategory(createdProject, (ProjectCategory)maybeCategory.get());
            }
            if (Boolean.TRUE.equals(assignWorkflowSchemeInProjectCreation.get())) {
                this.publishAnalytics("project.create.assignWorkflowScheme", createdProject);
            }
            this.publishAnalytics("project.create", createdProject);
            return Response.status((Response.Status)Response.Status.CREATED).location(responseEntity.getSelf()).entity((Object)responseEntity).build();
        });
    }

    private boolean shouldApplyCoreProjectConfiguration(ProjectCreationData projectCreationData) {
        ProjectTemplateKey projectTemplateKey = projectCreationData.getProjectTemplateKey();
        return projectTemplateKey == null || StringUtils.isEmpty((CharSequence)projectTemplateKey.getKey());
    }

    private Function<ProjectInputBean, ProjectCreationData> toProjectCreationData() {
        return projectInputBean -> {
            ProjectCreationData.Builder builder = new ProjectCreationData.Builder().withName(projectInputBean.getName()).withKey(projectInputBean.getKey()).withDescription(projectInputBean.getDescription()).withLead(this.userManager.getUserByName(projectInputBean.getLead())).withUrl(projectInputBean.getUrl()).withAssigneeType(Long.valueOf(projectInputBean.getAssigneeType().getId())).withAvatarId(projectInputBean.getAvatarId()).withProjectTemplateKey(projectInputBean.getProjectTemplateKey()).withType(projectInputBean.getProjectTypeKey());
            return builder.build();
        };
    }

    private Either<Response, Option<ProjectCategory>> loadProjectCategory(Long categoryId) {
        if (categoryId != null) {
            ProjectCategory category = this.projectManager.getProjectCategoryObject(categoryId);
            if (category != null) {
                return Either.right((Object)Option.some((Object)category));
            }
            return Either.left((Object)this.responses.errorResponse(ErrorCollections.validationError((String)"projectCategory", (String)this.i18nHelper.getText("admin.errors.project.category.does.not.exist"))));
        }
        return Either.right((Object)Option.none());
    }

    @PUT
    @Path(value="{projectIdOrKey}")
    @Operation(summary="Update a project", description="Updates a project. Only non null values sent in JSON will be updated in the project. Values available for the assigneeType field are: \"PROJECT_LEAD\" and \"UNASSIGNED\".", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="projectIdOrKey", description="Project id or project key", required=true), @Parameter(name="expand", description="Parameters to expand")})
    @RequestBody(description="Project update data", required=true, content={@Content(schema=@Schema(implementation=ProjectUpdateBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Updated project data", responseCode="200", content={@Content(schema=@Schema(implementation=ProjectBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the request is not valid and the project could not be updated", responseCode="400"), @ApiResponse(description="Returned if the user is not authenticated", responseCode="401"), @ApiResponse(description="Returned if the user does not have rights to update projects", responseCode="403"), @ApiResponse(description="Returned if the project does not exist", responseCode="404")})
    public Response updateProject(@PathParam(value="projectIdOrKey") String projectIdOrKey, @QueryParam(value="expand") String expand, ProjectUpdateBean updateData) {
        if (!this.authContext.isLoggedInUser()) {
            return this.responses.notLoggedInResponse();
        }
        return (Response)this.getProjectForEdit(projectIdOrKey).left().on(projectToEdit -> {
            ProjectService.UpdateProjectValidationResult basicValidationResult = this.projectService.validateUpdateProject(this.authContext.getLoggedInUser(), ProjectResource.requestProjectUpdate(projectToEdit, updateData));
            if (!basicValidationResult.isValid()) {
                return this.responses.errorResponse(basicValidationResult.getErrorCollection());
            }
            Optional<ProjectService.UpdateProjectSchemesValidationResult> schemesValidationResult = this.validateSchemesIfUpdated((Project)projectToEdit, updateData);
            if (schemesValidationResult.isPresent() && !schemesValidationResult.get().isValid()) {
                return this.responses.errorResponse(schemesValidationResult.get().getErrorCollection());
            }
            return (Response)this.loadProjectCategory(updateData.getCategoryId()).left().on(maybeProjectCategory -> {
                Project project = this.projectService.updateProject(basicValidationResult);
                if (maybeProjectCategory.isDefined()) {
                    this.projectManager.setProjectCategory(project, (ProjectCategory)maybeProjectCategory.get());
                }
                schemesValidationResult.ifPresent(validationResult -> this.projectService.updateProjectSchemes(validationResult, project));
                return this.responses.okNoCache(this.projectBeanFactory.fullProject((Project)this.getProjectForView(projectIdOrKey).right().get(), Strings.nullToEmpty((String)expand)));
            });
        });
    }

    private Optional<ProjectService.UpdateProjectSchemesValidationResult> validateSchemesIfUpdated(Project projectToEdit, ProjectUpdateBean updateData) {
        if (!updateData.isSchemesUpdate()) {
            return Optional.empty();
        }
        Long permissionSchemeId = this.permissionSchemeManager.getSchemeIdFor(projectToEdit);
        Long notificationSchemeId = this.notificationSchemeManager.getSchemeIdFor(projectToEdit);
        Long securitySchemeId = this.issueSecuritySchemeManager.getSchemeIdFor(projectToEdit);
        if (!(this.isSchemeChanged(updateData.getPermissionScheme(), permissionSchemeId) || this.isSchemeChanged(updateData.getNotificationScheme(), notificationSchemeId) || this.isSchemeChanged(updateData.getIssueSecurityScheme(), securitySchemeId))) {
            return Optional.empty();
        }
        return Optional.of(this.projectService.validateUpdateProjectSchemes(this.authContext.getLoggedInUser(), ProjectResource.firstNotNullId(updateData.getPermissionScheme(), permissionSchemeId), ProjectResource.firstNotNullId(updateData.getNotificationScheme(), notificationSchemeId), ProjectResource.firstNotNullId(updateData.getIssueSecurityScheme(), securitySchemeId)));
    }

    private boolean isSchemeChanged(@Nullable Long newSchemeId, @Nullable Long currentSchemeId) {
        return newSchemeId != null && !newSchemeId.equals(currentSchemeId);
    }

    private static ProjectService.UpdateProjectRequest requestProjectUpdate(Project original, ProjectUpdateBean updateData) {
        ProjectService.UpdateProjectRequest request = new ProjectService.UpdateProjectRequest(original);
        request.name(updateData.getName());
        request.key(updateData.getKey());
        request.description(updateData.getDescription());
        request.url(updateData.getUrl());
        request.assigneeType(updateData.getAssigneeTypeOrNull());
        request.avatarId(updateData.getAvatarId());
        request.leadUsername(updateData.getLead());
        return request;
    }

    @Nullable
    private static Long firstNotNullId(@Nullable Long first, @Nullable Long second) {
        return first != null ? first : second;
    }

    @PUT
    @Path(value="{projectIdOrKey}/type/{newProjectTypeKey}")
    @Operation(summary="Update project type", description="Updates the type of a project", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="projectIdOrKey", description="Project id or project key", required=true), @Parameter(name="newProjectTypeKey", description="The key of the new project type", required=true)})
    @ApiResponses(value={@ApiResponse(description="Updated project data", responseCode="200", content={@Content(schema=@Schema(implementation=ProjectBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the request is not valid and the project type could not be updated", responseCode="400"), @ApiResponse(description="Returned if the user is not authenticated", responseCode="401"), @ApiResponse(description="Returned if the user does not have rights to update projects", responseCode="403"), @ApiResponse(description="Returned if the project does not exist", responseCode="404")})
    public Response updateProjectType(@PathParam(value="projectIdOrKey") String projectIdOrKey, @PathParam(value="newProjectTypeKey") String newProjectTypeKey) {
        if (!this.authContext.isLoggedInUser()) {
            return this.responses.notLoggedInResponse();
        }
        return (Response)this.getProjectForEdit(projectIdOrKey).left().on(project -> {
            Either updateResult = this.projectService.updateProjectType(this.authContext.getLoggedInUser(), project, new ProjectTypeKey(newProjectTypeKey));
            if (updateResult.isLeft()) {
                return this.responses.okNoCache(this.projectBeanFactory.fullProject((Project)updateResult.left().get(), ""));
            }
            return this.responses.errorResponse((com.atlassian.jira.util.ErrorCollection)updateResult.right().get());
        });
    }

    @PUT
    @Path(value="{projectIdOrKey}/archive")
    @Operation(summary="Archive a project", description="Archives a project", security={@SecurityRequirement(name="basic")})
    @Parameter(name="projectIdOrKey", description="Project id or project key", required=true)
    @ApiResponses(value={@ApiResponse(description="Returned if the project is successfully archived", responseCode="204"), @ApiResponse(description="Returned if the user is not authenticated", responseCode="401"), @ApiResponse(description="Returned if the currently authenticated user does not have permission to archive the project or doesn't have DC license or project is already archived", responseCode="403"), @ApiResponse(description="Returned if the project does not exist", responseCode="404")})
    public Response archiveProject(@PathParam(value="projectIdOrKey") String projectIdOrKey) {
        if (!this.authContext.isLoggedInUser()) {
            return this.responses.notLoggedInResponse();
        }
        return (Response)this.getProjectForEdit(projectIdOrKey).left().on(project -> {
            ArchivedProjectService.ValidationResult validationResult = this.archivedProjectService.validateArchiveProject(this.authContext.getLoggedInUser(), project.getKey());
            if (validationResult.isValid()) {
                ArchivedProjectService.ArchivingResult result = this.archivedProjectService.archiveProject(validationResult);
                return result.isValid() ? this.responses.noContent() : this.responses.errorResponse(result.getErrorCollection());
            }
            return this.responses.errorResponse(validationResult.getErrorCollection());
        });
    }

    @PUT
    @Path(value="{projectIdOrKey}/restore")
    @Operation(summary="Restore an archived project", description="Restores an archived project. In case of success restored project should be re-indexed.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="projectIdOrKey", description="Project id or project key", required=true)
    @ApiResponses(value={@ApiResponse(description="Returned if the project is successfully restored", responseCode="202"), @ApiResponse(description="Returned if the user is not authenticated", responseCode="401"), @ApiResponse(description="Returned if the currently authenticated user does not have permission to restore the project or doesn't have DC license or project is already restored", responseCode="403"), @ApiResponse(description="Returned if the project does not exist", responseCode="404")})
    public Response restoreProject(@PathParam(value="projectIdOrKey") String projectIdOrKey) {
        if (!this.authContext.isLoggedInUser()) {
            return this.responses.notLoggedInResponse();
        }
        return (Response)this.getProjectForView(projectIdOrKey, ProjectAction.VIEW_ARCHIVED_PROJECT).left().on(project -> {
            ArchivedProjectService.ValidationResult validationResult = this.archivedProjectService.validateRestoreProject(this.authContext.getLoggedInUser(), project.getKey());
            if (validationResult.isValid()) {
                ArchivedProjectService.ArchivingResult result = this.archivedProjectService.restoreProject(validationResult);
                return result.isValid() ? Response.status((Response.Status)Response.Status.ACCEPTED).build() : this.responses.errorResponse(result.getErrorCollection());
            }
            return this.responses.errorResponse(validationResult.getErrorCollection());
        });
    }

    @DELETE
    @Path(value="{projectIdOrKey}")
    @Operation(summary="Delete a project", description="Deletes a project", security={@SecurityRequirement(name="basic")})
    @Parameter(name="projectIdOrKey", description="Project id or project key", required=true)
    @ApiResponses(value={@ApiResponse(description="Returned if the project is successfully deleted", responseCode="204"), @ApiResponse(description="Returned if the user is not authenticated", responseCode="401"), @ApiResponse(description="Returned if the currently authenticated user does not have permission to delete the project", responseCode="403"), @ApiResponse(description="Returned if the project does not exist", responseCode="404")})
    public Response deleteProject(@PathParam(value="projectIdOrKey") String projectIdOrKey) {
        if (!this.authContext.isLoggedInUser()) {
            return this.responses.notLoggedInResponse();
        }
        return (Response)this.getProjectForDelete(projectIdOrKey).left().on(project -> {
            ProjectService.DeleteProjectValidationResult validationResult = this.projectService.validateDeleteProject(this.authContext.getLoggedInUser(), project.getKey());
            if (validationResult.isValid()) {
                ProjectService.DeleteProjectResult result = this.projectService.deleteProject(this.authContext.getLoggedInUser(), validationResult);
                return result.isValid() ? this.responses.noContent() : this.responses.errorResponse(result.getErrorCollection());
            }
            return this.responses.errorResponse(validationResult.getErrorCollection());
        });
    }

    @GET
    @Path(value="{projectIdOrKey}/versions")
    @Operation(summary="Get project versions", description="Contains a full representation of a the specified project's versions.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="projectIdOrKey", description="Project id or project key", required=true), @Parameter(name="expand", description="Parameters to expand")})
    @ApiResponses(value={@ApiResponse(description="Project versions", responseCode="200", content={@Content(schema=@Schema(implementation=VersionBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the project is not found, or the calling user does not have permission to view it", responseCode="404")})
    public Response getProjectVersions(@PathParam(value="projectIdOrKey") String projectIdOrKey, @QueryParam(value="expand") String expand) {
        return (Response)this.getProjectForView(projectIdOrKey).left().on(project -> {
            VersionService.VersionsResult versionResult = this.versionService.getVersionsByProject(this.authContext.getLoggedInUser(), project);
            if (!versionResult.isValid()) {
                throw new NotFoundWebException(ErrorCollection.of(versionResult.getErrorCollection()));
            }
            boolean expandOps = expand != null && expand.contains("operations");
            return this.responses.okNoCache(this.versionBeanFactory.createVersionBeans(versionResult.getVersions(), expandOps));
        });
    }

    @GET
    @Path(value="{projectIdOrKey}/version")
    @Operation(summary="Get paginated project versions", description="Returns all versions for the specified project. Results are paginated. Results can be ordered by the following fields: sequence, name, startDate, releaseDate.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="projectIdOrKey", description="Project id or project key", required=true), @Parameter(name="startAt", description="The page offset, if not specified then defaults to 0"), @Parameter(name="maxResults", description="How many results on the page should be included. Defaults to 50"), @Parameter(name="orderBy", description="Ordering of the results"), @Parameter(name="expand", description="Parameters to expand")})
    @ApiResponses(value={@ApiResponse(description="Project versions", responseCode="200", content={@Content(schema=@Schema(implementation=PageBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the project is not found, or the calling user does not have permission to view it", responseCode="404")})
    public Response getProjectVersionsPaginated(@PathParam(value="projectIdOrKey") String projectIdOrKey, @QueryParam(value="startAt") Long startAt, @QueryParam(value="maxResults") Integer maxResults, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="expand") String expand) {
        return (Response)this.getProjectForView(projectIdOrKey).left().on(project -> {
            ServiceOutcome pagedVersions;
            PageRequest pageRequest = PageRequests.request((Long)startAt, (Integer)((Integer)MoreObjects.firstNonNull((Object)maxResults, (Object)50)));
            OrderByRequest orderByRequest = null;
            if (orderBy != null) {
                Either parsedOrderBy = this.orderByRequestParser.parse(orderBy, VersionService.VersionExtractableField.class);
                if (parsedOrderBy.isLeft()) {
                    throw new BadRequestWebException(ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)parsedOrderBy.left().get()));
                }
                orderByRequest = (OrderByRequest)parsedOrderBy.right().get();
            }
            if (!(pagedVersions = this.versionService.getVersionsByProject(this.authContext.getLoggedInUser(), project, pageRequest, orderByRequest)).isValid()) {
                throw new RESTException(ErrorCollection.of(pagedVersions.getErrorCollection()));
            }
            boolean expandOps = expand != null && expand.contains("operations");
            boolean expandRemoteLinks = expand != null && expand.contains("remotelinks");
            return Response.ok(PageBean.from(pageRequest, (Page)pagedVersions.get()).setLinks(this.baseSelfForPagedVersions(project.getKey(), orderBy), pageRequest.getLimit()).build(input -> this.versionBeanFactory.createVersionBean((Version)input, expandOps, expandRemoteLinks))).cacheControl(com.atlassian.jira.rest.api.http.CacheControl.never()).build();
        });
    }

    private String baseSelfForPagedVersions(String projectKey, String orderByQuery) {
        UriBuilder withoutOrderBy = UriBuilder.fromPath((String)this.jiraBaseUrls.restApi2BaseUrl()).path(ProjectResource.class).path(projectKey).path("version");
        if (orderByQuery != null) {
            return withoutOrderBy.queryParam("orderBy", new Object[]{orderByQuery}).build(new Object[0]).toString();
        }
        return withoutOrderBy.build(new Object[0]).toString();
    }

    @GET
    @Path(value="{projectIdOrKey}/components")
    @Operation(summary="Get project components", description="Contains a full representation of the specified project's components.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="projectIdOrKey", description="Project id or project key", required=true)
    @ApiResponses(value={@ApiResponse(description="Project components", responseCode="200", content={@Content(schema=@Schema(implementation=ComponentBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the project is not found, or the calling user does not have permission to view it", responseCode="404")})
    public Response getProjectComponents(@PathParam(value="projectIdOrKey") String projectIdOrKey) {
        return (Response)this.getProjectForView(projectIdOrKey).left().on(project -> {
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            Collection projectComponents = this.projectComponentService.findAllForProject((com.atlassian.jira.util.ErrorCollection)errorCollection, project.getId());
            if (errorCollection.hasAnyErrors()) {
                throw new NotFoundWebException(ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection));
            }
            return this.responses.okNoCache(ComponentBean.asFullBeans(project, projectComponents, this.jiraBaseUrls, this.userManager, this.avatarService, this.permissionManager, this.projectManager));
        });
    }

    @GET
    @Operation(summary="Get all visible projects", description="Returns all projects which are visible for the currently logged in user. If no user is logged in, it returns the list of projects that are visible when using anonymous access.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="expand", description="Parameters to expand"), @Parameter(name="recent", description="If this parameter is set then only projects recently accessed by the current user (if not logged in then based on HTTP session) will be returned (maximum count limited to the specified number but no more than 20)"), @Parameter(name="includeArchived", description="Whether to include archived projects in response, default: false"), @Parameter(name="browseArchive", description="Whether to include only projects where current user can browse archive")})
    @ApiResponses(value={@ApiResponse(description="Project data", responseCode="200", content={@Content(schema=@Schema(implementation=ProjectBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the user is not authenticated", responseCode="401"), @ApiResponse(description="Returned if the user does not have rights to view projects", responseCode="403")})
    public Response getAllProjects(@QueryParam(value="expand") String expand, @QueryParam(value="recent") Integer recent, @QueryParam(value="includeArchived") boolean includeArchived, @QueryParam(value="browseArchive") boolean browseArchive) {
        return (Response)(recent != null ? this.getMostRecentProjects(recent) : this.getAllProjects(includeArchived)).left().on(this.projectListAsResponse(expand, browseArchive));
    }

    private Either<Response, List<Project>> getAllProjects(boolean includeArchived) {
        return this.responses.validateOutcome(this.projectService.getAllProjectsForAction(this.authContext.getLoggedInUser(), includeArchived ? ProjectAction.VIEW_ARCHIVED_PROJECT : ProjectAction.VIEW_PROJECT));
    }

    private Either<Response, Iterable<Project>> getMostRecentProjects(Integer count) {
        if (count < 0) {
            return Either.left((Object)this.responses.errorResponse(ErrorCollections.validationError((String)"recent", (String)this.i18nHelper.getText("rest.validation.error.negative.number"))));
        }
        List recentProjects = this.projectHistoryManager.getProjectHistoryWithPermissionChecks(ProjectAction.VIEW_PROJECT, this.authContext.getLoggedInUser());
        return Either.right((Object)Iterables.limit((Iterable)recentProjects, (int)Math.min(count, 20)));
    }

    private Function<Iterable<Project>, Response> projectListAsResponse(String expand, boolean browseArchive) {
        return projects -> {
            boolean isGlobalBrowse = this.globalPermissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, this.authContext.getLoggedInUser()) || this.globalPermissionManager.hasPermission(GlobalPermissionKey.of((String)"GLOBAL_BROWSE_ARCHIVE"), this.authContext.getLoggedInUser());
            return this.responses.okNoCache(ImmutableList.copyOf((Collection)StreamSupport.stream(projects.spliterator(), false).filter(project -> {
                if (browseArchive) {
                    return isGlobalBrowse || this.permissionManager.hasPermission(ProjectPermissions.BROWSE_ARCHIVE, project, this.authContext.getLoggedInUser());
                }
                return true;
            }).map(arg_0 -> this.projectBeanFactory.summaryProject(expand).apply(arg_0)).collect(Collectors.toList())));
        };
    }

    @GET
    @Path(value="{projectIdOrKey}/avatars")
    @Operation(summary="Get all avatars for a project", description="Returns all avatars which are visible for the currently logged in user. The avatars are grouped into system and custom.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="projectIdOrKey", description="Project id or project key", required=true)
    @ApiResponses(value={@ApiResponse(description="Avatars", responseCode="200", content={@Content(schema=@Schema(implementation=AvatarBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the project is not found, or the calling user does not have permission to view it", responseCode="404")})
    public Response getAllAvatars(@PathParam(value="projectIdOrKey") String projectIdOrKey) {
        return (Response)this.getProjectForView(projectIdOrKey).left().on(project -> {
            Avatar selectedAvatar = project.getAvatar();
            Long selectedAvatarId = selectedAvatar.getId();
            return this.responses.okNoCache(this.avatarResourceHelper.getAllAvatars(IconType.PROJECT_ICON_TYPE, project.getId().toString(), selectedAvatarId));
        });
    }

    @POST
    @Path(value="{projectIdOrKey}/avatar")
    @Operation(summary="Create avatar from temporary", description="Converts the temporary avatar into the final one. This is step 2/3 of changing an avatar for a project:\n- Upload (store temporary avatar)\n- Crop (create avatar from temporary)\n- Update (update project avatar)", security={@SecurityRequirement(name="basic")})
    @Parameter(name="projectIdOrKey", description="Project id or project key", required=true)
    @RequestBody(description="Cropping instructions", required=true, content={@Content(schema=@Schema(implementation=AvatarCroppingBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Avatar data", responseCode="201", content={@Content(schema=@Schema(implementation=AvatarBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the cropping coordinates are invalid", responseCode="400"), @ApiResponse(description="Returned if the user is not authenticated", responseCode="401"), @ApiResponse(description="Returned if the currently authenticated user does not have permission to pick avatar", responseCode="403"), @ApiResponse(description="Returned if the currently authenticated user does not have EDIT PROJECT permission", responseCode="404")})
    public Response createAvatarFromTemporary(@PathParam(value="projectIdOrKey") String projectIdOrKey, AvatarCroppingBean croppingInstructions) {
        return (Response)this.getProjectForEdit(projectIdOrKey).left().on(project -> this.avatarResourceHelper.createAvatarFromTemporary(IconType.PROJECT_ICON_TYPE, project.getId().toString(), croppingInstructions));
    }

    @PUT
    @Path(value="{projectIdOrKey}/avatar")
    @Operation(summary="Update project avatar", description="Updates an avatar for a project. This is step 3/3 of changing an avatar for a project.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="projectIdOrKey", description="Project id or project key", required=true)
    @RequestBody(description="Avatar data", required=true, content={@Content(schema=@Schema(implementation=AvatarBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Returned if the avatar was updated successfully", responseCode="204"), @ApiResponse(description="Returned if the avatar does not exist", responseCode="400"), @ApiResponse(description="Returned if the user is not logged in", responseCode="401"), @ApiResponse(description="Returned if the project does not exist", responseCode="404")})
    public Response updateProjectAvatar(@PathParam(value="projectIdOrKey") String projectIdOrKey, AvatarBean avatarBean) {
        return (Response)this.getProjectForEdit(projectIdOrKey).left().on(project -> {
            Long avatarId;
            String id = avatarBean.getId();
            try {
                avatarId = id == null ? null : Long.valueOf(id);
            }
            catch (NumberFormatException e) {
                avatarId = null;
            }
            ProjectService.UpdateProjectValidationResult updateProjectValidationResult = this.projectService.validateUpdateProject(this.authContext.getLoggedInUser(), project.getName(), project.getKey(), project.getDescription(), project.getLeadUserName(), project.getUrl(), project.getAssigneeType(), avatarId);
            if (!updateProjectValidationResult.isValid()) {
                this.throwWebException(updateProjectValidationResult.getErrorCollection());
            }
            this.projectService.updateProject(updateProjectValidationResult);
            return this.responses.noContent();
        });
    }

    @POST
    @Consumes(value={"*/*"})
    @Operation(summary="Store temporary avatar", description="Uploads an image and creates a temporary avatar. This is step 1/3 of changing an avatar for a project:\n- Upload (store temporary avatar)\n- Crop (create avatar from temporary)\n- Update (update project avatar)\n\nSupported image formats: BMP, GIF, JPEG, PNG, WBMP.\ncurl \\\n  -X POST \\\n  -u admin:admin \\\n  -H \"X-Atlassian-Token: no-check\" \\\n  -H \"Content-Type: image/png\" \\\n  --data-binary @mynewavatar.png \\\n  'http://localhost:8090/jira/rest/api/2/user/avatar/temporary?username=admin&amp;filename=mynewavatar.png'\n", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="projectIdOrKey", description="Project id or project key", required=true), @Parameter(name="filename", description="Name of file being uploaded", required=true), @Parameter(name="size", description="Size of the image file", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returns coordinates for cropping the temporary avatar. You'll need them in the next step.", responseCode="201", content={@Content(schema=@Schema(implementation=AvatarCroppingBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the request does not contain a valid XSRF token", responseCode="403"), @ApiResponse(description="Returned if the currently authenticated user does not have EDIT PROJECT permission", responseCode="404")})
    @Path(value="{projectIdOrKey}/avatar/temporary")
    public Response storeTemporaryAvatar(@PathParam(value="projectIdOrKey") String projectIdOrKey, @QueryParam(value="filename") String filename, @QueryParam(value="size") Long size, @Context HttpServletRequest request) {
        XsrfCheckResult xsrfCheckResult = this.xsrfChecker.checkWebRequestInvocation(ExecutingHttpRequest.get());
        if (xsrfCheckResult.isRequired() && !xsrfCheckResult.isValid()) {
            throw new XsrfCheckFailedException();
        }
        return (Response)this.getProjectForEdit(projectIdOrKey).left().on(project -> this.avatarResourceHelper.storeTemporaryAvatar(IconType.PROJECT_ICON_TYPE, project.getId().toString(), filename, size, request));
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="{projectIdOrKey}/avatar/temporary")
    @Produces(value={"text/html"})
    @Operation(summary="Store temporary avatar using multipart", description="Creates temporary avatar using multipart. The response is sent back as JSON stored in a textarea. This is because\nthe client uses remote iframing to submit avatars using multipart. So we must send them a valid HTML page back from\nwhich the client parses the JSON.\n", security={@SecurityRequirement(name="basic")})
    @Parameter(name="projectIdOrKey", description="Project id or project key", required=true)
    @ApiResponses(value={@ApiResponse(description="Temporary avatar cropping instructions embeded in HTML page. Error messages will also be embeded in the page.", responseCode="201", content={@Content(schema=@Schema(implementation=AvatarCroppingBean.class), mediaType="text/html")}), @ApiResponse(description="Returned if the currently authenticated user does not have EDIT PROJECT permission", responseCode="404")})
    public Response storeTemporaryAvatarUsingMultiPart(@PathParam(value="projectIdOrKey") String projectIdOrKey, @MultipartFormParam(value="avatar") FilePart filePart, @Context HttpServletRequest request) {
        XsrfCheckResult xsrfCheckResult = this.xsrfChecker.checkWebRequestInvocation(ExecutingHttpRequest.get());
        if (xsrfCheckResult.isRequired() && !xsrfCheckResult.isValid()) {
            throw new XsrfCheckFailedException();
        }
        return (Response)this.getProjectForEdit(projectIdOrKey).left().on(project -> this.avatarResourceHelper.storeTemporaryAvatarUsingMultiPart(IconType.PROJECT_ICON_TYPE, project.getId().toString(), filePart, request));
    }

    @DELETE
    @Path(value="{projectIdOrKey}/avatar/{id}")
    @Operation(summary="Delete an avatar", description="Deletes avatar", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="projectIdOrKey", description="Project id or project key", required=true), @Parameter(name="id", description="Database id for avatar", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returned if the avatar is successfully deleted", responseCode="204"), @ApiResponse(description="Returned if the currently authenticated user does not have permission to delete the avatar", responseCode="403"), @ApiResponse(description="Returned if the avatar or project does not exist", responseCode="404")})
    public Response deleteAvatar(@PathParam(value="projectIdOrKey") String projectIdOrKey, @PathParam(value="id") Long id) {
        return (Response)this.getProjectForEdit(projectIdOrKey).left().on(project -> this.avatarResourceHelper.deleteAvatar(id));
    }

    @GET
    @Path(value="{projectIdOrKey}/statuses")
    @Operation(summary="Get all issue types with statuses for a project", description="Get all issue types with valid status values for a project", security={@SecurityRequirement(name="basic")})
    @Parameter(name="projectIdOrKey", description="Project id or project key", required=true)
    @ApiResponses(value={@ApiResponse(description="Issue types with status values", responseCode="200", content={@Content(schema=@Schema(implementation=IssueTypeWithStatusJsonBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the project is not found, or the calling user does not have permission to view it", responseCode="404")})
    public Response getAllStatuses(@PathParam(value="projectIdOrKey") String projectIdOrKey) {
        return (Response)this.getProjectForView(projectIdOrKey).left().on(project -> {
            Collection issueTypesForProject = this.issueTypeSchemeManager.getIssueTypesForProject(project);
            ArrayList issueTypesWithStatuses = Lists.newArrayList();
            for (IssueType issueType : issueTypesForProject) {
                JiraWorkflow workflow = this.workflowManager.getWorkflow(project.getId(), issueType.getId());
                ImmutableList statusJsonBeans = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)workflow.getLinkedStatusObjects(), status -> this.statusHelper.createStatusBean((Status)status, this.uriInfo, StatusResource.class)));
                issueTypesWithStatuses.add(this.createIssueTypeWithStatuses(issueType, (ImmutableList<StatusJsonBean>)statusJsonBeans));
            }
            return Response.ok((Object)issueTypesWithStatuses).cacheControl(CacheControl.NO_CACHE).build();
        });
    }

    private void throwWebException(com.atlassian.jira.util.ErrorCollection errorCollection) {
        throw new RESTException(ErrorCollection.of(errorCollection));
    }

    private IssueTypeWithStatusJsonBean createIssueTypeWithStatuses(IssueType issueType, ImmutableList<StatusJsonBean> statusJsonBeans) {
        return new IssueTypeWithStatusJsonBean(this.uriBuilder.build(this.uriInfo, IssueTypeResource.class, issueType.getId()).toString(), issueType.getId(), issueType.getName(), issueType.isSubTask(), (Collection<StatusJsonBean>)statusJsonBeans);
    }

    private Either<Response, Project> getProjectForView(String projectIdOrKey) {
        return this.getProjectForView(projectIdOrKey, ProjectAction.VIEW_PROJECT);
    }

    private Either<Response, Project> getProjectForView(String projectIdOrKey, ProjectAction projectAction) {
        return this.getEitherProjectOrErrors(projectIdOrKey, projectAction);
    }

    private Either<Response, Project> getProjectForEdit(String projectIdOrKey) {
        return this.getEitherProjectOrErrors(projectIdOrKey, ProjectAction.EDIT_PROJECT_CONFIG);
    }

    private Either<Response, Project> getProjectForDelete(String projectIdOrKey) {
        return this.getEitherProjectOrErrors(projectIdOrKey, ProjectAction.DELETE_PROJECT);
    }

    private Either<Response, Project> getEitherProjectOrErrors(String projectIdOrKey, ProjectAction action) {
        ProjectService.GetProjectResult projectResult = this.projectFinder.getGetProjectForActionByIdOrKey(this.authContext.getLoggedInUser(), projectIdOrKey, action);
        if (!projectResult.isValid()) {
            return Either.left((Object)this.responses.errorResponse(projectResult.getErrorCollection()));
        }
        return Either.right((Object)projectResult.getProject());
    }

    private void publishAnalytics(String endpoint, Project project) {
        this.eventPublisher.publish((Object)new EndpointUsageEvent(endpoint, true, project.getId(), "project"));
    }
}

