/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.bc.project.property.ProjectPropertyService;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.issue.fields.rest.json.beans.EntityPropertyBean;
import com.atlassian.jira.issue.fields.rest.json.beans.EntityPropertyBeanSelfFunctions;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.v2.admin.WorkflowTransitionResource;
import com.atlassian.jira.rest.v2.entity.property.BasePropertyWithKeyResource;
import com.atlassian.jira.rest.v2.entity.property.EntityPropertiesKeysBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraKeyUtils;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.google.common.base.Predicate;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.function.BiFunction;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="project/{projectIdOrKey}/properties")
@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ProjectPropertyResource {
    private final BasePropertyWithKeyResource<Project> delegate;

    @Inject
    public ProjectPropertyResource(ProjectPropertyService projectPropertyService, JiraAuthenticationContext authContext, JiraBaseUrls jiraBaseUrls, I18nHelper i18n) {
        this.delegate = new BasePropertyWithKeyResource(projectPropertyService, authContext, jiraBaseUrls, i18n, new IsValidProjectKeyPredicate(), (BiFunction<Long, String, String>)new EntityPropertyBeanSelfFunctions.ProjectPropertySelfBiFunction(), EntityPropertyType.ISSUE_PROPERTY);
    }

    @ExperimentalApi
    @GET
    @Operation(summary="Get keys of all properties for project", description="Returns the keys of all properties for the project identified by the key or by the id.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="projectIdOrKey", description="The project from which keys will be returned.", required=true)
    @ApiResponses(value={@ApiResponse(description="Returned if the project was found.", responseCode="200", content={@Content(schema=@Schema(implementation=EntityPropertiesKeysBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the project key or id is invalid.", responseCode="400"), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to browse the project.", responseCode="403"), @ApiResponse(description="Returned if the project with given key or id does not exist or if the property with given key is not found.", responseCode="404")})
    public Response getPropertiesKeys(@PathParam(value="projectIdOrKey") String projectIdOrKey) {
        return this.delegate.getPropertiesKeys(projectIdOrKey);
    }

    @ExperimentalApi
    @PUT
    @Path(value="/{propertyKey}")
    @Operation(summary="Set value of specified project's property", description="Sets the value of the specified project's property. You can use this resource to store a custom data against the project identified by the key or by the id. The user who stores the data is required to have permissions to administer the project.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="projectIdOrKey", description="The project on which the property will be set.", required=true), @Parameter(name="propertyKey", description="The key of the project's property. The maximum length of the key is 255 bytes.", required=true)})
    @RequestBody(description="The request containing value of the project's property. The value has to be a valid, non-empty JSON conforming to http://tools.ietf.org/html/rfc4627. The maximum length of the property value is 32768 bytes.", required=true, content={@Content(schema=@Schema(implementation=WorkflowTransitionResource.PropertyBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Returned if the project property is successfully updated.", responseCode="200"), @ApiResponse(description="Returned if the project property is successfully created.", responseCode="201"), @ApiResponse(description="Returned if the project key or id is invalid.", responseCode="400"), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to administer the project.", responseCode="403"), @ApiResponse(description="Returned if the project with given key or id does not exist.", responseCode="404")})
    public Response setProperty(@PathParam(value="projectIdOrKey") String projectIdOrKey, @PathParam(value="propertyKey") String propertyKey, @Context HttpServletRequest request) {
        return this.delegate.setProperty(projectIdOrKey, propertyKey, request);
    }

    @ExperimentalApi
    @GET
    @Path(value="/{propertyKey}")
    @Operation(summary="Get value of property from project", description="Returns the value of the property with a given key from the project identified by the key or by the id.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="projectIdOrKey", description="The project from which the property will be returned.", required=true), @Parameter(name="propertyKey", description="The key of the property to return.", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returned if the project property was found.", responseCode="200", content={@Content(schema=@Schema(implementation=EntityPropertyBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the project key or id is invalid.", responseCode="400"), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to browse the project.", responseCode="403"), @ApiResponse(description="Returned if the project with given key or id does not exist or if the property with given key is not found.", responseCode="404")})
    public Response getProperty(@PathParam(value="projectIdOrKey") String projectIdOrKey, @PathParam(value="propertyKey") String propertyKey) {
        return this.delegate.getProperty(projectIdOrKey, propertyKey);
    }

    @ExperimentalApi
    @DELETE
    @Path(value="/{propertyKey}")
    @Operation(summary="Delete property from project", description="Removes the property from the project identified by the key or by the id.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="projectIdOrKey", description="The project from which the property will be removed.", required=true), @Parameter(name="propertyKey", description="The key of the property to remove.", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returned if the project property was removed successfully.", responseCode="204"), @ApiResponse(description="Returned if the project key or id is invalid.", responseCode="400"), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to edit the project.", responseCode="403"), @ApiResponse(description="Returned if the project with given key or id does not exist or if the property with given key is not found.", responseCode="404")})
    public Response deleteProperty(@PathParam(value="projectIdOrKey") String projectIdOrKey, @PathParam(value="propertyKey") String propertyKey) {
        return this.delegate.deleteProperty(projectIdOrKey, propertyKey);
    }

    private static class IsValidProjectKeyPredicate
    implements Predicate<String> {
        private IsValidProjectKeyPredicate() {
        }

        public boolean apply(String projectKey) {
            return JiraKeyUtils.validProjectKey((String)projectKey);
        }
    }
}

