/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.SecuritySchemeJsonBean;
import com.atlassian.jira.issue.security.IssueSecurityLevelScheme;
import com.atlassian.jira.issue.security.IssueSecuritySchemeService;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.Collection;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="project/{projectKeyOrId}/issuesecuritylevelscheme")
@Produces(value={"application/json"})
@LicensedOnly
public class ProjectIssueSecurityLevelSchemeResource {
    private final IssueSecuritySchemeService issueSecuritySchemeService;
    private final ResponseFactory responseFactory;
    private final JiraBaseUrls baseUrls;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Inject
    public ProjectIssueSecurityLevelSchemeResource(IssueSecuritySchemeService issueSecuritySchemeService, ResponseFactory responseFactory, JiraBaseUrls baseUrls, JiraAuthenticationContext jiraAuthenticationContext) {
        this.issueSecuritySchemeService = issueSecuritySchemeService;
        this.responseFactory = responseFactory;
        this.baseUrls = baseUrls;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @GET
    @Operation(summary="Get issue security scheme for project", description="Returns the issue security scheme for project.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="projectKeyOrId", description="The project id or project key", required=true)
    @ApiResponses(value={@ApiResponse(description="Issue security scheme", responseCode="200", content={@Content(schema=@Schema(implementation=SecuritySchemeJsonBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the user is not logged in.", responseCode="401"), @ApiResponse(description="Returned if the project is visible for calling user, but the user doesn't have administrative permissions", responseCode="403"), @ApiResponse(description="Returned if the project does not exist, or is not visible to the calling user", responseCode="404")})
    public Response getIssueSecurityScheme(@PathParam(value="projectKeyOrId") String projectKeyOrId) {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        ServiceOutcome<IssueSecurityLevelScheme> issueSecurityLevelScheme = this.getIssueSecurityLevelScheme(user, projectKeyOrId);
        return (Response)this.responseFactory.validateOutcome(issueSecurityLevelScheme).left().on(securityLevelScheme -> {
            ServiceOutcome issueSecurityLevels = this.issueSecuritySchemeService.getIssueSecurityLevels(user, securityLevelScheme.getId().longValue());
            return (Response)this.responseFactory.validateOutcome(issueSecurityLevels).left().on(issueSecurityLevels1 -> this.responseFactory.okNoCache(SecuritySchemeJsonBean.fullBean((IssueSecurityLevelScheme)securityLevelScheme, (JiraBaseUrls)this.baseUrls, (Collection)issueSecurityLevels1)));
        });
    }

    private ServiceOutcome<IssueSecurityLevelScheme> getIssueSecurityLevelScheme(ApplicationUser user, String projectKeyOrId) {
        try {
            return this.issueSecuritySchemeService.getIssueSecurityLevelSchemeForProject(user, Long.parseLong(projectKeyOrId));
        }
        catch (NumberFormatException e) {
            return this.issueSecuritySchemeService.getIssueSecurityLevelSchemeForProject(user, projectKeyOrId);
        }
    }
}

