/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.ProjectCategoryJsonBean;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectCategoryImpl;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.v2.issue.project.ProjectCategoryBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.AccessDisablingHelper;
import com.atlassian.jira.util.AccessDisablingHelperConfig;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;

@Path(value="projectCategory")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@LicensedOnly
public class ProjectCategoryResource {
    private final ProjectManager projectManager;
    private final JiraBaseUrls jiraBaseUrls;
    private final JiraAuthenticationContext authContext;
    private final PermissionManager permissionManager;
    private final I18nHelper i18n;
    private final AccessDisablingHelper accessDisablingHelper;

    @Inject
    public ProjectCategoryResource(ProjectManager projectManager, JiraBaseUrls jiraBaseUrls, JiraAuthenticationContext authContext, PermissionManager permissionManager, I18nHelper i18n, AccessDisablingHelper accessDisablingHelper) {
        this.projectManager = projectManager;
        this.jiraBaseUrls = jiraBaseUrls;
        this.authContext = authContext;
        this.permissionManager = permissionManager;
        this.i18n = i18n;
        this.accessDisablingHelper = accessDisablingHelper;
    }

    @GET
    @Path(value="{id}")
    @Operation(summary="Get project category by ID", description="Returns a full representation of the project category that has the given id.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="id", description="A project category id", required=true)
    @ApiResponses(value={@ApiResponse(description="Returned if the project category exists and is visible by the calling user.", responseCode="200", content={@Content(schema=@Schema(implementation=ProjectCategoryJsonBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the project category does not exist, or is not visible to the calling user.", responseCode="404")})
    public Response getProjectCategoryById(@PathParam(value="id") Long id) {
        if (id == null) {
            return this.fieldValueMustBeProvidedResponse("id");
        }
        ProjectCategory projectCategory = this.projectManager.getProjectCategoryObject(id);
        if (projectCategory == null) {
            return this.projectCategoryNotFoundResponse(id);
        }
        return Response.ok((Object)ProjectCategoryJsonBean.bean((ProjectCategory)projectCategory, (JiraBaseUrls)this.jiraBaseUrls)).cacheControl(CacheControl.never()).build();
    }

    @GET
    @AnonymousSiteAccess
    @Operation(summary="Get all project categories", description="Returns all project categories", security={@SecurityRequirement(name="basic")})
    @ApiResponses(value={@ApiResponse(description="Returns a list of all project categories.", responseCode="200", content={@Content(schema=@Schema(implementation=ProjectCategoryJsonBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if an error occurs while retrieving the list of projects.", responseCode="500")})
    public Response getAllProjectCategories() {
        this.blockAnonymousIfNeeded();
        Collection allProjectCategories = this.projectManager.getAllProjectCategories();
        ArrayList beans = Lists.newArrayList((Iterable)Iterables.transform((Iterable)allProjectCategories, projectCategory -> ProjectCategoryJsonBean.bean((ProjectCategory)projectCategory, (JiraBaseUrls)this.jiraBaseUrls)));
        return Response.ok((Object)beans).cacheControl(CacheControl.never()).build();
    }

    @POST
    @Operation(summary="Create project category", description="Create a project category.", security={@SecurityRequirement(name="basic")})
    @RequestBody(description="The project category to create.", required=true, content={@Content(schema=@Schema(implementation=ProjectCategoryBean.class))})
    @ApiResponses(value={@ApiResponse(description="Returned if the project category is created successfully.", responseCode="201", content={@Content(schema=@Schema(implementation=ProjectCategoryJsonBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the caller is not logged in so does not have permission to create project categories.", responseCode="401"), @ApiResponse(description="Returned if the caller is authenticated and does not have permission to create project categories (is not global admin).", responseCode="403"), @ApiResponse(description="Returned if a project category with the given name already exists.", responseCode="409")})
    public Response createProjectCategory(ProjectCategoryBean bean) {
        ApplicationUser user = this.authContext.getUser();
        if (user == null) {
            return this.userMustBeAuthenticatedResponse();
        }
        if (!this.permissionManager.hasPermission(0, user)) {
            return this.userMustBeAdminResponse();
        }
        if (StringUtils.isBlank((CharSequence)bean.getName())) {
            return this.fieldValueMustBeProvidedResponse("name");
        }
        if (StringUtils.isBlank((CharSequence)bean.getDescription())) {
            return this.fieldValueMustBeProvidedResponse("description");
        }
        if (!this.projectManager.isProjectCategoryUnique(bean.getName())) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)ErrorCollection.of(this.i18n.getText("rest.project.category.with.name.exists", bean.getName()))).build();
        }
        ProjectCategory projectCategory = this.projectManager.createProjectCategory(bean.getName(), bean.getDescription());
        ProjectCategoryJsonBean projectCategoryBean = ProjectCategoryJsonBean.bean((ProjectCategory)projectCategory, (JiraBaseUrls)this.jiraBaseUrls);
        URI selfPath = UriBuilder.fromPath((String)projectCategoryBean.getSelf()).build(new Object[0]);
        return Response.status((Response.Status)Response.Status.CREATED).location(selfPath).entity((Object)projectCategoryBean).cacheControl(CacheControl.never()).build();
    }

    @DELETE
    @Path(value="{id}")
    @Operation(summary="Delete project category", description="Delete a project category.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="id", description="Id of the project category to delete.", required=true)
    @ApiResponses(value={@ApiResponse(description="Returned if the project category is successfully deleted.", responseCode="204"), @ApiResponse(description="Returned if the caller is not logged in so does not have permission to delete project categories.", responseCode="401"), @ApiResponse(description="Returned if the caller is authenticated and does not have permission to delete project categories (is not global admin).", responseCode="403"), @ApiResponse(description="Returned if the project category does not exist or the currently authenticated user does not have permission to view it.", responseCode="404")})
    public Response removeProjectCategory(@PathParam(value="id") Long id) {
        ApplicationUser user = this.authContext.getUser();
        if (user == null) {
            return this.userMustBeAuthenticatedResponse();
        }
        if (!this.permissionManager.hasPermission(0, user)) {
            return this.userMustBeAdminResponse();
        }
        if (id == null) {
            return this.fieldValueMustBeProvidedResponse("id");
        }
        ProjectCategory projectCategory = this.projectManager.getProjectCategoryObject(id);
        if (projectCategory == null) {
            return this.projectCategoryNotFoundResponse(id);
        }
        this.projectManager.removeProjectCategory(id);
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    @PUT
    @Path(value="{id}")
    @Operation(summary="Update project category", description="Modify a project category.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="id", description="Id of the project category to modify.", required=true)
    @RequestBody(description="The project category to modify.", required=true, content={@Content(schema=@Schema(implementation=ProjectCategoryBean.class))})
    @ApiResponses(value={@ApiResponse(description="Returned if the project category exists and the currently authenticated user has permission to edit it.", responseCode="200", content={@Content(schema=@Schema(implementation=ProjectCategoryJsonBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the caller is not logged in so does not have permission to change project categories.", responseCode="401"), @ApiResponse(description="Returned if the caller is authenticated and does not have permission to change project categories (is not global admin).", responseCode="403"), @ApiResponse(description="Returned if the project category does not exist or the currently authenticated user does not have permission to view it.", responseCode="404")})
    public Response updateProjectCategory(@PathParam(value="id") Long id, ProjectCategoryBean bean) {
        ApplicationUser user = this.authContext.getUser();
        if (user == null) {
            return this.userMustBeAuthenticatedResponse();
        }
        if (!this.permissionManager.hasPermission(0, user)) {
            return this.userMustBeAdminResponse();
        }
        if (id == null) {
            return this.fieldValueMustBeProvidedResponse("id");
        }
        ProjectCategory projectCategory = this.projectManager.getProjectCategoryObject(id);
        if (projectCategory == null) {
            return this.projectCategoryNotFoundResponse(id);
        }
        String name = bean.getName() != null ? bean.getName() : projectCategory.getName();
        String description = bean.getDescription() != null ? bean.getDescription() : projectCategory.getDescription();
        this.projectManager.updateProjectCategory((ProjectCategory)new ProjectCategoryImpl(projectCategory.getId(), name, description));
        ProjectCategory updatedProjectCategory = this.projectManager.getProjectCategoryObject(id);
        return Response.ok((Object)ProjectCategoryJsonBean.bean((ProjectCategory)updatedProjectCategory, (JiraBaseUrls)this.jiraBaseUrls)).cacheControl(CacheControl.never()).build();
    }

    private void blockAnonymousIfNeeded() {
        if (!this.accessDisablingHelper.canBeAccessedByCurrentUser(AccessDisablingHelperConfig.builder().blockAnonymous(true).build())) {
            throw new NotAuthorisedWebException();
        }
    }

    private Response fieldValueMustBeProvidedResponse(String fieldName) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of(this.i18n.getText("rest.missing.parameter", fieldName))).build();
    }

    private Response projectCategoryNotFoundResponse(Long id) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorCollection.of(this.i18n.getText("rest.project.category.not.found", id.toString()))).build();
    }

    private Response userMustBeAuthenticatedResponse() {
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)ErrorCollection.of(this.i18n.getText("rest.authentication.no.user.logged.in"))).build();
    }

    private Response userMustBeAdminResponse() {
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ErrorCollection.of(this.i18n.getText("rest.authorization.admin.required"))).build();
    }
}

