/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.PrioritySchemeService;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.v2.issue.PrioritySchemeBean;
import com.atlassian.jira.rest.v2.issue.PrioritySchemeListBean;
import com.atlassian.jira.rest.v2.issue.PrioritySchemeUpdateBean;
import com.atlassian.jira.rest.v2.priority.PrioritySchemeBeansFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import com.atlassian.jira.util.PageRequests;
import com.atlassian.jira.util.Pages;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="priorityschemes")
@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class PrioritySchemeResource {
    private static final int DEFAULT_RESULTS = 100;
    private static final int MAX_RESULTS = 1000;
    private final PrioritySchemeService prioritySchemeService;
    private final JiraAuthenticationContext authContext;
    private final ResponseFactory responseFactory;
    private final PrioritySchemeBeansFactory prioritySchemeBeansFactory;

    @Inject
    public PrioritySchemeResource(@ComponentImport PrioritySchemeService prioritySchemeService, JiraAuthenticationContext authContext, ResponseFactory responseFactory, PrioritySchemeBeansFactory prioritySchemeBeansFactory) {
        this.prioritySchemeService = prioritySchemeService;
        this.authContext = authContext;
        this.responseFactory = responseFactory;
        this.prioritySchemeBeansFactory = prioritySchemeBeansFactory;
    }

    @POST
    @ExperimentalApi
    @Operation(summary="Create new priority scheme", description="Creates new priority scheme.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="uriInfo", description="a UriInfo", required=true)
    @RequestBody(description="Data of priority scheme to create", required=true, content={@Content(schema=@Schema(implementation=PrioritySchemeUpdateBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Newly created priority scheme", responseCode="201", content={@Content(schema=@Schema(implementation=PrioritySchemeBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the request is invalid.", responseCode="400"), @ApiResponse(description="Returned if the user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the caller user does not have permission to create priority scheme.", responseCode="403"), @ApiResponse(description="Returned if the priority scheme was not created because of other error.", responseCode="500")})
    public Response createPriorityScheme(@Context UriInfo uriInfo, PrioritySchemeUpdateBean data) {
        ServiceOutcome response = this.prioritySchemeService.createScheme(this.authContext.getLoggedInUser(), this.getServiceDataFromJsonData(data));
        if (!response.isValid()) {
            return this.responseFactory.errorResponse(response.getErrorCollection());
        }
        PrioritySchemeBean bean = this.prioritySchemeBeansFactory.buildResponseBean(this.authContext.getLoggedInUser(), uriInfo, (FieldConfigScheme)response.getReturnedValue());
        return Response.status((Response.Status)Response.Status.CREATED).location(bean.getSelf()).entity((Object)bean).cacheControl(CacheControl.never()).build();
    }

    @DELETE
    @Path(value="{schemeId}")
    @ExperimentalApi
    @Operation(summary="Delete a priority scheme", description="Deletes a priority scheme. All projects using deleted scheme will use default priority scheme afterwards.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="schemeId", description="Id of priority scheme to delete", required=true)
    @ApiResponses(value={@ApiResponse(description="Returned if the priority scheme is successfully deleted.", responseCode="204"), @ApiResponse(description="Returned if the user is not logged in.", responseCode="401"), @ApiResponse(description="Returned if the currently authenticated user does not have permission to delete priority scheme.", responseCode="403"), @ApiResponse(description="Returned if the priority scheme does not exist.", responseCode="404")})
    public Response deletePriorityScheme(@PathParam(value="schemeId") Long schemeId) {
        ServiceResult result = this.prioritySchemeService.deleteScheme(this.authContext.getLoggedInUser(), schemeId);
        if (!result.isValid()) {
            return this.responseFactory.errorResponse(result.getErrorCollection());
        }
        return this.responseFactory.noContent();
    }

    @PUT
    @Path(value="{schemeId}")
    @ExperimentalApi
    @Operation(summary="Update a priority scheme", description="Updates a priority scheme. Update will be rejected if issue migration would be needed as a result of scheme update. Priority scheme update with migration is possible from the UI.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="uriInfo", description="a UriInfo", required=true), @Parameter(name="schemeId", description="id of the priority scheme to update", required=true)})
    @RequestBody(description="New scheme data", required=true, content={@Content(schema=@Schema(implementation=PrioritySchemeUpdateBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Updated priority scheme", responseCode="200", content={@Content(schema=@Schema(implementation=PrioritySchemeBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the request is invalid.", responseCode="400"), @ApiResponse(description="Returned if the user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the caller user does not have permission to update priority scheme.", responseCode="403"), @ApiResponse(description="Returned if the priority scheme does not exist.", responseCode="404"), @ApiResponse(description="Returned if the priority scheme was not updated because of other error.", responseCode="500")})
    public Response updatePriorityScheme(@Context UriInfo uriInfo, @PathParam(value="schemeId") Long schemeId, PrioritySchemeUpdateBean data) {
        PrioritySchemeUpdateBean updateData = new PrioritySchemeUpdateBean.Builder(data).id(schemeId).build();
        ServiceOutcome outcome = this.prioritySchemeService.editScheme(this.authContext.getLoggedInUser(), this.getServiceDataFromJsonData(updateData), true);
        if (!outcome.isValid()) {
            return this.responseFactory.errorResponse(outcome.getErrorCollection());
        }
        PrioritySchemeBean bean = this.prioritySchemeBeansFactory.buildResponseBean(this.authContext.getLoggedInUser(), uriInfo, (FieldConfigScheme)outcome.get());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)bean).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="{schemeId}")
    @ExperimentalApi
    @Operation(summary="Get a priority scheme by ID", description="Gets a full representation of a priority scheme in JSON format.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="uriInfo", description="a UriInfo", required=true), @Parameter(name="schemeId", description="id of priority scheme to get", required=true)})
    @ApiResponses(value={@ApiResponse(description="Priority scheme", responseCode="200", content={@Content(schema=@Schema(implementation=PrioritySchemeBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the caller user does not have permission to view priority scheme.", responseCode="403"), @ApiResponse(description="Returned if the priority scheme does not exist.", responseCode="404")})
    public Response getPriorityScheme(@Context UriInfo uriInfo, @PathParam(value="schemeId") Long schemeId) {
        ServiceOutcome outcome = this.prioritySchemeService.getScheme(this.authContext.getLoggedInUser(), schemeId);
        if (!outcome.isValid()) {
            return this.responseFactory.errorResponse(outcome.getErrorCollection());
        }
        PrioritySchemeBean bean = this.prioritySchemeBeansFactory.buildResponseBean(this.authContext.getLoggedInUser(), uriInfo, (FieldConfigScheme)outcome.get());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)bean).cacheControl(CacheControl.never()).build();
    }

    @GET
    @ExperimentalApi
    @Operation(summary="Get all priority schemes", description="Returns all priority schemes. All project keys associated with the priority scheme will only be returned if additional query parameter is provided <code>expand=schemes.projectKeys</code>", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="uriInfo", description="a UriInfo", required=true), @Parameter(name="startAt", description="the page offset, if not specified then defaults to 0"), @Parameter(name="maxResults", description="how many results on the page should be included. Defaults to 100, maximum is 1000.")})
    @ApiResponses(value={@ApiResponse(description="Priority schemes", responseCode="200", content={@Content(schema=@Schema(implementation=PrioritySchemeListBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the caller user does not have permission to view priority schemes.", responseCode="403")})
    public Response getPrioritySchemes(@Context UriInfo uriInfo, @QueryParam(value="startAt") Long startAt, @QueryParam(value="maxResults") Integer maxResults) {
        ServiceOutcome schemesResponse = this.prioritySchemeService.getSchemes(this.authContext.getLoggedInUser());
        if (!schemesResponse.isValid()) {
            return this.responseFactory.errorResponse(schemesResponse.getErrorCollection());
        }
        int limit = maxResults != null && maxResults >= 0 ? Math.min(1000, maxResults) : 100;
        PageRequest pageRequest = PageRequests.request((Long)startAt, (Integer)limit);
        Collection sortedSchemes = (Collection)schemesResponse.get();
        Page schemesPage = Pages.toPage((Iterable)sortedSchemes, (PageRequest)pageRequest);
        List beans = (List)schemesPage.getValues().stream().map(scheme -> this.prioritySchemeBeansFactory.buildResponseBean(this.authContext.getLoggedInUser(), uriInfo, (FieldConfigScheme)scheme)).collect(CollectorsUtil.toImmutableList());
        return Response.ok((Object)new PrioritySchemeListBean(beans, pageRequest.getStart(), pageRequest.getLimit(), sortedSchemes.size())).cacheControl(CacheControl.never()).build();
    }

    private PrioritySchemeService.PrioritySchemeData getServiceDataFromJsonData(PrioritySchemeUpdateBean data) {
        return PrioritySchemeService.PrioritySchemeData.builder().id(data.getId()).name(data.getName()).description(data.getDescription()).priorityIds(data.getOptionIds()).defaultPriorityId(data.getDefaultOptionId()).build();
    }
}

