/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.config.IssueTypeSchemeService;
import com.atlassian.jira.config.IssueTypeService;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.issue.fields.rest.json.beans.AssociateProjectsBean;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeSchemeCreateUpdateBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.v2.EndpointUsageEvent;
import com.atlassian.jira.rest.v2.issue.IssueTypeSchemeBean;
import com.atlassian.jira.rest.v2.issue.IssueTypeSchemeListBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectBeanFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Path(value="issuetypescheme")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@LicensedOnly
public class IssueTypeSchemeResource {
    private final JiraAuthenticationContext authContext;
    private final JiraBaseUrls jiraBaseUrls;
    private final IssueTypeService issueTypeService;
    private final ResponseFactory responseFactory;
    private final OptionSetManager optionSetManager;
    private final ProjectBeanFactory projectBeanFactory;
    private final IssueTypeSchemeService issueTypeSchemeService;
    private final EventPublisher eventPublisher;

    @Inject
    public IssueTypeSchemeResource(JiraAuthenticationContext authContext, JiraBaseUrls jiraBaseUrls, IssueTypeService issueTypeService, ResponseFactory responseFactory, OptionSetManager optionSetManager, ProjectBeanFactory projectBeanFactory, IssueTypeSchemeService issueTypeSchemeService, EventPublisher eventPublisher) {
        this.authContext = authContext;
        this.jiraBaseUrls = jiraBaseUrls;
        this.issueTypeService = issueTypeService;
        this.responseFactory = responseFactory;
        this.optionSetManager = optionSetManager;
        this.projectBeanFactory = projectBeanFactory;
        this.issueTypeSchemeService = issueTypeSchemeService;
        this.eventPublisher = eventPublisher;
    }

    @POST
    @Operation(summary="Create an issue type scheme from JSON representation", description="Creates an issue type scheme from a JSON representation", security={@SecurityRequirement(name="basic")})
    @RequestBody(description="Issue type scheme creation details.", required=true, content={@Content(schema=@Schema(implementation=IssueTypeSchemeCreateUpdateBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Returns a JSON representation of the newly created IssueTypeScheme if successful.", responseCode="200", content={@Content(schema=@Schema(implementation=IssueTypeSchemeBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the request is invalid.", responseCode="400"), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to administer Jira.", responseCode="403")})
    public Response createIssueTypeScheme(IssueTypeSchemeCreateUpdateBean createBean) {
        ServiceOutcome result = this.issueTypeSchemeService.createIssueTypeScheme(this.authContext.getLoggedInUser(), createBean.getName(), createBean.getDescription(), createBean.getIssueTypeIds(), createBean.getDefaultIssueTypeId());
        if (result.isValid()) {
            this.publishAnalytics("issuetypescheme.createScheme", true);
            return this.responseFactory.okNoCache(this.schemeToFullyExpandedBean((FieldConfigScheme)result.get()));
        }
        this.publishAnalytics("issuetypescheme.createScheme", false);
        return this.responseFactory.errorResponse(result.getErrorCollection());
    }

    @GET
    @Operation(summary="Get list of all issue type schemes visible to user", description="Returns a list of all issue type schemes visible to the user. All issue types associated with the scheme will only be returned if an additional query parameter is provided: expand=schemes.issueTypes. Similarly, the default issue type associated with the scheme (if one exists) will only be returned if an additional query parameter is provided: expand=schemes.defaultIssueType. Note that both query parameters can be used together: expand=schemes.issueTypes,schemes.defaultIssueType.", security={@SecurityRequirement(name="basic")})
    @ApiResponses(value={@ApiResponse(description="Returns a list of issue type schemes.", responseCode="200", content={@Content(schema=@Schema(implementation=IssueTypeSchemeListBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to administer Jira.", responseCode="403")})
    public Response getAllIssueTypeSchemes() {
        ServiceOutcome result = this.issueTypeSchemeService.getAllIssueTypeSchemes(this.authContext.getLoggedInUser());
        if (result.isValid()) {
            this.publishAnalytics("issuetypescheme.getAllSchemes", true);
            IssueTypeSchemeListBean schemesList = new IssueTypeSchemeListBean(((List)result.get()).stream().map(this::schemeToBean).collect(Collectors.toList()));
            return this.responseFactory.okNoCache(schemesList);
        }
        this.publishAnalytics("issuetypescheme.getAllSchemes", false);
        return this.responseFactory.errorResponse(result.getErrorCollection());
    }

    @GET
    @Path(value="{schemeId}")
    @Operation(summary="Get full representation of issue type scheme by id", description="Returns a full representation of the issue type scheme that has the given id", security={@SecurityRequirement(name="basic")})
    @Parameter(name="schemeId", description="A String containing an issue type scheme's id.", in=ParameterIn.PATH, required=true)
    @ApiResponses(value={@ApiResponse(description="Returns a full representation of the issue type scheme with the given id.", responseCode="200", content={@Content(schema=@Schema(implementation=IssueTypeSchemeBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to administer Jira.", responseCode="403"), @ApiResponse(description="Returned if the issue type scheme does not exist.", responseCode="404")})
    public Response getIssueTypeScheme(@PathParam(value="schemeId") String schemeId) {
        ServiceOutcome result = this.issueTypeSchemeService.getIssueTypeScheme(this.authContext.getLoggedInUser(), schemeId);
        if (result.isValid()) {
            this.publishAnalytics("issuetypescheme.getScheme", true);
            return this.responseFactory.okNoCache(this.schemeToBean((FieldConfigScheme)result.get()));
        }
        this.publishAnalytics("issuetypescheme.getScheme", false);
        return this.responseFactory.errorResponse(result.getErrorCollection());
    }

    @PUT
    @Path(value="{schemeId}")
    @Operation(summary="Update specified issue type scheme from JSON representation", description="Updates the specified issue type scheme from a JSON representation", security={@SecurityRequirement(name="basic")})
    @Parameter(name="schemeId", description="The id of the issue type scheme to update.", in=ParameterIn.PATH, required=true)
    @RequestBody(description="Specifies the new set of attributes that the issue type scheme will take on.", required=true, content={@Content(schema=@Schema(implementation=IssueTypeSchemeCreateUpdateBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Returns a JSON representation of the updated issue type scheme.", responseCode="200", content={@Content(schema=@Schema(implementation=IssueTypeSchemeBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the request is invalid. This happens when the name or issue types are invalid. It also occurs when the default issue type isn't found in the associated issue types collection.", responseCode="400"), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to administer Jira.", responseCode="403"), @ApiResponse(description="Returned if the issue type scheme to update does not exist.", responseCode="404")})
    public Response updateIssueTypeScheme(@PathParam(value="schemeId") String schemeId, IssueTypeSchemeCreateUpdateBean updateBean) {
        ServiceOutcome result = this.issueTypeSchemeService.updateIssueTypeScheme(this.authContext.getLoggedInUser(), schemeId, updateBean.getName(), updateBean.getDescription(), updateBean.getIssueTypeIds(), updateBean.getDefaultIssueTypeId());
        if (result.isValid()) {
            this.publishAnalytics("issuetypescheme.updateScheme", true);
            return this.responseFactory.okNoCache(this.schemeToFullyExpandedBean((FieldConfigScheme)result.get()));
        }
        this.publishAnalytics("issuetypescheme.updateScheme", false);
        return this.responseFactory.errorResponse(result.getErrorCollection());
    }

    @DELETE
    @Path(value="{schemeId}")
    @Operation(summary="Delete specified issue type scheme", description="Deletes the specified issue type scheme. Any projects associated with this IssueTypeScheme will be automatically associated with the global default IssueTypeScheme.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="schemeId", description="The id of the issue type scheme to remove.", in=ParameterIn.PATH, required=true)
    @ApiResponses(value={@ApiResponse(description="Confirmation that the delete was successful.", responseCode="204"), @ApiResponse(description="Returned if the request is invalid. It happens when there are associated issues with the issue type which is being removed, but it is impossible to migrate these issues to the alternative issue type.", responseCode="400"), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to administer Jira or if an attempt is made to delete the default IssueTypeScheme.", responseCode="403"), @ApiResponse(description="Returned if the issue type scheme which is supposed to be removed does not exist.", responseCode="404")})
    public Response deleteIssueTypeScheme(@PathParam(value="schemeId") String schemeId) {
        ServiceOutcome result = this.issueTypeSchemeService.deleteIssueTypeScheme(this.authContext.getLoggedInUser(), schemeId);
        if (result.isValid()) {
            this.publishAnalytics("issuetypescheme.deleteScheme", true);
            return this.responseFactory.noContent();
        }
        this.publishAnalytics("issuetypescheme.deleteScheme", false);
        return this.responseFactory.errorResponse(result.getErrorCollection());
    }

    @POST
    @Path(value="{schemeId}/associations")
    @Operation(summary="Add project associations to scheme", description="Adds additional projects to those already associated with the specified issue type scheme", security={@SecurityRequirement(name="basic")})
    @Parameter(name="schemeId", description="The id of the issue type scheme whose project associations we're adding to.", in=ParameterIn.PATH, required=true)
    @RequestBody(description="Collection of projects, specified by id or key, to associate with this issue type scheme", required=true, content={@Content(schema=@Schema(implementation=AssociateProjectsBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Confirmation that the association was successful.", responseCode="200"), @ApiResponse(description="Returned if the request is invalid. This occurs when the supplied project ids/keys are invalid. It also happens if performing the association would require an issue type migration for any of the projects.", responseCode="400"), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to administer Jira.", responseCode="403"), @ApiResponse(description="Returned if the issue type scheme to update does not exist.", responseCode="404")})
    public Response addProjectAssociationsToScheme(@PathParam(value="schemeId") String schemeId, AssociateProjectsBean assocProjects) throws SearchException {
        ServiceOutcome result = this.issueTypeSchemeService.addProjectAssociations(this.authContext.getLoggedInUser(), schemeId, assocProjects.getIdsOrKeys());
        if (result.isValid()) {
            this.publishAnalytics("issuetypescheme.addProjectAssociations", true);
            return Response.ok().cacheControl(CacheControl.never()).build();
        }
        this.publishAnalytics("issuetypescheme.addProjectAssociations", false);
        return this.responseFactory.errorResponse(result.getErrorCollection());
    }

    @GET
    @Path(value="{schemeId}/associations")
    @Operation(summary="Get all of the associated projects for specified scheme", description="For the specified issue type scheme, returns all of the associated projects", security={@SecurityRequirement(name="basic")})
    @Parameter(name="schemeId", description="Id of the issue type scheme whose projects we're accessing", in=ParameterIn.PATH, required=true)
    @ApiResponses(value={@ApiResponse(description="The collection of projects associated with this issue type scheme.", responseCode="200", content={@Content(schema=@Schema(implementation=ProjectBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to administer Jira.", responseCode="403"), @ApiResponse(description="Returned if the specified issue type scheme does not exist.", responseCode="404")})
    public Response getAssociatedProjects(@PathParam(value="schemeId") String schemeId, @QueryParam(value="expand") String expand) {
        ServiceOutcome result = this.issueTypeSchemeService.getAssociatedProjects(this.authContext.getLoggedInUser(), schemeId);
        if (result.isValid()) {
            this.publishAnalytics("issuetypescheme.getProjectAssociations", true);
            return this.responseFactory.okNoCache(((List)result.get()).stream().map(proj -> this.projectBeanFactory.fullProject((Project)proj, StringUtils.defaultString((String)expand))).collect(Collectors.toList()));
        }
        this.publishAnalytics("issuetypescheme.getProjectAssociations", false);
        return this.responseFactory.errorResponse(result.getErrorCollection());
    }

    @PUT
    @Path(value="{schemeId}/associations")
    @Operation(summary="Set project associations for scheme", description="Associates the given projects with the specified issue type scheme", security={@SecurityRequirement(name="basic")})
    @Parameter(name="schemeId", description="The id of the issue type scheme whose project associations we're replacing.", in=ParameterIn.PATH, required=true)
    @RequestBody(description="Collection of projects, specified by id or key, to associate with this issue type scheme", required=true, content={@Content(schema=@Schema(implementation=AssociateProjectsBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Confirmation that the association was successful.", responseCode="200"), @ApiResponse(description="Returned if the request is invalid. This occurs when the supplied project ids/keys are invalid. It also happens if performing the association would require an issue type migration for any of the newly associated projects.", responseCode="400"), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to administer Jira.", responseCode="403"), @ApiResponse(description="Returned if the issue type scheme to update does not exist.", responseCode="404")})
    public Response setProjectAssociationsForScheme(@PathParam(value="schemeId") String schemeId, AssociateProjectsBean assocProjects) throws SearchException {
        ServiceOutcome result = this.issueTypeSchemeService.setProjectAssociations(this.authContext.getLoggedInUser(), schemeId, assocProjects.getIdsOrKeys());
        if (result.isValid()) {
            this.publishAnalytics("issuetypescheme.setProjectAssociations", true);
            return Response.ok().cacheControl(CacheControl.never()).build();
        }
        this.publishAnalytics("issuetypescheme.setProjectAssociations", false);
        return this.responseFactory.errorResponse(result.getErrorCollection());
    }

    @DELETE
    @Path(value="{schemeId}/associations")
    @Operation(summary="Remove all project associations for specified scheme", description="Removes all project associations for the specified issue type scheme", security={@SecurityRequirement(name="basic")})
    @Parameter(name="schemeId", description="The id of the issue type scheme whose project associations we're removing", in=ParameterIn.PATH, required=true)
    @ApiResponses(value={@ApiResponse(description="Confirmation that the associations were removed.", responseCode="204"), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to administer Jira or if an attempt is made to remove associations for the default/global issue type scheme.", responseCode="403"), @ApiResponse(description="Returned if the specified issue type scheme does not exist.", responseCode="404")})
    public Response removeAllProjectAssociations(@PathParam(value="schemeId") String schemeId) {
        ServiceOutcome result = this.issueTypeSchemeService.removeAllProjectAssociations(this.authContext.getLoggedInUser(), schemeId);
        if (result.isValid()) {
            this.publishAnalytics("issuetypescheme.removeAllProjectAssociations", true);
            return this.responseFactory.noContent();
        }
        this.publishAnalytics("issuetypescheme.removeAllProjectAssociations", false);
        return this.responseFactory.errorResponse(result.getErrorCollection());
    }

    @DELETE
    @Path(value="{schemeId}/associations/{projIdOrKey}")
    @Operation(summary="Remove given project association for specified scheme", description="For the specified issue type scheme, removes the given project association", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="schemeId", description="The id of the issue type scheme whose project association we're removing", in=ParameterIn.PATH, required=true), @Parameter(name="projIdOrKey", description="The id or key of the project that is to be un-associated with the issue type scheme", in=ParameterIn.PATH, required=true)})
    @ApiResponses(value={@ApiResponse(description="Confirmation that the association was removed.", responseCode="204"), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to administer Jira or if an attempt is made to remove an association for the default/global issue type scheme.", responseCode="403"), @ApiResponse(description="Returned if the specified issue type scheme or project does not exist.", responseCode="404")})
    public Response removeProjectAssociation(@PathParam(value="schemeId") String schemeId, @PathParam(value="projIdOrKey") String projIdOrKey) {
        ServiceOutcome result = this.issueTypeSchemeService.removeProjectAssociation(this.authContext.getLoggedInUser(), schemeId, projIdOrKey);
        if (result.isValid()) {
            this.publishAnalytics("issuetypescheme.removeProjectAssociation", true);
            return this.responseFactory.noContent();
        }
        this.publishAnalytics("issuetypescheme.removeProjectAssociation", false);
        return this.responseFactory.errorResponse(result.getErrorCollection());
    }

    private IssueTypeSchemeBean schemeToBean(FieldConfigScheme itScheme) {
        ApplicationUser user = this.authContext.getUser();
        IssueTypeSchemeBean bean = new IssueTypeSchemeBean();
        bean.setId(itScheme.getId().toString());
        bean.setSelf(this.jiraBaseUrls.restApi2BaseUrl() + "issuetypescheme/" + itScheme.getId());
        bean.setName(itScheme.getName());
        bean.setDescription(itScheme.getDescription());
        bean.setDefaultIssueTypeSupplier(() -> {
            IssueType defaultIT = this.issueTypeSchemeService.getDefaultIssueType(itScheme);
            return defaultIT == null ? null : IssueTypeJsonBean.shortBean((IssueType)defaultIT, (JiraBaseUrls)this.jiraBaseUrls);
        });
        bean.setIssueTypesSupplier(() -> {
            FieldConfig config = itScheme.getOneAndOnlyConfig();
            Collection options = this.optionSetManager.getOptionsForConfig(config).getOptions();
            return options.stream().map(o -> o.getId()).map(id -> this.issueTypeService.getIssueType(user, id)).map(itype -> IssueTypeJsonBean.shortBean((IssueType)((IssueType)itype.get()), (JiraBaseUrls)this.jiraBaseUrls)).collect(Collectors.toList());
        });
        return bean;
    }

    private IssueTypeSchemeBean schemeToFullyExpandedBean(FieldConfigScheme itScheme) {
        IssueTypeSchemeBean maybeExpanded = this.schemeToBean(itScheme);
        maybeExpanded.setIssueTypes((Collection<IssueTypeJsonBean>)maybeExpanded.getIssueTypesSupplier().get());
        maybeExpanded.setDefaultIssueType(maybeExpanded.getDefaultIssueTypeSupplier().get());
        return maybeExpanded;
    }

    private void publishAnalytics(String endpoint, boolean successfulUsage) {
        this.eventPublisher.publish((Object)new EndpointUsageEvent(endpoint, successfulUsage));
    }
}

