/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeJsonBean;
import com.atlassian.plugins.rest.api.expand.annotation.Expandable;
import com.atlassian.plugins.rest.api.expand.expander.SelfExpanding;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.xml.bind.annotation.XmlAttribute;

public class IssueTypeSchemeBean {
    @XmlAttribute(name="expand")
    @Schema(example="issueTypes")
    private String expand;
    @JsonProperty
    @Schema(example="http://localhost:8090/jira/rest/api/2/issuetypescheme/10100")
    private String self;
    @JsonProperty
    @Schema(example="10100")
    private String id;
    @JsonProperty
    @Schema(example="Some grouping of issue types for the greater good.")
    private String name;
    @JsonProperty
    @Schema(example="A brief explanation of this issue type scheme.")
    private String description;
    @JsonProperty
    private IssueTypeJsonBean defaultIssueType;
    @JsonIgnore
    private Supplier<IssueTypeJsonBean> defaultIssueTypeSupplier;
    @JsonIgnore
    @Expandable(value="defaultIssueType")
    private SelfExpanding defaultIssueTypeExpander = () -> {
        this.defaultIssueType = this.defaultIssueTypeSupplier.get();
    };
    @JsonProperty
    private List<IssueTypeJsonBean> issueTypes;
    @JsonIgnore
    private Supplier<List<IssueTypeJsonBean>> issueTypesSupplier;
    @JsonIgnore
    @Expandable(value="issueTypes")
    private SelfExpanding issueTypesExpander = () -> {
        this.issueTypes = this.issueTypesSupplier.get();
    };

    public String getExpand() {
        return this.expand;
    }

    public void setExpand(String expand) {
        this.expand = expand;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public IssueTypeJsonBean getDefaultIssueType() {
        return this.defaultIssueType;
    }

    public void setDefaultIssueType(IssueTypeJsonBean defaultIssueType) {
        this.defaultIssueType = defaultIssueType;
    }

    public Supplier<IssueTypeJsonBean> getDefaultIssueTypeSupplier() {
        return this.defaultIssueTypeSupplier;
    }

    public void setDefaultIssueTypeSupplier(Supplier<IssueTypeJsonBean> defaultIssueTypeSupplier) {
        this.defaultIssueTypeSupplier = defaultIssueTypeSupplier;
    }

    public SelfExpanding getDefaultIssueTypeExpander() {
        return this.defaultIssueTypeExpander;
    }

    public void setDefaultIssueTypeExpander(SelfExpanding defaultIssueTypeExpander) {
        this.defaultIssueTypeExpander = defaultIssueTypeExpander;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSelf() {
        return this.self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public Supplier<List<IssueTypeJsonBean>> getIssueTypesSupplier() {
        return this.issueTypesSupplier;
    }

    public void setIssueTypesSupplier(Supplier<List<IssueTypeJsonBean>> issueTypesSupplier) {
        this.issueTypesSupplier = issueTypesSupplier;
    }

    public List<IssueTypeJsonBean> getIssueTypes() {
        return this.issueTypes;
    }

    public void setIssueTypes(Collection<IssueTypeJsonBean> issueTypes) {
        this.issueTypes = new ArrayList<IssueTypeJsonBean>(issueTypes);
    }

    public String toString() {
        return "IssueTypeSchemeBean{self='" + this.self + "', id='" + this.id + "', name='" + this.name + "', description='" + this.description + "', defaultIssueType='" + this.defaultIssueType + "', issueTypes=" + this.issueTypes + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueTypeSchemeBean that = (IssueTypeSchemeBean)o;
        return Objects.equals(this.expand, that.expand) && Objects.equals(this.self, that.self) && Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.defaultIssueType, that.defaultIssueType) && Objects.equals(this.issueTypes, that.issueTypes);
    }

    public int hashCode() {
        return Objects.hash(this.expand, this.self, this.id, this.name, this.description, this.defaultIssueType, this.issueTypes);
    }
}

