/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.config.IssueTypeService;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeCreateBean;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeUpdateBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.pagination.PageBean;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.v2.issue.AvatarBean;
import com.atlassian.jira.rest.v2.issue.AvatarCroppingBean;
import com.atlassian.jira.rest.v2.issue.AvatarResourceHelper;
import com.atlassian.jira.rest.v2.issue.IssueTypeBeanBuilder;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.XsrfCheckResult;
import com.atlassian.jira.security.xsrf.XsrfInvocationChecker;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import com.atlassian.jira.util.PageRequests;
import com.atlassian.jira.util.Pages;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugins.rest.api.multipart.FilePart;
import com.atlassian.plugins.rest.api.multipart.MultipartFormParam;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.Option;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="issuetype")
@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IssueTypeResource {
    private final JiraAuthenticationContext authContext;
    private final UriInfo contextUriInfo;
    private final JiraBaseUrls jiraBaseUrls;
    private final IssueTypeService issueTypeService;
    private final I18nHelper i18n;
    private final XsrfInvocationChecker xsrfChecker;
    private final AvatarResourceHelper avatarResourceHelper;
    private final GlobalPermissionManager globalPermissionManager;
    private final ResponseFactory responseFactory;

    @Inject
    public IssueTypeResource(JiraAuthenticationContext authContext, UriInfo contextUriInfo, JiraBaseUrls jiraBaseUrls, IssueTypeService issueTypeService, I18nHelper i18n, XsrfInvocationChecker xsrfChecker, AvatarResourceHelper avatarResourceHelper, GlobalPermissionManager globalPermissionManager, ResponseFactory responseFactory) {
        this.authContext = authContext;
        this.contextUriInfo = contextUriInfo;
        this.jiraBaseUrls = jiraBaseUrls;
        this.issueTypeService = issueTypeService;
        this.i18n = i18n;
        this.xsrfChecker = xsrfChecker;
        this.avatarResourceHelper = avatarResourceHelper;
        this.globalPermissionManager = globalPermissionManager;
        this.responseFactory = responseFactory;
    }

    @GET
    @Operation(summary="Get list of all issue types visible to user", description="Returns a list of all issue types visible to the user", security={@SecurityRequirement(name="basic")})
    @ApiResponses(value={@ApiResponse(description="Returns a list of issue types.", responseCode="200", content={@Content(schema=@Schema(implementation=IssueTypeJsonBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the user is not logged in.", responseCode="401"), @ApiResponse(description="Returned if the user does not have the administrator permission.", responseCode="403")})
    public Response getIssueAllTypes() {
        return Response.ok(this.transformIssueTypeToBeans(this.issueTypeService.getIssueTypes(this.authContext.getUser()))).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="{id}")
    @Operation(summary="Get full representation of issue type by id", description="Returns a full representation of the issue type that has the given id.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="id", description="The issue type id.", in=ParameterIn.PATH, required=true)
    @ApiResponses(value={@ApiResponse(description="Returns the issue type with the given id.", responseCode="200", content={@Content(schema=@Schema(implementation=IssueTypeJsonBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the issue type does not exist, or is not visible to the calling user.", responseCode="404")})
    public Response getIssueType(@PathParam(value="id") String issueTypeId) {
        return (Response)this.issueTypeService.getIssueType(this.authContext.getUser(), issueTypeId).fold(this::notFoundResponse, issueType -> Response.ok((Object)this.createIssueTypeBean((IssueType)issueType)).cacheControl(CacheControl.never()).build());
    }

    @GET
    @Path(value="{id}/alternatives")
    @Operation(summary="Get list of alternative issue types for given id", description="Returns a list of all alternative issue types for the given issue type id.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="id", description="The issue type id.", in=ParameterIn.PATH, required=true)
    @ApiResponses(value={@ApiResponse(description="Returns a list of issue types.", responseCode="200", content={@Content(schema=@Schema(implementation=IssueTypeJsonBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the issue type does not exist, or is not visible to the calling user.", responseCode="404")})
    public Response getAlternativeIssueTypes(@PathParam(value="id") String issueTypeId) {
        ApplicationUser user = this.authContext.getUser();
        Option issueType = this.issueTypeService.getIssueType(user, issueTypeId);
        return (Response)issueType.fold(this::notFoundResponse, issueType1 -> Response.ok(this.transformIssueTypeToBeans(this.issueTypeService.getAvailableAlternativesForIssueType(this.authContext.getUser(), issueTypeId))).cacheControl(CacheControl.never()).build());
    }

    @POST
    @Operation(summary="Create an issue type from JSON representation", description="Creates an issue type from a JSON representation and adds the issue newly created issue type to the default issue type scheme.", security={@SecurityRequirement(name="basic")})
    @RequestBody(description="All information about the issue type.", required=true, content={@Content(schema=@Schema(implementation=IssueTypeCreateBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="The new issue type has been created.", responseCode="201"), @ApiResponse(description="Returned if the request is invalid. This happens when the name is invalid or issue type is subtask on instance which has subtasks disabled.", responseCode="400"), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to administer Jira.", responseCode="403"), @ApiResponse(description="Returned if there already exists an issue type with the specified name.", responseCode="409")})
    public Response createIssueType(IssueTypeCreateBean issueTypeCreateBean) {
        ApplicationUser user = this.authContext.getUser();
        IssueTypeService.CreateValidationResult validationResult = this.issueTypeService.validateCreateIssueType(user, this.issueTypeCreateInputFromBean(issueTypeCreateBean));
        if (validationResult.isValid()) {
            IssueTypeService.IssueTypeResult issueTypeResult = this.issueTypeService.createIssueType(user, validationResult);
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)this.createIssueTypeBean(issueTypeResult.getIssueType())).cacheControl(CacheControl.never()).build();
        }
        return this.error(validationResult.getErrorCollection());
    }

    @DELETE
    @Path(value="{id}")
    @Operation(summary="Delete specified issue type and migrate associated issues", description="Deletes the specified issue type. If the issue type has any associated issues, these issues will be migrated to the alternative issue type specified in the parameter.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="id", description="The issue type id.", in=ParameterIn.PATH, required=true), @Parameter(name="alternativeIssueTypeId", description="The id of an issue type to which issues associated with the removed issue type will be migrated.", in=ParameterIn.PATH, required=true)})
    @ApiResponses(value={@ApiResponse(description="Returns NO_CONTENT if successful.", responseCode="204"), @ApiResponse(description="Returned if the request is invalid. It happens when there are associated issues with the issue type which is being removed, but it is impossible to migrate these issues to the alternative issue type.", responseCode="400"), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to administer Jira.", responseCode="403"), @ApiResponse(description="Returned if the issue type to update does not exist.", responseCode="404")})
    public Response deleteIssueType(@PathParam(value="id") String issueTypeId, @QueryParam(value="alternativeIssueTypeId") String alternativeIssueTypeId) {
        IssueTypeService.IssueTypeDeleteInput issueTypeDeleteInput;
        ApplicationUser user = this.authContext.getUser();
        IssueTypeService.DeleteValidationResult validationResult = this.issueTypeService.validateDeleteIssueType(user, issueTypeDeleteInput = new IssueTypeService.IssueTypeDeleteInput(issueTypeId, Option.option((Object)alternativeIssueTypeId)));
        if (validationResult.isValid()) {
            this.issueTypeService.deleteIssueType(user, validationResult);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(CacheControl.never()).build();
        }
        return this.error(validationResult.getErrorCollection());
    }

    @PUT
    @Path(value="{id}")
    @Operation(summary="Update specified issue type from JSON representation", description="Updates the specified issue type from a JSON representation.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="id", description="The issue type id.", in=ParameterIn.PATH, required=true)
    @RequestBody(description="All information about the issue type.", required=true, content={@Content(schema=@Schema(implementation=IssueTypeUpdateBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Returned if the issue type was updated successfully.", responseCode="200"), @ApiResponse(description="Returned if the request is invalid. This happens when the name is invalid or if the avatar with given id does not exist.", responseCode="400"), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to administer Jira.", responseCode="403"), @ApiResponse(description="Returned if the issue type to update does not exist.", responseCode="404"), @ApiResponse(description="Returned if there already exists an issue type with the specified name.", responseCode="409")})
    public Response updateIssueType(@PathParam(value="id") String issueTypeId, IssueTypeUpdateBean issueTypeUpdateBean) {
        IssueTypeService.IssueTypeUpdateInput updateInput;
        ApplicationUser user = this.authContext.getUser();
        IssueTypeService.UpdateValidationResult updateValidationResult = this.issueTypeService.validateUpdateIssueType(user, issueTypeId, updateInput = this.issueTypeUpdateInputFromBean(issueTypeUpdateBean));
        if (updateValidationResult.isValid()) {
            IssueTypeService.IssueTypeResult issueTypeResult = this.issueTypeService.updateIssueType(user, updateValidationResult);
            return Response.ok((Object)this.createIssueTypeBean(issueTypeResult.getIssueType())).cacheControl(CacheControl.never()).build();
        }
        return this.error(updateValidationResult.getErrorCollection());
    }

    @POST
    @Consumes(value={"*/*"})
    @Path(value="{id}/avatar/temporary")
    @Operation(summary="Create temporary avatar for issue type", description="Creates temporary avatar. Creating a temporary avatar is part of a 3-step process in uploading a new avatar for an issue type: upload, crop, confirm.\nThe following examples shows these three steps using curl.\nThe cookies (session) need to be preserved between requests, hence the use of -b and -c.\nThe id created in step 2 needs to be passed to step 3\n(you can simply pass the whole response of step 2 as the request of step 3).\ncurl -c cookiejar.txt -X POST -u admin:admin -H \"X-Atlassian-Token: no-check\" \\\n  -H \"Content-Type: image/png\" --data-binary @mynewavatar.png \\\n  'http://localhost:8090/jira/rest/api/2/issuetype/1/avatar/temporary?filename=mynewavatar.png'\n\ncurl -b cookiejar.txt -X POST -u admin:admin -H \"X-Atlassian-Token: no-check\" \\\n  -H \"Content-Type: application/json\" --data '{\"cropperWidth\": \"65\",\"cropperOffsetX\": \"10\",\"cropperOffsetY\": \"16\"}' \\\n  -o tmpid.json \\\n  http://localhost:8090/jira/rest/api/2/issuetype/1/avatar\n\ncurl -b cookiejar.txt -X PUT -u admin:admin -H \"X-Atlassian-Token: no-check\" \\\n  -H \"Content-Type: application/json\" --data-binary @tmpid.json \\\n  http://localhost:8090/jira/rest/api/2/issuetype/1/avatar", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="id", description="The issue type id.", in=ParameterIn.PATH, required=true), @Parameter(name="filename", description="Name of file being uploaded.", in=ParameterIn.PATH, required=true), @Parameter(name="size", description="Size of file.", in=ParameterIn.PATH, required=true)})
    @ApiResponses(value={@ApiResponse(description="Temporary avatar cropping instructions.", responseCode="201", content={@Content(schema=@Schema(implementation=AvatarCroppingBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to administer Jira.", responseCode="403"), @ApiResponse(description="Returned if the issue type to update does not exist or if the request does not contain valid XSRF token.", responseCode="404")})
    public Response storeTemporaryAvatar(@PathParam(value="id") String issueTypeId, @QueryParam(value="filename") String filename, @QueryParam(value="size") Long size, @Context HttpServletRequest request) {
        return (Response)this.validateUploadAttachment(this.authContext.getUser(), issueTypeId).getOr(() -> this.avatarResourceHelper.storeTemporaryAvatar(IconType.ISSUE_TYPE_ICON_TYPE, issueTypeId, filename, size, request));
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="{id}/avatar/temporary")
    @Produces(value={"text/html"})
    @Operation(summary="Create temporary avatar using multipart for issue type", description="Creates temporary avatar using multipart. The response is sent back as JSON stored in a textarea. This is because\nthe client uses remote iframing to submit avatars using multipart. So we must send them a valid HTML page back from\nwhich the client parses the JSON from.\nCreating a temporary avatar is part of a 3-step process in uploading a new\navatar for an issue type: upload, crop, confirm. This endpoint allows you to use a multipart upload\ninstead of sending the image directly as the request body.\nYou *must* use \"avatar\" as the name of the upload parameter:\ncurl -c cookiejar.txt -X POST -u admin:admin -H \"X-Atlassian-Token: no-check\" \\\n  -F \"avatar=@mynewavatar.png;type=image/png\" \\\n  'http://localhost:8090/jira/rest/api/2/issuetype/1/avatar/temporary'", security={@SecurityRequirement(name="basic")})
    @Parameter(name="id", description="The issue type id.", in=ParameterIn.PATH, required=true)
    @ApiResponses(value={@ApiResponse(description="Temporary avatar cropping instructions embeded in HTML page. Error messages will also be embeded in the page.", responseCode="201", content={@Content(schema=@Schema(implementation=AvatarCroppingBean.class), mediaType="text/html")}), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to administer Jira.", responseCode="403"), @ApiResponse(description="Returned if the issue type to update does not exist or if the request does not contain valid XSRF token.", responseCode="404")})
    public Response storeTemporaryAvatarUsingMultiPart(@PathParam(value="id") String issueTypeId, @MultipartFormParam(value="avatar") FilePart filePart, @Context HttpServletRequest request) {
        return (Response)this.validateUploadAttachment(this.authContext.getUser(), issueTypeId).getOr(() -> this.avatarResourceHelper.storeTemporaryAvatarUsingMultiPart(IconType.ISSUE_TYPE_ICON_TYPE, issueTypeId, filePart, request));
    }

    @POST
    @Path(value="{id}/avatar")
    @Operation(summary="Convert temporary avatar into a real avatar", description="Converts temporary avatar into a real avatar", security={@SecurityRequirement(name="basic")})
    @Parameter(name="id", description="The issue type id.", in=ParameterIn.PATH, required=true)
    @RequestBody(description="Cropping instructions.", required=true, content={@Content(schema=@Schema(implementation=AvatarCroppingBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Returns created avatar.", responseCode="201", content={@Content(schema=@Schema(implementation=AvatarBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the cropping coordinates are invalid.", responseCode="400"), @ApiResponse(description="Returned if the currently authenticated user does not have permission to pick avatar.", responseCode="403"), @ApiResponse(description="Returned if the currently authenticated user does not have EDIT PROJECT permission.", responseCode="404"), @ApiResponse(description="Returned if an error occurs while converting temporary avatar to real avatar.", responseCode="500")})
    public Response createAvatarFromTemporary(@PathParam(value="id") String issueTypeId, AvatarCroppingBean croppingInstructions) {
        return (Response)this.validateUploadAttachment(this.authContext.getUser(), issueTypeId).getOr(() -> this.avatarResourceHelper.createAvatarFromTemporary(IconType.ISSUE_TYPE_ICON_TYPE, issueTypeId, croppingInstructions));
    }

    @GET
    @Path(value="page")
    @Produces(value={"application/json"})
    @ExperimentalApi
    @Operation(summary="Get paginated list of filtered issue types", description="Returns paginated list of filtered issue types", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="startAt", description="The index of the first issue type to return."), @Parameter(name="maxResults", description="The maximum number of issue types to return."), @Parameter(name="query", description="The string that issue type names will be matched with."), @Parameter(name="projectIds", description="The set of project ids to filter issue types.")})
    @ApiResponse(description="Returns paginated list of issue types.", responseCode="200", content={@Content(schema=@Schema(implementation=IssueTypeJsonBean.class), mediaType="application/json")})
    public Response getPaginatedIssueTypes(@Context UriInfo uriInfo, @HeaderParam(value="X-Requested-With") String requestedWith, @DefaultValue(value="0") @QueryParam(value="startAt") Long startAt, @DefaultValue(value="100") @QueryParam(value="maxResults") Integer maxResults, @DefaultValue(value="") @QueryParam(value="query") String query, @QueryParam(value="projectIds") Set<Long> projectIds) {
        ApplicationUser user = this.authContext.getLoggedInUser();
        Stream issueTypeStream = projectIds.isEmpty() ? this.issueTypeService.findIssueTypes(user, query) : this.issueTypeService.findIssueTypes(user, query, projectIds);
        PageRequest pageRequest = PageRequests.request((Long)startAt, (Integer)maxResults);
        Page statusPage = Pages.toPage(() -> issueTypeStream.sorted(Comparator.comparing(IssueConstant::getName)).iterator(), (PageRequest)pageRequest);
        PageBean<IssueTypeJsonBean> bean = PageBean.from(pageRequest, statusPage).build(issueType -> IssueTypeJsonBean.shortBean((IssueType)issueType, (JiraBaseUrls)this.jiraBaseUrls));
        return Response.ok(bean).cacheControl(CacheControl.never()).build();
    }

    private Option<Response> validateUploadAttachment(ApplicationUser user, String issueTypeId) {
        XsrfCheckResult xsrfCheckResult = this.xsrfChecker.checkWebRequestInvocation(ExecutingHttpRequest.get());
        if (user == null) {
            return Option.some((Object)Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)ErrorCollection.of(this.i18n.getText("rest.authentication.no.user.logged.in"))).cacheControl(CacheControl.never()).build());
        }
        if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user)) {
            return Option.some((Object)Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ErrorCollection.of(this.i18n.getText("rest.authorization.admin.required"))).cacheControl(CacheControl.never()).build());
        }
        if (this.issueTypeService.getIssueType(user, issueTypeId).isEmpty()) {
            return Option.some((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorCollection.of(this.i18n.getText("admin.error.issue.type.update.not.exist"))).cacheControl(CacheControl.never()).build());
        }
        if (xsrfCheckResult.isRequired() && !xsrfCheckResult.isValid()) {
            return Option.some((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"XSRF check failed").build());
        }
        return Option.none(Response.class);
    }

    private Response error(com.atlassian.jira.util.ErrorCollection errorCollection) {
        ErrorCollection.Reason reason = ErrorCollection.Reason.getWorstReason((Collection)errorCollection.getReasons());
        return Response.status((int)reason.getHttpStatusCode()).entity((Object)ErrorCollection.of(errorCollection)).cacheControl(CacheControl.never()).build();
    }

    private List<IssueTypeJsonBean> transformIssueTypeToBeans(Iterable<IssueType> issueTypes) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(issueTypes, this::createIssueTypeBean));
    }

    private IssueTypeJsonBean createIssueTypeBean(IssueType issueType) {
        return new IssueTypeBeanBuilder().jiraBaseUrls(this.jiraBaseUrls).context(this.contextUriInfo).issueType(issueType).build();
    }

    private IssueTypeService.IssueTypeCreateInput issueTypeCreateInputFromBean(IssueTypeCreateBean issueTypeCreateBean) {
        return IssueTypeService.IssueTypeCreateInput.builder().setDescription(issueTypeCreateBean.getDescription()).setName(issueTypeCreateBean.getName()).setType(issueTypeCreateBean.getType() == IssueTypeCreateBean.Type.standard ? IssueTypeService.IssueTypeCreateInput.Type.STANDARD : IssueTypeService.IssueTypeCreateInput.Type.SUBTASK).build();
    }

    private IssueTypeService.IssueTypeUpdateInput issueTypeUpdateInputFromBean(IssueTypeUpdateBean issueTypeUpdateBean) {
        return IssueTypeService.IssueTypeUpdateInput.builder().setDescription(issueTypeUpdateBean.getDescription()).setName(issueTypeUpdateBean.getName()).setAvatarId(issueTypeUpdateBean.getAvatarId()).build();
    }

    private Response notFoundResponse() {
        return this.responseFactory.notFound("admin.error.issue.type.get.not.exist", new String[0]);
    }
}

