/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.bc.issuetype.property.IssueTypePropertyService;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.issue.fields.rest.json.beans.EntityPropertyBean;
import com.atlassian.jira.issue.fields.rest.json.beans.EntityPropertyBeanSelfFunctions;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.issuetype.IssueTypeWithID;
import com.atlassian.jira.rest.v2.admin.WorkflowTransitionResource;
import com.atlassian.jira.rest.v2.entity.property.BasePropertyResource;
import com.atlassian.jira.rest.v2.entity.property.EntityPropertiesKeysBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.function.BiFunction;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="issuetype/{issueTypeId}/properties")
@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IssueTypePropertyResource {
    private final BasePropertyResource<IssueTypeWithID> delegate;

    @Inject
    public IssueTypePropertyResource(IssueTypePropertyService issueTypePropertyService, JiraAuthenticationContext authenticationContext, JiraBaseUrls jiraBaseUrls, I18nHelper i18n) {
        this.delegate = new BasePropertyResource(issueTypePropertyService, authenticationContext, jiraBaseUrls, i18n, (BiFunction<Long, String, String>)new EntityPropertyBeanSelfFunctions.IssueTypePropertySelfBiFunction(), EntityPropertyType.ISSUE_TYPE_PROPERTY);
    }

    @ExperimentalApi
    @GET
    @Operation(summary="Get all properties keys for issue type", description="Returns the keys of all properties for the issue type identified by the id", security={@SecurityRequirement(name="basic")})
    @Parameter(name="issueTypeId", description="The issue type from which the keys will be returned.", in=ParameterIn.PATH, required=true)
    @ApiResponses(value={@ApiResponse(description="Returns keys of all properties for the issue type.", responseCode="200", content={@Content(schema=@Schema(implementation=EntityPropertiesKeysBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the issue type id is invalid.", responseCode="400"), @ApiResponse(description="Returned if the issue type with given id does not exist or if the user does not have permissions to view this issue type.", responseCode="404")})
    public Response getPropertyKeys(@PathParam(value="issueTypeId") String issueTypeId) {
        return this.delegate.getPropertiesKeys(issueTypeId);
    }

    @ExperimentalApi
    @PUT
    @Path(value="/{propertyKey}")
    @Operation(summary="Update specified issue type's property", description="Sets the value of the specified issue type's property", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="issueTypeId", description="The issue type on which the property will be set.", in=ParameterIn.PATH, required=true), @Parameter(name="propertyKey", description="The key of the issue type's property. The maximum length of the key is 255 bytes", in=ParameterIn.PATH, required=true, schema=@Schema(type="string", maxLength=255))})
    @RequestBody(description="The value of the issue type's property. The value has to be a valid, non-empty JSON conforming to http://tools.ietf.org/html/rfc4627. The maximum length of the property value is 32768 bytes.", required=true, content={@Content(schema=@Schema(implementation=WorkflowTransitionResource.PropertyBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Returned if the issue type property is successfully updated.", responseCode="200"), @ApiResponse(description="Returned if the issue type property is successfully created.", responseCode="201"), @ApiResponse(description="Returned if the issue type id is invalid.", responseCode="400"), @ApiResponse(description="Returned if the issue type with given id does not exist or if the user does not have permissions to edit this issue type.", responseCode="404")})
    public Response setProperty(@PathParam(value="issueTypeId") String issueTypeId, @PathParam(value="propertyKey") String propertyKey, @Context HttpServletRequest request) {
        return this.delegate.setProperty(issueTypeId, propertyKey, request);
    }

    @ExperimentalApi
    @GET
    @Path(value="/{propertyKey}")
    @Operation(summary="Get value of specified issue type's property", description="Returns the value of the property with a given key from the issue type identified by the id", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="issueTypeId", description="The issue type from which the property will be returned.", in=ParameterIn.PATH, required=true), @Parameter(name="propertyKey", description="The key of the property to return.", in=ParameterIn.PATH, required=true)})
    @ApiResponses(value={@ApiResponse(description="Returns the value of the property with a given key from the issue type.", responseCode="200", content={@Content(schema=@Schema(implementation=EntityPropertyBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the issue type id is invalid.", responseCode="400"), @ApiResponse(description="Returned if the issue type with given id does not exist or if the property with given key is not found.", responseCode="404")})
    public Response getProperty(@PathParam(value="issueTypeId") String issueTypeId, @PathParam(value="propertyKey") String propertyKey) {
        return this.delegate.getProperty(issueTypeId, propertyKey);
    }

    @ExperimentalApi
    @DELETE
    @Path(value="/{propertyKey}")
    @Operation(summary="Delete specified issue type's property", description="Removes the property from the issue type identified by the id", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="issueTypeId", description="The issue type from which the property will be removed.", in=ParameterIn.PATH, required=true), @Parameter(name="propertyKey", description="The key of the property to remove.", in=ParameterIn.PATH, required=true)})
    @ApiResponses(value={@ApiResponse(description="Removes the property from the issue type.", responseCode="204"), @ApiResponse(description="Returned if the issue type id is invalid.", responseCode="400"), @ApiResponse(description="Returned if the issue type with given id does not exist or if the property with given key is not found.", responseCode="404")})
    public Response deleteProperty(@PathParam(value="issueTypeId") String issueTypeId, @PathParam(value="propertyKey") String propertyKey) {
        return this.delegate.deleteProperty(issueTypeId, propertyKey);
    }
}

