/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.config.SubTaskService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueLinksBeanBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueLinksBeanBuilderFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueRefJsonBean;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.v2.issue.IssueFinder;
import com.atlassian.jira.rest.v2.issue.IssueSubTaskMovePositionBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.List;
import java.util.function.Function;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="issue/{issueIdOrKey}/subtask")
@Produces(value={"application/json"})
@LicensedOnly
public class IssueSubTaskResource {
    private final SubTaskService subTaskService;
    private final IssueFinder issueFinder;
    private final JiraAuthenticationContext authenticationContext;
    private final IssueLinksBeanBuilderFactory issueLinksBeanBuilderFactory;
    private final ResponseFactory responseFactory;

    @Inject
    public IssueSubTaskResource(SubTaskService subTaskService, IssueFinder issueFinder, JiraAuthenticationContext authenticationContext, IssueLinksBeanBuilderFactory issueLinksBeanBuilderFactory, ResponseFactory responseFactory) {
        this.subTaskService = subTaskService;
        this.issueFinder = issueFinder;
        this.authenticationContext = authenticationContext;
        this.issueLinksBeanBuilderFactory = issueLinksBeanBuilderFactory;
        this.responseFactory = responseFactory;
    }

    @GET
    @Operation(summary="Get an issue's subtask list", description="Returns an issue's subtask list", security={@SecurityRequirement(name="basic")})
    @Parameter(name="issueIdOrKey", description="The parent issue's key or id", in=ParameterIn.PATH, required=true)
    @ApiResponses(value={@ApiResponse(description="Returned if the request was successful.", responseCode="200", content={@Content(schema=@Schema(implementation=IssueRefJsonBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the user is not allowed to edit the issue", responseCode="403"), @ApiResponse(description="Returned if the issue doesn't exist", responseCode="404")})
    public Response getSubTasks(@PathParam(value="issueIdOrKey") String issueIdOrKey) {
        return this.withIssue(issueIdOrKey, issue -> {
            IssueLinksBeanBuilder issueLinkBeanBuilder = this.issueLinksBeanBuilderFactory.newIssueLinksBeanBuilder(issue);
            List subtaskLinks = issueLinkBeanBuilder.buildSubtaskLinks();
            return this.responseFactory.okNoCache(subtaskLinks);
        });
    }

    @GET
    @Path(value="move")
    @Operation(summary="Check if a subtask can be moved", description="Checks if a subtask can be moved", security={@SecurityRequirement(name="basic")})
    @Parameter(name="issueIdOrKey", description="The parent issue's key or id", in=ParameterIn.PATH, required=true)
    @ApiResponse(description="Returned if the request was successful.", responseCode="200", content={@Content(schema=@Schema(implementation=Boolean.class), mediaType="application/json")})
    public Response canMoveSubTask(@PathParam(value="issueIdOrKey") String issueIdOrKey) {
        return this.withIssue(issueIdOrKey, issue -> Response.ok((Object)this.subTaskService.canMoveSubtask(this.authenticationContext.getLoggedInUser(), issue)).build());
    }

    @POST
    @Path(value="move")
    @Consumes(value={"application/json"})
    @Operation(summary="Reorder an issue's subtasks", description="Reorders an issue's subtasks by moving the subtask at index 'from' to index 'to'.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="issueIdOrKey", description="The parent issue's key or id", in=ParameterIn.PATH, required=true)
    @RequestBody(description="The description of previous and current position of subtask in the sequence.", required=true, content={@Content(schema=@Schema(implementation=IssueSubTaskMovePositionBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Returned if the request was successful", responseCode="204"), @ApiResponse(description="Returned if the from or to parameters are out of bounds", responseCode="400"), @ApiResponse(description="Returned if the user is not allowed to edit the issue", responseCode="403"), @ApiResponse(description="Returned if the parent issue doesn't exist", responseCode="404")})
    public Response moveSubTasks(@PathParam(value="issueIdOrKey") String issueIdOrKey, IssueSubTaskMovePositionBean position) {
        return this.withIssue(issueIdOrKey, issue -> {
            ApplicationUser user = this.authenticationContext.getLoggedInUser();
            ServiceResult result = this.subTaskService.moveSubTask(user, issue, Long.valueOf(position.getOriginal()), Long.valueOf(position.getCurrent()));
            if (!result.isValid()) {
                return this.responseFactory.errorResponse(result.getErrorCollection());
            }
            return Response.noContent().cacheControl(CacheControl.never()).build();
        });
    }

    private Response withIssue(String issueIdOrKey, Function<Issue, Response> fn) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        if (issue != null) {
            return fn.apply((Issue)issue);
        }
        return this.responseFactory.notFound("", new String[0]);
    }
}

