/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.SecuritySchemeJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.SecuritySchemesJsonBean;
import com.atlassian.jira.issue.security.IssueSecurityLevelScheme;
import com.atlassian.jira.issue.security.IssueSecuritySchemeService;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="issuesecurityschemes")
@AnonymousSiteAccess
@Produces(value={"application/json"})
public class IssueSecuritySchemeResource {
    private final IssueSecuritySchemeService issueSecuritySchemeService;
    private final ResponseFactory responseFactory;
    private final JiraBaseUrls baseUrls;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Inject
    public IssueSecuritySchemeResource(IssueSecuritySchemeService issueSecuritySchemeService, ResponseFactory responseFactory, JiraBaseUrls baseUrls, JiraAuthenticationContext jiraAuthenticationContext) {
        this.issueSecuritySchemeService = issueSecuritySchemeService;
        this.responseFactory = responseFactory;
        this.baseUrls = baseUrls;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @GET
    @Operation(summary="Get all issue security schemes", description="Returns all issue security schemes that are defined.", security={@SecurityRequirement(name="basic")})
    @ApiResponses(value={@ApiResponse(description="Returns a list of all available issue security schemes.", responseCode="200", content={@Content(schema=@Schema(implementation=SecuritySchemesJsonBean.class))}), @ApiResponse(description="Returned if the user is not logged in.", responseCode="401"), @ApiResponse(description="Returned if the user does not have the administrator permission.", responseCode="403")})
    public Response getIssueSecuritySchemes() {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        ServiceOutcome issueSecurityLevelSchemes = this.issueSecuritySchemeService.getIssueSecurityLevelSchemes(user);
        return (Response)this.responseFactory.validateOutcome(issueSecurityLevelSchemes).left().on(issueSecurityLevelSchemes1 -> this.responseFactory.okNoCache(SecuritySchemesJsonBean.fromList((List)SecuritySchemeJsonBean.fromIssueSecuritySchemes(new ArrayList(issueSecurityLevelSchemes1), (JiraBaseUrls)this.baseUrls))));
    }

    @GET
    @Path(value="{id}")
    @Operation(summary="Get specific issue security scheme by id", description="Returns the issue security scheme along with that are defined.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="id", description="The issue security scheme id.", in=ParameterIn.PATH, required=true)
    @ApiResponses(value={@ApiResponse(description="Returns the issue security scheme with the given id.", responseCode="200", content={@Content(schema=@Schema(implementation=SecuritySchemeJsonBean.class))}), @ApiResponse(description="Returned if the user is not logged in.", responseCode="401"), @ApiResponse(description="Returned if the user does not have the administrator permission and the scheme is not used in any project where the user has administrative permission.", responseCode="403")})
    public Response getIssueSecurityScheme(@PathParam(value="id") Long id) {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        ServiceOutcome issueSecurityLevelScheme = this.issueSecuritySchemeService.getIssueSecurityLevelScheme(user, id.longValue());
        return (Response)this.responseFactory.validateOutcome(issueSecurityLevelScheme).left().on(securityLevelScheme -> {
            ServiceOutcome issueSecurityLevels = this.issueSecuritySchemeService.getIssueSecurityLevels(user, id.longValue());
            return (Response)this.responseFactory.validateOutcome(issueSecurityLevels).left().on(issueSecurityLevels1 -> this.responseFactory.okNoCache(SecuritySchemeJsonBean.fullBean((IssueSecurityLevelScheme)securityLevelScheme, (JiraBaseUrls)this.baseUrls, (Collection)issueSecurityLevels1)));
        });
    }
}

