/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.issue.vote.VoteService;
import com.atlassian.jira.bc.issue.watcher.WatcherService;
import com.atlassian.jira.bc.issue.watcher.WatchingDisabledException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.rest.json.beans.CommentJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.CommentsWithPaginationJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.NotificationJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.PinnedCommentJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.WorklogJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.WorklogWithPaginationBean;
import com.atlassian.jira.notification.AdhocNotificationService;
import com.atlassian.jira.notification.AdhocNotificationServiceImpl;
import com.atlassian.jira.notification.NotificationBuilder;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.issue.IssuesCreateResponse;
import com.atlassian.jira.rest.api.issue.RemoteIssueLinkCreateOrUpdateRequest;
import com.atlassian.jira.rest.api.pagination.PageBean;
import com.atlassian.jira.rest.api.property.PropertiesBean;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.util.IssuePicker;
import com.atlassian.jira.rest.util.ProjectKeyOrId;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.util.RestIssueFinder;
import com.atlassian.jira.rest.v2.entity.property.IssuePropertiesLoader;
import com.atlassian.jira.rest.v2.issue.ArchiveIssueResource;
import com.atlassian.jira.rest.v2.issue.AssignIssueResource;
import com.atlassian.jira.rest.v2.issue.CommentResource;
import com.atlassian.jira.rest.v2.issue.CreateIssueResource;
import com.atlassian.jira.rest.v2.issue.CreateMetaIssueTypeBean;
import com.atlassian.jira.rest.v2.issue.DeleteIssueResource;
import com.atlassian.jira.rest.v2.issue.EditMetaBean;
import com.atlassian.jira.rest.v2.issue.FieldMetaBean;
import com.atlassian.jira.rest.v2.issue.IncludedFields;
import com.atlassian.jira.rest.v2.issue.IssueBean;
import com.atlassian.jira.rest.v2.issue.IssueBeanBuilder2;
import com.atlassian.jira.rest.v2.issue.IssueUpdateBean;
import com.atlassian.jira.rest.v2.issue.IssuesUpdateBean;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.rest.v2.issue.RemoteIssueLinkBean;
import com.atlassian.jira.rest.v2.issue.RemoteIssueLinkResource;
import com.atlassian.jira.rest.v2.issue.ResourceUriBuilder;
import com.atlassian.jira.rest.v2.issue.TransitionBean;
import com.atlassian.jira.rest.v2.issue.TransitionsMetaBean;
import com.atlassian.jira.rest.v2.issue.UpdateIssueResource;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.jira.rest.v2.issue.UserBeanBuilder;
import com.atlassian.jira.rest.v2.issue.VoteBean;
import com.atlassian.jira.rest.v2.issue.WatchersBean;
import com.atlassian.jira.rest.v2.issue.builder.BeanBuilderFactory;
import com.atlassian.jira.rest.v2.issue.watcher.WatchersFinder;
import com.atlassian.jira.rest.v2.issue.worklog.IssueWorklogResource;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserIssueHistoryManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.OrderByRequest;
import com.atlassian.jira.util.OrderByRequestParser;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import com.atlassian.jira.util.PageRequests;
import com.atlassian.jira.util.collect.Transformed;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.workflow.IssueWorkflowManager;
import com.atlassian.mail.MailFactory;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.opensymphony.workflow.loader.ActionDescriptor;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;

@Path(value="issue")
@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IssueResource {
    private static final int MAX_PAGE_SIZE = 1000;
    private static ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final RestIssueFinder issueFinder;
    private final UserManager userManager;
    private final IssueWorkflowManager issueWorkflowManager;
    private final JiraAuthenticationContext authContext;
    private final VoteService voteService;
    private final I18nHelper i18n;
    private final WatchersFinder watchersFinder;
    private final WatcherService watcherService;
    private final AdhocNotificationService notificationService;
    private final BeanBuilderFactory beanBuilderFactory;
    private final UriInfo contextUriInfo;
    private final AssignIssueResource assignIssueResource;
    private final CreateIssueResource createIssueResource;
    private final DeleteIssueResource deleteIssueResource;
    private final ArchiveIssueResource archiveIssueResource;
    private final UpdateIssueResource updateIssueResource;
    private final RemoteIssueLinkResource remoteIssueLinkResource;
    private final IssueWorklogResource issueWorklogResource;
    private final CommentResource commentResource;
    private final JiraBaseUrls jiraBaseUrls;
    private final IssuePicker issuePicker;
    private final OrderByRequestParser orderByRequestParser;
    private final ResponseFactory responseFactory;
    private final IssuePropertiesLoader issuePropertiesLoader;
    private final UserIssueHistoryManager userIssueHistoryManager;
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;
    private final ResourceUriBuilder resourceUriBuilder;

    @Inject
    public IssueResource(JiraAuthenticationContext authContext, UserManager userManager, VoteService voteService, I18nHelper i18n, WatchersFinder watchersFinder, WatcherService watcherService, BeanBuilderFactory beanBuilderFactory, UriInfo contextUriInfo, RestIssueFinder issueFinder, CreateIssueResource createIssueResource, UpdateIssueResource updateIssueResource, DeleteIssueResource deleteIssueResource, ArchiveIssueResource archiveIssueResource, RemoteIssueLinkResource remoteIssueLinkResource, IssueWorklogResource issueWorklogResource, CommentResource commentResource, IssueWorkflowManager issueWorkflowManager, AssignIssueResource assignIssueResource, AdhocNotificationService notificationService, JiraBaseUrls jiraBaseUrls, IssuePicker issuePicker, OrderByRequestParser orderByRequestParser, ResponseFactory responseFactory, IssuePropertiesLoader issuePropertiesLoader, UserIssueHistoryManager userIssueHistoryManager, PermissionManager permissionManager, ProjectManager projectManager, ResourceUriBuilder resourceUriBuilder) {
        this.jiraBaseUrls = jiraBaseUrls;
        this.issuePicker = issuePicker;
        this.orderByRequestParser = orderByRequestParser;
        this.responseFactory = responseFactory;
        this.issuePropertiesLoader = issuePropertiesLoader;
        this.authContext = (JiraAuthenticationContext)Assertions.notNull((Object)authContext);
        this.userManager = (UserManager)Assertions.notNull((Object)userManager);
        this.voteService = (VoteService)Assertions.notNull((Object)voteService);
        this.i18n = (I18nHelper)Assertions.notNull((Object)i18n);
        this.watchersFinder = (WatchersFinder)Assertions.notNull((Object)watchersFinder);
        this.watcherService = (WatcherService)Assertions.notNull((Object)watcherService);
        this.beanBuilderFactory = (BeanBuilderFactory)Assertions.notNull((Object)beanBuilderFactory);
        this.contextUriInfo = (UriInfo)Assertions.notNull((Object)contextUriInfo);
        this.issueFinder = (RestIssueFinder)Assertions.notNull((Object)issueFinder);
        this.createIssueResource = (CreateIssueResource)Assertions.notNull((Object)createIssueResource);
        this.updateIssueResource = (UpdateIssueResource)Assertions.notNull((Object)updateIssueResource);
        this.deleteIssueResource = (DeleteIssueResource)Assertions.notNull((Object)deleteIssueResource);
        this.archiveIssueResource = (ArchiveIssueResource)Assertions.notNull((Object)archiveIssueResource);
        this.remoteIssueLinkResource = (RemoteIssueLinkResource)Assertions.notNull((Object)remoteIssueLinkResource);
        this.issueWorklogResource = (IssueWorklogResource)Assertions.notNull((Object)issueWorklogResource);
        this.commentResource = (CommentResource)Assertions.notNull((Object)commentResource);
        this.issueWorkflowManager = (IssueWorkflowManager)Assertions.notNull((Object)issueWorkflowManager);
        this.assignIssueResource = (AssignIssueResource)Assertions.notNull((Object)assignIssueResource);
        this.notificationService = (AdhocNotificationService)Assertions.notNull((Object)notificationService);
        this.userIssueHistoryManager = (UserIssueHistoryManager)Assertions.notNull((Object)userIssueHistoryManager);
        this.permissionManager = (PermissionManager)Assertions.notNull((Object)permissionManager);
        this.projectManager = (ProjectManager)Assertions.notNull((Object)projectManager);
        this.resourceUriBuilder = resourceUriBuilder;
    }

    @GET
    @Path(value="{issueIdOrKey}/transitions")
    @Operation(summary="Get list of transitions possible for an issue", description="Get a list of the transitions possible for this issue by the current user, along with fields that are required and their types.\nFields will only be returned if `expand=transitions.fields`.\nThe fields in the metadata correspond to the fields in the transition screen for that transition.\nFields not in the screen will not be in the metadata.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true), @Parameter(name="transitionId", description="Transition id", in=ParameterIn.QUERY)})
    @ApiResponses(value={@ApiResponse(description="Returns a response containing a Map of TransitionFieldBeans for each transition possible by the current user.", responseCode="200", content={@Content(schema=@Schema(implementation=TransitionsMetaBean.class))}), @ApiResponse(description="Returned if the issue does not exist or the user does not have permission to view it.", responseCode="404")})
    public Response getTransitions(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="transitionId") String transitionId) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        try {
            if (StringUtils.isNotBlank((CharSequence)transitionId)) {
                Integer.valueOf(transitionId);
            }
        }
        catch (NumberFormatException e) {
            throw new RESTException(Response.Status.BAD_REQUEST, this.i18n.getText("rest.transition.error.id.not.integer"));
        }
        List actions = this.issueWorkflowManager.getSortedAvailableActions(issue, this.authContext.getUser());
        ArrayList<TransitionBean> transitions = new ArrayList<TransitionBean>(actions.size());
        for (ActionDescriptor action : actions) {
            if (StringUtils.isNotBlank((CharSequence)transitionId) && !Integer.valueOf(transitionId).equals(action.getId())) continue;
            TransitionBean transitionMetaBean = this.beanBuilderFactory.newTransitionMetaBeanBuilder().issue(issue).action(action).build();
            transitions.add(transitionMetaBean);
        }
        TransitionsMetaBean transitionsMetaBean = new TransitionsMetaBean(transitions);
        return Response.ok((Object)transitionsMetaBean).cacheControl(CacheControl.never()).build();
    }

    @Path(value="picker")
    @GET
    @Operation(summary="Get suggested issues for auto-completion", description="Get issue picker resource", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="query", description="the query", in=ParameterIn.QUERY), @Parameter(name="currentJQL", description="the JQL in context of which the request is executed", in=ParameterIn.QUERY), @Parameter(name="currentIssueKey", description="the key of the issue in context of which the request is executed", in=ParameterIn.QUERY), @Parameter(name="currentProjectId", description="the id of the project in context of which the request is executed", in=ParameterIn.QUERY), @Parameter(name="showSubTasks", description="if set to false, subtasks will not be included in the list", in=ParameterIn.QUERY), @Parameter(name="showSubTaskParent", description="if set to false and request is executed in context of a subtask, the parent issue will not be included in the auto-completion result, even if it matches the query", in=ParameterIn.QUERY)})
    @ApiResponse(description="Returns a response containing issue picker resource.", responseCode="200", content={@Content(schema=@Schema(implementation=IssuePicker.IssuePickerResult.class))})
    public Response getIssuePickerResource(@QueryParam(value="query") String query, @QueryParam(value="currentJQL") String currentJQL, @QueryParam(value="currentIssueKey") String currentIssueKey, @QueryParam(value="currentProjectId") String currentProjectId, @QueryParam(value="showSubTasks") boolean showSubTasks, @QueryParam(value="showSubTaskParent") boolean showSubTaskParent) {
        return this.issuePicker.getIssuesResponse((Option<String>)Option.option((Object)query), currentJQL, currentIssueKey, currentProjectId, showSubTasks, showSubTaskParent);
    }

    @POST
    @Path(value="{issueIdOrKey}/transitions")
    @Operation(summary="Perform a transition on an issue", description="Perform a transition on an issue.\nWhen performing the transition you can update or set other issue fields.\nThe fields that can be set on transition, in either the fields parameter or the update parameter can be determined using the /rest/api/2/issue/{issueIdOrKey}/transitions?expand=transitions.fields resource.\nIf a field is not configured to appear on the transition screen, then it will not be in the transition metadata, and a field validation error will occur if it is submitted.\nThe updateHistory param adds the issues retrieved by this method to the current user's issue history, if set to true (by default, the issue history does not include issues retrieved via the REST API).\nYou can view the issue history in the Jira application, via the Issues dropdown or by using the lastViewed JQL field in an issue search.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true)
    @io.swagger.v3.oas.annotations.parameters.RequestBody(description="Issue update bean", content={@Content(schema=@Schema(implementation=IssueUpdateBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Returns a response indicating the result of the transition operation.", responseCode="204"), @ApiResponse(description="Returned if the transition is not valid for the issue, or the user does not have permission to transition the issue.", responseCode="400"), @ApiResponse(description="Returned if the issue does not exist.", responseCode="404"), @ApiResponse(description="If transition ID is incorrect.", responseCode="500")})
    public Response doTransition(@PathParam(value="issueIdOrKey") String issueIdOrKey, IssueUpdateBean issueUpdateBean) {
        if (issueUpdateBean.getTransition() == null) {
            throw new RESTException(Response.Status.BAD_REQUEST, this.i18n.getText("rest.transition.error.no.transition"));
        }
        try {
            Integer.parseInt(issueUpdateBean.getTransition().getId());
        }
        catch (NumberFormatException e) {
            throw new RESTException(Response.Status.BAD_REQUEST, this.i18n.getText("rest.transition.error.id.not.integer"));
        }
        Issue issue = this.issueFinder.find(issueIdOrKey);
        return this.updateIssueResource.transitionIssue(issue, issueUpdateBean);
    }

    @DELETE
    @Path(value="{issueIdOrKey}/votes")
    @Operation(summary="Remove vote from issue", description="Remove your vote from an issue.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true)
    @ApiResponses(value={@ApiResponse(description="Returns a response indicating the result of the remove vote operation.", responseCode="204"), @ApiResponse(description="Returned if the user cannot remove a vote for any reason. (The user did not vote on the issue, the user is the reporter, voting is disabled, the issue does not exist, etc.)", responseCode="404")})
    public Response removeVote(@PathParam(value="issueIdOrKey") String issueIdOrKey) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        VoteService.VoteValidationResult validationResult = this.voteService.validateRemoveVote(this.authContext.getUser(), this.authContext.getUser(), issue);
        if (!validationResult.isValid()) {
            throw new RESTException(Response.Status.NOT_FOUND, ErrorCollection.of(validationResult.getErrorCollection()));
        }
        this.voteService.removeVote(this.authContext.getUser(), validationResult);
        return IssueResource.NO_CONTENT();
    }

    @POST
    @Path(value="{issueIdOrKey}/votes")
    @Operation(summary="Add vote to issue", description="Adds voter (currently logged user) to particular ticket. You need to be logged in to use this method.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="issueIdOrKey", description="Issue id.", in=ParameterIn.PATH)
    @ApiResponses(value={@ApiResponse(description="Returns the vote count for particular ticket.", responseCode="200"), @ApiResponse(description="Returned if the user cannot vote for any reason. (The user is the reporter, the user does not have permission to vote, voting is disabled in the instance, the issue does not exist, etc.)", responseCode="404")})
    public Response addVote(@PathParam(value="issueIdOrKey") String issueIdOrKey) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        VoteService.VoteValidationResult validationResult = this.voteService.validateAddVote(this.authContext.getUser(), this.authContext.getUser(), issue);
        if (!validationResult.isValid()) {
            throw new RESTException(Response.Status.NOT_FOUND, ErrorCollection.of(validationResult.getErrorCollection()));
        }
        this.voteService.addVote(this.authContext.getUser(), validationResult);
        return IssueResource.NO_CONTENT();
    }

    @GET
    @Path(value="{issueIdOrKey}/votes")
    @Operation(summary="Get votes for issue", description="A REST sub-resource representing the voters on the issue.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true)
    @ApiResponses(value={@ApiResponse(description="Returns a response containing information about voting on the current issue", responseCode="200", content={@Content(schema=@Schema(implementation=VoteBean.class))}), @ApiResponse(description="Returned if the user cannot view the issue in question or voting is disabled.", responseCode="404")})
    public Response getVotes(@PathParam(value="issueIdOrKey") String issueIdOrKey) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        ApplicationUser user = this.authContext.getUser();
        if (this.voteService.isVotingEnabled()) {
            boolean hasVoted = this.voteService.hasVoted(issue, user);
            ServiceOutcome outcome = this.voteService.viewVoters(issue, user);
            ArrayList voters = outcome.isValid() ? new ArrayList(Transformed.collection((Collection)((Collection)outcome.getReturnedValue()), input -> UserBeanBuilder.shortBuilder(this.jiraBaseUrls).user((ApplicationUser)input).buildShort())) : new ArrayList();
            URI selfUri = this.resourceUriBuilder.getBuilder(this.contextUriInfo.getBaseUriBuilder(), IssueResource.class).path(issue.getKey()).path("votes").build(new Object[0]);
            VoteBean voteBean = new VoteBean(selfUri, hasVoted, issue.getVotes(), voters);
            return Response.ok((Object)voteBean).cacheControl(CacheControl.never()).build();
        }
        throw new RESTException(Response.Status.NOT_FOUND, ErrorCollection.of(this.i18n.getText("issue.operations.voting.disabled")));
    }

    @GET
    @Path(value="{issueIdOrKey}")
    @Operation(summary="Get issue for key", description="Returns a full representation of the issue for the given issue key.\nAn issue JSON consists of the issue key, a collection of fields,\na link to the workflow transition sub-resource, and (optionally) the HTML rendered values of any fields that support it\n(e.g. if wiki syntax is enabled for the description or comments).\nThe fields param (which can be specified multiple times) gives a comma-separated list of fields\nto include in the response. This can be used to retrieve a subset of fields.\nA particular field can be excluded by prefixing it with a minus.\nBy default, all (*all) fields are returned in this get-issue resource. Note: the default is different\nwhen doing a jql search -- the default there is just navigable fields (*navigable).\n- *all - include all fields\n- *navigable - include just navigable fields\n- summary,comment - include just the summary and comments\n- -comment - include everything except comments (the default is *all for get-issue)\n- *all,-comment - include everything except comments\n\nThe {@code properties} param is similar to {@code fields} and specifies a comma-separated list of issue\nproperties to include. Unlike {@code fields}, properties are not included by default. To include them all\nsend {@code ?properties=*all}. You can also include only specified properties or exclude some properties\nwith a minus (-) sign.\n\n- {@code *all} - include all properties\n- {@code *all, -prop1} - include all properties except {@code prop1}\n- {@code prop1, prop1} - include {@code prop1} and {@code prop2} properties\n\nJira will attempt to identify the issue by the issueIdOrKey path parameter. This can be an issue id,\nor an issue key. If the issue cannot be found via an exact match, Jira will also look for the issue in a case-insensitive way,\nby looking to see if the issue was moved. In either of these cases, the request will proceed as normal (a 302 or other redirect\nwill not be returned). The issue key contained in the response will indicate the current value of issue's key.\n\nThe expand param is used to include, hidden by default, parts of response. This can be used to include:\n\n- renderedFields - field values in HTML format\n- names - display name of each field\n- schema - schema for each field which describes a type of the field\n- transitions - all possible transitions for the given issue\n- operations - all possibles operations which may be applied on issue\n- editmeta - information about how each field may be edited. It contains field's schema as well.\n- changelog - history of all changes of the given issue\n- versionedRepresentations -\nREST representations of all fields. Some field may contain more recent versions. RESET representations are numbered.\nThe greatest number always represents the most recent version. It is recommended that the most recent version is used.\nversion for these fields which provide a more recent REST representation.\nAfter including versionedRepresentations \"fields\" field become hidden.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true), @Parameter(name="fields", description="The list of fields to return for the issue. By default, all fields are returned.", in=ParameterIn.QUERY), @Parameter(name="expand", description="The expand param is used to include, hidden by default, parts of response. This can be used to include: renderedFields, names, schema, transitions, operations, editmeta, changelog, versionedRepresentations.", in=ParameterIn.QUERY), @Parameter(name="properties", description="The list of properties to return for the issue. By default no properties are returned.", in=ParameterIn.QUERY), @Parameter(name="updateHistory", description="The updateHistory param adds the issues retrieved by this method to the current user's issue history", in=ParameterIn.QUERY)})
    @ApiResponses(value={@ApiResponse(description="Returns a full representation of a Jira issue in JSON format.", responseCode="200", content={@Content(schema=@Schema(implementation=IssueBean.class))}), @ApiResponse(description="Returned if the requested issue is not found, or the user does not have permission to view it.", responseCode="404")})
    public Response getIssue(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="fields") List<StringList> fields, @QueryParam(value="expand") String expand, @QueryParam(value="properties") List<StringList> properties, @QueryParam(value="updateHistory") boolean updateHistory) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        IncludedFields include = IncludedFields.includeAllByDefault(fields);
        IssueBeanBuilder2 issueBeanBuilder = this.beanBuilderFactory.newIssueBeanBuilder2(include, expand);
        IssueBean bean = issueBeanBuilder.build(issue);
        ApplicationUser user = this.authContext.getLoggedInUser();
        PropertiesBean propertiesBean = this.issuePropertiesLoader.getProperties(user, issue, properties);
        bean.setProperties(propertiesBean);
        if (updateHistory && user != null) {
            this.userIssueHistoryManager.addIssueToHistory(user, issue);
        }
        return Response.ok((Object)bean).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="{issueIdOrKey}/watchers")
    @Operation(summary="Get list of watchers of issue", description="Returns the list of watchers for the issue with the given key.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true)
    @ApiResponses(value={@ApiResponse(description="Returns the list of watchers for an issue.", responseCode="200", content={@Content(schema=@Schema(implementation=WatchersBean.class))}), @ApiResponse(description="Returned if the requested issue is not found, or the user does not have permission to view it.", responseCode="404")})
    public Response getIssueWatchers(@PathParam(value="issueIdOrKey") String issueIdOrKey) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        WatchersBean watchers = this.watchersFinder.getWatchers(issue, this.authContext.getUser());
        return Response.ok((Object)watchers).cacheControl(CacheControl.never()).build();
    }

    @POST
    @Path(value="{issueIdOrKey}/watchers")
    @Operation(summary="Add a user as watcher", description="Adds a user to an issue's watcher list.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true), @Parameter(name="userName", description="The name of the user to add to the watcher list. If no name is specified, the current user is added.", in=ParameterIn.QUERY)})
    @ApiResponses(value={@ApiResponse(description="Returned if the watcher was added successfully.", responseCode="204"), @ApiResponse(description="Returned if a user name query parameter is not supplied.", responseCode="400"), @ApiResponse(description="Returned if the calling user does not have permission to add the watcher to the issue's list of watchers.", responseCode="401"), @ApiResponse(description="Returned if either the issue does not exist.", responseCode="404")})
    public Response addWatcher(@PathParam(value="issueIdOrKey") String issueIdOrKey, String userName) {
        try {
            ApplicationUser watchUser = this.getUserFromPost(userName);
            if (watchUser == null) {
                return this.BAD_REQUEST();
            }
            Issue issue = this.issueFinder.find(issueIdOrKey);
            ServiceOutcome outcome = this.watcherService.addWatcher(issue, this.authContext.getUser(), watchUser);
            if (!outcome.isValid()) {
                throw new NotAuthorisedWebException(ErrorCollection.of(outcome.getErrorCollection()));
            }
            return IssueResource.NO_CONTENT();
        }
        catch (WatchingDisabledException e) {
            throw new NotFoundWebException(e);
        }
    }

    private ApplicationUser getUserFromPost(String body) {
        if (StringUtils.isEmpty((CharSequence)body)) {
            return this.authContext.getUser();
        }
        JsonFactory factory = OBJECT_MAPPER.getJsonFactory();
        try {
            JsonParser jp = factory.createJsonParser(body);
            JsonNode obj = (JsonNode)OBJECT_MAPPER.readTree(jp);
            if (obj.isTextual()) {
                String userName = obj.asText();
                if (StringUtils.isEmpty((CharSequence)userName)) {
                    return this.authContext.getUser();
                }
                return this.userManager.getUserByName(userName);
            }
            throw new WebApplicationException(this.BAD_REQUEST());
        }
        catch (JsonParseException e) {
            throw new WebApplicationException((Throwable)e, this.BAD_REQUEST());
        }
        catch (JsonProcessingException e) {
            throw new WebApplicationException((Throwable)e, this.BAD_REQUEST());
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e, this.BAD_REQUEST());
        }
    }

    @DELETE
    @Path(value="{issueIdOrKey}/watchers")
    @Operation(summary="Delete watcher from issue", description="Removes a user from an issue's watcher list.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true), @Parameter(name="userName", description="The name of the user to remove from the watcher list.", in=ParameterIn.QUERY)})
    @ApiResponses(value={@ApiResponse(description="Returned if the watcher was removed successfully.", responseCode="204"), @ApiResponse(description="Returned if a user name query parameter is not supplied.", responseCode="400"), @ApiResponse(description="Returned if the calling user does not have permission to remove the watcher from the issue's list of watchers.", responseCode="401"), @ApiResponse(description="Returned if either the issue does not exist.", responseCode="404")})
    public Response removeWatcher(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="username") String userName) {
        try {
            if (userName == null) {
                return this.BAD_REQUEST();
            }
            ApplicationUser unwatchUser = this.userManager.getUserByNameEvenWhenUnknown(userName);
            Issue issue = this.issueFinder.find(issueIdOrKey);
            ServiceOutcome outcome = this.watcherService.removeWatcher(issue, this.authContext.getUser(), unwatchUser);
            if (!outcome.isValid()) {
                throw new NotAuthorisedWebException(ErrorCollection.of(outcome.getErrorCollection()));
            }
            return IssueResource.NO_CONTENT();
        }
        catch (WatchingDisabledException e) {
            throw new NotFoundWebException();
        }
    }

    @POST
    @Operation(summary="Create an issue or sub-task from json", description="Creates an issue or a sub-task from a JSON representation.\nThe fields that can be set on create, in either the fields parameter or the update parameter can be determined using the /rest/api/2/issue/createmeta resource.\nIf a field is not configured to appear on the create screen, then it will not be in the createmeta, and a field\nvalidation error will occur if it is submitted.\nCreating a sub-task is similar to creating a regular issue, with two important differences:\n- the issueType field must correspond to a sub-task issue type (you can use /issue/createmeta to discover sub-task issue types), and\n- you must provide a parent field in the issue create request containing the id or key of the parent issue.\nThe updateHistory param adds the project that this issue is created in, to the current user's project history, if set to true (by default, the project history is not updated).\nYou can view the project history in the Jira application, via the Projects dropdown.", security={@SecurityRequirement(name="basic")})
    @io.swagger.v3.oas.annotations.parameters.RequestBody(description="Issue update bean", content={@Content(schema=@Schema(implementation=IssueUpdateBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Returns a link to the created issue.", responseCode="201", content={@Content(schema=@Schema(implementation=IssueCreateResponse.class))}), @ApiResponse(description="Returned if the input is invalid (e.g. missing required fields, invalid field values, and so forth).", responseCode="400")})
    public Response createIssue(@QueryParam(value="updateHistory") @DefaultValue(value="false") boolean updateHistory, IssueUpdateBean createRequest) {
        return this.createIssueResource.createIssue(createRequest, updateHistory, this.contextUriInfo);
    }

    @POST
    @Path(value="/bulk")
    @Operation(summary="Create an issue or sub-task from json - bulk operation.", description="Creates issues or sub-tasks from a JSON representation. Creates many issues in one bulk operation.\nCreating a sub-task is similar to creating a regular issue. More details can be found in createIssue section.", security={@SecurityRequirement(name="basic")})
    @io.swagger.v3.oas.annotations.parameters.RequestBody(description="Issues update bean", content={@Content(schema=@Schema(implementation=IssuesUpdateBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Returns a link to the created issues.", responseCode="201", content={@Content(schema=@Schema(implementation=IssuesCreateResponse.class))}), @ApiResponse(description="Returned if the input is invalid (e.g. missing required fields, invalid field values, and so forth).", responseCode="400")})
    public Response createIssues(IssuesUpdateBean createRequest) {
        return this.createIssueResource.createIssues(createRequest, this.contextUriInfo);
    }

    @DELETE
    @Path(value="{issueIdOrKey}")
    @Operation(summary="Delete an issue", description="Deletes an issue. If the issue has subtasks you must set the parameter deleteSubtasks=true to delete the issue. You cannot delete an issue without its subtasks also being deleted.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true), @Parameter(name="deleteSubtasks", description="A String of true or false indicating that any subtasks should also be deleted. If the issue has no subtasks this parameter is ignored. If the issue has subtasks and this parameter is missing or false, then the issue will not be deleted and an error will be returned.", in=ParameterIn.QUERY, required=false)})
    @ApiResponses(value={@ApiResponse(description="Returned if the issue was removed successfully.", responseCode="204"), @ApiResponse(description="Returned if an error occurs.", responseCode="400"), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to delete the issue.", responseCode="403"), @ApiResponse(description="Returned if the issue does not exist.", responseCode="404")})
    public Response deleteIssue(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="deleteSubtasks") String deleteSubtasks) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        return this.deleteIssueResource.deleteIssue(issue, deleteSubtasks, this.contextUriInfo);
    }

    @PUT
    @Path(value="{issueIdOrKey}/archive")
    @Operation(summary="Archive an issue", description="Archives an issue.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true), @Parameter(name="notifyUsers", description="Send the email with notification that the issue was updated to users that watch it. Admin or project admin permissions are required to disable the notification.", in=ParameterIn.QUERY, required=false)})
    @ApiResponses(value={@ApiResponse(description="Returns a response indicating the result of the archive operation.", responseCode="204"), @ApiResponse(description="Returned if the user is not logged in.", responseCode="401"), @ApiResponse(description="Returned if the currently authenticated user does not have permission to archive the issue or doesn't have DC license or issue is already archived.", responseCode="403"), @ApiResponse(description="Returned if the issue does not exist.", responseCode="404")})
    public Response archiveIssue(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="notifyUsers") @DefaultValue(value="true") boolean notifyUsers) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        return this.archiveIssueResource.archiveIssue(issue.getKey(), notifyUsers);
    }

    @POST
    @Path(value="archive")
    @Produces(value={"text/plain"})
    @Operation(summary="Archive list of issues", description="Archives a list of issues.", security={@SecurityRequirement(name="basic")})
    @io.swagger.v3.oas.annotations.parameters.RequestBody(description="List of issue keys", content={@Content(schema=@Schema(implementation=List.class), mediaType="text/plain")})
    @Parameter(name="notifyUsers", description="Send the email with notification that the issue was updated to users that watch it. Admin or project admin permissions are required to disable the notification.", in=ParameterIn.QUERY, required=false)
    @ApiResponses(value={@ApiResponse(description="Returns a stream of issues archiving results.", responseCode="200", content={@Content(schema=@Schema(implementation=StreamingOutput.class), mediaType="text/plain")}), @ApiResponse(description="Returned if the user is not logged in.", responseCode="401"), @ApiResponse(description="Returned if the currently authenticated user does not have permission to archive the issue or doesn't have DC license or issue is already archived.", responseCode="403"), @ApiResponse(description="Returned if the issue does not exist.", responseCode="404")})
    public Response archiveIssues(@RequestBody List<String> issueKeys, @QueryParam(value="notifyUsers") @DefaultValue(value="false") boolean notifyUsers) {
        StreamingOutput streamingOutput = output -> {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));
            for (String issueKey : issueKeys) {
                Response response = this.archiveIssueResource.archiveIssue(issueKey, notifyUsers);
                writer.write(String.format("%s, %d %s\n", issueKey, response.getStatus(), Response.Status.fromStatusCode((int)response.getStatus())));
                writer.flush();
            }
        };
        return Response.ok((Object)streamingOutput).build();
    }

    @PUT
    @Path(value="{issueIdOrKey}/restore")
    @Operation(summary="Restore an archived issue", description="Restores an archived issue.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true), @Parameter(name="notifyUsers", description="Send the email with notification that the issue was updated to users that watch it. Admin or project admin permissions are required to disable the notification.", in=ParameterIn.QUERY, required=false)})
    @ApiResponses(value={@ApiResponse(description="Returns a response indicating the result of the restore operation.", responseCode="204"), @ApiResponse(description="Returned if the user is not logged in.", responseCode="401"), @ApiResponse(description="Returned if the currently authenticated user does not have permission to restore the issue or doesn't have DC license or issue is not archived.", responseCode="403"), @ApiResponse(description="Returned if the issue does not exist.", responseCode="404")})
    public Response restoreIssue(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="notifyUsers") @DefaultValue(value="true") boolean notifyUsers) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        return this.archiveIssueResource.restoreIssue(issue.getKey(), notifyUsers);
    }

    @GET
    @Path(value="createmeta/{projectIdOrKey}/issuetypes")
    @Operation(summary="Get metadata for project issue types", description="Returns the metadata for issue types used for creating issues. Data will not be returned if the user does not have permission to create issues in that project.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="projectIdOrKey", description="Project id or key", in=ParameterIn.PATH, required=true), @Parameter(name="startAt", description="The page offset", in=ParameterIn.QUERY, required=false), @Parameter(name="maxResults", description="How many results on the page should be included", in=ParameterIn.QUERY, required=false)})
    @ApiResponses(value={@ApiResponse(description="Returns the metadata for issue types used for creating issues.", responseCode="200", content={@Content(schema=@Schema(implementation=CreateMetaIssueTypeBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the user does not have permission to view the requested project or project doesn't exist.", responseCode="400")})
    public Response getCreateIssueMetaProjectIssueTypes(@PathParam(value="projectIdOrKey") String projectIdOrKey, @QueryParam(value="startAt") @DefaultValue(value="0") long startAt, @QueryParam(value="maxResults") @DefaultValue(value="50") int maxResults) {
        try {
            if (!this.hasUserCreateIssuePermissionOnProject(projectIdOrKey)) {
                throw new WebApplicationException(this.BAD_REQUEST());
            }
            PageRequest pageRequest = PageRequests.request((Long)startAt, (Integer)Math.min(maxResults, 1000));
            Page<CreateMetaIssueTypeBean> issueTypesForProject = this.beanBuilderFactory.newCreateMetaIssueTypeBeanBuilder(projectIdOrKey).buildPaged(pageRequest);
            return Response.ok(PageBean.from(pageRequest, issueTypesForProject).build(Function.identity())).cacheControl(CacheControl.never()).build();
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException((Throwable)e, this.BAD_REQUEST());
        }
    }

    @GET
    @Path(value="createmeta/{projectIdOrKey}/issuetypes/{issueTypeId}")
    @Operation(summary="Get metadata for issue types used for creating issues", description="Returns the metadata for issue types used for creating issues. Data will not be returned if the user does not have permission to create issues in that project.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="projectIdOrKey", description="Project id or key", in=ParameterIn.PATH, required=true), @Parameter(name="issueTypeId", description="Issue type id", in=ParameterIn.PATH, required=true), @Parameter(name="startAt", description="The page offset", in=ParameterIn.QUERY, required=false), @Parameter(name="maxResults", description="How many results on the page should be included", in=ParameterIn.QUERY, required=false)})
    @ApiResponses(value={@ApiResponse(description="Returns the metadata for issue types used for creating issues.", responseCode="200", content={@Content(schema=@Schema(implementation=FieldMetaBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the user does not have permission to view the requested project or project doesn't exist.", responseCode="400")})
    public Response getCreateIssueMetaFields(@PathParam(value="projectIdOrKey") String projectIdOrKey, @PathParam(value="issueTypeId") String issueTypeId, @QueryParam(value="startAt") @DefaultValue(value="0") long startAt, @QueryParam(value="maxResults") @DefaultValue(value="50") int maxResults) {
        try {
            if (!this.hasUserCreateIssuePermissionOnProject(projectIdOrKey)) {
                throw new WebApplicationException(this.BAD_REQUEST());
            }
            PageRequest pageRequest = PageRequests.request((Long)startAt, (Integer)Math.min(maxResults, 1000));
            Page<FieldMetaBean> fieldMetaBeanPage = this.beanBuilderFactory.newCreateMetaFieldBeanBuilder(projectIdOrKey, issueTypeId).buildPaged(pageRequest);
            return Response.ok(PageBean.from(pageRequest, fieldMetaBeanPage).build(Function.identity())).cacheControl(CacheControl.never()).build();
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException((Throwable)e, this.BAD_REQUEST());
        }
    }

    @GET
    @Path(value="{issueIdOrKey}/editmeta")
    @Operation(summary="Get metadata for issue types used for editing issues", description="Returns the meta data for editing an issue. The fields in the editmeta correspond to the fields in the edit screen for the issue. Fields not in the screen will not be in the editmeta.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true)
    @ApiResponses(value={@ApiResponse(description="Returns a response containing a Map of FieldBeans for fields editable by the current user.", responseCode="200", content={@Content(schema=@Schema(implementation=EditMetaBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the requested issue is not found or the user does not have permission to view it.", responseCode="404")})
    public Response getEditIssueMeta(@PathParam(value="issueIdOrKey") String issueIdOrKey) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        EditMetaBean bean = this.beanBuilderFactory.newEditMetaBeanBuilder().issue(issue).build();
        return Response.ok((Object)bean).cacheControl(CacheControl.never()).build();
    }

    @PUT
    @Path(value="{issueIdOrKey}")
    @Operation(summary="Edit an issue from a JSON representation", description="Edits an issue from a JSON representation. The issue can either be updated by setting explicit the field value(s) or by using an operation to change the field value.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true), @Parameter(name="notifyUsers", description="Send the email with notification that the issue was updated to users that watch it. Admin or project admin permissions are required to disable the notification.", in=ParameterIn.QUERY, required=false)})
    @io.swagger.v3.oas.annotations.parameters.RequestBody(description="Issue update bean", content={@Content(schema=@Schema(implementation=IssueUpdateBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Returned if it updated the issue successfully.", responseCode="204"), @ApiResponse(description="Returned if the requested issue update failed.", responseCode="400"), @ApiResponse(description="Returned if the user doesn't have permissions to disable users notification.", responseCode="403")})
    public Response editIssue(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="notifyUsers") @DefaultValue(value="true") boolean notifyUsers, IssueUpdateBean updateRequest) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        return this.updateIssueResource.editIssue(issue, updateRequest, notifyUsers);
    }

    @PUT
    @Path(value="{issueIdOrKey}/assignee")
    @Operation(summary="Assign an issue to a user", description="Assign an issue to a user.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true)
    @io.swagger.v3.oas.annotations.parameters.RequestBody(description="UserBean containing the username", content={@Content(schema=@Schema(implementation=UserBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Returns a response indicating the result of the assign operation.", responseCode="204"), @ApiResponse(description="Returned if there is a problem with the received user representation.", responseCode="400"), @ApiResponse(description="Returned if the calling user does not have permission to assign the issue.", responseCode="401"), @ApiResponse(description="Returned if either the issue or the user does not exist.", responseCode="404")})
    public Response assign(@PathParam(value="issueIdOrKey") String issueIdOrKey, UserBean assigneeBean) {
        String assigneeName = assigneeBean == null ? null : assigneeBean.getName();
        Issue issue = this.issueFinder.find(issueIdOrKey);
        return this.assignIssueResource.assignIssue(issue, assigneeName);
    }

    @GET
    @Path(value="{issueIdOrKey}/remotelink")
    @Operation(summary="Get remote issue links for an issue", description="Get remote issue links for an issue.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true), @Parameter(name="globalId", description="Global id of the remote issue link", in=ParameterIn.QUERY)})
    @ApiResponses(value={@ApiResponse(description="Returns a response containing remote issue links for the issue.", responseCode="200", content={@Content(schema=@Schema(implementation=RemoteIssueLinkBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the linkId is not a valid number, or if the remote issue link with the given id does not belong to the given issue.", responseCode="400"), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to view the remote issue link, or if issue linking is disabled.", responseCode="403"), @ApiResponse(description="Returned if the issue or remote issue link do not exist.", responseCode="404")})
    public Response getRemoteIssueLinks(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="globalId") String globalId) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        return this.remoteIssueLinkResource.getRemoteIssueLinks(issue, globalId);
    }

    @GET
    @Path(value="{issueIdOrKey}/remotelink/{linkId}")
    @Operation(summary="Get a remote issue link by its id", description="Get a remote issue link by its id.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true), @Parameter(name="linkId", description="Id of the remote issue link", in=ParameterIn.PATH, required=true)})
    @ApiResponses(value={@ApiResponse(description="Returns a response containing a remote issue link.", responseCode="200", content={@Content(schema=@Schema(implementation=RemoteIssueLinkBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the linkId is not a valid number, or if the remote issue link with the given id does not belong to the given issue.", responseCode="400"), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to view the remote issue link, or if issue linking is disabled.", responseCode="403"), @ApiResponse(description="Returned if the issue or remote issue link do not exist.", responseCode="404")})
    public Response getRemoteIssueLinkById(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="linkId") String linkId) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        return this.remoteIssueLinkResource.getRemoteIssueLinkById(issue, linkId);
    }

    @POST
    @Path(value="{issueIdOrKey}/remotelink")
    @Operation(summary="Create or update remote issue link", description="Creates or updates a remote issue link from a JSON representation. If a globalId is provided and a remote issue link exists with that globalId, the remote issue link is updated. Otherwise, the remote issue link is created.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true)
    @io.swagger.v3.oas.annotations.parameters.RequestBody(description="Remote issue link create or update request", content={@Content(schema=@Schema(implementation=RemoteIssueLinkCreateOrUpdateRequest.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Returns a link to the created/updated remote issue link.", responseCode="200", content={@Content(schema=@Schema(implementation=RemoteIssueLinkBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the input is invalid (e.g. missing required fields, invalid values, and so forth).", responseCode="400"), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to create/update the remote issue link, or if issue linking is disabled.", responseCode="403")})
    public Response createOrUpdateRemoteIssueLink(@PathParam(value="issueIdOrKey") String issueIdOrKey, RemoteIssueLinkCreateOrUpdateRequest request) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        return this.remoteIssueLinkResource.createOrUpdateRemoteIssueLink(issue, request, this.contextUriInfo);
    }

    @PUT
    @Path(value="{issueIdOrKey}/remotelink/{linkId}")
    @Operation(summary="Update remote issue link", description="Updates a remote issue link from a JSON representation. Any fields not provided are set to null.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true), @Parameter(name="linkId", description="Id of the remote issue link", in=ParameterIn.PATH, required=true)})
    @io.swagger.v3.oas.annotations.parameters.RequestBody(description="Remote issue link create or update request", content={@Content(schema=@Schema(implementation=RemoteIssueLinkCreateOrUpdateRequest.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Returns a response indicating the result of the update operation.", responseCode="204"), @ApiResponse(description="Returned if the input is invalid (e.g. missing required fields, invalid values, and so forth).", responseCode="400"), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to update the remote issue link, or if issue linking is disabled.", responseCode="403")})
    public Response updateRemoteIssueLink(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="linkId") String linkId, RemoteIssueLinkCreateOrUpdateRequest updateRequest) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        return this.remoteIssueLinkResource.updateRemoteIssueLink(issue, linkId, updateRequest);
    }

    @DELETE
    @Path(value="{issueIdOrKey}/remotelink/{linkId}")
    @Operation(summary="Delete remote issue link by id", description="Delete the remote issue link with the given id on the issue.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true), @Parameter(name="linkId", description="Id of the remote issue link", in=ParameterIn.PATH, required=true)})
    @ApiResponses(value={@ApiResponse(description="Returned if the remote issue link was removed successfully.", responseCode="204"), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to delete the remote issue link, or if issue linking is disabled.", responseCode="403"), @ApiResponse(description="Returned if the issue or remote issue link do not exist.", responseCode="404")})
    public Response deleteRemoteIssueLinkById(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="linkId") String remoteIssueLinkId) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        return this.remoteIssueLinkResource.deleteRemoteIssueLinkById(issue, remoteIssueLinkId);
    }

    @DELETE
    @Path(value="{issueIdOrKey}/remotelink")
    @Operation(summary="Delete remote issue link", description="Delete the remote issue link with the given global id on the issue.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true), @Parameter(name="globalId", description="Global id of the remote issue link", in=ParameterIn.QUERY, required=true)})
    @ApiResponses(value={@ApiResponse(description="Returned if the remote issue link was removed successfully.", responseCode="204"), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to delete the remote issue link, or if issue linking is disabled.", responseCode="403"), @ApiResponse(description="Returned if the issue or remote issue link do not exist.", responseCode="404")})
    public Response deleteRemoteIssueLinkByGlobalId(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="globalId") String globalId) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        return this.remoteIssueLinkResource.deleteRemoteIssueLinkByGlobalId(issue, globalId);
    }

    @GET
    @Path(value="{issueIdOrKey}/worklog")
    @Operation(summary="Get worklogs for an issue", description="Returns all work logs for an issue. Work logs won't be returned if the Log work field is hidden for the project.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true)
    @ApiResponses(value={@ApiResponse(description="Returns a collection of worklogs associated with the issue, with count and pagination information.", responseCode="200", content={@Content(schema=@Schema(implementation=WorklogWithPaginationBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the issue with the given id/key does not exist or if the currently authenticated user does not have permission to view it.", responseCode="404")})
    public Response getIssueWorklog(@PathParam(value="issueIdOrKey") String issueIdOrKey) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        return this.issueWorklogResource.getIssueWorklogs(issue);
    }

    @GET
    @Path(value="{issueIdOrKey}/worklog/{id}")
    @Operation(summary="Get a worklog by id", description="Returns a specific worklog. The work log won't be returned if the Log work field is hidden for the project.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true), @Parameter(name="id", description="Worklog id", in=ParameterIn.PATH, required=true)})
    @ApiResponses(value={@ApiResponse(description="Returns a response containing a worklog.", responseCode="200", content={@Content(schema=@Schema(implementation=WorklogJsonBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the work log with the given id does not exist or if the currently authenticated user does not have permission to view it.", responseCode="404")})
    public Response getWorklog(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="id") String worklogId) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        return this.issueWorklogResource.getWorklogForIssue(worklogId, issue);
    }

    @PUT
    @Path(value="{issueIdOrKey}/worklog/{id}")
    @Operation(summary="Update a worklog entry", description="Updates an existing worklog entry. Note that:\n- Fields possible for editing are: comment, visibility, started, timeSpent and timeSpentSeconds.\n- Either timeSpent or timeSpentSeconds can be set.\n- Fields which are not set will not be updated.\n- For a request to be valid, it has to have at least one field change.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="issueIdOrKey", description="a string containing the issue id or key the worklog belongs to", in=ParameterIn.PATH, required=true), @Parameter(name="id", description="id of the worklog to be updated", in=ParameterIn.PATH, required=true), @Parameter(name="adjustEstimate", description="allows you to provide specific instructions to update the remaining time estimate of the issue. Valid values are: new, leave, auto", in=ParameterIn.QUERY), @Parameter(name="newEstimate", description="required when 'new' is selected for adjustEstimate", in=ParameterIn.QUERY)})
    @io.swagger.v3.oas.annotations.parameters.RequestBody(description="Worklog update request", content={@Content(schema=@Schema(implementation=WorklogJsonBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Returned if update was successful.", responseCode="200", content={@Content(schema=@Schema(implementation=WorklogJsonBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the input is invalid (e.g. missing required fields, invalid values, and so forth).", responseCode="400"), @ApiResponse(description="Returned if the calling user does not have permission to update the worklog.", responseCode="403")})
    public Response updateWorklog(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="id") String worklogId, @QueryParam(value="adjustEstimate") String adjustEstimate, @QueryParam(value="newEstimate") String newEstimate, WorklogJsonBean request) {
        if (request.getId() != null && !request.getId().equals(worklogId)) {
            throw new RESTException(Response.Status.BAD_REQUEST, this.i18n.getText("rest.worklog.error.id.mismatch"));
        }
        request.setId(worklogId);
        Issue issue = this.issueFinder.find(issueIdOrKey);
        return this.issueWorklogResource.updateWorklog(issue, request, new IssueWorklogResource.WorklogAdjustmentRequest(adjustEstimate, newEstimate, null, null), this.contextUriInfo);
    }

    @DELETE
    @Path(value="{issueIdOrKey}/worklog/{id}")
    @Operation(summary="Delete a worklog entry", description="Deletes an existing worklog entry.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="issueIdOrKey", description="a string containing the issue id or key the worklog belongs to", in=ParameterIn.PATH, required=true), @Parameter(name="id", description="Id of the worklog to be deleted", in=ParameterIn.PATH, required=true), @Parameter(name="adjustEstimate", description="Allows you to provide specific instructions to update the remaining time estimate of the issue. Valid values are: new, leave, manual, auto", in=ParameterIn.QUERY), @Parameter(name="newEstimate", description="Required when 'new' is selected for adjustEstimate. e.g. \"2d\"", in=ParameterIn.QUERY), @Parameter(name="increaseBy", description="Required when 'manual' is selected for adjustEstimate. e.g. \"2d\"", in=ParameterIn.QUERY)})
    @ApiResponses(value={@ApiResponse(description="Returned if delete was successful.", responseCode="204"), @ApiResponse(description="Returned if the input is invalid (e.g. missing required fields, invalid values, and so forth).", responseCode="400"), @ApiResponse(description="Returned if the calling user does not have permission to delete the worklog.", responseCode="403")})
    public Response deleteWorklog(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="id") String worklogId, @QueryParam(value="adjustEstimate") String adjustEstimate, @QueryParam(value="newEstimate") String newEstimate, @QueryParam(value="increaseBy") String increaseBy) {
        WorklogJsonBean request = new WorklogJsonBean();
        request.setId(worklogId);
        Issue issue = this.issueFinder.find(issueIdOrKey);
        return this.issueWorklogResource.deleteWorklog(issue, request, new IssueWorklogResource.WorklogAdjustmentRequest(adjustEstimate, newEstimate, null, increaseBy), this.contextUriInfo);
    }

    @POST
    @Path(value="{issueIdOrKey}/worklog")
    @Operation(summary="Add a worklog entry", description="Adds a new worklog entry to an issue.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="issueIdOrKey", description="a string containing the issue id or key the worklog will be added to", in=ParameterIn.PATH, required=true), @Parameter(name="adjustEstimate", description="Allows you to provide specific instructions to update the remaining time estimate of the issue. Valid values are: new, leave, manual, auto", in=ParameterIn.QUERY), @Parameter(name="newEstimate", description="Required when 'new' is selected for adjustEstimate. e.g. \"2d\"", in=ParameterIn.QUERY), @Parameter(name="reduceBy", description="Required when 'manual' is selected for adjustEstimate. e.g. \"2d\"", in=ParameterIn.QUERY)})
    @io.swagger.v3.oas.annotations.parameters.RequestBody(description="Worklog create request", content={@Content(schema=@Schema(implementation=WorklogJsonBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Returned if add was successful.", responseCode="201", content={@Content(schema=@Schema(implementation=WorklogJsonBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the input is invalid (e.g. missing required fields, invalid values, and so forth).", responseCode="400"), @ApiResponse(description="Returned if the calling user does not have permission to add the worklog.", responseCode="403")})
    public Response addWorklog(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="adjustEstimate") String adjustEstimate, @QueryParam(value="newEstimate") String newEstimate, @QueryParam(value="reduceBy") String reduceBy, WorklogJsonBean request) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        return this.issueWorklogResource.addWorklog(issue, request, new IssueWorklogResource.WorklogAdjustmentRequest(adjustEstimate, newEstimate, reduceBy, null), this.contextUriInfo);
    }

    @GET
    @Path(value="{issueIdOrKey}/comment")
    @Operation(summary="Get comments for an issue", description="Returns all comments for an issue. Results can be ordered by the 'created' field which means the date a comment was added.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true), @Parameter(name="startAt", description="The page offset, if not specified then defaults to 0", in=ParameterIn.QUERY), @Parameter(name="maxResults", description="How many results on the page should be included. Defaults to 50.", in=ParameterIn.QUERY), @Parameter(name="orderBy", description="Ordering of the results", in=ParameterIn.QUERY), @Parameter(name="expand", description="Optional flags: renderedBody (provides body rendered in HTML)", in=ParameterIn.QUERY)})
    @ApiResponses(value={@ApiResponse(description="Returns a collection of comments associated with the issue, with count and pagination information.", responseCode="200", content={@Content(schema=@Schema(implementation=CommentsWithPaginationJsonBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the issue with the given id/key does not exist or if the currently authenticated user does not have permission to view it.", responseCode="404")})
    public Response getComments(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="startAt") Long startAt, @QueryParam(value="maxResults") Integer maxResults, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="expand") String expand) {
        Either maybeOrderByOrError = orderBy != null ? this.orderByRequestParser.parse(orderBy, CommentResource.CommentField.class).map(Option::some) : Either.right((Object)Option.none());
        return (Response)maybeOrderByOrError.leftMap(this.responseFactory::errorResponse).left().on(maybeOrderBy -> this.commentResource.getComments(issueIdOrKey, expand, PageRequests.request((Long)startAt, (Integer)maxResults), (Option<OrderByRequest<CommentResource.CommentField>>)maybeOrderBy));
    }

    @GET
    @Path(value="{issueIdOrKey}/pinned-comments")
    @Operation(summary="Get pinned comments for an issue", description="Returns all pinned to the issue comments.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true)
    @ApiResponses(value={@ApiResponse(description="Returns a collection of pinned comments associated with the issue.", responseCode="200", content={@Content(schema=@Schema(implementation=PinnedCommentJsonBean.class, type="array"), mediaType="application/json")}), @ApiResponse(description="Returned if the issue with the given id/key does not exist or if the currently authenticated user does not have permission to view it.", responseCode="404")})
    public Response getPinnedComments(@PathParam(value="issueIdOrKey") String issueIdOrKey) {
        return this.commentResource.getPinnedComments(issueIdOrKey);
    }

    @GET
    @Path(value="{issueIdOrKey}/comment/{id}")
    @Operation(summary="Get a comment by id", description="Returns a single comment.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true), @Parameter(name="id", description="Comment id", in=ParameterIn.PATH, required=true), @Parameter(name="expand", description="Optional flags: renderedBody (provides body rendered in HTML)", in=ParameterIn.QUERY)})
    @ApiResponses(value={@ApiResponse(description="Returns a full representation of a Jira comment in JSON format.", responseCode="200", content={@Content(schema=@Schema(implementation=CommentJsonBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the requested comment is not found, or the user does not have permission to view it.", responseCode="404")})
    public Response getComment(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="id") String commentId, @QueryParam(value="expand") String expand) {
        return this.commentResource.getComment(issueIdOrKey, commentId, expand);
    }

    @PUT
    @Path(value="{issueIdOrKey}/comment/{id}")
    @Operation(summary="Update a comment", description="Updates an existing comment using its JSON representation.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true), @Parameter(name="id", description="Comment id", in=ParameterIn.PATH, required=true), @Parameter(name="expand", description="Optional flags: renderedBody (provides body rendered in HTML)", in=ParameterIn.QUERY)})
    @io.swagger.v3.oas.annotations.parameters.RequestBody(description="Comment update request", content={@Content(schema=@Schema(implementation=CommentJsonBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Returned if update was successful.", responseCode="200", content={@Content(schema=@Schema(implementation=CommentJsonBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the input is invalid (e.g. missing required fields, invalid values, and so forth).", responseCode="400")})
    public Response updateComment(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="id") String commentId, @QueryParam(value="expand") String expand, CommentJsonBean request) {
        return this.commentResource.updateComment(issueIdOrKey, commentId, expand, request);
    }

    @PUT
    @Path(value="{issueIdOrKey}/comment/{id}/pin")
    @Operation(summary="Pin a comment", description="Pins a comment to the top of the comment list.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true), @Parameter(name="id", description="Comment id", in=ParameterIn.PATH, required=true)})
    @io.swagger.v3.oas.annotations.parameters.RequestBody(description="'true' must be included as raw data", required=true, content={@Content(schema=@Schema(implementation=Boolean.class))})
    @ApiResponses(value={@ApiResponse(description="Returned if the comment was pinned successfully.", responseCode="204"), @ApiResponse(description="Returned if the comment with the given id does not exist or if the currently authenticated user does not have permission to pin it.", responseCode="404")})
    public Response setPinComment(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="id") String commentId, boolean pinned) {
        return this.commentResource.setPinComment(issueIdOrKey, commentId, pinned);
    }

    @DELETE
    @Path(value="{issueIdOrKey}/comment/{id}")
    @Operation(summary="Delete a comment", description="Deletes an existing comment.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true), @Parameter(name="id", description="Comment id", in=ParameterIn.PATH, required=true)})
    @ApiResponses(value={@ApiResponse(description="Returned if delete was successful.", responseCode="204"), @ApiResponse(description="Returned if the input is invalid (e.g. missing required fields, invalid values, and so forth).", responseCode="400")})
    public Response deleteComment(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="id") String commentId) {
        return this.commentResource.deleteComment(issueIdOrKey, commentId);
    }

    @POST
    @Path(value="{issueIdOrKey}/comment")
    @Operation(summary="Add a comment", description="Adds a new comment to an issue.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true), @Parameter(name="expand", description="Optional flags: renderedBody (provides body rendered in HTML)", in=ParameterIn.QUERY)})
    @io.swagger.v3.oas.annotations.parameters.RequestBody(description="Comment create request", content={@Content(schema=@Schema(implementation=CommentJsonBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Returned if add was successful.", responseCode="201", content={@Content(schema=@Schema(implementation=CommentJsonBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the input is invalid (e.g. missing required fields, invalid values, and so forth).", responseCode="400")})
    public Response addComment(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="expand") String expand, CommentJsonBean request) {
        return this.commentResource.addComment(issueIdOrKey, expand, request);
    }

    @POST
    @Path(value="{issueIdOrKey}/notify")
    @Operation(summary="Send notification to recipients", description="Sends a notification (email) to the list or recipients defined in the request.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true)
    @io.swagger.v3.oas.annotations.parameters.RequestBody(description="Notification request", content={@Content(schema=@Schema(implementation=NotificationJsonBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Returned if adding to the mail queue was successful.", responseCode="204"), @ApiResponse(description="Returned if the input is invalid (e.g. missing required fields, invalid values, and so forth).", responseCode="400"), @ApiResponse(description="Returned is outgoing emails are disabled OR no SMTP server is defined.", responseCode="403")})
    public Response notify(@PathParam(value="issueIdOrKey") String issueIdOrKey, NotificationJsonBean request) {
        AdhocNotificationService.ValidateNotificationResult result;
        if (MailFactory.getSettings().isSendingDisabled()) {
            throw new RESTException(Response.Status.FORBIDDEN, ErrorCollection.of(this.i18n.getText("rest.error.outgoing.mail.disabled")));
        }
        if (MailFactory.getServerManager().getDefaultSMTPMailServer() == null) {
            throw new RESTException(Response.Status.FORBIDDEN, ErrorCollection.of(this.i18n.getText("rest.error.no.smtp.defined")));
        }
        ApplicationUser user = this.authContext.getUser();
        Issue issue = this.issueFinder.find(issueIdOrKey);
        ErrorCollection errors = ErrorCollection.of(new String[0]);
        ServiceOutcome notificationBuilder = AdhocNotificationServiceImpl.makeBuilder((NotificationBuilder)this.notificationService.makeBuilder(), (NotificationJsonBean)request, (I18nHelper)this.i18n);
        if (!notificationBuilder.isValid()) {
            errors.addErrorCollection(notificationBuilder.getErrorCollection());
        }
        if (!(result = this.notificationService.validateNotification((NotificationBuilder)notificationBuilder.getReturnedValue(), user, issue)).isValid()) {
            throw new RESTException(Response.Status.BAD_REQUEST, errors.addErrorCollection(result.getErrorCollection()));
        }
        this.notificationService.sendNotification(result);
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    protected Response BAD_REQUEST() {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.never()).build();
    }

    protected static Response NO_CONTENT() {
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    private boolean hasUserCreateIssuePermissionOnProject(String projectIdOrKey) {
        Project project = (Project)ProjectKeyOrId.parse(projectIdOrKey).fold(arg_0 -> ((ProjectManager)this.projectManager).getProjectObj(arg_0), arg_0 -> ((ProjectManager)this.projectManager).getProjectObjByKey(arg_0));
        return project != null && this.permissionManager.hasPermission(ProjectPermissions.CREATE_ISSUES, project, this.authContext.getLoggedInUser());
    }
}

