/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.bc.issue.properties.IssuePropertyService;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueKey;
import com.atlassian.jira.issue.fields.rest.json.beans.EntityPropertyBean;
import com.atlassian.jira.issue.fields.rest.json.beans.EntityPropertyBeanSelfFunctions;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.rest.v2.entity.property.BasePropertyWithKeyResource;
import com.atlassian.jira.rest.v2.entity.property.EntityPropertiesKeysBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.google.common.base.Predicate;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.function.BiFunction;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="issue/{issueIdOrKey}/properties")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AnonymousSiteAccess
public class IssuePropertyResource {
    private final BasePropertyWithKeyResource<Issue> delegate;

    @Inject
    public IssuePropertyResource(IssuePropertyService issuePropertyService, JiraAuthenticationContext authContext, JiraBaseUrls jiraBaseUrls, I18nHelper i18n) {
        this.delegate = new BasePropertyWithKeyResource(issuePropertyService, authContext, jiraBaseUrls, i18n, (Predicate<String>)new IssueKey.IsValidIssueKeyPredicate(), (BiFunction<Long, String, String>)new EntityPropertyBeanSelfFunctions.IssuePropertySelfBiFunction(), EntityPropertyType.ISSUE_PROPERTY);
    }

    @ExperimentalApi
    @GET
    @Operation(summary="Get keys of all properties for an issue", description="Returns the keys of all properties for the issue identified by the key or by the id.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true)
    @ApiResponses(value={@ApiResponse(description="Returns a response containing EntityPropertiesKeysBean.", responseCode="200", content={@Content(schema=@Schema(implementation=EntityPropertiesKeysBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the issue key or id is invalid.", responseCode="400"), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to view the issue.", responseCode="403"), @ApiResponse(description="Returned if the issue with given key or id does not exist or if the property with given key is not found.", responseCode="404")})
    public Response getPropertiesKeys(@PathParam(value="issueIdOrKey") String issueIdOrKey) {
        return this.delegate.getPropertiesKeys(issueIdOrKey);
    }

    @ExperimentalApi
    @PUT
    @Path(value="/{propertyKey}")
    @Operation(summary="Update the value of a specific issue's property", description="Sets the value of the specified issue's property.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true), @Parameter(name="propertyKey", description="The key of the issue's property", in=ParameterIn.PATH, required=true, schema=@Schema(type="string", maxLength=255))})
    @RequestBody(description="The value of the issue's property", required=true, content={@Content(schema=@Schema(type="string", format="json"))})
    @ApiResponses(value={@ApiResponse(description="Returned if the issue property is successfully updated.", responseCode="200"), @ApiResponse(description="Returned if the issue property is successfully created.", responseCode="201"), @ApiResponse(description="Returned if the issue key or id is invalid.", responseCode="400"), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to edit the issue.", responseCode="403"), @ApiResponse(description="Returned if the issue with given key or id does not exist.", responseCode="404")})
    public Response setProperty(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="propertyKey") String issuePropertyKey, @Context HttpServletRequest request) {
        return this.delegate.setProperty(issueIdOrKey, issuePropertyKey, request);
    }

    @ExperimentalApi
    @GET
    @Path(value="/{propertyKey}")
    @Operation(summary="Get the value of a specific property from an issue", description="Returns the value of the property with a given key from the issue identified by the key or by the id.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true), @Parameter(name="propertyKey", description="The key of the property to return", in=ParameterIn.PATH, required=true)})
    @ApiResponses(value={@ApiResponse(description="Returned if the issue property was found.", responseCode="200", content={@Content(schema=@Schema(implementation=EntityPropertyBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the issue key or id is invalid.", responseCode="400"), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to view the issue.", responseCode="403"), @ApiResponse(description="Returned if the issue with given key or id does not exist or if the property with given key is not found.", responseCode="404")})
    public Response getProperty(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="propertyKey") String issuePropertyKey) {
        return this.delegate.getProperty(issueIdOrKey, issuePropertyKey);
    }

    @ExperimentalApi
    @DELETE
    @Path(value="/{propertyKey}")
    @Operation(summary="Delete a property from an issue", description="Removes the property from the issue identified by the key or by the id.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true), @Parameter(name="propertyKey", description="The key of the property to remove", in=ParameterIn.PATH, required=true)})
    @ApiResponses(value={@ApiResponse(description="Returned if the issue property was removed successfully.", responseCode="204"), @ApiResponse(description="Returned if the issue key or id is invalid.", responseCode="400"), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to edit the issue.", responseCode="403"), @ApiResponse(description="Returned if the issue with given key or id does not exist or if the property with given key is not found.", responseCode="404")})
    public Response deleteProperty(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="propertyKey") String propertyKey) {
        return this.delegate.deleteProperty(issueIdOrKey, propertyKey);
    }
}

