/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.IssueContextImpl;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.rest.FieldOperationHolder;
import com.atlassian.jira.issue.fields.rest.RestFieldOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.beans.EntityPropertyBeanHelper;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.api.issue.FieldOperation;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.rest.v2.issue.CreateMetaFieldBeanBuilder;
import com.atlassian.jira.rest.v2.issue.DefaultFieldMetaBeanHelper;
import com.atlassian.jira.rest.v2.issue.EditMetaFieldBeanBuilder;
import com.atlassian.jira.rest.v2.issue.IssueUpdateBean;
import com.atlassian.jira.rest.v2.issue.IssuesUpdateBean;
import com.atlassian.jira.rest.v2.issue.TransitionMetaFieldBeanBuilder;
import com.atlassian.jira.rest.v2.issue.version.VersionBeanFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Lists;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class IssueInputParametersAssembler {
    private final IssueService issueService;
    private final FieldManager fieldManager;
    private final ProjectManager projectManager;
    private final ConstantsManager constantsManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PermissionManager permissionManager;
    private final VersionBeanFactory versionBeanFactory;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final JiraBaseUrls baseUrls;
    private final FieldScreenRendererFactory fieldScreenRendererFactory;
    private final WorkflowManager workflowManager;
    private final IssueFactory issueFactory;
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private final IssueManager issueManager;
    private final FeatureManager featureManager;

    public IssueInputParametersAssembler(IssueService issueService, FieldManager fieldManager, ProjectManager projectManager, ConstantsManager constantsManager, FieldLayoutManager fieldLayoutManager, JiraAuthenticationContext jiraAuthenticationContext, PermissionManager permissionManager, VersionBeanFactory versionBeanFactory, VelocityRequestContextFactory velocityRequestContextFactory, JiraBaseUrls baseUrls, FieldScreenRendererFactory fieldScreenRendererFactory, WorkflowManager workflowManager, IssueFactory issueFactory, IssueSecurityLevelManager issueSecurityLevelManager, IssueManager issueManager, @ComponentImport FeatureManager featureManager) {
        this.issueService = issueService;
        this.fieldManager = fieldManager;
        this.projectManager = projectManager;
        this.constantsManager = constantsManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.permissionManager = permissionManager;
        this.versionBeanFactory = versionBeanFactory;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.baseUrls = baseUrls;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.workflowManager = workflowManager;
        this.issueFactory = issueFactory;
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.issueManager = issueManager;
        this.featureManager = featureManager;
    }

    Result makeUpdateAssembler(IssueUpdateBean request, Issue issue) {
        IssueInputParametersBuilder assembler = this.newAssembler();
        assembler.buildForEdit(request, issue);
        return assembler;
    }

    Result makeTransitionAssember(IssueUpdateBean updateBean, Issue issue) {
        IssueInputParametersBuilder assembler = this.newAssembler();
        assembler.buildForTransition(updateBean, issue);
        return assembler;
    }

    Result makeCreateAssembler(IssueUpdateBean request) {
        IssueInputParametersBuilder assembler = this.newAssembler();
        assembler.buildForCreate(request);
        return assembler;
    }

    List<Result> makeCreateAssemblers(IssuesUpdateBean requests) {
        ArrayList results = Lists.newArrayListWithCapacity((int)requests.getIssueUpdates().size());
        for (IssueUpdateBean request : requests.getIssueUpdates()) {
            results.add(this.makeCreateAssembler(request));
        }
        return results;
    }

    private IssueInputParametersBuilder newAssembler() {
        return new IssueInputParametersBuilder(this.issueService, this.fieldManager, this.projectManager, this.constantsManager, this.fieldLayoutManager, this.jiraAuthenticationContext, this.versionBeanFactory, this.velocityRequestContextFactory, this.baseUrls, this.fieldScreenRendererFactory, this.workflowManager, this.issueFactory, this.issueSecurityLevelManager, this.permissionManager, this.issueManager, this.featureManager);
    }

    private static class IssueInputParametersBuilder
    implements Result {
        private final FieldManager fieldManager;
        private final ProjectManager projectManager;
        private final ConstantsManager constantsManager;
        private final FieldLayoutManager fieldLayoutManager;
        private final JiraAuthenticationContext jiraAuthenticationContext;
        private final VersionBeanFactory versionBeanFactory;
        private final VelocityRequestContextFactory velocityRequestContextFactory;
        private final JiraBaseUrls baseUrls;
        private final FieldScreenRendererFactory fieldScreenRendererFactory;
        private final WorkflowManager workflowManager;
        private final IssueFactory issueFactory;
        private final IssueSecurityLevelManager issueSecurityLevelManager;
        private final PermissionManager permissionManager;
        private final IssueManager issueManager;
        private final FeatureManager featureManager;
        private final ErrorCollection errors;
        private final IssueInputParameters parameters;
        private final Map<String, List<FieldOperation>> updates = new LinkedHashMap<String, List<FieldOperation>>();
        private String parentIdorKey;

        public IssueInputParametersBuilder(IssueService issueService, FieldManager fieldManager, ProjectManager projectManager, ConstantsManager constantsManager, FieldLayoutManager fieldLayoutManager, JiraAuthenticationContext jiraAuthenticationContext, VersionBeanFactory versionBeanFactory, VelocityRequestContextFactory velocityRequestContextFactory, JiraBaseUrls baseUrls, FieldScreenRendererFactory fieldScreenRendererFactory, WorkflowManager workflowManager, IssueFactory issueFactory, IssueSecurityLevelManager issueSecurityLevelManager, PermissionManager permissionManager, IssueManager issueManager, @ComponentImport FeatureManager featureManager) {
            this.fieldManager = fieldManager;
            this.projectManager = projectManager;
            this.constantsManager = constantsManager;
            this.fieldLayoutManager = fieldLayoutManager;
            this.jiraAuthenticationContext = jiraAuthenticationContext;
            this.versionBeanFactory = versionBeanFactory;
            this.velocityRequestContextFactory = velocityRequestContextFactory;
            this.baseUrls = baseUrls;
            this.fieldScreenRendererFactory = fieldScreenRendererFactory;
            this.workflowManager = workflowManager;
            this.issueFactory = issueFactory;
            this.issueSecurityLevelManager = issueSecurityLevelManager;
            this.permissionManager = permissionManager;
            this.issueManager = issueManager;
            this.parameters = issueService.newIssueInputParameters();
            this.featureManager = featureManager;
            this.parameters.setRetainExistingValuesWhenParameterNotProvided(true, false);
            this.errors = new SimpleErrorCollection();
        }

        @Override
        public ErrorCollection getErrors() {
            return this.errors;
        }

        @Override
        public IssueInputParameters getParameters() {
            return this.parameters;
        }

        @Override
        public String getParentIdorKey() {
            return this.parentIdorKey;
        }

        void buildForEdit(IssueUpdateBean request, Issue issue) {
            this.build(request, this.getValidFieldsForEdit(issue), true);
            this.parameters.setRetainExistingValuesWhenParameterNotProvided(true, true);
            if (!this.errors.hasAnyErrors()) {
                this.finalizeIssueInputParams((IssueContext)issue, issue);
            }
        }

        void buildForTransition(IssueUpdateBean updateBean, Issue issue) {
            this.build(updateBean, this.getValidFieldsForTransition(issue, updateBean.getTransition().getId()), false);
            if (!this.errors.hasAnyErrors()) {
                this.finalizeIssueInputParams((IssueContext)issue, issue);
            }
        }

        private void build(IssueUpdateBean request, Set<String> validFieldIds, boolean mustHaveFields) {
            Map<String, Object> fields = request.fields();
            Map<String, List<FieldOperation>> update = request.update();
            if (mustHaveFields && fields == null && update == null) {
                this.errors.addErrorMessage("one of 'fields' or 'update' required", ErrorCollection.Reason.VALIDATION_FAILED);
                return;
            }
            if (fields != null) {
                this.handleFields(fields, validFieldIds);
            }
            if (update != null) {
                this.handleUpdate(update, validFieldIds);
            }
            this.parameters.setHistoryMetadata(request.getHistoryMetadata());
            Map properties = EntityPropertyBeanHelper.propertiesAsMap(request.getProperties());
            properties.forEach((arg_0, arg_1) -> ((IssueInputParameters)this.parameters).addProperty(arg_0, arg_1));
        }

        public void buildForCreate(IssueUpdateBean request) {
            this.initProjectAndIssueType(request.fields());
            Long projectId = this.parameters.getProjectId();
            if (projectId == null) {
                this.errors.addError("project", "project is required", ErrorCollection.Reason.VALIDATION_FAILED);
                return;
            }
            String issueTypeId = this.parameters.getIssueTypeId();
            if (issueTypeId == null) {
                this.errors.addError("issuetype", "issue type is required", ErrorCollection.Reason.VALIDATION_FAILED);
                return;
            }
            IssueContextImpl issueCtx = new IssueContextImpl(projectId, issueTypeId);
            if (issueCtx.getProjectObject() == null) {
                this.errors.addError("project", "valid project is required", ErrorCollection.Reason.VALIDATION_FAILED);
                return;
            }
            if (issueCtx.getIssueTypeObject() == null) {
                this.errors.addError("issuetype", "valid issue type is required", ErrorCollection.Reason.VALIDATION_FAILED);
                return;
            }
            this.parameters.setApplyDefaultValuesWhenParameterNotProvided(true);
            this.build(request, this.getValidFieldsForCreate((IssueContext)issueCtx), true);
            if (!this.errors.hasAnyErrors()) {
                this.finalizeIssueInputParams((IssueContext)issueCtx, null);
            }
        }

        private void initProjectAndIssueType(Map<String, Object> fields) {
            for (Map.Entry<String, Object> e : fields.entrySet()) {
                String fieldId = e.getKey();
                Object value = e.getValue();
                JsonData data = new JsonData(value);
                if ("project".equals(fieldId)) {
                    this.parameters.setProjectId(this.parseProject(fieldId, data, this.errors));
                }
                if (!"issuetype".equals(fieldId)) continue;
                this.parameters.setIssueTypeId(this.parseIssueType(fieldId, data, this.errors));
            }
        }

        private void handleFields(Map<String, Object> fields, Set<String> validFieldIds) {
            for (Map.Entry<String, Object> e : fields.entrySet()) {
                String fieldId = e.getKey();
                Object value = e.getValue();
                JsonData data = new JsonData(value);
                if ("parent".equals(fieldId)) {
                    String id = data.asObjectWithProperty("id", fieldId, this.errors);
                    if (id != null) {
                        this.parentIdorKey = id;
                        continue;
                    }
                    this.parentIdorKey = data.asObjectWithProperty("key", fieldId, this.errors);
                    continue;
                }
                if ("project".equals(fieldId)) {
                    this.parameters.setProjectId(this.parseProject(fieldId, data, this.errors));
                    continue;
                }
                if ("issuetype".equals(fieldId)) {
                    this.parameters.setIssueTypeId(this.parseIssueType(fieldId, data, this.errors));
                    continue;
                }
                if (validFieldIds.contains(fieldId)) {
                    this.addSetOperation(this.updates, fieldId, value);
                    continue;
                }
                this.errors.addError(fieldId, "Field '" + fieldId + "' cannot be set. It is not on the appropriate screen, or unknown.");
            }
        }

        private Long parseProject(String fieldId, JsonData data, ErrorCollection errors) {
            Project byKey;
            ResourceRef project = (ResourceRef)data.convertValue(fieldId, ResourceRef.class, errors);
            if (project == null) {
                return null;
            }
            if (project.id() != null) {
                try {
                    Project byId = this.projectManager.getProjectObj(Long.valueOf(Long.parseLong(project.id())));
                    if (byId != null) {
                        return byId.getId();
                    }
                }
                catch (NumberFormatException e) {
                    errors.addError(fieldId, "invalid id: " + project.id());
                }
            } else if (project.key() != null && (byKey = this.projectManager.getProjectObjByKey(project.key())) != null) {
                return byKey.getId();
            }
            errors.addError(fieldId, "Could not find project by id or key.");
            return null;
        }

        private String parseIssueType(String fieldId, JsonData data, ErrorCollection errors) {
            ResourceRef issuetype = (ResourceRef)data.convertValue(fieldId, ResourceRef.class, errors);
            if (issuetype == null) {
                return null;
            }
            if (issuetype.id() != null) {
                return issuetype.id();
            }
            if (issuetype.name() != null) {
                String name = issuetype.name();
                for (IssueType it : this.constantsManager.getAllIssueTypeObjects()) {
                    if (!name.equals(it.getNameTranslation()) && !name.equals(it.getName())) continue;
                    return it.getId();
                }
            }
            errors.addError(fieldId, "Could not find issuetype by id or name.");
            return null;
        }

        private void handleUpdate(Map<String, List<FieldOperation>> update, Set<String> validFieldIds) {
            for (String fieldId : update.keySet()) {
                if (validFieldIds.contains(fieldId)) {
                    if (this.updates.containsKey(fieldId)) {
                        this.errors.addErrorMessage("Field '" + fieldId + "' cannot appear in both 'fields' and 'update'");
                        continue;
                    }
                    this.updates.put(fieldId, update.get(fieldId));
                    continue;
                }
                this.errors.addError(fieldId, "Field '" + fieldId + "' cannot be set. It is not on the appropriate screen, or unknown.");
            }
        }

        private void finalizeIssueInputParams(IssueContext issueCtx, Issue issue) {
            for (Map.Entry<String, List<FieldOperation>> entry : this.updates.entrySet()) {
                String fieldId = entry.getKey();
                List<FieldOperation> operations = entry.getValue();
                Field field = this.fieldManager.getField(fieldId);
                if (field == null) {
                    String msg = "Field with id '" + fieldId + "' does not exist";
                    if (issue != null) {
                        msg = msg + " for issue '" + issue.getKey() + "'";
                    }
                    this.errors.addErrorMessage(msg);
                    continue;
                }
                if (!(field instanceof RestFieldOperations)) continue;
                RestFieldOperationsHandler operationsHandler = ((RestFieldOperations)field).getRestFieldOperation();
                Set supportedOperations = operationsHandler.getSupportedOperations();
                ArrayList<FieldOperationHolder> operationsHolders = new ArrayList<FieldOperationHolder>(operations.size());
                for (FieldOperation operation : operations) {
                    String operationName = operation.getOperation();
                    if (!supportedOperations.contains(operationName)) {
                        this.errors.addErrorMessage("Field with id' " + fieldId + "' and name '" + field.getName() + "' does not support operation '" + operationName + "' Supported operation(s) are: '" + StringUtils.join(supportedOperations.iterator(), (String)",") + "'");
                        continue;
                    }
                    FieldOperationHolder fieldOperationHolder = new FieldOperationHolder(operationName, new JsonData(operation.getValue()));
                    operationsHolders.add(fieldOperationHolder);
                }
                if (operationsHolders.isEmpty()) continue;
                ErrorCollection errorCollection = operationsHandler.updateIssueInputParameters(issueCtx, issue, fieldId, this.parameters, operationsHolders);
                this.errors.getErrorMessages().addAll(errorCollection.getErrorMessages());
                this.errors.getErrors().putAll(errorCollection.getErrors());
            }
        }

        private void addSetOperation(Map<String, List<FieldOperation>> updates, String fieldId, Object value) {
            Field field = this.fieldManager.getField(fieldId);
            if (field instanceof RestFieldOperations) {
                RestFieldOperations restField = (RestFieldOperations)field;
                if (restField.getRestFieldOperation().getSupportedOperations().contains("set")) {
                    FieldOperation op = new FieldOperation();
                    op.init("set", value);
                    updates.put(fieldId, Collections.singletonList(op));
                } else {
                    this.errors.addError(fieldId, "Field does not support update '" + fieldId + "'");
                }
            } else {
                this.errors.addError(fieldId, "Field does not support update '" + fieldId + "'");
            }
        }

        private Set<String> getValidFieldsForEdit(Issue issue) {
            EditMetaFieldBeanBuilder builder = new EditMetaFieldBeanBuilder(this.fieldLayoutManager, issue.getProjectObject(), issue, issue.getIssueType(), this.jiraAuthenticationContext.getLoggedInUser(), this.versionBeanFactory, this.velocityRequestContextFactory, this.baseUrls, this.fieldScreenRendererFactory, this.fieldManager, this.issueManager);
            HashSet<String> strings = new HashSet<String>();
            strings.add("comment");
            strings.addAll(builder.buildKeys());
            return strings;
        }

        private Set<String> getValidFieldsForCreate(IssueContext issueCtx) {
            Project projectObject = issueCtx.getProjectObject();
            if (projectObject != null && issueCtx.getIssueType() != null) {
                CreateMetaFieldBeanBuilder builder = new CreateMetaFieldBeanBuilder(this.fieldLayoutManager, projectObject, issueCtx.getIssueType(), this.issueFactory, this.jiraAuthenticationContext.getLoggedInUser(), this.versionBeanFactory, this.velocityRequestContextFactory, this.baseUrls, this.permissionManager, this.fieldScreenRendererFactory, this.jiraAuthenticationContext, this.fieldManager, new DefaultFieldMetaBeanHelper(projectObject, issueCtx.getIssueType(), this.issueSecurityLevelManager, this.featureManager));
                return builder.buildKeys();
            }
            return Collections.emptySet();
        }

        private Set<String> getValidFieldsForTransition(Issue issue, String actionId) {
            ActionDescriptor actionDescriptor = this.getActionDescriptor(issue, actionId);
            if (issue == null) {
                this.errors.addErrorMessage("getValidFieldsForTransition - Issue is null");
            }
            if (actionDescriptor == null) {
                this.errors.addErrorMessage("Transition id' " + actionId + "' is not valid for this issue.");
            }
            TransitionMetaFieldBeanBuilder builder = new TransitionMetaFieldBeanBuilder(this.fieldScreenRendererFactory, this.fieldLayoutManager, actionDescriptor, issue, this.jiraAuthenticationContext.getLoggedInUser(), this.versionBeanFactory, this.velocityRequestContextFactory, this.baseUrls);
            HashSet<String> strings = new HashSet<String>();
            strings.add("comment");
            strings.addAll(builder.buildKeys());
            return strings;
        }

        private ActionDescriptor getActionDescriptor(Issue issue, String actionId) {
            JiraWorkflow workflow = this.workflowManager.getWorkflow(issue);
            if (workflow == null) {
                return null;
            }
            WorkflowDescriptor descriptor = workflow.getDescriptor();
            if (descriptor == null) {
                return null;
            }
            try {
                return descriptor.getAction(Integer.parseInt(actionId));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    public static interface Result {
        public ErrorCollection getErrors();

        public IssueInputParameters getParameters();

        public String getParentIdorKey();
    }
}

