/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueRefJsonBean;
import com.atlassian.jira.rest.api.issue.JsonTypeBean;
import com.atlassian.jira.rest.api.property.PropertiesBean;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.rest.v2.issue.ChangelogBean;
import com.atlassian.jira.rest.v2.issue.EditMetaBean;
import com.atlassian.jira.rest.v2.issue.IncludedFields;
import com.atlassian.jira.rest.v2.issue.OpsbarBean;
import com.atlassian.jira.rest.v2.issue.TransitionBean;
import com.atlassian.plugins.rest.api.expand.annotation.Expandable;
import com.atlassian.plugins.rest.api.expand.expander.SelfExpanding;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.swagger.v3.oas.annotations.media.Schema;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="issue")
public class IssueBean {
    private static final String FIELDS_EXAMPLE = "{\n    \"watcher\": {\n        \"self\": \"http://www.example.com/jira/rest/api/2/issue/EX-1/watchers\",\n        \"isWatching\": false,\n        \"watchCount\": 1,\n        \"watchers\": [\n            {\n                \"self\": \"http://www.example.com/jira/rest/api/2/user?username=fred\",\n                \"name\": \"fred\",\n                \"displayName\": \"Fred F. User\",\n                \"active\": false\n            }\n        ]\n    },\n    \"attachment\": [\n        {\n            \"self\": \"http://www.example.com/jira/rest/api/2.0/attachments/10000\",\n            \"filename\": \"picture.jpg\",\n            \"author\": {\n                \"self\": \"http://www.example.com/jira/rest/api/2/user?username=fred\",\n                \"key\": \"JIRAUSER10100\",\n                \"name\": \"fred\",\n                \"emailAddress\": \"fred@example.com\",\n                \"avatarUrls\": {\n                    \"48x48\": \"http://www.example.com/jira/secure/useravatar?size=large&ownerId=fred\",\n                    \"24x24\": \"http://www.example.com/jira/secure/useravatar?size=small&ownerId=fred\",\n                    \"16x16\": \"http://www.example.com/jira/secure/useravatar?size=xsmall&ownerId=fred\",\n                    \"32x32\": \"http://www.example.com/jira/secure/useravatar?size=medium&ownerId=fred\"\n                },\n                \"displayName\": \"Fred F. User\",\n                \"active\": true,\n                \"deleted\": false,\n                \"timeZone\": \"Australia/Sydney\",\n                \"locale\": \"en_AU\",\n                \"lastLoginTime\": \"2023-08-30T16:37:01+1000\"\n            },\n            \"created\": \"2024-05-23T14:47:28.592+0000\",\n            \"size\": 23123,\n            \"mimeType\": \"image/jpeg\",\n            \"content\": \"http://www.example.com/jira/attachments/10000\",\n            \"thumbnail\": \"http://www.example.com/jira/secure/thumbnail/10000\"\n        }\n    ],\n    \"sub-tasks\": [\n        {\n            \"id\": \"10000\",\n            \"type\": {\n                \"id\": \"10000\",\n                \"name\": \"\",\n                \"inward\": \"Parent\",\n                \"outward\": \"Sub-task\"\n            },\n            \"outwardIssue\": {\n                \"id\": \"10003\",\n                \"key\": \"EX-2\",\n                \"self\": \"http://www.example.com/jira/rest/api/2/issue/EX-2\",\n                \"fields\": {\n                    \"status\": {\n                        \"iconUrl\": \"http://www.example.com/jira//images/icons/statuses/open.png\",\n                        \"name\": \"Open\"\n                    }\n                }\n            }\n        }\n    ],\n    \"description\": \"example bug report\",\n    \"project\": {\n        \"self\": \"http://www.example.com/jira/rest/api/2/project/EX\",\n        \"id\": \"10000\",\n        \"key\": \"EX\",\n        \"name\": \"Example\",\n        \"avatarUrls\": {\n            \"48x48\": \"http://www.example.com/jira/secure/projectavatar?size=large&pid=10000\",\n            \"24x24\": \"http://www.example.com/jira/secure/projectavatar?size=small&pid=10000\",\n            \"16x16\": \"http://www.example.com/jira/secure/projectavatar?size=xsmall&pid=10000\",\n            \"32x32\": \"http://www.example.com/jira/secure/projectavatar?size=medium&pid=10000\"\n        },\n        \"projectCategory\": {\n            \"self\": \"http://www.example.com/jira/rest/api/2/projectCategory/10000\",\n            \"id\": \"10000\",\n            \"name\": \"FIRST\",\n            \"description\": \"First Project Category\"\n        }\n    },\n    \"comment\": [\n        {\n            \"self\": \"http://www.example.com/jira/rest/api/2/issue/10010/comment/10000\",\n            \"id\": \"10000\",\n            \"author\": {\n                \"self\": \"http://www.example.com/jira/rest/api/2/user?username=fred\",\n                \"name\": \"fred\",\n                \"displayName\": \"Fred F. User\",\n                \"active\": false\n            },\n            \"body\": \"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque eget venenatis elit. Duis eu justo eget augue iaculis fermentum. Sed semper quam laoreet nisi egestas at posuere augue semper.\",\n            \"updateAuthor\": {\n                \"self\": \"http://www.example.com/jira/rest/api/2/user?username=fred\",\n                \"name\": \"fred\",\n                \"displayName\": \"Fred F. User\",\n                \"active\": false\n            },\n            \"created\": \"2024-05-23T14:47:28.538+0000\",\n            \"updated\": \"2024-05-23T14:47:28.538+0000\",\n            \"visibility\": {\n                \"type\": \"role\",\n                \"value\": \"Administrators\"\n            }\n        }\n    ],\n    \"issuelinks\": [\n        {\n            \"id\": \"10001\",\n            \"type\": {\n                \"id\": \"10000\",\n                \"name\": \"Dependent\",\n                \"inward\": \"depends on\",\n                \"outward\": \"is depended by\"\n            },\n            \"outwardIssue\": {\n                \"id\": \"10004L\",\n                \"key\": \"PRJ-2\",\n                \"self\": \"http://www.example.com/jira/rest/api/2/issue/PRJ-2\",\n                \"fields\": {\n                    \"status\": {\n                        \"iconUrl\": \"http://www.example.com/jira//images/icons/statuses/open.png\",\n                        \"name\": \"Open\"\n                    }\n                }\n            }\n        },\n        {\n            \"id\": \"10002\",\n            \"type\": {\n                \"id\": \"10000\",\n                \"name\": \"Dependent\",\n                \"inward\": \"depends on\",\n                \"outward\": \"is depended by\"\n            },\n            \"inwardIssue\": {\n                \"id\": \"10004\",\n                \"key\": \"PRJ-3\",\n                \"self\": \"http://www.example.com/jira/rest/api/2/issue/PRJ-3\",\n                \"fields\": {\n                    \"status\": {\n                        \"iconUrl\": \"http://www.example.com/jira//images/icons/statuses/open.png\",\n                        \"name\": \"Open\"\n                    }\n                }\n            }\n        }\n    ],\n    \"worklog\": [\n        {\n            \"self\": \"http://www.example.com/jira/rest/api/2/issue/10010/worklog/10000\",\n            \"author\": {\n                \"self\": \"http://www.example.com/jira/rest/api/2/user?username=fred\",\n                \"name\": \"fred\",\n                \"displayName\": \"Fred F. User\",\n                \"active\": false\n            },\n            \"updateAuthor\": {\n                \"self\": \"http://www.example.com/jira/rest/api/2/user?username=fred\",\n                \"name\": \"fred\",\n                \"displayName\": \"Fred F. User\",\n                \"active\": false\n            },\n            \"comment\": \"I did some work here.\",\n            \"updated\": \"2024-05-23T14:47:28.599+0000\",\n            \"visibility\": {\n                \"type\": \"group\",\n                \"value\": \"jira-developers\"\n            },\n            \"started\": \"2024-05-23T14:47:28.598+0000\",\n            \"timeSpent\": \"3h 20m\",\n            \"timeSpentSeconds\": 12000,\n            \"id\": \"100028\",\n            \"issueId\": \"10002\"\n        }\n    ],\n    \"updated\": 1,\n    \"timetracking\": {\n        \"originalEstimate\": \"10m\",\n        \"remainingEstimate\": \"3m\",\n        \"timeSpent\": \"6m\",\n        \"originalEstimateSeconds\": 600,\n        \"remainingEstimateSeconds\": 200,\n        \"timeSpentSeconds\": 400\n    }\n}";
    @XmlAttribute
    private String expand;
    @XmlElement
    @Schema(example="10000")
    private String id;
    @XmlElement
    @Schema(example="https://jira.atlassian.com/rest/api/2/issue/10000")
    private URI self;
    @XmlElement
    @Schema(example="HSP-1")
    private String key;
    @XmlElement
    @JsonInclude
    @Schema(example="{\n    \"watcher\": {\n        \"self\": \"http://www.example.com/jira/rest/api/2/issue/EX-1/watchers\",\n        \"isWatching\": false,\n        \"watchCount\": 1,\n        \"watchers\": [\n            {\n                \"self\": \"http://www.example.com/jira/rest/api/2/user?username=fred\",\n                \"name\": \"fred\",\n                \"displayName\": \"Fred F. User\",\n                \"active\": false\n            }\n        ]\n    },\n    \"attachment\": [\n        {\n            \"self\": \"http://www.example.com/jira/rest/api/2.0/attachments/10000\",\n            \"filename\": \"picture.jpg\",\n            \"author\": {\n                \"self\": \"http://www.example.com/jira/rest/api/2/user?username=fred\",\n                \"key\": \"JIRAUSER10100\",\n                \"name\": \"fred\",\n                \"emailAddress\": \"fred@example.com\",\n                \"avatarUrls\": {\n                    \"48x48\": \"http://www.example.com/jira/secure/useravatar?size=large&ownerId=fred\",\n                    \"24x24\": \"http://www.example.com/jira/secure/useravatar?size=small&ownerId=fred\",\n                    \"16x16\": \"http://www.example.com/jira/secure/useravatar?size=xsmall&ownerId=fred\",\n                    \"32x32\": \"http://www.example.com/jira/secure/useravatar?size=medium&ownerId=fred\"\n                },\n                \"displayName\": \"Fred F. User\",\n                \"active\": true,\n                \"deleted\": false,\n                \"timeZone\": \"Australia/Sydney\",\n                \"locale\": \"en_AU\",\n                \"lastLoginTime\": \"2023-08-30T16:37:01+1000\"\n            },\n            \"created\": \"2024-05-23T14:47:28.592+0000\",\n            \"size\": 23123,\n            \"mimeType\": \"image/jpeg\",\n            \"content\": \"http://www.example.com/jira/attachments/10000\",\n            \"thumbnail\": \"http://www.example.com/jira/secure/thumbnail/10000\"\n        }\n    ],\n    \"sub-tasks\": [\n        {\n            \"id\": \"10000\",\n            \"type\": {\n                \"id\": \"10000\",\n                \"name\": \"\",\n                \"inward\": \"Parent\",\n                \"outward\": \"Sub-task\"\n            },\n            \"outwardIssue\": {\n                \"id\": \"10003\",\n                \"key\": \"EX-2\",\n                \"self\": \"http://www.example.com/jira/rest/api/2/issue/EX-2\",\n                \"fields\": {\n                    \"status\": {\n                        \"iconUrl\": \"http://www.example.com/jira//images/icons/statuses/open.png\",\n                        \"name\": \"Open\"\n                    }\n                }\n            }\n        }\n    ],\n    \"description\": \"example bug report\",\n    \"project\": {\n        \"self\": \"http://www.example.com/jira/rest/api/2/project/EX\",\n        \"id\": \"10000\",\n        \"key\": \"EX\",\n        \"name\": \"Example\",\n        \"avatarUrls\": {\n            \"48x48\": \"http://www.example.com/jira/secure/projectavatar?size=large&pid=10000\",\n            \"24x24\": \"http://www.example.com/jira/secure/projectavatar?size=small&pid=10000\",\n            \"16x16\": \"http://www.example.com/jira/secure/projectavatar?size=xsmall&pid=10000\",\n            \"32x32\": \"http://www.example.com/jira/secure/projectavatar?size=medium&pid=10000\"\n        },\n        \"projectCategory\": {\n            \"self\": \"http://www.example.com/jira/rest/api/2/projectCategory/10000\",\n            \"id\": \"10000\",\n            \"name\": \"FIRST\",\n            \"description\": \"First Project Category\"\n        }\n    },\n    \"comment\": [\n        {\n            \"self\": \"http://www.example.com/jira/rest/api/2/issue/10010/comment/10000\",\n            \"id\": \"10000\",\n            \"author\": {\n                \"self\": \"http://www.example.com/jira/rest/api/2/user?username=fred\",\n                \"name\": \"fred\",\n                \"displayName\": \"Fred F. User\",\n                \"active\": false\n            },\n            \"body\": \"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque eget venenatis elit. Duis eu justo eget augue iaculis fermentum. Sed semper quam laoreet nisi egestas at posuere augue semper.\",\n            \"updateAuthor\": {\n                \"self\": \"http://www.example.com/jira/rest/api/2/user?username=fred\",\n                \"name\": \"fred\",\n                \"displayName\": \"Fred F. User\",\n                \"active\": false\n            },\n            \"created\": \"2024-05-23T14:47:28.538+0000\",\n            \"updated\": \"2024-05-23T14:47:28.538+0000\",\n            \"visibility\": {\n                \"type\": \"role\",\n                \"value\": \"Administrators\"\n            }\n        }\n    ],\n    \"issuelinks\": [\n        {\n            \"id\": \"10001\",\n            \"type\": {\n                \"id\": \"10000\",\n                \"name\": \"Dependent\",\n                \"inward\": \"depends on\",\n                \"outward\": \"is depended by\"\n            },\n            \"outwardIssue\": {\n                \"id\": \"10004L\",\n                \"key\": \"PRJ-2\",\n                \"self\": \"http://www.example.com/jira/rest/api/2/issue/PRJ-2\",\n                \"fields\": {\n                    \"status\": {\n                        \"iconUrl\": \"http://www.example.com/jira//images/icons/statuses/open.png\",\n                        \"name\": \"Open\"\n                    }\n                }\n            }\n        },\n        {\n            \"id\": \"10002\",\n            \"type\": {\n                \"id\": \"10000\",\n                \"name\": \"Dependent\",\n                \"inward\": \"depends on\",\n                \"outward\": \"is depended by\"\n            },\n            \"inwardIssue\": {\n                \"id\": \"10004\",\n                \"key\": \"PRJ-3\",\n                \"self\": \"http://www.example.com/jira/rest/api/2/issue/PRJ-3\",\n                \"fields\": {\n                    \"status\": {\n                        \"iconUrl\": \"http://www.example.com/jira//images/icons/statuses/open.png\",\n                        \"name\": \"Open\"\n                    }\n                }\n            }\n        }\n    ],\n    \"worklog\": [\n        {\n            \"self\": \"http://www.example.com/jira/rest/api/2/issue/10010/worklog/10000\",\n            \"author\": {\n                \"self\": \"http://www.example.com/jira/rest/api/2/user?username=fred\",\n                \"name\": \"fred\",\n                \"displayName\": \"Fred F. User\",\n                \"active\": false\n            },\n            \"updateAuthor\": {\n                \"self\": \"http://www.example.com/jira/rest/api/2/user?username=fred\",\n                \"name\": \"fred\",\n                \"displayName\": \"Fred F. User\",\n                \"active\": false\n            },\n            \"comment\": \"I did some work here.\",\n            \"updated\": \"2024-05-23T14:47:28.599+0000\",\n            \"visibility\": {\n                \"type\": \"group\",\n                \"value\": \"jira-developers\"\n            },\n            \"started\": \"2024-05-23T14:47:28.598+0000\",\n            \"timeSpent\": \"3h 20m\",\n            \"timeSpentSeconds\": 12000,\n            \"id\": \"100028\",\n            \"issueId\": \"10002\"\n        }\n    ],\n    \"updated\": 1,\n    \"timetracking\": {\n        \"originalEstimate\": \"10m\",\n        \"remainingEstimate\": \"3m\",\n        \"timeSpent\": \"6m\",\n        \"originalEstimateSeconds\": 600,\n        \"remainingEstimateSeconds\": 200,\n        \"timeSpentSeconds\": 400\n    }\n}")
    private Map<String, Object> fields;
    @XmlElement
    @JsonInclude
    @Schema(example="{\n    \"watcher\": {\n        \"self\": \"http://www.example.com/jira/rest/api/2/issue/EX-1/watchers\",\n        \"isWatching\": false,\n        \"watchCount\": 1,\n        \"watchers\": [\n            {\n                \"self\": \"http://www.example.com/jira/rest/api/2/user?username=fred\",\n                \"name\": \"fred\",\n                \"displayName\": \"Fred F. User\",\n                \"active\": false\n            }\n        ]\n    },\n    \"attachment\": [\n        {\n            \"self\": \"http://www.example.com/jira/rest/api/2.0/attachments/10000\",\n            \"filename\": \"picture.jpg\",\n            \"author\": {\n                \"self\": \"http://www.example.com/jira/rest/api/2/user?username=fred\",\n                \"key\": \"JIRAUSER10100\",\n                \"name\": \"fred\",\n                \"emailAddress\": \"fred@example.com\",\n                \"avatarUrls\": {\n                    \"48x48\": \"http://www.example.com/jira/secure/useravatar?size=large&ownerId=fred\",\n                    \"24x24\": \"http://www.example.com/jira/secure/useravatar?size=small&ownerId=fred\",\n                    \"16x16\": \"http://www.example.com/jira/secure/useravatar?size=xsmall&ownerId=fred\",\n                    \"32x32\": \"http://www.example.com/jira/secure/useravatar?size=medium&ownerId=fred\"\n                },\n                \"displayName\": \"Fred F. User\",\n                \"active\": true,\n                \"deleted\": false,\n                \"timeZone\": \"Australia/Sydney\",\n                \"locale\": \"en_AU\",\n                \"lastLoginTime\": \"2023-08-30T16:37:01+1000\"\n            },\n            \"created\": \"2024-05-23T14:47:28.592+0000\",\n            \"size\": 23123,\n            \"mimeType\": \"image/jpeg\",\n            \"content\": \"http://www.example.com/jira/attachments/10000\",\n            \"thumbnail\": \"http://www.example.com/jira/secure/thumbnail/10000\"\n        }\n    ],\n    \"sub-tasks\": [\n        {\n            \"id\": \"10000\",\n            \"type\": {\n                \"id\": \"10000\",\n                \"name\": \"\",\n                \"inward\": \"Parent\",\n                \"outward\": \"Sub-task\"\n            },\n            \"outwardIssue\": {\n                \"id\": \"10003\",\n                \"key\": \"EX-2\",\n                \"self\": \"http://www.example.com/jira/rest/api/2/issue/EX-2\",\n                \"fields\": {\n                    \"status\": {\n                        \"iconUrl\": \"http://www.example.com/jira//images/icons/statuses/open.png\",\n                        \"name\": \"Open\"\n                    }\n                }\n            }\n        }\n    ],\n    \"description\": \"example bug report\",\n    \"project\": {\n        \"self\": \"http://www.example.com/jira/rest/api/2/project/EX\",\n        \"id\": \"10000\",\n        \"key\": \"EX\",\n        \"name\": \"Example\",\n        \"avatarUrls\": {\n            \"48x48\": \"http://www.example.com/jira/secure/projectavatar?size=large&pid=10000\",\n            \"24x24\": \"http://www.example.com/jira/secure/projectavatar?size=small&pid=10000\",\n            \"16x16\": \"http://www.example.com/jira/secure/projectavatar?size=xsmall&pid=10000\",\n            \"32x32\": \"http://www.example.com/jira/secure/projectavatar?size=medium&pid=10000\"\n        },\n        \"projectCategory\": {\n            \"self\": \"http://www.example.com/jira/rest/api/2/projectCategory/10000\",\n            \"id\": \"10000\",\n            \"name\": \"FIRST\",\n            \"description\": \"First Project Category\"\n        }\n    },\n    \"comment\": [\n        {\n            \"self\": \"http://www.example.com/jira/rest/api/2/issue/10010/comment/10000\",\n            \"id\": \"10000\",\n            \"author\": {\n                \"self\": \"http://www.example.com/jira/rest/api/2/user?username=fred\",\n                \"name\": \"fred\",\n                \"displayName\": \"Fred F. User\",\n                \"active\": false\n            },\n            \"body\": \"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque eget venenatis elit. Duis eu justo eget augue iaculis fermentum. Sed semper quam laoreet nisi egestas at posuere augue semper.\",\n            \"updateAuthor\": {\n                \"self\": \"http://www.example.com/jira/rest/api/2/user?username=fred\",\n                \"name\": \"fred\",\n                \"displayName\": \"Fred F. User\",\n                \"active\": false\n            },\n            \"created\": \"2024-05-23T14:47:28.538+0000\",\n            \"updated\": \"2024-05-23T14:47:28.538+0000\",\n            \"visibility\": {\n                \"type\": \"role\",\n                \"value\": \"Administrators\"\n            }\n        }\n    ],\n    \"issuelinks\": [\n        {\n            \"id\": \"10001\",\n            \"type\": {\n                \"id\": \"10000\",\n                \"name\": \"Dependent\",\n                \"inward\": \"depends on\",\n                \"outward\": \"is depended by\"\n            },\n            \"outwardIssue\": {\n                \"id\": \"10004L\",\n                \"key\": \"PRJ-2\",\n                \"self\": \"http://www.example.com/jira/rest/api/2/issue/PRJ-2\",\n                \"fields\": {\n                    \"status\": {\n                        \"iconUrl\": \"http://www.example.com/jira//images/icons/statuses/open.png\",\n                        \"name\": \"Open\"\n                    }\n                }\n            }\n        },\n        {\n            \"id\": \"10002\",\n            \"type\": {\n                \"id\": \"10000\",\n                \"name\": \"Dependent\",\n                \"inward\": \"depends on\",\n                \"outward\": \"is depended by\"\n            },\n            \"inwardIssue\": {\n                \"id\": \"10004\",\n                \"key\": \"PRJ-3\",\n                \"self\": \"http://www.example.com/jira/rest/api/2/issue/PRJ-3\",\n                \"fields\": {\n                    \"status\": {\n                        \"iconUrl\": \"http://www.example.com/jira//images/icons/statuses/open.png\",\n                        \"name\": \"Open\"\n                    }\n                }\n            }\n        }\n    ],\n    \"worklog\": [\n        {\n            \"self\": \"http://www.example.com/jira/rest/api/2/issue/10010/worklog/10000\",\n            \"author\": {\n                \"self\": \"http://www.example.com/jira/rest/api/2/user?username=fred\",\n                \"name\": \"fred\",\n                \"displayName\": \"Fred F. User\",\n                \"active\": false\n            },\n            \"updateAuthor\": {\n                \"self\": \"http://www.example.com/jira/rest/api/2/user?username=fred\",\n                \"name\": \"fred\",\n                \"displayName\": \"Fred F. User\",\n                \"active\": false\n            },\n            \"comment\": \"I did some work here.\",\n            \"updated\": \"2024-05-23T14:47:28.599+0000\",\n            \"visibility\": {\n                \"type\": \"group\",\n                \"value\": \"jira-developers\"\n            },\n            \"started\": \"2024-05-23T14:47:28.598+0000\",\n            \"timeSpent\": \"3h 20m\",\n            \"timeSpentSeconds\": 12000,\n            \"id\": \"100028\",\n            \"issueId\": \"10002\"\n        }\n    ],\n    \"updated\": 1,\n    \"timetracking\": {\n        \"originalEstimate\": \"10m\",\n        \"remainingEstimate\": \"3m\",\n        \"timeSpent\": \"6m\",\n        \"originalEstimateSeconds\": 600,\n        \"remainingEstimateSeconds\": 200,\n        \"timeSpentSeconds\": 400\n    }\n}")
    private Map<String, Object> renderedFields;
    @XmlElement
    private PropertiesBean properties;
    @XmlTransient
    private final Map<String, Object> renderedFields_ = Maps.newHashMap();
    @XmlTransient
    @Expandable(value="renderedFields")
    private SelfExpanding renderedFieldExpander = new SelfExpanding(){

        public void expand() {
            IssueBean.this.renderedFields = IssueBean.this.renderedFields_;
        }
    };
    @XmlElement
    @Schema(example="{\n    \"watcher\": \"watcher\",\n    \"attachment\": \"attachment\",\n    \"sub-tasks\": \"sub-tasks\",\n    \"description\": \"description\",\n    \"project\": \"project\",\n    \"comment\": \"comment\",\n    \"issuelinks\": \"issuelinks\",\n    \"worklog\": \"worklog\",\n    \"updated\": \"updated\",\n    \"timetracking\": \"timetracking\"\n}")
    private Map<String, String> names;
    @XmlTransient
    private final Map<String, String> names_ = Maps.newHashMap();
    @XmlTransient
    @Expandable(value="names")
    private SelfExpanding namesExpander = new SelfExpanding(){

        public void expand() {
            IssueBean.this.names = IssueBean.this.names_;
        }
    };
    @XmlElement
    @Schema(example="{\n    \"type\": \"project\",\n    \"custom\": \"com.atlassian.jira.plugin.system.customfieldtypes:project\",\n    \"customId\": 10101\n}")
    private Map<String, JsonTypeBean> schema;
    @XmlTransient
    private final Map<String, JsonTypeBean> schema_ = Maps.newHashMap();
    @XmlTransient
    @Expandable(value="schema")
    private SelfExpanding schemaExpander = new SelfExpanding(){

        public void expand() {
            IssueBean.this.schema = IssueBean.this.schema_;
        }
    };
    @XmlElement
    @Expandable(value="transitions")
    private List<TransitionBean> transitions;
    @XmlElement
    private OpsbarBean operations;
    @XmlTransient
    private OpsbarBean operations_;
    @XmlTransient
    @Expandable(value="operations")
    private SelfExpanding operationsExpander = new SelfExpanding(){

        public void expand() {
            IssueBean.this.operations = IssueBean.this.operations_;
        }
    };
    @XmlTransient
    @Expandable(value="editmeta")
    private SelfExpanding editmetaExpander = new SelfExpanding(){

        public void expand() {
            IssueBean.this.editmeta = IssueBean.this.editmeta_;
        }
    };
    @XmlElement
    private EditMetaBean editmeta;
    @XmlTransient
    private EditMetaBean editmeta_;
    @XmlTransient
    @Expandable(value="changelog")
    private SelfExpanding changelogExpander = new SelfExpanding(){

        public void expand() {
            IssueBean.this.changelog = IssueBean.this.changelog_;
        }
    };
    @XmlElement
    private ChangelogBean changelog;
    @XmlTransient
    private ChangelogBean changelog_;
    @XmlTransient
    @Expandable(value="versionedRepresentations")
    private SelfExpanding versionedRepresentationsExpander = new SelfExpanding(){

        public void expand() {
            IssueBean.this.versionedRepresentations = IssueBean.this.versionedRepresentations_;
        }
    };
    @XmlElement
    private Map<String, Map<Integer, Object>> versionedRepresentations;
    @XmlTransient
    private final Map<String, Map<Integer, Object>> versionedRepresentations_ = Maps.newHashMap();
    private IncludedFields fieldsToInclude;

    public IssueBean() {
    }

    public IssueBean(Long id, String key, URI selfUri) {
        this(id == null ? null : id.toString(), key, selfUri);
    }

    public IssueBean(String id, String key, URI selfUri) {
        this.id = id;
        this.self = selfUri;
        this.key = key;
    }

    public IssueBean fieldsToInclude(IncludedFields fieldsToInclude) {
        this.fieldsToInclude = fieldsToInclude;
        return this;
    }

    public IssueBean fields(Map<String, Object> fields) {
        this.fields = Maps.newHashMap(fields);
        return this;
    }

    public void addField(Field field, FieldJsonRepresentation data, boolean includeRenderedVersion) {
        this.addField(field.getName(), field, data, includeRenderedVersion);
    }

    public void addField(String displayName, Field field, FieldJsonRepresentation data, boolean includeRenderedVersion) {
        if ((this.fieldsToInclude == null || this.fieldsToInclude.included(field)) && data.getStandardData() != null) {
            JsonType schema = field instanceof RestAwareField ? ((RestAwareField)field).getJsonSchema() : null;
            String fieldId = field.getId();
            this.addRawField(fieldId, displayName, schema, data.getStandardData().getData());
            if (includeRenderedVersion && data.getRenderedData() != null) {
                this.renderedFields_.put(fieldId, data.getRenderedData().getData());
            }
        }
    }

    public void addParentField(IssueRefJsonBean value, String displayName) {
        String fieldId = "parent";
        if (this.fieldsToInclude == null || this.fieldsToInclude.included("parent", true)) {
            JsonType schema = JsonTypeBuilder.systemArray((String)"issuelinks", (String)"parent");
            this.addRawField("parent", displayName, schema, value);
        }
    }

    void addRawField(String fieldId, String displayName, JsonType schema, Object value) {
        if (this.fields == null) {
            this.fields = Maps.newHashMap();
        }
        this.names_.put(fieldId, displayName);
        if (schema != null) {
            this.schema_.put(fieldId, new JsonTypeBean(schema));
        }
        this.fields.put(fieldId, value);
    }

    public boolean hasField(String fieldId) {
        return this.fields != null && this.fields.containsKey(fieldId);
    }

    public String getKey() {
        return this.key;
    }

    public String getId() {
        return this.id;
    }

    public URI getSelf() {
        return this.self;
    }

    public Map<String, Object> getFields() {
        return this.fields;
    }

    @JsonIgnore
    public Map<String, Object> getRenderedFields() {
        return this.renderedFields_;
    }

    @JsonGetter(value="renderedFields")
    public Map<String, Object> getRenderedFieldsJson() {
        return this.renderedFields;
    }

    public PropertiesBean getProperties() {
        return this.properties;
    }

    public void setProperties(PropertiesBean properties) {
        this.properties = properties;
    }

    @JsonIgnore
    public Map<String, String> getNames() {
        return this.names_;
    }

    @JsonGetter(value="names")
    public Map<String, String> getNamesJson() {
        return this.names;
    }

    @JsonIgnore
    public Map<String, JsonTypeBean> getSchema() {
        return this.schema_;
    }

    @JsonGetter(value="schema")
    public Map<String, JsonTypeBean> getSchemaJson() {
        return this.schema;
    }

    public List<TransitionBean> getTransitions() {
        return this.transitions;
    }

    @JsonIgnore
    public OpsbarBean getOperations() {
        return this.operations_;
    }

    @JsonGetter(value="operations")
    public OpsbarBean getOperationsJson() {
        return this.operations;
    }

    @JsonIgnore
    public EditMetaBean getEditMeta() {
        return this.editmeta_;
    }

    @JsonGetter(value="editmeta")
    public EditMetaBean getEditMetaJson() {
        return this.editmeta;
    }

    @JsonIgnore
    public ChangelogBean getChangelog() {
        return this.changelog_;
    }

    @JsonGetter(value="changelog")
    public ChangelogBean getChangelogJson() {
        return this.changelog;
    }

    @JsonIgnore
    public Map<String, Map<Integer, Object>> getVersionedRepresentations() {
        return this.versionedRepresentations_;
    }

    @JsonGetter(value="versionedRepresentations")
    public Map<String, Map<Integer, Object>> getVersionedRepresentationsJson() {
        return this.versionedRepresentations;
    }

    public void setFieldsToInclude(IncludedFields fieldsToInclude) {
        this.fieldsToInclude = fieldsToInclude;
    }

    public void addFields(Map<String, Object> fields) {
        if (fields.isEmpty()) {
            return;
        }
        if (this.fields == null) {
            this.fields = new HashMap<String, Object>();
        }
        this.fields.putAll(fields);
    }

    public void addNames(Map<String, String> names) {
        this.names_.putAll(names);
    }

    public void addRenderedFields(Map<String, Object> renderedFields) {
        this.renderedFields_.putAll(renderedFields);
    }

    public void addSchema(Map<String, JsonTypeBean> schema) {
        this.schema_.putAll(schema);
    }

    public void addTransitionBeans(List<TransitionBean> transitionBeans) {
        this.addAll(transitionBeans);
    }

    public void setEditMeta(EditMetaBean editMeta) {
        this.editmeta_ = editMeta;
    }

    public void setOperations(OpsbarBean opsbarBean) {
        this.operations_ = opsbarBean;
    }

    public void setChangelog(ChangelogBean changelog) {
        this.changelog_ = changelog;
    }

    public void addVersionedRepresentations(Map<String, Map<Integer, Object>> versionedRepresentations) {
        this.versionedRepresentations_.putAll(versionedRepresentations);
    }

    public List<String> expand() {
        return StringList.fromQueryParam(this.expand).asList();
    }

    public IssueBean expand(Iterable<String> expand) {
        this.expand = expand != null ? StringList.fromList(expand).toQueryParam() : null;
        return this;
    }

    public Map<String, String> names() {
        return this.names;
    }

    public IssueBean names(@Nullable Map<String, String> names) {
        this.names = names;
        return this;
    }

    public Map<String, JsonTypeBean> schema() {
        return this.schema;
    }

    public IssueBean schema(@Nullable Map<String, JsonTypeBean> schema) {
        this.schema = schema;
        return this;
    }

    public IssueBean editmeta(EditMetaBean editmeta) {
        this.editmeta_ = editmeta;
        return this;
    }

    public void setTransitionBeans(List<TransitionBean> transitionBeans) {
        this.addAll(transitionBeans);
    }

    public IssueBean changelog(ChangelogBean changelog) {
        this.changelog_ = changelog;
        return this;
    }

    private void addAll(List<TransitionBean> transitionBeans) {
        if (this.transitions == null) {
            this.transitions = Lists.newArrayList();
        }
        this.transitions.addAll(transitionBeans);
    }
}

