/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.attachment.AttachmentService;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.CreateAttachmentParamsBean;
import com.atlassian.jira.issue.fields.rest.json.beans.AttachmentJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.AttachmentJsonBeanConverter;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.issue.IssueFinder;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.multipart.FilePart;
import com.atlassian.plugins.rest.api.multipart.MultipartConfig;
import com.atlassian.plugins.rest.api.multipart.MultipartConfigClass;
import com.atlassian.plugins.rest.api.multipart.MultipartFormParam;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.ofbiz.core.util.UtilDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.config.Configuration;

@Path(value="issue/{issueIdOrKey}/attachments")
@AnonymousSiteAccess
@Produces(value={"application/json"})
public class IssueAttachmentsResource {
    private static final Logger log = LoggerFactory.getLogger(IssueAttachmentsResource.class);
    private final JiraAuthenticationContext authContext;
    private final IssueFinder issueFinder;
    private final AttachmentService attachmentService;
    private final AttachmentManager attachmentManager;
    private final IssueUpdater issueUpdater;
    private final I18nHelper i18n;
    private final AttachmentJsonBeanConverter attachmentJsonBeanConverter;

    @Inject
    public IssueAttachmentsResource(JiraAuthenticationContext authContext, AttachmentService attachmentService, AttachmentManager attachmentManager, IssueUpdater issueUpdater, I18nHelper i18n, IssueFinder issueFinder, @ComponentImport AttachmentJsonBeanConverter attachmentJsonBeanConverter) {
        this.authContext = authContext;
        this.attachmentService = attachmentService;
        this.attachmentManager = attachmentManager;
        this.issueUpdater = issueUpdater;
        this.i18n = i18n;
        this.issueFinder = issueFinder;
        this.attachmentJsonBeanConverter = attachmentJsonBeanConverter;
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @MultipartConfigClass(value=JiraAttachmentMultipartConfig.class)
    @Operation(summary="Add one or more attachments to an issue", description="Add one or more attachments to an issue.\nThis resource expects a multipart post. The media-type multipart/form-data is defined in RFC 1867. Most client libraries have classes that make dealing with multipart posts simple. For instance, in Java the Apache HTTP Components library provides a MultiPartEntity that makes it simple to submit a multipart POST.\nIn order to protect against XSRF attacks, because this method accepts multipart/form-data, it has XSRF protection\non it. This means you must submit a header of X-Atlassian-Token: no-check with the request, otherwise it will be blocked.\nThe name of the multipart/form-data parameter that contains attachments must be file.\nA simple example to upload a file called \"myfile.txt\" to issue TEST-123:\ncurl -D- -u admin:admin -X POST -H \"X-Atlassian-Token: no-check\" -F \"file=@myfile.txt\" http://myhost/rest/api/2/issue/TEST-123/attachments", security={@SecurityRequirement(name="basic")})
    @Parameter(name="issueIdOrKey", description="Issue id or key", in=ParameterIn.PATH, required=true)
    @RequestBody(description="Attachments to be added", content={@Content(schema=@Schema(type="string", format="binary"), mediaType="multipart/form-data")})
    @ApiResponses(value={@ApiResponse(description="Returns a JSON representation of the attachments added.", responseCode="200", content={@Content(schema=@Schema(implementation=AttachmentJsonBean.class))}), @ApiResponse(description="Returned if attachments is disabled or if you don't have permission to add attachments to this issue.", responseCode="403"), @ApiResponse(description="Returned if the requested issue is not found, the user does not have permission to view it, or if the attachments exceeds the maximum configured attachment size.", responseCode="404")})
    public Response addAttachment(@PathParam(value="issueIdOrKey") String issueIdOrKey, @MultipartFormParam(value="file") Collection<FilePart> fileParts) {
        MutableIssue issue;
        JiraServiceContextImpl context = new JiraServiceContextImpl(this.authContext.getUser());
        if (!this.attachmentService.canCreateAttachments((JiraServiceContext)context, (Issue)(issue = this.issueFinder.getIssueObject(issueIdOrKey)))) {
            throw new RESTException(Response.Status.FORBIDDEN, ErrorCollection.of(this.i18n.getText("attachment.service.error.create.no.permission")));
        }
        try {
            ArrayList<ChangeItemBean> beans = new ArrayList<ChangeItemBean>(fileParts.size());
            for (FilePart filePart : fileParts) {
                ChangeItemBean changeItemBean;
                String filePartName = filePart.getName();
                CreateAttachmentParamsBean createAttachmentParamsBean = new CreateAttachmentParamsBean.Builder(this.getFileFromFilePart(filePart), filePartName, filePart.getContentType(), this.authContext.getLoggedInUser(), (Issue)issue).createdTime((Date)UtilDateTime.nowTimestamp()).build();
                if (filePartName == null) {
                    log.warn("Cannot create attachment without a filename.");
                    changeItemBean = null;
                } else {
                    changeItemBean = this.attachmentManager.createAttachment(createAttachmentParamsBean);
                }
                beans.add(changeItemBean);
            }
            IssueUpdateBean issueUpdateBean = new IssueUpdateBean((Issue)issue, (Issue)issue, EventType.ISSUE_UPDATED_ID, this.authContext.getUser());
            issueUpdateBean.setDispatchEvent(true);
            issueUpdateBean.setChangeItems(beans);
            this.issueUpdater.doUpdate(issueUpdateBean, true);
            ArrayList<Attachment> attachments = new ArrayList<Attachment>(beans.size());
            for (ChangeItemBean changeItemBean : beans) {
                Attachment attachment;
                String idStringValue = changeItemBean.getTo();
                if (idStringValue == null || (attachment = this.attachmentManager.getAttachment(Long.valueOf(idStringValue))) == null) continue;
                attachments.add(attachment);
            }
            Collection jsonBeans = this.attachmentJsonBeanConverter.shortBeans(attachments);
            return Response.ok((Object)jsonBeans).cacheControl(CacheControl.never()).build();
        }
        catch (Exception e) {
            log.error("Error saving attachment", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    private File getFileFromFilePart(FilePart filePart) throws IOException {
        File file = File.createTempFile("attachment-", ".tmp");
        file.deleteOnExit();
        filePart.write(file);
        return file;
    }

    private static Integer getMaxAttachmentSize() {
        Integer maxSize;
        try {
            String maxSizeStr = Configuration.getString((String)"webwork.multipart.maxSize");
            if (maxSizeStr != null) {
                try {
                    maxSize = Integer.parseInt(maxSizeStr);
                }
                catch (NumberFormatException e) {
                    maxSize = Integer.MAX_VALUE;
                    log.warn("Property 'webwork.multipart.maxSize' with value '" + maxSizeStr + "' is not a number. Defaulting to Integer.MAX_VALUE");
                }
            } else {
                maxSize = Integer.MAX_VALUE;
                log.warn("Property 'webwork.multipart.maxSize' is not set. Defaulting to Integer.MAX_VALUE");
            }
        }
        catch (IllegalArgumentException e1) {
            maxSize = Integer.MAX_VALUE;
            log.warn("Failed getting string from Configuration for 'webwork.multipart.maxSize' property. Defaulting to Integer.MAX_VALUE", (Throwable)e1);
        }
        return maxSize;
    }

    public static class JiraAttachmentMultipartConfig
    implements MultipartConfig {
        public long getMaxFileSize() {
            return IssueAttachmentsResource.getMaxAttachmentSize().intValue();
        }

        public long getMaxSize() {
            return IssueAttachmentsResource.getMaxAttachmentSize() * 10;
        }
    }
}

