/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.ImmutableGroup;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.embedded.InvalidGroupException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.group.GroupService;
import com.atlassian.jira.issue.fields.rest.json.UserBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.pagination.PageBean;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.BadRequestWebException;
import com.atlassian.jira.rest.exception.ForbiddenWebException;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.exception.ServerErrorWebException;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.util.SelfLinkBuilder;
import com.atlassian.jira.rest.v2.issue.AddGroupBean;
import com.atlassian.jira.rest.v2.issue.GroupBean;
import com.atlassian.jira.rest.v2.issue.GroupBeanBuilder;
import com.atlassian.jira.rest.v2.issue.UpdateUserToGroupBean;
import com.atlassian.jira.rest.v2.issue.UserJsonBeanListWrapper;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import com.atlassian.jira.util.PageRequests;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.MoreObjects;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Path(value="group")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@LicensedOnly
public class GroupResource {
    static final int MAX_USERS_COUNT = 50;
    private final GlobalPermissionManager permissionManager;
    private final JiraAuthenticationContext authContext;
    private final I18nHelper i18n;
    private final GroupManager groupManager;
    private final GroupService groupService;
    private final JiraBaseUrls jiraBaseUrls;
    private final SelfLinkBuilder.SelfLink groupSelfLink;
    private final CrowdService crowdService;
    private final UserBeanFactory userBeanFactory;
    private final ResponseFactory responses;

    @Inject
    public GroupResource(GlobalPermissionManager permissionManager, JiraAuthenticationContext authContext, I18nHelper i18n, GroupManager groupManager, GroupService groupService, JiraBaseUrls jiraBaseUrls, SelfLinkBuilder selfLinkBuilder, CrowdService crowdService, UserBeanFactory userBeanFactory, ResponseFactory responses) {
        this.permissionManager = permissionManager;
        this.authContext = authContext;
        this.i18n = i18n;
        this.groupManager = groupManager;
        this.groupService = groupService;
        this.jiraBaseUrls = jiraBaseUrls;
        this.crowdService = crowdService;
        this.userBeanFactory = userBeanFactory;
        this.responses = responses;
        this.groupSelfLink = selfLinkBuilder.path("group");
    }

    private boolean hasGroupManagementPermission(ApplicationUser remoteUser) {
        return this.permissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, remoteUser) || this.permissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, remoteUser);
    }

    @Path(value="member")
    @GET
    @Operation(summary="Get users from a specified group", description="Returns a paginated list of users who are members of the specified group and its subgroups", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="groupname", description="The group name.", in=ParameterIn.PATH, required=true), @Parameter(name="includeInactiveUsers", description="Include inactive users.", in=ParameterIn.QUERY, required=false), @Parameter(name="startAt", description="The index of the first user in group to return.", in=ParameterIn.QUERY, required=false), @Parameter(name="maxResults", description="The maximum number of users to return.", in=ParameterIn.QUERY, required=false)})
    @ApiResponses(value={@ApiResponse(description="Returns a paginated list of users in the group", responseCode="200", content={@Content(schema=@Schema(implementation=UserJsonBean.class))}), @ApiResponse(description="Returned if the name of the provided group is empty", responseCode="400"), @ApiResponse(description="Returned if the user is not logged in.", responseCode="401"), @ApiResponse(description="Returned if the calling user is not admin or sysadmin", responseCode="403"), @ApiResponse(description="Returned if the specified group does not exist", responseCode="404")})
    public Response getUsersFromGroup(@QueryParam(value="groupname") String groupName, @QueryParam(value="includeInactiveUsers") @DefaultValue(value="false") boolean includeInactiveUsers, @QueryParam(value="startAt") @DefaultValue(value="0") Long startAt, @QueryParam(value="maxResults") @DefaultValue(value="50") Integer maxResults) {
        this.ensureCanManageGroups();
        Group group = this.ensureGroupExists(groupName);
        Integer limit = (Integer)MoreObjects.firstNonNull((Object)maxResults, (Object)50);
        PageRequest pageRequest = PageRequests.request((Long)startAt, (Integer)Math.min(limit, 50));
        Page usersInGroup = this.groupManager.getUsersInGroup(group.getName(), Boolean.valueOf(includeInactiveUsers), pageRequest);
        return this.responses.okNoCache(PageBean.from(pageRequest, usersInGroup).setLinks(this.buildSelfForPagedUsers(groupName, includeInactiveUsers, startAt, maxResults), pageRequest.getLimit()).build(user -> this.userBeanFactory.createBean(user, this.authContext.getLoggedInUser())));
    }

    private String buildSelfForPagedUsers(String groupName, Boolean includeInactiveUsers, Long startAt, Integer maxResults) {
        SelfLinkBuilder.SelfLink selfLink = this.groupSelfLink.path("member", new String[0]).queryParam("groupname", groupName).queryParam("includeInactiveUsers", includeInactiveUsers.toString()).queryParam("startAt", startAt.toString()).queryParam("maxResults", maxResults.toString());
        return selfLink.toString();
    }

    @POST
    @WebSudoRequired
    @Operation(summary="Create a group with given parameters", description="Creates a group by given group parameter", security={@SecurityRequirement(name="basic")})
    @Parameter(name="groupBean", description="A group to add", required=true)
    @ApiResponses(value={@ApiResponse(description="Returns full representation of a Jira group in JSON format.", responseCode="201", content={@Content(schema=@Schema(implementation=GroupBean.class))}), @ApiResponse(description="Returned if user requested an empty group name or group already exists", responseCode="400"), @ApiResponse(description="Returned if the current user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the current user does not have administrator permissions.", responseCode="403")})
    public Response createGroup(AddGroupBean groupBean) {
        String groupName = groupBean.getName();
        return this.doGroupUpdate(() -> {
            this.validateGroupName(groupName);
            if (this.crowdService.getGroup(groupName) != null) {
                throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("groupbrowser.error.group.exists")));
            }
            ImmutableGroup immutableGroup = new ImmutableGroup(groupName);
            this.crowdService.addGroup((Group)immutableGroup);
            GroupBean responseGroupBean = this.buildGroupBean((Group)immutableGroup);
            return Response.status((Response.Status)Response.Status.CREATED).location(responseGroupBean.getSelf()).entity((Object)responseGroupBean).cacheControl(CacheControl.never()).build();
        });
    }

    @DELETE
    @WebSudoRequired
    @Operation(summary="Delete a specified group", description="Deletes a group by given group parameter", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="groupname", description="The name of the group to delete.", in=ParameterIn.QUERY, required=true), @Parameter(name="swapGroup", description="A different group to transfer the restrictions to.", in=ParameterIn.QUERY, required=false)})
    @ApiResponses(value={@ApiResponse(description="Returned if the group was deleted.", responseCode="200"), @ApiResponse(description="Returned if user requested a group that does not exist", responseCode="400"), @ApiResponse(description="Returned if the current user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the current user does not have administrator permissions.", responseCode="403"), @ApiResponse(description="Returned if the requested group was not found.", responseCode="404")})
    public Response removeGroup(@QueryParam(value="groupname") String groupName, @QueryParam(value="swapGroup") String swapGroup) {
        return this.doGroupUpdate(() -> {
            this.ensureGroupExists(groupName);
            JiraServiceContextImpl validateContext = new JiraServiceContextImpl(this.authContext.getLoggedInUser());
            if (!this.groupService.validateDelete((JiraServiceContext)validateContext, groupName, swapGroup)) {
                return this.responses.errorResponse(validateContext.getErrorCollection());
            }
            JiraServiceContextImpl deleteContext = new JiraServiceContextImpl(this.authContext.getLoggedInUser());
            if (!this.groupService.delete((JiraServiceContext)deleteContext, groupName, swapGroup)) {
                return this.responses.errorResponse(deleteContext.getErrorCollection());
            }
            return Response.ok().cacheControl(CacheControl.never()).build();
        });
    }

    @POST
    @WebSudoRequired
    @Path(value="user")
    @Operation(summary="Add a user to a specified group", description="Adds given user to a group", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="groupname", description="A name of requested group.", in=ParameterIn.QUERY, required=true), @Parameter(name="userBean", description="User to add to a group", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returns full representation of a Jira group in JSON format.", responseCode="201", content={@Content(schema=@Schema(implementation=GroupBean.class))}), @ApiResponse(description="Returned if user requested an empty group name or the user already belongs to the group.", responseCode="400"), @ApiResponse(description="Returned if the current user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the current user does not have administrator permissions.", responseCode="403"), @ApiResponse(description="Returned if the requested group was not found or requested user was not found.", responseCode="404")})
    public Response addUserToGroup(@QueryParam(value="groupname") String groupName, UpdateUserToGroupBean userBean) {
        return this.doGroupUpdate(() -> {
            this.ensureGroupExists(groupName);
            String username = userBean.getName();
            JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(this.authContext.getLoggedInUser());
            if (!this.groupService.validateAddUserToGroup((JiraServiceContext)serviceContext, (Collection)ImmutableList.of((Object)groupName), username)) {
                return this.responses.errorResponse(serviceContext.getErrorCollection());
            }
            User crowdUser = this.getUser(username);
            ImmutableGroup immutableGroup = new ImmutableGroup(groupName);
            ImmutableUser immutableUser = ImmutableUser.newUser((User)crowdUser).toUser();
            if (this.crowdService.addUserToGroup((User)immutableUser, (Group)immutableGroup)) {
                GroupBean responseGroupBean = this.buildGroupBean((Group)immutableGroup);
                return Response.status((Response.Status)Response.Status.CREATED).location(responseGroupBean.getSelf()).entity((Object)responseGroupBean).cacheControl(CacheControl.never()).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of(this.i18n.getText("rest.group.user.already.exists.in.group", username, groupName))).cacheControl(CacheControl.never()).build();
        });
    }

    @WebSudoRequired
    @DELETE
    @Path(value="user")
    @Operation(summary="Remove a user from a specified group", description="Removes given user from a group", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="groupname", description="A name of requested group.", in=ParameterIn.QUERY, required=true), @Parameter(name="username", description="User to remove from a group", in=ParameterIn.QUERY, required=true)})
    @ApiResponses(value={@ApiResponse(description="If the user was removed from the group.", responseCode="200"), @ApiResponse(description="Returned if user requested an empty group name", responseCode="400"), @ApiResponse(description="Returned if the current user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the current user does not have administrator permissions.", responseCode="403"), @ApiResponse(description="Returned if the requested group was not found or the requested user wan not found", responseCode="404")})
    public Response removeUserFromGroup(@QueryParam(value="groupname") String groupName, @QueryParam(value="username") String username) {
        return this.doGroupUpdate(() -> {
            this.ensureGroupExists(groupName);
            User crowdUser = this.getUser(username);
            JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(this.authContext.getLoggedInUser());
            if (!this.groupService.validateRemoveUserFromGroups((JiraServiceContext)serviceContext, (List)ImmutableList.of((Object)groupName), username)) {
                return this.responses.errorResponse(serviceContext.getErrorCollection());
            }
            ImmutableGroup immutableGroup = new ImmutableGroup(groupName);
            ImmutableUser immutableUser = ImmutableUser.newUser((User)crowdUser).toUser();
            this.crowdService.removeUserFromGroup((User)immutableUser, (Group)immutableGroup);
            return Response.ok().cacheControl(CacheControl.never()).build();
        });
    }

    private Response doGroupUpdate(GroupUpdateCommand command) {
        this.ensureCanManageGroups();
        try {
            return command.execute();
        }
        catch (OperationNotPermittedException e) {
            throw new ForbiddenWebException(ErrorCollection.of(this.i18n.getText("generic.error", e.getLocalizedMessage())));
        }
        catch (InvalidGroupException e) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("generic.error", e.getLocalizedMessage())));
        }
        catch (OperationFailedException e) {
            throw new ServerErrorWebException(ErrorCollection.of(this.i18n.getText("generic.error", e.getLocalizedMessage())));
        }
    }

    private Group ensureGroupExists(String groupName) {
        this.validateGroupName(groupName);
        Group group = this.groupManager.getGroup(groupName.trim());
        if (group == null) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.group.error.not.found", groupName)));
        }
        return group;
    }

    private User getUser(String username) {
        User crowdUser = null;
        if (username != null && (crowdUser = this.crowdService.getUser(username)) == null) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("admin.errors.user.does.not.exist", username)));
        }
        return crowdUser;
    }

    private void ensureCanManageGroups() {
        ApplicationUser remoteUser = this.authContext.getLoggedInUser();
        if (!this.hasGroupManagementPermission(remoteUser)) {
            throw new ForbiddenWebException(ErrorCollection.of(this.i18n.getText("rest.authorization.admin.required")));
        }
    }

    private void validateGroupName(String groupName) {
        if (StringUtils.isEmpty((CharSequence)groupName)) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("rest.group.error.empty")));
        }
    }

    private GroupBean buildGroupBean(Group group) {
        Supplier userSupplier = () -> ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)this.groupManager.getUsersInGroup(group), user -> user != null && user.isActive()));
        int activeUserCount = this.groupManager.getUsersInGroupCount(group);
        UserJsonBeanListWrapper userJsonBeanListWrapper = new UserJsonBeanListWrapper(activeUserCount, (Supplier<List<ApplicationUser>>)userSupplier, 50, this.authContext.getLoggedInUser(), this.userBeanFactory);
        return new GroupBeanBuilder(this.jiraBaseUrls, group.getName()).users(userJsonBeanListWrapper).build();
    }

    static interface GroupUpdateCommand {
        public Response execute() throws OperationNotPermittedException, InvalidGroupException;
    }
}

