/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.v2.issue.GroupSuggestionsBean;
import com.atlassian.jira.rest.v2.issue.groups.GroupPickerResourceHelper;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="groups")
@AnonymousSiteAccess
@Produces(value={"application/json"})
public class GroupPickerResource {
    private GroupPickerResourceHelper groupPickerHelper;

    private GroupPickerResource() {
    }

    @Inject
    public GroupPickerResource(GroupPickerResourceHelper groupPickerHelper) {
        this.groupPickerHelper = groupPickerHelper;
    }

    @Path(value="/picker")
    @GET
    @Operation(summary="Get groups matching a query", description="Returns groups with substrings matching a given query", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="query", description="A String to match groups against", in=ParameterIn.QUERY), @Parameter(name="exclude", description="List of groups to exclude", in=ParameterIn.QUERY), @Parameter(name="maxResults", description="Maximum number of results to return", in=ParameterIn.QUERY), @Parameter(name="userName", description="Username for the context", in=ParameterIn.QUERY)})
    @ApiResponse(description="Returns a collection of matching groups", responseCode="200", content={@Content(schema=@Schema(implementation=GroupSuggestionsBean.class))})
    public Response findGroups(@QueryParam(value="query") String query, @QueryParam(value="exclude") List<String> excludeGroups, @QueryParam(value="maxResults") Integer maxResults, @QueryParam(value="userName") String userName) {
        GroupSuggestionsBean suggestions = this.groupPickerHelper.findGroupsAsBean(query, excludeGroups, maxResults, userName);
        return Response.ok((Object)suggestions).cacheControl(CacheControl.never()).build();
    }
}

