/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.SearchContextImpl;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.v2.issue.GroupSuggestionsBean;
import com.atlassian.jira.rest.v2.issue.UserPickerResultsBean;
import com.atlassian.jira.rest.v2.issue.UsersAndGroupsBean;
import com.atlassian.jira.rest.v2.issue.groups.GroupPickerResourceHelper;
import com.atlassian.jira.rest.v2.issue.users.UserPickerResourceHelper;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserFilter;
import com.atlassian.jira.user.UserFilterManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

@Path(value="groupuserpicker")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AnonymousSiteAccess
public class GroupAndUserPickerResource {
    private final JiraAuthenticationContext authContext;
    private final ConstantsManager constantsManager;
    private final CustomFieldManager customFieldManager;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private final GroupPickerResourceHelper groupPickerHelper;
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;
    private final UserFilterManager userFilterManager;
    private final UserPickerResourceHelper userPickerHelper;
    private final GlobalPermissionManager globalPermissionManager;
    private final I18nHelper i18n;

    @Inject
    public GroupAndUserPickerResource(JiraAuthenticationContext authContext, ConstantsManager constantsManager, CustomFieldManager customFieldManager, FieldConfigSchemeManager fieldConfigSchemeManager, GroupPickerResourceHelper groupPickerHelper, PermissionManager permissionManager, ProjectManager projectManager, UserFilterManager userFilterManager, UserPickerResourceHelper userPickerHelper, GlobalPermissionManager globalPermissionManager, I18nHelper i18n) {
        this.authContext = authContext;
        this.constantsManager = constantsManager;
        this.customFieldManager = customFieldManager;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
        this.groupPickerHelper = groupPickerHelper;
        this.permissionManager = permissionManager;
        this.projectManager = projectManager;
        this.userFilterManager = userFilterManager;
        this.userPickerHelper = userPickerHelper;
        this.globalPermissionManager = globalPermissionManager;
        this.i18n = i18n;
    }

    @GET
    @Operation(summary="Get users and groups matching query with highlighting", description="Returns a list of users and groups matching query with highlighting", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="query", description="A string used to search username, Name or e-mail address", in=ParameterIn.QUERY), @Parameter(name="maxResults", description="The maximum number of users to return", in=ParameterIn.QUERY), @Parameter(name="showAvatar", description="Show avatar", in=ParameterIn.QUERY), @Parameter(name="fieldId", description="The custom field id", in=ParameterIn.QUERY), @Parameter(name="projectId", description="The list of project ids to further restrict the search", in=ParameterIn.QUERY), @Parameter(name="issueTypeId", description="The list of issue type ids to further restrict the search", in=ParameterIn.QUERY)})
    @ApiResponses(value={@ApiResponse(description="Returns a list of users and groups matching query with highlighting", responseCode="200", content={@Content(schema=@Schema(implementation=UsersAndGroupsBean.class))}), @ApiResponse(description="Returned if the user does not have permission to view users and groups", responseCode="403")})
    public Response findUsersAndGroups(@QueryParam(value="query") String query, @QueryParam(value="maxResults") Integer maxResults, @QueryParam(value="showAvatar") Boolean showAvatar, @QueryParam(value="fieldId") String fieldId, @QueryParam(value="projectId") List<String> projectId, @QueryParam(value="issueTypeId") List<String> issueTypeId) {
        ApplicationUser user = this.authContext.getLoggedInUser();
        if (user != null || this.globalPermissionManager.hasPermission(GlobalPermissionKey.USER_PICKER, user)) {
            List<Long> projectIdList;
            SearchContextImpl searchContext;
            UserSearchParams.Builder paramBuilder = UserSearchParams.builder().allowEmptyQuery(false).includeActive(true).includeInactive(false);
            boolean returnEmptyUsers = false;
            if (StringUtils.isNotBlank((CharSequence)fieldId) && !this.updateParamWithUserFilter(paramBuilder, fieldId, (SearchContext)(searchContext = new SearchContextImpl(null, projectIdList = this.getProjectIdList(projectId), this.getIssueTypeIdList(issueTypeId))))) {
                returnEmptyUsers = true;
            }
            UserSearchParams searchParams = paramBuilder.build();
            UserPickerResultsBean userResultsBean = this.userPickerHelper.findUsersAsBean(returnEmptyUsers ? "" : query, maxResults, showAvatar, null, searchParams);
            GroupSuggestionsBean groupsAsBean = this.groupPickerHelper.findGroupsAsBean(query, null, maxResults, null);
            return Response.ok((Object)new UsersAndGroupsBean(userResultsBean, groupsAsBean)).cacheControl(CacheControl.never()).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.i18n.getText("rest.authentication.no.user.logged.in")).build();
    }

    private boolean updateParamWithUserFilter(UserSearchParams.Builder paramBuilder, String fieldId, SearchContext searchContext) {
        UserFilter userFilter;
        FieldConfig fieldConfig;
        CustomField customField = this.customFieldManager.getCustomFieldObject(fieldId);
        if (customField != null && (fieldConfig = customField.getReleventConfig(searchContext)) != null && (userFilter = this.userFilterManager.getFilter(fieldConfig)) != null) {
            paramBuilder.filter(userFilter);
            if (CollectionUtils.isNotEmpty((Collection)userFilter.getRoleIds())) {
                Collection<Long> projectIds = this.getProjectIdsFromFieldConfig(searchContext.getProjectIds(), fieldConfig);
                Iterable<Project> projectObjects = this.getProjectObjects(projectIds);
                Iterable browsableProjects = Iterables.filter(projectObjects, project -> project != null && this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, this.authContext.getUser()));
                paramBuilder.filterByProjectIds((Collection)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)browsableProjects, Project::getId)));
            }
            return true;
        }
        return false;
    }

    private Collection<Long> getProjectIdsFromFieldConfig(Collection<Long> existingProjectIds, FieldConfig fieldConfig) {
        if (CollectionUtils.isNotEmpty(existingProjectIds)) {
            return existingProjectIds;
        }
        return CustomFieldUtils.getProjectIdsFromProjectOrFieldConfig(null, (FieldConfig)fieldConfig, (FieldConfigSchemeManager)this.fieldConfigSchemeManager, (ProjectManager)this.projectManager);
    }

    private Iterable<Project> getProjectObjects(Collection<Long> projectIds) {
        if (CollectionUtils.isEmpty(projectIds)) {
            return List.of();
        }
        if (projectIds.size() == 1) {
            Project project = this.projectManager.getProjectObj(projectIds.iterator().next());
            return project == null ? List.of() : List.of(project);
        }
        List projects = this.projectManager.getProjectObjects();
        return Iterables.filter((Iterable)projects, input -> input != null && projectIds.contains(input.getId()));
    }

    private List<Long> getProjectIdList(List<String> projectIdList) {
        HashSet projectIds = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(projectIdList)) {
            for (String projectIdStr : projectIdList) {
                long projectId = NumberUtils.toLong((String)projectIdStr, (long)-1L);
                if (projectId <= 0L) continue;
                projectIds.add(projectId);
            }
        }
        return ImmutableList.copyOf((Collection)projectIds);
    }

    private List<String> getIssueTypeIdList(List<String> issueTypeIdList) {
        HashSet issueTypeIdSet = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(issueTypeIdList)) {
            for (String issueTypeIdStr : issueTypeIdList) {
                if (NumberUtils.toLong((String)issueTypeIdStr, (long)-1L) <= 0L) continue;
                issueTypeIdSet.addAll(this.constantsManager.expandIssueTypeIds(List.of(issueTypeIdStr)));
            }
        }
        return ImmutableList.copyOf((Collection)issueTypeIdSet);
    }
}

