/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.customfield.CreateValidationResult;
import com.atlassian.jira.bc.customfield.CustomFieldDefinition;
import com.atlassian.jira.bc.customfield.CustomFieldService;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.customfield.CustomFieldDefinitionJsonBean;
import com.atlassian.jira.rest.api.field.FieldBean;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.AccessDisablingHelper;
import com.atlassian.jira.util.AccessDisablingHelperConfig;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="field")
@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class FieldResource {
    private final FieldManager fieldManager;
    private final JiraAuthenticationContext authenticationContext;
    private final CustomFieldService customFieldService;
    private final SearchHandlerManager searchHandlerManager;
    private final AccessDisablingHelper accessDisablingHelper;
    private final PermissionManager permissionManager;

    @Inject
    public FieldResource(FieldManager fieldManager, JiraAuthenticationContext authenticationContext, CustomFieldService customFieldService, SearchHandlerManager searchHandlerManager, AccessDisablingHelper accessDisablingHelper, PermissionManager permissionManager) {
        this.fieldManager = fieldManager;
        this.authenticationContext = authenticationContext;
        this.customFieldService = customFieldService;
        this.searchHandlerManager = searchHandlerManager;
        this.accessDisablingHelper = accessDisablingHelper;
        this.permissionManager = permissionManager;
    }

    @GET
    @Operation(summary="Get all fields, both System and Custom", description="Returns a list of all fields, both System and Custom", security={@SecurityRequirement(name="basic")})
    @ApiResponses(value={@ApiResponse(description="Returns a list of all fields", responseCode="200", content={@Content(schema=@Schema(implementation=FieldBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if user is not logged-in and don't have access to any project", responseCode="401")})
    public Response getFields() {
        if (!this.accessDisablingHelper.canBeAccessedByCurrentUser(AccessDisablingHelperConfig.builder().blockAnyoneNotFulfillingCondition(user -> user != null || this.permissionManager.hasProjects(ProjectPermissions.BROWSE_PROJECTS, null)).build())) {
            throw new NotAuthorisedWebException();
        }
        HashSet<Field> fields = new HashSet<Field>();
        Set orderableFields = this.fieldManager.getOrderableFields();
        for (OrderableField orderableField : orderableFields) {
            if (orderableField instanceof NavigableField) continue;
            fields.add((Field)orderableField);
        }
        try {
            fields.addAll(this.fieldManager.getAvailableNavigableFields(this.authenticationContext.getUser()));
        }
        catch (FieldException e) {
            throw new RESTException(Response.Status.INTERNAL_SERVER_ERROR, e.getLocalizedMessage());
        }
        return Response.ok(FieldBean.shortBeans(fields, this.fieldManager, this.searchHandlerManager)).build();
    }

    @POST
    @Operation(summary="Create a custom field using a definition", description="Creates a custom field using a definition", security={@SecurityRequirement(name="basic")})
    @Parameter(name="customFieldDefinitionJsonBean", description="Definition of custom field to create", required=true, content={@Content(schema=@Schema(implementation=CustomFieldDefinitionJsonBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Custom field was created", responseCode="201", content={@Content(schema=@Schema(implementation=FieldBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the input is invalid", responseCode="400"), @ApiResponse(description="Returned if exception occured during custom field creation", responseCode="500")})
    public Response createCustomField(CustomFieldDefinitionJsonBean customFieldDefinitionJsonBean) {
        CustomFieldDefinition.Builder customFieldDefinitionBuilder = CustomFieldDefinition.builder().name(customFieldDefinitionJsonBean.name()).description(customFieldDefinitionJsonBean.description()).cfType(customFieldDefinitionJsonBean.type()).searcherKey(customFieldDefinitionJsonBean.searcherKey()).isGlobal(customFieldDefinitionJsonBean.projectIds() == null || customFieldDefinitionJsonBean.projectIds().isEmpty()).isAllIssueTypes(customFieldDefinitionJsonBean.issueTypeIds() == null || customFieldDefinitionJsonBean.issueTypeIds().isEmpty());
        if (customFieldDefinitionJsonBean.projectIds() != null) {
            customFieldDefinitionBuilder.addProjectIds(customFieldDefinitionJsonBean.projectIds().toArray(new Long[0]));
        }
        if (customFieldDefinitionJsonBean.issueTypeIds() != null) {
            customFieldDefinitionBuilder.addIssueTypeIds(customFieldDefinitionJsonBean.issueTypeIds().toArray(new String[0]));
        }
        CustomFieldDefinition customFieldDefinition = customFieldDefinitionBuilder.build();
        ServiceOutcome outcome = this.customFieldService.validateCreate(this.authenticationContext.getUser(), customFieldDefinition);
        if (!outcome.isValid()) {
            throw new RESTException(Response.Status.BAD_REQUEST, ErrorCollection.of(outcome.getErrorCollection()));
        }
        ServiceOutcome serviceOutcome = this.customFieldService.create((CreateValidationResult)outcome.getReturnedValue());
        Field field = this.fieldManager.getField(((CustomField)serviceOutcome.getReturnedValue()).getId());
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)FieldBean.shortBean(field, this.fieldManager, this.searchHandlerManager)).build();
    }
}

