/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.rest.api.issue.JsonTypeBean;
import com.atlassian.jira.rest.serializer.DefaultValueSerializer;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FieldMetaBean {
    @JsonProperty
    @Schema(example="true")
    private boolean required;
    @JsonProperty
    private JsonTypeBean schema;
    @JsonProperty
    @Schema(example="My Multi Select")
    private String name;
    @JsonProperty
    @Schema(example="customfield_10000")
    private String fieldId;
    @JsonProperty
    @Schema(example="/rest/api/2/customFieldOption/10000")
    private String autoCompleteUrl;
    @JsonProperty
    @Schema(example="true")
    private Boolean hasDefaultValue;
    @JsonProperty
    @Schema(example="[\"set\", \"add\"]")
    private Collection<String> operations;
    @JsonProperty
    @Schema(example="[\"red\", \"blue\", \"default value\"]")
    private Collection<?> allowedValues;
    @JsonProperty
    @JsonSerialize(using=DefaultValueSerializer.class, include=JsonSerialize.Inclusion.NON_NULL)
    private Object defaultValue;

    FieldMetaBean() {
    }

    public FieldMetaBean(boolean required, Boolean hasDefaultValue, JsonType schema, String name, String fieldId, String autoCompleteUrl, Collection<String> operations, Collection<?> allowedValues, Object defaultValue) {
        this.required = required;
        this.hasDefaultValue = hasDefaultValue;
        this.schema = schema == null ? null : new JsonTypeBean(schema);
        this.name = name;
        this.fieldId = fieldId;
        this.autoCompleteUrl = autoCompleteUrl;
        this.operations = operations;
        this.allowedValues = allowedValues;
        this.defaultValue = defaultValue;
    }

    public boolean isRequired() {
        return this.required;
    }

    public JsonTypeBean getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public String getAutoCompleteUrl() {
        return this.autoCompleteUrl;
    }

    public Boolean getHasDefaultValue() {
        return this.hasDefaultValue;
    }

    public Collection<String> getOperations() {
        return this.operations;
    }

    public Collection<?> getAllowedValues() {
        return this.allowedValues;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }
}

