/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.security.login.LoginReason;
import com.atlassian.jira.bc.security.login.LoginResult;
import com.atlassian.jira.bc.security.login.LoginService;
import com.atlassian.jira.event.user.UserProfileUpdatedEvent;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.plugin.user.PasswordPolicyManager;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.BadRequestWebException;
import com.atlassian.jira.rest.exception.ForbiddenWebException;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.exception.ServerErrorWebException;
import com.atlassian.jira.rest.v2.admin.applicationrole.ApplicationRoleBeanConverter;
import com.atlassian.jira.rest.v2.issue.PasswordBean;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.jira.rest.v2.issue.UserBeanBuilder;
import com.atlassian.jira.rest.v2.issue.UserWriteBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.DelegatingApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugins.rest.api.security.annotation.UnlicensedSiteAccess;
import com.google.common.collect.ImmutableList;
import com.opensymphony.util.TextUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="myself")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ExperimentalApi
@LicensedOnly
public class CurrentUserResource {
    private static final int MAX_LENGTH = 255;
    private final Logger log = LoggerFactory.getLogger(CurrentUserResource.class);
    private final UserUtil userUtil;
    private final UserManager userManager;
    private final PasswordPolicyManager passwordPolicyManager;
    private final EventPublisher eventPublisher;
    private final I18nHelper i18n;
    private final EmailFormatter emailFormatter;
    private final JiraAuthenticationContext authContext;
    private final TimeZoneManager timeZoneManager;
    private final AvatarService avatarService;
    private final JiraBaseUrls jiraBaseUrls;
    private final LoginService loginService;
    private final I18nHelper.BeanFactory beanFactory;
    private final ApplicationRoleManager applicationRoleManager;
    private final ApplicationRoleBeanConverter applicationRoleBeanConverter;

    @Inject
    public CurrentUserResource(UserUtil userUtil, UserManager userManager, PasswordPolicyManager passwordPolicyManager, EventPublisher eventPublisher, I18nHelper i18n, EmailFormatter emailFormatter, JiraAuthenticationContext authContext, TimeZoneManager timeZoneManager, AvatarService avatarService, JiraBaseUrls jiraBaseUrls, LoginService loginService, I18nHelper.BeanFactory beanFactory, ApplicationRoleBeanConverter applicationRoleBeanConverter, ApplicationRoleManager applicationRoleManager) {
        this.userManager = userManager;
        this.passwordPolicyManager = passwordPolicyManager;
        this.eventPublisher = eventPublisher;
        this.jiraBaseUrls = jiraBaseUrls;
        this.userUtil = userUtil;
        this.i18n = i18n;
        this.emailFormatter = emailFormatter;
        this.authContext = authContext;
        this.timeZoneManager = timeZoneManager;
        this.avatarService = avatarService;
        this.beanFactory = beanFactory;
        this.loginService = loginService;
        this.applicationRoleManager = applicationRoleManager;
        this.applicationRoleBeanConverter = applicationRoleBeanConverter;
    }

    @UnlicensedSiteAccess
    @GET
    @Operation(summary="Get currently logged user", description="Returns currently logged user. This resource cannot be accessed anonymously", security={@SecurityRequirement(name="basic")})
    @ApiResponses(value={@ApiResponse(description="Returns a full representation of a Jira user in JSON format.", responseCode="200", content={@Content(schema=@Schema(implementation=UserBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the current user is not authenticated.", responseCode="401")})
    public Response getUser() {
        ApplicationUser currentUser = this.authContext.getUser();
        if (currentUser == null) {
            throw new NotAuthorisedWebException(ErrorCollection.of(this.i18n.getText("rest.authentication.no.user.logged.in")));
        }
        return this.createUserResponse(currentUser);
    }

    @PUT
    @UnlicensedSiteAccess
    @Operation(summary="Update currently logged user", description="Modify currently logged user. The 'value' fields present will override the existing value. Fields skipped in request will not be changed. Only email and display name can be change that way. Requires user password.", security={@SecurityRequirement(name="basic")})
    @RequestBody(description="The new user details to be set.", required=true, content={@Content(schema=@Schema(implementation=UserWriteBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Confirmation that the user was updated.", responseCode="200", content={@Content(schema=@Schema(implementation=UserWriteBean.class), mediaType="application/json")}), @ApiResponse(description="The request is invalid including incorrect password.", responseCode="400"), @ApiResponse(description="The user is not authenticated.", responseCode="401"), @ApiResponse(description="The directory is read-only.", responseCode="403"), @ApiResponse(description="The user could not be found.", responseCode="404")})
    public Response updateUser(UserWriteBean userBean) {
        ApplicationUser currentUser = this.authContext.getUser();
        if (currentUser == null) {
            throw new NotAuthorisedWebException(ErrorCollection.of(this.i18n.getText("rest.authentication.no.user.logged.in")));
        }
        String password = userBean.getPassword();
        if (StringUtils.isBlank((CharSequence)password)) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("rest.myself.error.password.cannot.be.empty")));
        }
        if (StringUtils.isBlank((CharSequence)userBean.getEmailAddress()) && StringUtils.isBlank((CharSequence)userBean.getDisplayName())) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("rest.myself.error.no.value.found.to.be.changed")));
        }
        if (StringUtils.length((CharSequence)userBean.getDisplayName()) > 255) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("rest.myself.error.field.too.long", "displayName", Integer.toString(255))));
        }
        if (StringUtils.length((CharSequence)userBean.getEmailAddress()) > 255) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("rest.myself.error.field.too.long", "emailAddress", Integer.toString(255))));
        }
        if (StringUtils.isNotBlank((CharSequence)userBean.getEmailAddress()) && !TextUtils.verifyEmail((String)userBean.getEmailAddress())) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("admin.errors.invalid.email")));
        }
        if (!this.userManager.canUpdateUser(currentUser)) {
            throw new ForbiddenWebException(ErrorCollection.of(this.i18n.getText("admin.errors.cannot.edit.user.directory.read.only")));
        }
        this.checkAuthentication(currentUser, password);
        ImmutableUser.Builder userBuilder = ImmutableUser.newUser((User)currentUser.getDirectoryUser());
        userBuilder.emailAddress((String)StringUtils.defaultIfBlank((CharSequence)userBean.getEmailAddress(), (CharSequence)currentUser.getEmailAddress()));
        userBuilder.displayName((String)StringUtils.defaultIfBlank((CharSequence)userBean.getDisplayName(), (CharSequence)currentUser.getDisplayName()));
        this.userManager.updateUser((ApplicationUser)new DelegatingApplicationUser(currentUser.getId(), currentUser.getKey(), (User)userBuilder.toUser()));
        String key = currentUser.getKey();
        ApplicationUser changedUser = this.userManager.getUserByKey(key);
        if (changedUser == null) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.user.error.not.found.with.key", key)));
        }
        this.eventPublisher.publish((Object)new UserProfileUpdatedEvent(changedUser, changedUser));
        return this.createUserResponse(changedUser);
    }

    private void checkAuthentication(ApplicationUser user, String password) {
        switch (this.getLoginResultReason(user, password)) {
            case OK: {
                break;
            }
            case AUTHENTICATION_DENIED: {
                throw new NotAuthorisedWebException(ErrorCollection.of(this.i18n.getText("changepassword.elevated.authorisation.required")));
            }
            case AUTHORISATION_FAILED: 
            case AUTHENTICATED_FAILED: {
                throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("changepassword.could.not.find.user")));
            }
        }
    }

    private LoginReason getLoginResultReason(ApplicationUser user, String password) {
        LoginResult loginResult;
        try {
            loginResult = this.loginService.authenticate(user, password);
        }
        catch (Exception e) {
            this.log.debug("An error occurred while authenticating user {}: {}", (Object)user.getName(), (Object)e.getMessage());
            throw new ServerErrorWebException(ErrorCollection.of(this.i18n.getText("rest.error.internal")));
        }
        if (loginResult == null) {
            this.log.debug("An error occurred while authenticating user {}: Could not authenticate user.", (Object)user.getName());
            throw new ServerErrorWebException(ErrorCollection.of(this.i18n.getText("rest.error.internal")));
        }
        LoginReason reason = loginResult.getReason();
        if (reason == null) {
            this.log.debug("An error occurred while authenticating user {}: Missing authorisation operation reason.", (Object)user.getName());
            throw new ServerErrorWebException(ErrorCollection.of(this.i18n.getText("rest.error.internal")));
        }
        return reason;
    }

    @PUT
    @Path(value="password")
    @UnlicensedSiteAccess
    @Operation(summary="Update caller password", description="Modify caller password.", security={@SecurityRequirement(name="basic")})
    @RequestBody(description="The new password to be set.", required=true, content={@Content(schema=@Schema(implementation=PasswordBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Confirmation that the password was changed.", responseCode="204"), @ApiResponse(description="The request is invalid including incorrect password.", responseCode="400"), @ApiResponse(description="The user is not authenticated.", responseCode="401"), @ApiResponse(description="The directory is read-only.", responseCode="403"), @ApiResponse(description="The user could not be found.", responseCode="404")})
    public Response changeMyPassword(PasswordBean passwordBean) {
        ApplicationUser currentUser = this.authContext.getUser();
        if (currentUser == null) {
            throw new NotAuthorisedWebException(ErrorCollection.of(this.i18n.getText("rest.authentication.no.user.logged.in")));
        }
        String password = passwordBean.getPassword();
        String currentPassword = passwordBean.getCurrentPassword();
        if (StringUtils.isBlank((CharSequence)password)) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("changepassword.new.password.required")));
        }
        Collection messages = this.passwordPolicyManager.checkPolicy(currentUser, currentPassword, password);
        if (!messages.isEmpty()) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("changepassword.new.password.rejected")));
        }
        this.checkAuthentication(currentUser, currentPassword);
        try {
            this.userUtil.changePassword(currentUser, password);
        }
        catch (UserNotFoundException e) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("changepassword.could.not.find.user")));
        }
        catch (InvalidCredentialException e) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("changepassword.new.password.rejected")));
        }
        catch (OperationNotPermittedException | PermissionException e) {
            throw new ForbiddenWebException(ErrorCollection.of(this.i18n.getText("admin.errors.cannot.edit.user.directory.read.only")));
        }
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    private Response createUserResponse(ApplicationUser currentUser) {
        UserBeanBuilder builder = UserBeanBuilder.fullBuilder(this.jiraBaseUrls, this.emailFormatter, this.avatarService, this.beanFactory, this.userManager, currentUser).user(currentUser).groups((List<String>)ImmutableList.copyOf((Collection)this.userUtil.getGroupNamesForUser(currentUser.getUsername()))).timeZone(this.timeZoneManager.getTimeZoneforUser(currentUser)).applicationRoles(this.applicationRoleManager.getRolesForUser(currentUser));
        return Response.ok((Object)builder.buildFull(this.applicationRoleBeanConverter)).cacheControl(CacheControl.never()).build();
    }
}

