/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.bc.issue.visibility.Visibilities;
import com.atlassian.jira.bc.issue.visibility.Visibility;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.PinnedComment;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.issue.fields.rest.json.beans.CommentJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.CommentsWithPaginationJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.EntityPropertyBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.PinnedCommentJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.VisibilityJsonBean;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.v2.issue.IssueFinder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.OrderByRequest;
import com.atlassian.jira.util.OrderByRequests;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import com.atlassian.jira.util.Pages;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import io.atlassian.fugue.Option;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommentResource {
    private static final Logger log = LoggerFactory.getLogger(CommentResource.class);
    private static final String COMMENT_FIELD_KEY = "comment";
    private CommentService commentService;
    private JiraAuthenticationContext authContext;
    private I18nHelper i18n;
    private ProjectRoleManager projectRoleManager;
    private JiraBaseUrls jiraBaseUrls;
    private IssueFinder issueFinder;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;
    private final RendererManager rendererManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final EmailFormatter emailFormatter;

    private CommentResource(IssueFinder issueFinder, DateTimeFormatterFactory dateTimeFormatterFactory, RendererManager rendererManager, FieldLayoutManager fieldLayoutManager, EmailFormatter emailFormatter) {
        this.issueFinder = issueFinder;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.rendererManager = rendererManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.emailFormatter = emailFormatter;
    }

    @Inject
    public CommentResource(CommentService commentService, JiraAuthenticationContext authContext, I18nHelper i18n, ProjectRoleManager projectRoleManager, JiraBaseUrls jiraBaseUrls, IssueFinder issueFinder, DateTimeFormatterFactory dateTimeFormatterFactory, RendererManager rendererManager, FieldLayoutManager fieldLayoutManager, EmailFormatter emailFormatter) {
        this.authContext = authContext;
        this.commentService = commentService;
        this.i18n = i18n;
        this.projectRoleManager = projectRoleManager;
        this.jiraBaseUrls = jiraBaseUrls;
        this.issueFinder = issueFinder;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.rendererManager = rendererManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.emailFormatter = emailFormatter;
    }

    public Response getComments(String issueIdOrKey, String expand, PageRequest pageRequest, Option<OrderByRequest<CommentField>> orderByRequest) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        if (issue == null) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.comment.error.issue.invalid", issueIdOrKey)));
        }
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        List commentsForUser = this.commentService.getCommentsForUser(this.authContext.getUser(), (Issue)issue);
        if (!errorCollection.hasAnyErrors()) {
            List sortedComments = (List)orderByRequest.map(request -> OrderByRequests.toOrdering((OrderByRequest)request).sortedCopy((Iterable)commentsForUser)).getOrElse((Object)commentsForUser);
            Page commentsPage = Pages.toPage((Iterable)sortedComments, (PageRequest)pageRequest);
            Collection commentJsonBeans = expand != null ? CommentJsonBean.expandedShortBeans((Collection)commentsPage.getValues(), (JiraBaseUrls)this.jiraBaseUrls, (ProjectRoleManager)this.projectRoleManager, (DateTimeFormatterFactory)this.dateTimeFormatterFactory, (RendererManager)this.rendererManager, (String)this.getCommentFieldRendererType((Issue)issue), (IssueRenderContext)issue.getIssueRenderContext(), (String)expand, (ApplicationUser)this.authContext.getUser(), (EmailFormatter)this.emailFormatter) : CommentJsonBean.shortBeans((Collection)commentsPage.getValues(), (JiraBaseUrls)this.jiraBaseUrls, (ProjectRoleManager)this.projectRoleManager, (ApplicationUser)this.authContext.getUser(), (EmailFormatter)this.emailFormatter);
            CommentsWithPaginationJsonBean commentsBean = new CommentsWithPaginationJsonBean();
            commentsBean.setComments(commentJsonBeans);
            commentsBean.setStartAt(Integer.valueOf(Ints.saturatedCast((long)pageRequest.getStart())));
            commentsBean.setMaxResults(Integer.valueOf(pageRequest.getLimit()));
            commentsBean.setTotal(Integer.valueOf(commentsForUser.size()));
            return Response.ok((Object)commentsBean).cacheControl(CacheControl.never()).build();
        }
        throw new NotFoundWebException(ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection));
    }

    public Response getComment(String issueIdOrKey, String commentId, String expand) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        if (issue == null) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.comment.error.issue.invalid", issueIdOrKey)));
        }
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        try {
            Comment comment = this.commentService.getCommentById(this.authContext.getUser(), Long.valueOf(Long.parseLong(commentId)), (com.atlassian.jira.util.ErrorCollection)errorCollection);
            if (errorCollection.hasAnyErrors()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection)).cacheControl(CacheControl.never()).build();
            }
            if (!issue.equals((Object)comment.getIssue())) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorCollection.of(this.i18n.getText("rest.comment.error.invalidIssueForComment", issue.getKey()))).cacheControl(CacheControl.never()).build();
            }
            if (expand != null) {
                return Response.ok((Object)CommentJsonBean.expandedShortBean((Comment)comment, (JiraBaseUrls)this.jiraBaseUrls, (ProjectRoleManager)this.projectRoleManager, (DateTimeFormatterFactory)this.dateTimeFormatterFactory, (RendererManager)this.rendererManager, (String)this.getCommentFieldRendererType((Issue)issue), (IssueRenderContext)issue.getIssueRenderContext(), (String)expand, (ApplicationUser)this.authContext.getUser(), (EmailFormatter)this.emailFormatter)).cacheControl(CacheControl.never()).build();
            }
            return Response.ok((Object)CommentJsonBean.shortBean((Comment)comment, (JiraBaseUrls)this.jiraBaseUrls, (ProjectRoleManager)this.projectRoleManager, (ApplicationUser)this.authContext.getUser(), (EmailFormatter)this.emailFormatter)).cacheControl(CacheControl.never()).build();
        }
        catch (NumberFormatException e) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("comment.service.error.no.comment.for.id", commentId)));
        }
    }

    public Response updateComment(String issueIdOrKey, String commentId, final String expand, CommentJsonBean request) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (request.getId() != null && !request.getId().equals(commentId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of(this.i18n.getText("rest.comment.error.id.mismatch"))).cacheControl(CacheControl.never()).build();
        }
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        if (issue == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorCollection.of(this.i18n.getText("rest.comment.error.issue.invalid", issueIdOrKey))).cacheControl(CacheControl.never()).build();
        }
        try {
            Comment comment = this.commentService.getCommentById(this.authContext.getUser(), Long.valueOf(Long.parseLong(commentId)), (com.atlassian.jira.util.ErrorCollection)errorCollection);
            if (errorCollection.hasAnyErrors()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection)).cacheControl(CacheControl.never()).build();
            }
            if (comment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorCollection.of(this.i18n.getText("comment.service.error.no.comment.for.id", commentId))).cacheControl(CacheControl.never()).build();
            }
            if (!issue.equals((Object)comment.getIssue())) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorCollection.of(this.i18n.getText("rest.comment.error.invalidIssueForComment", issue.getKey()))).cacheControl(CacheControl.never()).build();
            }
            Visibility visibility = request.isVisibilitySet() ? Visibilities.fromVisibilityBean((VisibilityJsonBean)request.getVisibility(), (ProjectRoleManager)this.projectRoleManager) : Visibilities.fromGroupAndRoleId((String)comment.getGroupLevel(), (Long)comment.getRoleLevelId());
            final ApplicationUser user = this.authContext.getUser();
            CommentService.CommentParameters commentParameters = CommentService.CommentParameters.builder().author(user).body(request.getBody()).commentProperties(this.getCommentProperties(request.getProperties())).visibility(visibility).issue((Issue)issue).build();
            final CommentService.CommentUpdateValidationResult commentValidationResult = this.commentService.validateCommentUpdate(user, comment.getId(), commentParameters);
            return (Response)commentValidationResult.getCommentProperties().fold((Supplier)new Supplier<Response>(){

                @Override
                public Response get() {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of(commentValidationResult.getErrorCollection())).cacheControl(CacheControl.never()).build();
                }
            }, (Function)new Function<Map<String, JSONObject>, Response>(){
                final /* synthetic */ Issue val$issue;
                {
                    this.val$issue = issue;
                }

                @Override
                public Response apply(Map<String, JSONObject> properties) {
                    Comment updatedComment = (Comment)commentValidationResult.getComment().get();
                    CommentResource.this.commentService.update(user, commentValidationResult, true);
                    CommentJsonBean bean = expand != null ? CommentJsonBean.expandedShortBean((Comment)updatedComment, (JiraBaseUrls)CommentResource.this.jiraBaseUrls, (ProjectRoleManager)CommentResource.this.projectRoleManager, (DateTimeFormatterFactory)CommentResource.this.dateTimeFormatterFactory, (RendererManager)CommentResource.this.rendererManager, (String)CommentResource.this.getCommentFieldRendererType(this.val$issue), (IssueRenderContext)this.val$issue.getIssueRenderContext(), (String)expand, (ApplicationUser)CommentResource.this.authContext.getUser(), (EmailFormatter)CommentResource.this.emailFormatter) : CommentJsonBean.shortBean((Comment)updatedComment, (JiraBaseUrls)CommentResource.this.jiraBaseUrls, (ProjectRoleManager)CommentResource.this.projectRoleManager, (ApplicationUser)CommentResource.this.authContext.getUser(), (EmailFormatter)CommentResource.this.emailFormatter);
                    return Response.ok((Object)bean).location(CommentResource.this.getUri(bean)).cacheControl(CacheControl.never()).build();
                }
            });
        }
        catch (NumberFormatException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorCollection.of(this.i18n.getText("comment.service.error.no.comment.for.id", commentId))).cacheControl(CacheControl.never()).build();
        }
    }

    public Response deleteComment(String issueIdOrKey, String commentId) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        if (issue == null) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.comment.error.issue.invalid", issueIdOrKey)));
        }
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        try {
            Comment comment = this.commentService.getCommentById(this.authContext.getUser(), Long.valueOf(Long.parseLong(commentId)), (com.atlassian.jira.util.ErrorCollection)errorCollection);
            if (errorCollection.hasAnyErrors()) {
                throw new NotFoundWebException(ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection));
            }
            if (!issue.equals((Object)comment.getIssue())) {
                throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.comment.error.invalidIssueForComment", issue.getKey())));
            }
            JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(this.authContext.getUser(), (com.atlassian.jira.util.ErrorCollection)errorCollection);
            this.commentService.delete((JiraServiceContext)jiraServiceContext, comment, true);
            if (errorCollection.hasAnyErrors()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection)).cacheControl(CacheControl.never()).build();
            }
            return Response.noContent().cacheControl(CacheControl.never()).build();
        }
        catch (NumberFormatException e) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("comment.service.error.no.comment.for.id", commentId)));
        }
    }

    public Response setPinComment(String issueIdOrKey, String commentId, boolean pinned) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        if (issue == null) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.comment.error.issue.invalid", issueIdOrKey)));
        }
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        try {
            Comment comment = this.commentService.getCommentById(this.authContext.getLoggedInUser(), Long.valueOf(Long.parseLong(commentId)), (com.atlassian.jira.util.ErrorCollection)errorCollection);
            if (errorCollection.hasAnyErrors()) {
                throw new NotFoundWebException(ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection));
            }
            if (!issue.equals((Object)comment.getIssue())) {
                throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.comment.error.invalidIssueForComment", issue.getKey())));
            }
            JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(this.authContext.getLoggedInUser(), (com.atlassian.jira.util.ErrorCollection)errorCollection);
            this.commentService.setPin((JiraServiceContext)jiraServiceContext, comment, pinned);
            if (errorCollection.hasAnyErrors()) {
                ErrorCollection.Reason worstReason = ErrorCollection.Reason.getWorstReason((Collection)errorCollection.getReasons());
                return Response.status((int)(worstReason != null ? worstReason.getHttpStatusCode() : Response.Status.BAD_REQUEST.getStatusCode())).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection)).cacheControl(CacheControl.never()).build();
            }
            return Response.ok((Object)commentId).cacheControl(CacheControl.never()).build();
        }
        catch (NumberFormatException e) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("comment.service.error.no.comment.for.id", commentId)));
        }
    }

    public Response getPinnedComments(String issueIdOrKey) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        if (issue == null) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.comment.error.issue.invalid", issueIdOrKey)));
        }
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        try {
            JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(this.authContext.getLoggedInUser(), (com.atlassian.jira.util.ErrorCollection)errorCollection);
            List pinnedCommentJsonBeans = this.commentService.getPinnedComments((JiraServiceContext)jiraServiceContext, (Issue)issue).stream().map(pinnedComment -> PinnedCommentJsonBean.renderedShortBean((PinnedComment)pinnedComment, (DateTimeFormatterFactory)this.dateTimeFormatterFactory)).collect(Collectors.toList());
            if (errorCollection.hasAnyErrors()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection)).cacheControl(CacheControl.never()).build();
            }
            return Response.ok(pinnedCommentJsonBeans).cacheControl(CacheControl.never()).build();
        }
        catch (NumberFormatException e) {
            throw new NotFoundWebException(ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection));
        }
    }

    public Response addComment(String issueIdOrKey, final String expand, CommentJsonBean request) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        if (issue == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorCollection.of(this.i18n.getText("rest.comment.error.issue.invalid", issueIdOrKey))).cacheControl(CacheControl.never()).build();
        }
        final ApplicationUser user = this.authContext.getUser();
        Visibility commentVisibility = Visibilities.fromVisibilityBean((VisibilityJsonBean)request.getVisibility(), (ProjectRoleManager)this.projectRoleManager);
        CommentService.CommentParameters commentParameters = CommentService.CommentParameters.builder().author(user).body(request.getBody()).commentProperties(this.getCommentProperties(request.getProperties())).visibility(commentVisibility).issue((Issue)issue).build();
        final CommentService.CommentCreateValidationResult commentValidationResult = this.commentService.validateCommentCreate(user, commentParameters);
        return (Response)commentValidationResult.getCommentInputParameters().fold((Supplier)new Supplier<Response>(){

            @Override
            public Response get() {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of(commentValidationResult.getErrorCollection())).cacheControl(CacheControl.never()).build();
            }
        }, (Function)new Function<CommentService.CommentParameters, Response>(){
            final /* synthetic */ Issue val$issue;
            {
                this.val$issue = issue;
            }

            @Override
            public Response apply(CommentService.CommentParameters commentParameters) {
                Comment comment = CommentResource.this.commentService.create(user, commentValidationResult, true);
                CommentJsonBean entity = expand != null ? CommentJsonBean.expandedShortBean((Comment)comment, (JiraBaseUrls)CommentResource.this.jiraBaseUrls, (ProjectRoleManager)CommentResource.this.projectRoleManager, (DateTimeFormatterFactory)CommentResource.this.dateTimeFormatterFactory, (RendererManager)CommentResource.this.rendererManager, (String)CommentResource.this.getCommentFieldRendererType(this.val$issue), (IssueRenderContext)this.val$issue.getIssueRenderContext(), (String)expand, (ApplicationUser)CommentResource.this.authContext.getUser(), (EmailFormatter)CommentResource.this.emailFormatter) : CommentJsonBean.shortBean((Comment)comment, (JiraBaseUrls)CommentResource.this.jiraBaseUrls, (ProjectRoleManager)CommentResource.this.projectRoleManager, (ApplicationUser)CommentResource.this.authContext.getUser(), (EmailFormatter)CommentResource.this.emailFormatter);
                return Response.status((Response.Status)Response.Status.CREATED).location(CommentResource.this.getUri(entity)).entity((Object)entity).cacheControl(CacheControl.never()).build();
            }
        });
    }

    private URI getUri(CommentJsonBean comment) {
        try {
            return new URI(comment.getSelf());
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private String getCommentFieldRendererType(Issue issue) {
        FieldLayout layout = this.fieldLayoutManager.getFieldLayout(issue);
        List fieldLayoutItems = layout.getVisibleLayoutItems(issue.getProjectObject(), CollectionBuilder.list((Object[])new String[]{issue.getIssueTypeId()}));
        for (FieldLayoutItem item : fieldLayoutItems) {
            if (!COMMENT_FIELD_KEY.equals(item.getOrderableField().getId())) continue;
            return item.getRendererType();
        }
        return null;
    }

    private Map<String, JSONObject> getCommentProperties(List<EntityPropertyBean> properties) {
        HashMap mapOfProperties = Maps.newHashMap();
        if (properties != null) {
            for (EntityPropertyBean propertyBean : properties) {
                try {
                    mapOfProperties.put(propertyBean.getKey(), new JSONObject(propertyBean.getValue()));
                }
                catch (JSONException e) {
                    log.error("Error when building comment properties", (Throwable)e);
                }
            }
        }
        return mapOfProperties;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum CommentField implements OrderByRequests.ExtractableField<Comment>
    {
        created{

            public Comparable getValue(Comment entity) {
                return entity.getCreated();
            }
        };

    }
}

