/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.bc.issue.comment.property.CommentPropertyService;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.fields.rest.json.beans.EntityPropertyBean;
import com.atlassian.jira.issue.fields.rest.json.beans.EntityPropertyBeanSelfFunctions;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.rest.v2.entity.property.BasePropertyResource;
import com.atlassian.jira.rest.v2.entity.property.EntityPropertiesKeysBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.function.BiFunction;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="comment/{commentId}/properties")
@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CommentPropertyResource {
    private final BasePropertyResource<Comment> delegate;

    @Inject
    public CommentPropertyResource(CommentPropertyService commentPropertyService, JiraAuthenticationContext authenticationContext, JiraBaseUrls jiraBaseUrls, I18nHelper i18n) {
        this.delegate = new BasePropertyResource(commentPropertyService, authenticationContext, jiraBaseUrls, i18n, (BiFunction<Long, String, String>)new EntityPropertyBeanSelfFunctions.CommentPropertySelfBifFunction(), EntityPropertyType.COMMENT_PROPERTY);
    }

    @ExperimentalApi
    @GET
    @Operation(summary="Get properties keys of a comment", description="Returns the keys of all properties for the comment identified by the key or by the id.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="commentId", description="the comment from which keys will be returned.", in=ParameterIn.PATH, required=true)
    @ApiResponses(value={@ApiResponse(description="Returns a list of all properties in the comment.", responseCode="200", content={@Content(schema=@Schema(implementation=EntityPropertiesKeysBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the comment key or id is invalid.", responseCode="400"), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to browse the comment.", responseCode="403"), @ApiResponse(description="Returned if the comment with given key or id does not exist or if the property with given key is not found.", responseCode="404")})
    public Response getPropertiesKeys(@PathParam(value="commentId") String commentId) {
        return this.delegate.getPropertiesKeys(commentId);
    }

    @ExperimentalApi
    @PUT
    @Path(value="/{propertyKey}")
    @Operation(summary="Set a property on a comment", description="Sets the value of the specified comment's property.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="commentId", description="the comment on which the property will be set.", in=ParameterIn.PATH, required=true), @Parameter(name="propertyKey", description="the key of the comment's property. The maximum length of the key is 255 bytes.", in=ParameterIn.PATH, required=true)})
    @RequestBody(description="the request containing value of the comment's property. The value has to be a valid, non-empty JSON conforming to http://tools.ietf.org/html/rfc4627. The maximum length of the property value is 32768 bytes.", content={@Content(mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Returned if the comment property is successfully updated.", responseCode="200"), @ApiResponse(description="Returned if the comment property is successfully created.", responseCode="201"), @ApiResponse(description="Returned if the comment key or id is invalid.", responseCode="400"), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to administer the comment.", responseCode="403"), @ApiResponse(description="Returned if the comment with given key or id does not exist.", responseCode="404")})
    public Response setProperty(@PathParam(value="commentId") String commentId, @PathParam(value="propertyKey") String propertyKey, @Context HttpServletRequest request) {
        return this.delegate.setProperty(commentId, propertyKey, request);
    }

    @ExperimentalApi
    @GET
    @Path(value="/{propertyKey}")
    @Operation(summary="Get a property from a comment", description="Returns the value of the property with a given key from the comment identified by the key or by the id. The user who retrieves the property is required to have permissions to read the comment.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="commentId", description="the comment from which the property will be returned.", in=ParameterIn.PATH, required=true), @Parameter(name="propertyKey", description="the key of the property to return.", in=ParameterIn.PATH, required=true)})
    @ApiResponses(value={@ApiResponse(description="Returns the value of the property with a given key from the comment.", responseCode="200", content={@Content(schema=@Schema(implementation=EntityPropertyBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the comment key or id is invalid.", responseCode="400"), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to browse the comment.", responseCode="403"), @ApiResponse(description="Returned if the comment with given key or id does not exist or if the property with given key is not found.", responseCode="404")})
    public Response getProperty(@PathParam(value="commentId") String commentId, @PathParam(value="propertyKey") String propertyKey) {
        return this.delegate.getProperty(commentId, propertyKey);
    }

    @ExperimentalApi
    @DELETE
    @Path(value="/{propertyKey}")
    @Operation(summary="Delete a property from a comment", description="Removes the property from the comment identified by the key or by the id. Ths user removing the property is required to have permissions to administer the comment.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="commentId", description="the comment from which the property will be removed.", in=ParameterIn.PATH, required=true), @Parameter(name="propertyKey", description="the key of the property to remove.", in=ParameterIn.PATH, required=true)})
    @ApiResponses(value={@ApiResponse(description="Returned if the comment property was removed successfully.", responseCode="204"), @ApiResponse(description="Returned if the comment key or id is invalid.", responseCode="400"), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to edit the comment.", responseCode="403"), @ApiResponse(description="Returned if the comment with given key or id does not exist or if the property with given key is not found.", responseCode="404")})
    public Response deleteProperty(@PathParam(value="commentId") String commentId, @PathParam(value="propertyKey") String propertyKey) {
        return this.delegate.deleteProperty(commentId, propertyKey);
    }
}

