/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.v2.issue.AvatarBean;
import com.atlassian.jira.rest.v2.issue.AvatarCroppingBean;
import com.atlassian.jira.rest.v2.issue.AvatarResourceHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.AccessDisablingHelper;
import com.atlassian.jira.util.AccessDisablingHelperConfig;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="avatar")
@UnrestrictedAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AvatarResource {
    private final AvatarResourceHelper avatarResourceHelper;
    private final AccessDisablingHelper accessDisablingHelper;
    private final JiraAuthenticationContext authContext;
    private final EventPublisher eventPublisher;

    @Inject
    public AvatarResource(AvatarResourceHelper avatarResourceHelper, JiraAuthenticationContext authContext, EventPublisher eventPublisher, AccessDisablingHelper accessDisablingHelper) {
        this.accessDisablingHelper = accessDisablingHelper;
        this.avatarResourceHelper = avatarResourceHelper;
        this.authContext = authContext;
        this.eventPublisher = eventPublisher;
    }

    @GET
    @Path(value="{type}/system")
    @Operation(summary="Get all system avatars", description="Returns all system avatars of the given type.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="type", description="the avatar type", in=ParameterIn.PATH, required=true)
    @ApiResponses(value={@ApiResponse(description="Returns a map containing a list of system avatars. A map is returned to be consistent with the shape of the project/KEY/avatars REST end point.", responseCode="200", content={@Content(schema=@Schema(implementation=AvatarBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if accessed by anonymous user", responseCode="401"), @ApiResponse(description="Returned if an error occurs while retrieving the list of avatars.", responseCode="500")})
    public Response getAllSystemAvatars(@PathParam(value="type") String type) {
        if (!this.accessDisablingHelper.canBeAccessedByCurrentUser(AccessDisablingHelperConfig.builder().blockAnonymous(true).build())) {
            throw new NotAuthorisedWebException();
        }
        IconType iconType = IconType.of((String)type);
        return this.avatarResourceHelper.getAllSystemAvatars(iconType);
    }

    @POST
    @Consumes(value={"*/*"})
    @Path(value="{type}/temporary")
    @Operation(summary="Create temporary avatar", description="Creates temporary avatar", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="type", description="the avatar type", in=ParameterIn.PATH, required=true), @Parameter(name="filename", description="name of file being uploaded", in=ParameterIn.QUERY), @Parameter(name="size", description="size of file", in=ParameterIn.QUERY)})
    @ApiResponses(value={@ApiResponse(description="temporary avatar cropping instructions", responseCode="201", content={@Content(schema=@Schema(implementation=AvatarCroppingBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the request does not contain a valid XSRF token", responseCode="403"), @ApiResponse(description="Validation failed. For example filesize is beyond max attachment size.", responseCode="400"), @ApiResponse(description="Returned if an error occurs while converting temporary avatar to real avatar", responseCode="500")})
    public Response storeTemporaryAvatar(@PathParam(value="type") String type, @QueryParam(value="filename") String filename, @QueryParam(value="size") Long size, @Context HttpServletRequest request) {
        IconType iconType = IconType.of((String)type);
        return this.avatarResourceHelper.storeTemporaryAvatar(iconType, null, filename, size, request);
    }

    @POST
    @Path(value="{type}/temporaryCrop")
    @Operation(summary="Update avatar cropping", description="Updates the cropping instructions of the temporary avatar", security={@SecurityRequirement(name="basic")})
    @Parameter(name="type", description="the avatar type", in=ParameterIn.PATH, required=true)
    @RequestBody(description="cropping instructions", content={@Content(schema=@Schema(implementation=AvatarCroppingBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Returned if the cropping coordinates are invalid", responseCode="400"), @ApiResponse(description="Returned if an error occurs while cropping the temporary avatar", responseCode="500")})
    public Response createAvatarFromTemporary(@PathParam(value="type") String type, AvatarCroppingBean croppingInstructions) {
        IconType iconType = IconType.of((String)type);
        return this.avatarResourceHelper.cropTemporaryAvatar(iconType, null, croppingInstructions);
    }
}

