/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@XmlRootElement(name="avatar")
public class AvatarBean {
    @XmlElement
    @Schema(example="1000")
    private String id;
    @XmlElement
    @Schema(example="fred")
    private String owner;
    @XmlElement
    @Schema(example="true")
    private boolean isSystemAvatar;
    @XmlElement
    @Schema(example="false")
    private boolean isSelected;
    @XmlElement
    @Schema(example="false")
    private boolean isDeletable;
    @XmlElement
    @Schema(example="{\n    \"16x16\": \"http://localhost:8090/jira/secure/useravatar?size=xsmall&avatarId=10040\",\n    \"24x24\": \"http://localhost:8090/jira/secure/useravatar?size=small&avatarId=10040\",\n    \"32x32\": \"http://localhost:8090/jira/secure/useravatar?size=medium&avatarId=10040\",\n    \"48x48\": \"http://localhost:8090/jira/secure/useravatar?avatarId=10040\"\n}")
    Map<String, URI> urls;

    public AvatarBean() {
    }

    public AvatarBean(String id, String owner) {
        this(id, owner, false, null);
    }

    public AvatarBean(String id, String owner, boolean isSystemAvatar, boolean isDeletable) {
        this(id, owner, isSystemAvatar, isDeletable, null);
    }

    public AvatarBean(String id, String owner, boolean isSystemAvatar, Map<String, URI> urls) {
        this(id, owner, isSystemAvatar, !isSystemAvatar, urls);
    }

    public AvatarBean(String id, String owner, boolean isSystemAvatar, boolean isDeletable, Map<String, URI> urls) {
        this.id = id;
        this.owner = owner;
        this.isSystemAvatar = isSystemAvatar;
        this.isDeletable = isDeletable;
        this.urls = urls;
        this.isSelected = false;
    }

    public String getId() {
        return this.id;
    }

    @JsonProperty
    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    @JsonIgnore
    public boolean getSystemAvatar() {
        return this.isSystemAvatar;
    }

    @JsonIgnore
    public boolean getDeletable() {
        return this.isDeletable;
    }

    public String getOwner() {
        return this.owner;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    public static class SystemAvatars {
        private List<AvatarBean> system;
    }
}

