/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.index.summary;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.index.summary.IndexSummarizer;
import com.atlassian.jira.index.summary.IssueIndexSummary;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.v2.index.summary.IndexSummaryBean;
import com.atlassian.jira.rest.v2.index.summary.IndexSummaryBeanBuilder;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.time.Instant;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Produces(value={"application/json"})
@Path(value="index/summary")
@AdminOnly
public class IndexSummaryResource {
    private final ResponseFactory responseFactory;
    private final ClusterManager clusterManager;
    private final IndexSummarizer indexSummarizer;

    @Inject
    public IndexSummaryResource(ResponseFactory responseFactory, @ComponentImport ClusterManager clusterManager, @ComponentImport IndexSummarizer indexSummarizer) {
        this.responseFactory = responseFactory;
        this.clusterManager = clusterManager;
        this.indexSummarizer = indexSummarizer;
    }

    @GET
    @ExperimentalApi
    @Operation(summary="Get index condition summary", description="Returns a summary of the index condition of the current node.\nThe returned data consists of:\n- `nodeId` - Node identifier.\n- `reportTime` - Time of this report creation.\n- `issueIndex` - Summary of the issue index status.\n- `replicationQueues` - Map of index replication queues, where keys represent nodes from which replication operations came from.\n\n`issueIndex` can contain:\n    - `indexReadable` - If `false` the endpoint failed to read data from the issue index (check Jira logs for detailed stack trace), otherwise `true`.\n    - `countInDatabase` - Count of issues found in the database.\n    - `countInIndex` - Count of issues found while querying the index.\n    - `lastUpdatedInDatabase` - Time of the last update of the issue found in the database.\n    - `lastUpdatedInIndex` - Time of the last update of the issue found while querying the index.\n`replicationQueues`'s map values can contain:\n    - `lastConsumedOperation` - Last executed index replication operation by the current node from the sending node's queue.\n    - `lastConsumedOperation.id` - Identifier of the operation.\n    - `lastConsumedOperation.replicationTime` - Time when the operation was sent to other nodes.\n    - `lastOperationInQueue` - Last index replication operation in the sending node's queue.\n    - `lastOperationInQueue.id` - Identifier of the operation.\n    - `lastOperationInQueue.replicationTime` - Time when the operation was sent to other nodes.\n    - `queueSize` - Number of operations in the queue from the sending node to the current node.", security={@SecurityRequirement(name="basic")})
    @ApiResponses(value={@ApiResponse(description="Returns an object with data about the condition of the Jira node's index", responseCode="200", content={@Content(schema=@Schema(implementation=IndexSummaryBean.class))}), @ApiResponse(description="Returned when the current authenticated user does not have admin permission", responseCode="403")})
    public Response getIndexSummary() {
        IndexSummaryBeanBuilder beanBuilder = new IndexSummaryBeanBuilder();
        ServiceOutcome issueIndexSummaryOutcome = this.indexSummarizer.summarizeIssueIndex();
        if (!issueIndexSummaryOutcome.isValid()) {
            return this.responseFactory.errorResponse(issueIndexSummaryOutcome.getErrorCollection());
        }
        beanBuilder.issueIndex((IssueIndexSummary)issueIndexSummaryOutcome.get());
        if (this.clusterManager.isClustered()) {
            ServiceOutcome queueSummaryOutcome = this.indexSummarizer.summarizeIndexReplicationQueues();
            if (!queueSummaryOutcome.isValid()) {
                return this.responseFactory.errorResponse(queueSummaryOutcome.getErrorCollection());
            }
            ((Map)queueSummaryOutcome.get()).forEach(beanBuilder::queue);
            beanBuilder.nodeId(this.clusterManager.getNodeId());
        }
        beanBuilder.reportTime(Instant.now());
        return Response.ok((Object)beanBuilder.build()).build();
    }
}

