/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.index;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.core.util.Clock;
import com.atlassian.jira.config.BackgroundIndexTaskContext;
import com.atlassian.jira.config.ForegroundIndexTaskContext;
import com.atlassian.jira.config.IndexTaskContext;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.issue.index.IssueIndexingService;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.v2.index.ReindexBean;
import com.atlassian.jira.rest.v2.index.TaskDescriptorHelper;
import com.atlassian.jira.rest.v2.issue.IssueFinder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.jira.web.action.admin.index.IndexCommandResult;
import com.atlassian.jira.web.action.admin.index.ReIndexAsyncIndexerCommand;
import com.atlassian.jira.web.action.admin.index.ReIndexBackgroundIndexerCommand;
import com.atlassian.johnson.JohnsonEventContainer;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="reindex")
@LicensedOnly
public class ReindexResource {
    private static final Logger log = Logger.getLogger(ReindexResource.class);
    private final TaskManager taskManager;
    private final TaskDescriptorHelper taskDescriptorHelper;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final IndexLifecycleManager indexLifecycleManager;
    private final PermissionManager permissionManager;
    private final URI location;
    private final I18nHelper.BeanFactory i18nBeanFactory;
    private final JohnsonProvider johnsonProvider;
    private final IssueIndexingService issueIndexingService;
    private final Clock clock;
    private final IssueFinder issueFinder;

    @Inject
    public ReindexResource(@Qualifier(value="indexLifecycleManager") IndexLifecycleManager indexLifecycleManager, TaskManager taskManager, JiraAuthenticationContext jiraAuthenticationContext, PermissionManager permissionManager, JiraBaseUrls jiraBaseUrls, I18nHelper.BeanFactory i18nBeanFactory, IssueIndexingService issueIndexingService, Clock clock, IssueFinder issueFinder, JohnsonProvider johnsonProvider) {
        this.taskManager = taskManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.i18nBeanFactory = i18nBeanFactory;
        this.johnsonProvider = johnsonProvider;
        this.taskDescriptorHelper = new TaskDescriptorHelper(taskManager);
        this.indexLifecycleManager = indexLifecycleManager;
        this.permissionManager = permissionManager;
        this.issueIndexingService = issueIndexingService;
        this.clock = clock;
        this.issueFinder = issueFinder;
        try {
            this.location = new URI(jiraBaseUrls.restApi2BaseUrl() + "reindex/");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @POST
    @Path(value="issue")
    @Operation(summary="Reindex individual issues", description="Reindexes one or more individual issues. Indexing is performed synchronously - the call returns when indexing of the issues has completed or a failure occurs.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="issueId", description="The IDs or keys of one or more issues to reindex.", required=true), @Parameter(name="indexComments", description="Indicates that comments should also be reindexed."), @Parameter(name="indexChangeHistory", description="Indicates that changeHistory should also be reindexed."), @Parameter(name="indexWorklogs", description="Indicates that worklogs should also be reindexed.")})
    @ApiResponse(description="Returns response indicating reindex time.", responseCode="200", content={@Content(schema=@Schema(implementation=ReindexBean.class), mediaType="application/json")})
    public Response reindexIssues(@QueryParam(value="issueId") List<String> issueIds, @QueryParam(value="indexComments") @DefaultValue(value="false") boolean indexComments, @QueryParam(value="indexChangeHistory") @DefaultValue(value="false") boolean indexChangeHistory, @QueryParam(value="indexWorklogs") @DefaultValue(value="false") boolean indexWorklogs) {
        IssueIndexingParams issueIndexingParams = IssueIndexingParams.builder().setComments(indexComments).setChangeHistory(indexChangeHistory).setWorklogs(indexWorklogs).build();
        return this.reindexIssues(issueIds, issueIndexingParams);
    }

    Response reindexIssues(List<String> issueIds, IssueIndexingParams issueIndexingParams) {
        Date requestTime = this.clock.getCurrentDate();
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        if (!this.permissionManager.hasPermission(0, user)) {
            throw new NotAuthorisedWebException();
        }
        TaskDescriptor<IndexCommandResult> currentReindexTask = this.taskDescriptorHelper.getActiveIndexTask();
        if (currentReindexTask != null) {
            log.error((Object)("Attempt to reindex issues " + issueIds + " while another reindex task in progress."));
            try {
                return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)ReindexBean.fromTaskDescriptor(currentReindexTask)).location(this.location).build();
            }
            catch (Exception e) {
                return Response.serverError().entity((Object)e.getMessage()).cacheControl(CacheControl.never()).build();
            }
        }
        ArrayList<MutableIssue> issues = new ArrayList<MutableIssue>(issueIds.size());
        for (String issueId : issueIds) {
            issues.add(this.issueFinder.getIssueObject(issueId));
        }
        Date startTime = this.clock.getCurrentDate();
        try {
            long reindexTime = this.issueIndexingService.reIndexIssueObjects(issues, issueIndexingParams);
            log.debug((Object)("Issue reindex for " + issueIds + " complete, time taken=" + reindexTime + "ms"));
            Date finishTime = this.clock.getCurrentDate();
            ReindexBean reindexBean = new ReindexBean(null, 100L, "", ReindexBean.Type.FOREGROUND, requestTime, startTime, finishTime, true);
            return Response.status((Response.Status)Response.Status.OK).location(this.location).entity((Object)reindexBean).cacheControl(CacheControl.never()).build();
        }
        catch (IndexException e) {
            log.error((Object)("Reindex of issues " + issueIds + " failed: " + e), (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).cacheControl(CacheControl.never()).build();
        }
    }

    @POST
    @Operation(summary="Start a reindex operation", description="Kicks off a reindex. Need Admin permissions to perform this reindex.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="type", description="Case insensitive String indicating type of reindex. If omitted, then defaults to BACKGROUND_PREFERRED."), @Parameter(name="indexComments", description="Indicates that comments should also be reindexed. Not relevant for foreground reindex, where comments are always reindexed."), @Parameter(name="indexChangeHistory", description="Indicates that changeHistory should also be reindexed. Not relevant for foreground reindex, where changeHistory is always reindexed."), @Parameter(name="indexWorklogs", description="Indicates that worklogs should also be reindexed. Not relevant for foreground reindex, where worklogs are always reindexed.")})
    @ApiResponse(description="Returns a representation of the progress of the re-index operation.", responseCode="202", content={@Content(schema=@Schema(implementation=ReindexBean.class), mediaType="application/json")})
    public Response reindex(@QueryParam(value="type") String type, @QueryParam(value="indexComments") @DefaultValue(value="false") boolean indexComments, @QueryParam(value="indexChangeHistory") @DefaultValue(value="false") boolean indexChangeHistory, @QueryParam(value="indexWorklogs") @DefaultValue(value="false") boolean indexWorklogs) {
        IssueIndexingParams issueIndexingParams = IssueIndexingParams.builder().setComments(indexComments).setChangeHistory(indexChangeHistory).setWorklogs(indexWorklogs).build();
        return this.reindex(type, issueIndexingParams);
    }

    Response reindex(String type, IssueIndexingParams issueIndexingParams) {
        ReindexBean.Type requestedIndexType = ReindexBean.fromString(type);
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        if (!this.permissionManager.hasPermission(0, user)) {
            throw new NotAuthorisedWebException();
        }
        try {
            TaskDescriptor<IndexCommandResult> indexingTask;
            TaskDescriptor<IndexCommandResult> task = this.taskDescriptorHelper.getActiveIndexTask();
            if (task != null) {
                return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)ReindexBean.fromTaskDescriptor(task)).location(this.location).build();
            }
            if (requestedIndexType.equals((Object)ReindexBean.Type.FOREGROUND)) {
                indexingTask = this.triggerForegroundIndexing();
            } else {
                boolean canBeBackgroundIndexed = this.indexLifecycleManager.isIndexConsistent();
                if (canBeBackgroundIndexed) {
                    indexingTask = this.triggerBackgroundIndexing(issueIndexingParams);
                } else if (requestedIndexType.equals((Object)ReindexBean.Type.BACKGROUND_PREFFERED) || requestedIndexType.equals((Object)ReindexBean.Type.BACKGROUND_PREFERRED)) {
                    indexingTask = this.triggerForegroundIndexing();
                } else {
                    return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)this.i18n().getText("admin.indexing.strategy.background.unsafe")).cacheControl(CacheControl.never()).build();
                }
            }
            ReindexBean reindexBean = ReindexBean.fromTaskDescriptor(indexingTask);
            return Response.status((Response.Status)Response.Status.ACCEPTED).location(this.location).entity((Object)reindexBean).header("Retry-After", (Object)10L).cacheControl(CacheControl.never()).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    @GET
    @Operation(summary="Get reindex information", description="Returns information on the system reindexes. If a reindex is currently taking place then information about this reindex is returned. If there is no active index task, then returns information about the latest reindex task run, otherwise returns a 404 indicating that no reindex has taken place.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="taskId", description="The id of an indexing task you wish to obtain details on. If omitted, then defaults to the standard behaviour and returns information on the active reindex task, or the last task to run if no reindex is taking place.")
    @ApiResponses(value={@ApiResponse(description="Returns a representation of the progress of the re-index operation.", responseCode="200", content={@Content(schema=@Schema(implementation=ReindexBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if there is no re-indexing task found", responseCode="404")})
    public Response getReindexInfo(@QueryParam(value="taskId") long taskId) {
        try {
            TaskDescriptor<IndexCommandResult> task = this.taskDescriptorHelper.getIndexTask(taskId);
            if (task == null) {
                if (taskId > 0L) {
                    return this.build404Response();
                }
                task = this.taskDescriptorHelper.getLastindexTask();
                if (task == null) {
                    return this.build404Response();
                }
            }
            if (task.isFinished()) {
                return this.buildTaskCompletedResponse(task);
            }
            return this.buildTaskRunningResponse(task);
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)e.getMessage()).cacheControl(CacheControl.never()).build();
        }
    }

    @GET
    @Path(value="progress")
    @Operation(summary="Get reindex progress", description="Returns information on the system reindexes. If a reindex is currently taking place then information about this reindex is returned. If there is no active index task, then returns information about the latest reindex task run, otherwise returns a 404 indicating that no reindex has taken place.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="taskId", description="The id of an indexing task you wish to obtain details on. If omitted, then defaults to the standard behaviour and returns information on the active reindex task, or the last task to run if no reindex is taking place.")
    @ApiResponses(value={@ApiResponse(description="Returns a representation of the progress of the re-index operation.", responseCode="200", content={@Content(schema=@Schema(implementation=ReindexBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if there is no re-indexing task found", responseCode="404")})
    public Response getReindexProgress(@QueryParam(value="taskId") long taskId) {
        try {
            TaskDescriptor<IndexCommandResult> task = this.taskDescriptorHelper.getIndexTask(taskId);
            if (task == null) {
                if (taskId > 0L) {
                    return this.build404Response();
                }
                task = this.taskDescriptorHelper.getLastindexTask();
                if (task == null) {
                    return this.build404Response();
                }
            }
            if (task.isFinished()) {
                return this.buildTaskCompletedResponse(task);
            }
            return this.buildTaskProgressResponse(task);
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)e.getMessage()).cacheControl(CacheControl.never()).build();
        }
    }

    private Response buildTaskProgressResponse(TaskDescriptor<IndexCommandResult> task) {
        ReindexBean bean = ReindexBean.fromTaskDescriptor(task);
        return Response.ok((Object)bean).cacheControl(CacheControl.never()).build();
    }

    private Response buildTaskRunningResponse(TaskDescriptor<IndexCommandResult> task) {
        ReindexBean bean = ReindexBean.fromTaskDescriptor(task);
        long currentProgress = bean.getCurrentProgress();
        long retryAfter = currentProgress > 0L ? (100L - currentProgress) / currentProgress * task.getElapsedRunTime() / 1000L + 1L : 10L;
        return Response.status((Response.Status)Response.Status.SEE_OTHER).location(this.location).entity((Object)bean).header("Retry-After", (Object)retryAfter).cacheControl(CacheControl.never()).build();
    }

    private Response buildTaskCompletedResponse(TaskDescriptor<IndexCommandResult> task) {
        IndexCommandResult result = (IndexCommandResult)task.getResult();
        if (result.isSuccessful()) {
            return Response.ok((Object)ReindexBean.fromTaskDescriptor(task)).lastModified(task.getFinishedTimestamp()).build();
        }
        return Response.serverError().entity((Object)result.getErrorCollection()).cacheControl(CacheControl.never()).build();
    }

    private Response build404Response() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.i18n().getText("admin.indexing.no.task.found")).build();
    }

    private TaskDescriptor<IndexCommandResult> triggerBackgroundIndexing(IssueIndexingParams issueIndexingParams) {
        return this.submitIndexingTask((Callable<IndexCommandResult>)new ReIndexBackgroundIndexerCommand(this.indexLifecycleManager, issueIndexingParams, log, this.i18n(), this.i18nBeanFactory), (IndexTaskContext)new BackgroundIndexTaskContext(), true);
    }

    private TaskDescriptor<IndexCommandResult> triggerForegroundIndexing() {
        ReIndexAsyncIndexerCommand indexerCommand = new ReIndexAsyncIndexerCommand(this.getJohnsonEventContainer(), this.indexLifecycleManager, log, this.i18n(), this.i18nBeanFactory);
        return this.submitIndexingTask((Callable<IndexCommandResult>)indexerCommand, (IndexTaskContext)new ForegroundIndexTaskContext(), false);
    }

    private I18nHelper i18n() {
        return this.jiraAuthenticationContext.getI18nHelper();
    }

    private TaskDescriptor<IndexCommandResult> submitIndexingTask(Callable<IndexCommandResult> cmd, IndexTaskContext indexTaskContext, boolean cancellable) {
        return this.taskManager.submitTask(cmd, this.i18n().getText("admin.indexing.jira.indexing"), (TaskContext)indexTaskContext, cancellable);
    }

    private JohnsonEventContainer getJohnsonEventContainer() {
        return this.johnsonProvider.getContainer();
    }
}

