/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.index;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.index.request.ReindexRequest;
import com.atlassian.jira.index.request.ReindexRequestService;
import com.atlassian.jira.index.request.ReindexRequestType;
import com.atlassian.jira.rest.v2.index.ReindexRequestBean;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="reindex/request")
@LicensedOnly
public class ReindexRequestResource {
    private static final Logger log = LoggerFactory.getLogger(ReindexRequestResource.class);
    private final ReindexRequestService reindexRequestService;

    @Inject
    public ReindexRequestResource(ReindexRequestService reindexRequestService) {
        this.reindexRequestService = reindexRequestService;
    }

    @POST
    @Operation(summary="Execute pending reindex requests", description="Executes any pending reindex requests. Execution is asynchronous - progress of the returned tasks can be monitored through other REST calls.", security={@SecurityRequirement(name="basic")})
    @ApiResponses(value={@ApiResponse(description="Returns an array containing the reindex request IDs being processed.", responseCode="200", content={@Content(schema=@Schema(implementation=Long.class), mediaType="application/json")}), @ApiResponse(description="Returned if the user is not authorized to process reindex requests.", responseCode="401"), @ApiResponse(description="Returned if there is an error processing reindex requests.", responseCode="500")})
    public Response processRequests() {
        try {
            Set requests = this.reindexRequestService.processRequests(EnumSet.allOf(ReindexRequestType.class), true);
            ArrayList requestIds = new ArrayList();
            for (ReindexRequest request : requests) {
                requestIds.addAll(request.getAllRequestIds());
            }
            Collections.sort(requestIds);
            return Response.ok(requestIds).build();
        }
        catch (PermissionException e) {
            log.error("Permission error processing reindex requests: " + e, (Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (RuntimeException e) {
            log.error("Error processing reindex requests: " + e, (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="{requestId}")
    @Operation(summary="Get progress of a single reindex request", description="Retrieves the progress of a single reindex request.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="requestId", description="The reindex request ID.", required=true)
    @ApiResponses(value={@ApiResponse(description="Details and status of the reindex request.", responseCode="200", content={@Content(schema=@Schema(implementation=ReindexRequestBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if no such reindex request exists.", responseCode="404")})
    public Response getProgress(@PathParam(value="requestId") long requestId) {
        ReindexRequest request = this.reindexRequestService.getReindexProgress(requestId);
        if (request == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)new ReindexRequestBean(request)).build();
    }

    @GET
    @Path(value="bulk")
    @Operation(summary="Get progress of multiple reindex requests", description="Retrieves the progress of multiple reindex requests. Only reindex requests that actually exist will be returned in the results.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="requestId", description="The reindex request IDs.", required=true)
    @ApiResponse(description="An array of results describing the progress of each of the found requests.", responseCode="200", content={@Content(schema=@Schema(implementation=ReindexRequestBean.class, type="array"), mediaType="application/json")})
    public List<ReindexRequestBean> getProgressBulk(@QueryParam(value="requestId") Set<Long> requestIds) {
        Set requests = this.reindexRequestService.getReindexProgress(requestIds);
        ArrayList<ReindexRequestBean> beans = new ArrayList<ReindexRequestBean>();
        for (ReindexRequest request : requests) {
            beans.add(new ReindexRequestBean(request));
        }
        return beans;
    }
}

