/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.index;

import com.atlassian.jira.index.request.ReindexRequest;
import com.atlassian.jira.index.request.ReindexRequestType;
import com.atlassian.jira.index.request.ReindexStatus;
import com.atlassian.jira.rest.bind.DateTimeAdapter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement
public class ReindexRequestBean {
    @XmlElement
    @Schema(example="10500")
    private long id;
    @XmlElement
    @Schema(example="PENDING")
    private ReindexStatus status;
    @XmlElement
    @Schema(example="IMMEDIATE")
    private ReindexRequestType type;
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    @XmlElement
    @Schema(example="2013-09-25T10:15:00.000+0000")
    private Date requestTime;
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    @XmlElement
    @Schema(example="2013-09-25T10:15:00.000+0000")
    private Date startTime;
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    @XmlElement
    @Schema(example="2013-09-25T10:15:00.000+0000")
    private Date completionTime;

    public ReindexRequestBean() {
    }

    public ReindexRequestBean(ReindexRequest request) {
        this.id = request.getId();
        this.status = request.getStatus();
        this.requestTime = new Date(request.getRequestTime());
        this.startTime = request.getStartTime() == null ? null : new Date(request.getStartTime());
        this.completionTime = request.getCompletionTime() == null ? null : new Date(request.getCompletionTime());
        this.type = request.getType();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public ReindexStatus getStatus() {
        return this.status;
    }

    public void setStatus(ReindexStatus status) {
        this.status = status;
    }

    public ReindexRequestType getType() {
        return this.type;
    }

    public void setType(ReindexRequestType type) {
        this.type = type;
    }

    public Date getRequestTime() {
        return this.requestTime;
    }

    public void setRequestTime(Date requestTime) {
        this.requestTime = requestTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getCompletionTime() {
        return this.completionTime;
    }

    public void setCompletionTime(Date completionTime) {
        this.completionTime = completionTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReindexRequestBean)) {
            return false;
        }
        ReindexRequestBean that = (ReindexRequestBean)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }
}

