/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.index;

import com.atlassian.jira.config.ForegroundIndexTaskContext;
import com.atlassian.jira.rest.bind.DateTimeAdapter;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskProgressEvent;
import com.atlassian.jira.web.action.admin.index.IndexCommandResult;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement
class ReindexBean {
    @XmlElement
    @Schema(example="http://localhost:8080/jira")
    private String progressUrl;
    @XmlElement
    @Schema(example="0")
    private Long currentProgress;
    @XmlElement
    @Schema(example="Currently reindexing Change History")
    private String currentSubTask;
    @XmlElement
    @Schema(example="FOREGROUND")
    private Type type;
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    @XmlElement
    @Schema(example="2013-01-01T12:00:00.000+0000")
    private Date submittedTime;
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    @XmlElement
    @Schema(example="2013-01-01T12:00:00.000+0000")
    private Date startTime;
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    @XmlElement
    @Schema(example="2013-01-01T12:00:00.000+0000")
    private Date finishTime;
    @XmlElement
    @Schema(example="true")
    private boolean success;

    public ReindexBean() {
    }

    public ReindexBean(String progressUrl, Long currentProgress, String currentSubTask, Type type, Date submittedTime, Date startTime, Date finishTime, boolean success) {
        this.progressUrl = progressUrl;
        this.currentProgress = currentProgress;
        this.currentSubTask = currentSubTask;
        this.type = type;
        this.submittedTime = submittedTime;
        this.startTime = startTime;
        this.finishTime = finishTime;
        this.success = success;
    }

    public String getProgressUrl() {
        return this.progressUrl;
    }

    public Long getCurrentProgress() {
        return this.currentProgress;
    }

    public String getCurrentSubTask() {
        return this.currentSubTask;
    }

    public Type getType() {
        return this.type;
    }

    public Date getSubmittedTime() {
        return this.submittedTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getFinishTime() {
        return this.finishTime;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public static Type fromString(String typeValue) {
        if (typeValue == null) {
            return Type.BACKGROUND_PREFERRED;
        }
        for (Type type : Type.values()) {
            if (!type.equals((Object)Type.valueOf(typeValue.toUpperCase()))) continue;
            return type;
        }
        return Type.BACKGROUND_PREFERRED;
    }

    public static ReindexBean fromTaskDescriptor(@Nonnull TaskDescriptor<IndexCommandResult> task) {
        TaskProgressEvent tpe = task.getTaskProgressIndicator().getLastProgressEvent();
        long progress = tpe != null ? tpe.getTaskProgress() : 0L;
        boolean success = task.isFinished() && ((IndexCommandResult)task.getResult()).isSuccessful();
        String currentSubTask = task.getTaskProgressIndicator().getLastProgressEvent() == null ? null : task.getTaskProgressIndicator().getLastProgressEvent().getCurrentSubTask();
        return new ReindexBean(task.getProgressURL(), progress, currentSubTask, ReindexBean.indexType(task), task.getSubmittedTimestamp(), task.getStartedTimestamp(), task.getFinishedTimestamp(), success);
    }

    public static Type indexType(@Nonnull TaskDescriptor<IndexCommandResult> task) {
        if (task.getTaskContext() instanceof ForegroundIndexTaskContext) {
            return Type.FOREGROUND;
        }
        return Type.BACKGROUND;
    }

    public static enum Type {
        FOREGROUND,
        BACKGROUND,
        BACKGROUND_PREFFERED,
        BACKGROUND_PREFERRED;

    }
}

