/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.index;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.index.ha.IndexSnapshotAsyncStartResult;
import com.atlassian.jira.index.ha.IndexSnapshotOperator;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.v2.index.IndexSnapshotBean;
import com.atlassian.jira.rest.v2.index.IndexSnapshotPromiseBean;
import com.atlassian.jira.rest.v2.index.IndexSnapshotStatusBean;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.CorsAllowed;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="index-snapshot")
@CorsAllowed
@EventComponent
@SystemAdminOnly
public class IndexSnapshotResource {
    public static final long IS_SNAPSHOT_RUNNING_RESPONSE_CACHE_TIME_IN_SECONDS = 5L;
    private final IndexSnapshotOperator indexSnapshotOperator;
    private final GlobalPermissionManager permissionManager;
    private final JiraAuthenticationContext authContext;
    private final LoadingCache<String, Boolean> indexSnapshotRunningCache;

    @Inject
    public IndexSnapshotResource(final @ComponentImport IndexSnapshotOperator indexSnapshotOperator, GlobalPermissionManager permissionManager, JiraAuthenticationContext authContext) {
        this.indexSnapshotOperator = indexSnapshotOperator;
        this.permissionManager = permissionManager;
        this.authContext = authContext;
        this.indexSnapshotRunningCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, Boolean>(){

            public Boolean load(String key) {
                return indexSnapshotOperator.isIndexSnapshotRunning();
            }
        });
    }

    @POST
    @Operation(summary="Create index snapshot if not in progress", description="Starts taking an index snapshot if no other snapshot creation process is in progress", security={@SecurityRequirement(name="basic")})
    @ApiResponses(value={@ApiResponse(description="Returns the absolute path which index snapshot will be placed in, after it's created", responseCode="202", content={@Content(schema=@Schema(implementation=IndexSnapshotPromiseBean.class))}), @ApiResponse(description="Returned if the caller doesn't have sufficient privileges", responseCode="401"), @ApiResponse(description="Returned if snapshot creation is already in progress", responseCode="409")})
    public Response createIndexSnapshot() {
        if (!this.isSysAdmin()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        IndexSnapshotAsyncStartResult result = this.indexSnapshotOperator.performIndexSnapshotBackupAndCleanupAsync();
        if (result.getStatus() == IndexSnapshotAsyncStartResult.Status.BLOCKED) {
            return Response.status((Response.Status)Response.Status.CONFLICT).cacheControl(CacheControl.never()).build();
        }
        return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)IndexSnapshotPromiseBean.of(result.getFutureSnapshotName())).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Operation(summary="Get list of available index snapshots", description="Lists available index snapshots absolute paths with timestamps", security={@SecurityRequirement(name="basic")})
    @ApiResponses(value={@ApiResponse(description="Returns the list consisting of absolute paths to currently available index snapshots", responseCode="200", content={@Content(schema=@Schema(implementation=IndexSnapshotBean.class, type="array"))}), @ApiResponse(description="Returned if the caller doesn't have sufficient privileges", responseCode="401")})
    public Response listIndexSnapshot() {
        if (!this.isSysAdmin()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        List filenames = this.indexSnapshotOperator.listIndexSnapshotFiles().stream().map(file -> IndexSnapshotBean.of(file.toPath(), file.lastModified())).collect(Collectors.toList());
        return Response.ok(filenames).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="isRunning")
    @Operation(summary="Get index snapshot creation status", description="Checks if index snapshot creation is currently running", security={@SecurityRequirement(name="basic")})
    @ApiResponses(value={@ApiResponse(description="Returns status of current snapshot creation", responseCode="200", content={@Content(schema=@Schema(implementation=IndexSnapshotStatusBean.class))}), @ApiResponse(description="Returned if the caller doesn't have sufficient privileges", responseCode="401")})
    public Response isIndexSnapshotRunning() {
        if (!this.isSysAdmin()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        boolean indexSnapshotRunning = (Boolean)this.indexSnapshotRunningCache.getUnchecked((Object)IndexSnapshotResource.class.getName());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)IndexSnapshotStatusBean.of(indexSnapshotRunning)).build();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.indexSnapshotRunningCache.invalidateAll();
    }

    private boolean isSysAdmin() {
        ApplicationUser loggedInUser = this.authContext.getLoggedInUser();
        return this.permissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, loggedInUser);
    }
}

