/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.i18n.terminology;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.i18n.terminology.TerminologyEntry;
import com.atlassian.jira.i18n.terminology.TerminologyEntryImpl;
import com.atlassian.jira.i18n.terminology.TerminologyEntryReader;
import com.atlassian.jira.i18n.terminology.TerminologyEntryWriter;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.i18n.terminology.TerminologyRequestBean;
import com.atlassian.jira.rest.v2.i18n.terminology.TerminologyResponseBean;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Path(value="terminology/entries")
@LicensedOnly
public final class TerminologyResource {
    public static final javax.ws.rs.core.CacheControl CACHE_CONTROL_NEVER = CacheControl.never();
    private final TerminologyEntryReader terminologyEntryReader;
    private final TerminologyEntryWriter terminologyEntryWriter;
    private final FeatureManager featureManager;

    @Inject
    public TerminologyResource(@ComponentImport TerminologyEntryReader terminologyEntryReader, @ComponentImport TerminologyEntryWriter terminologyEntryWriter, @ComponentImport FeatureManager featureManager) {
        this.terminologyEntryReader = terminologyEntryReader;
        this.terminologyEntryWriter = terminologyEntryWriter;
        this.featureManager = featureManager;
    }

    @GET
    @ExperimentalApi
    @Operation(summary="Get all defined names for 'epic' and 'sprint'", description="Returns a list of all defined names for the default words 'epic' and 'sprint'", security={@SecurityRequirement(name="basic")})
    @ApiResponse(description="Returns a list of all defined names for the default words 'epic' and 'sprint'", responseCode="200", content={@Content(schema=@Schema(implementation=TerminologyResponseBean.class, type="array"), mediaType="application/json")})
    public Response getAllTerminologyEntries() {
        Collection allTerminologyEntries = this.terminologyEntryReader.getAllTerminologyEntries();
        return this.constructAllTerminologyEntriesResponse(allTerminologyEntries);
    }

    private Response constructAllTerminologyEntriesResponse(Collection<TerminologyEntry> terminologyEntries) {
        List list = terminologyEntries.stream().map(TerminologyResponseBean::new).collect(Collectors.toList());
        return Response.ok(list).cacheControl(CACHE_CONTROL_NEVER).build();
    }

    @GET
    @Path(value="{originalName}")
    @ExperimentalApi
    @Operation(summary="Get epic or sprint name by original name", description="Returns epic or sprint name as specified in the {originalName} path param", security={@SecurityRequirement(name="basic")})
    @Parameter(name="originalName", description="A numeric StatusCategory id or a status category key", required=true)
    @ApiResponses(value={@ApiResponse(description="Returns epic or sprint name.", responseCode="200", content={@Content(schema=@Schema(implementation=TerminologyResponseBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if there is no epic or sprint name defined in the {originalName}.", responseCode="404")})
    public Response getTerminologyEntry(@PathParam(value="originalName") String originalName) {
        Optional terminologyEntry = this.terminologyEntryReader.getTerminologyEntry(originalName);
        if (!terminologyEntry.isPresent()) {
            return this.createErrorResponse(Response.Status.NOT_FOUND, String.format("Terminology entry not found for the %s", originalName));
        }
        TerminologyResponseBean terminologyBean = new TerminologyResponseBean((TerminologyEntry)terminologyEntry.get());
        return Response.ok((Object)terminologyBean).cacheControl(CACHE_CONTROL_NEVER).build();
    }

    @POST
    @ExperimentalApi
    @Operation(summary="Update epic/sprint names from original to new", description="Change epic/sprint names from {originalName} to {newName}. The {newName} will be displayed in Jira instead of {originalName}\n{\"originalName\"} must be equal to \"epic\" or \"sprint\".\nThere can be only one entry per unique {\"originalName\"}.\n{\"newName\"} can only consist of alphanumeric characters and spaces e.g. {\"newName\": \"iteration number 2\"}.\n{\"newName\"} must be between 1 to 100 characters.\nIt can't use the already defined {\"newName\"} values or restricted JQL words.\nTo reset {\"newName\"} to the default value, enter the {\"originalName\"} value as the value for {\"newName\"}. For example, if you want to return to {\"originalName\": \"sprint\"}, enter {\"newName\": \"sprint\"}.", security={@SecurityRequirement(name="basic")})
    @RequestBody(description="Collection of TerminologyRequestBean", required=true, content={@Content(schema=@Schema(implementation=TerminologyRequestBean.class, type="array"), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Returned if the provided data isn't valid.", responseCode="400"), @ApiResponse(description="Returned if the user doesn't have admin permissions.", responseCode="403"), @ApiResponse(description="Returned if the feature is turned off via a feature flag.", responseCode="404")})
    public Response setTerminologyEntries(Collection<TerminologyRequestBean> terminologyRequestBeans) {
        if (!this.featureManager.isEnabled(JiraFeatureFlagRegistrar.TERMINOLOGY_CHANGES)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("You cannot change terminology with the " + JiraFeatureFlagRegistrar.TERMINOLOGY_CHANGES.featureKey() + " feature flag disabled.")).build();
        }
        ServiceResultImpl oneEntryPerOriginalNameResult = this.validateOnlyOneEntryPerOriginalName(terminologyRequestBeans);
        TerminologyEntryWriter.TerminologyValidationResult validationResults = this.validateTerminologyBeans(terminologyRequestBeans);
        if (validationResults.isValid() && oneEntryPerOriginalNameResult.isValid()) {
            this.terminologyEntryWriter.changeTerminology(validationResults);
            return Response.ok().cacheControl(CACHE_CONTROL_NEVER).build();
        }
        com.atlassian.jira.util.ErrorCollection combinedErrors = validationResults.getErrorCollection();
        combinedErrors.addErrorCollection(oneEntryPerOriginalNameResult.getErrorCollection());
        return this.createErrorResponse(combinedErrors);
    }

    private ServiceResultImpl validateOnlyOneEntryPerOriginalName(Collection<TerminologyRequestBean> terminologyRequestBeans) {
        Map<String, List<TerminologyRequestBean>> originalNamesToBeans = terminologyRequestBeans.stream().collect(Collectors.groupingBy(TerminologyRequestBean::getOriginalName));
        SimpleErrorCollection errors = new SimpleErrorCollection();
        originalNamesToBeans.entrySet().stream().filter(bean -> ((List)bean.getValue()).size() > 1).forEach(arg_0 -> TerminologyResource.lambda$validateOnlyOneEntryPerOriginalName$1((com.atlassian.jira.util.ErrorCollection)errors, arg_0));
        return new ServiceResultImpl((com.atlassian.jira.util.ErrorCollection)errors);
    }

    private TerminologyEntryWriter.TerminologyValidationResult validateTerminologyBeans(Collection<TerminologyRequestBean> terminologyRequestBeans) {
        TerminologyEntryWriter.TerminologyValidationResult creationResult = this.terminologyEntryWriter.validateAndPrepareTerminologyChange((Collection)terminologyRequestBeans.stream().map(bean -> new TerminologyEntryImpl(bean.getOriginalName(), bean.getNewName(), bean.getNewNamePlural())).collect(Collectors.toList()));
        return creationResult;
    }

    private Response createErrorResponse(com.atlassian.jira.util.ErrorCollection errors) {
        ErrorCollection responseErrors = ErrorCollection.of(errors);
        return Response.status((int)responseErrors.getStatus()).entity((Object)responseErrors).cacheControl(CACHE_CONTROL_NEVER).build();
    }

    private Response createErrorResponse(Response.Status status, String message) {
        return Response.status((Response.Status)status).entity((Object)ErrorCollection.of(message)).cacheControl(CACHE_CONTROL_NEVER).build();
    }

    private static /* synthetic */ void lambda$validateOnlyOneEntryPerOriginalName$1(com.atlassian.jira.util.ErrorCollection errors, Map.Entry bean) {
        errors.addError((String)bean.getKey(), "Multiple entries found for originalName: " + (String)bean.getKey());
    }
}

