/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.i18n.terminology;

import com.atlassian.jira.i18n.terminology.TerminologyEntry;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

public final class TerminologyRequestBean {
    @JsonProperty
    @Schema(example="Epic")
    private String originalName;
    @JsonProperty
    @Schema(example="Theme")
    private String newName;
    @JsonProperty
    @Schema(example="Themes")
    private String newNamePlural;

    public TerminologyRequestBean() {
    }

    public TerminologyRequestBean(TerminologyEntry terminologyEntry) {
        this.originalName = terminologyEntry.getOriginalName();
        this.newName = terminologyEntry.getNewName();
        this.newNamePlural = terminologyEntry.getNewNamePlural();
    }

    public TerminologyRequestBean(String originalName, String newName, String newNamePlural) {
        this.originalName = originalName;
        this.newName = newName;
        this.newNamePlural = newNamePlural;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public String getNewName() {
        return this.newName;
    }

    public String getNewNamePlural() {
        return this.newNamePlural;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TerminologyRequestBean that = (TerminologyRequestBean)o;
        return Objects.equals(this.originalName, that.originalName) && Objects.equals(this.newName, that.newName) && Objects.equals(this.newNamePlural, that.newNamePlural);
    }

    public int hashCode() {
        return Objects.hash(this.originalName, this.newName, this.newNamePlural);
    }

    public String toString() {
        return "TerminologyRequestBean{originalName='" + this.originalName + "', newName='" + this.newName + "', newNamePlural='" + this.newNamePlural + "'}";
    }
}

