/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.entity.property;

import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.entity.WithKey;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.entity.property.EntityWithKeyPropertyService;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.rest.v2.entity.property.BasePropertyResource;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.inject.Inject;

public class BasePropertyWithKeyResource<E extends WithId & WithKey>
extends BasePropertyResource<E> {
    private final EntityWithKeyPropertyService<E> entityPropertyService;
    private final Predicate<String> isValidKeyPredicate;

    @Inject
    public BasePropertyWithKeyResource(EntityWithKeyPropertyService<E> entityPropertyService, JiraAuthenticationContext authContext, JiraBaseUrls jiraBaseUrls, I18nHelper i18n, Predicate<String> validKeyPredicate, BiFunction<Long, String, String> entityIdAndPropertyKeyToSelfFunction, EntityPropertyType entityPropertyType) {
        super(entityPropertyService, authContext, jiraBaseUrls, i18n, entityIdAndPropertyKeyToSelfFunction, entityPropertyType);
        this.entityPropertyService = entityPropertyService;
        this.isValidKeyPredicate = (Predicate)Preconditions.checkNotNull(validKeyPredicate);
    }

    @Override
    protected EntityPropertyService.PropertyKeys<E> getPropertiesKeys(ApplicationUser user, String idOrKey) {
        return this.withKeyValidation(idOrKey, entityKey -> this.entityPropertyService.getPropertiesKeys(user, entityKey), entityId -> this.entityPropertyService.getPropertiesKeys(user, entityId));
    }

    @Override
    protected EntityPropertyService.SetPropertyValidationResult validateSetProperty(ApplicationUser user, EntityPropertyService.PropertyInput propertyInput, String idOrKey) {
        return this.withKeyValidation(idOrKey, key -> this.entityPropertyService.validateSetProperty(user, key, propertyInput), id -> this.entityPropertyService.validateSetProperty(user, id, propertyInput));
    }

    @Override
    protected EntityPropertyService.PropertyResult getProperty(ApplicationUser user, String propertyKey, String idOrKey) {
        return this.withKeyValidation(idOrKey, key -> this.entityPropertyService.getProperty(user, key, propertyKey), id -> this.entityPropertyService.getProperty(user, id, propertyKey));
    }

    @Override
    protected EntityPropertyService.DeletePropertyValidationResult validateDeleteProperty(ApplicationUser user, String propertyKey, String id) {
        return this.withKeyValidation(id, entityKey -> this.entityPropertyService.validateDeleteProperty(user, entityKey, propertyKey), entityId -> this.entityPropertyService.validateDeleteProperty(user, entityId, propertyKey));
    }

    private <T> T withKeyValidation(String idOrKey, Function<String, T> keyFunction, Function<Long, T> idFunction) {
        if (this.isValidKeyPredicate.apply((Object)idOrKey)) {
            return keyFunction.apply(idOrKey);
        }
        return this.withIdValidation(idOrKey, idFunction);
    }
}

