/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.dashboard;

import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.dashboard.DashboardService;
import com.atlassian.gadgets.dashboard.DashboardState;
import com.atlassian.gadgets.dashboard.PermissionException;
import com.atlassian.jira.bc.dashboard.DashboardItem;
import com.atlassian.jira.bc.dashboard.DashboardItemPropertyService;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.issue.fields.rest.json.beans.EntityPropertyBean;
import com.atlassian.jira.issue.fields.rest.json.beans.EntityPropertyBeanSelfFunctions;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.entity.property.BasePropertyResource;
import com.atlassian.jira.rest.v2.entity.property.EntityPropertiesKeysBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
@Path(value="dashboard/{dashboardId}/items/{itemId}/properties")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public final class DashboardItemPropertyResource {
    private static final Logger log = LoggerFactory.getLogger(DashboardItemPropertyResource.class);
    private final BasePropertyResource<DashboardItem> delegate;
    private final DashboardService dashboardService;
    private final JiraAuthenticationContext authenticationContext;
    private final I18nHelper i18nHelper;

    @Inject
    public DashboardItemPropertyResource(DashboardItemPropertyService dashboardItemPropertyService, DashboardService dashboardService, JiraAuthenticationContext authenticationContext, JiraBaseUrls jiraBaseUrls, I18nHelper i18n, I18nHelper i18nHelper) {
        this.i18nHelper = i18nHelper;
        this.dashboardService = dashboardService;
        this.authenticationContext = authenticationContext;
        this.delegate = new BasePropertyResource(dashboardItemPropertyService, authenticationContext, jiraBaseUrls, i18n, EntityPropertyBeanSelfFunctions.EMPTY_BIFUNCTION, EntityPropertyType.DASHBOARD_ITEM_PROPERTY);
    }

    @GET
    @Operation(summary="Get all properties keys for a dashboard item", description="Returns the keys of all properties for the dashboard item identified by the id.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="dashboardId", description="The dashboard id.", in=ParameterIn.PATH, required=true), @Parameter(name="itemId", description="The dashboard item from which keys will be returned.", in=ParameterIn.PATH, required=true)})
    @ApiResponses(value={@ApiResponse(description="Returned if the dashboard item was found.", responseCode="200", content={@Content(schema=@Schema(implementation=EntityPropertiesKeysBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the dashboard item id is invalid.", responseCode="400"), @ApiResponse(description="Returned if the dashboard item with given id does not exist or user does not have permissions to view it.", responseCode="404")})
    public Response getPropertiesKeys(@PathParam(value="dashboardId") String dashboardId, @PathParam(value="itemId") String itemId) {
        return (Response)this.validateDashboardContainsItem(dashboardId, itemId).left().on(input -> this.delegate.withSelfFunction(EntityPropertyBeanSelfFunctions.dashboardItemPropertySelfBiFunction((String)dashboardId)).getPropertiesKeys(itemId));
    }

    @PUT
    @Path(value="/{propertyKey}")
    @Operation(summary="Set a property on a dashboard item", description="Sets the value of the property with a given key on the dashboard item identified by the id.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="dashboardId", description="The dashboard id.", in=ParameterIn.PATH, required=true), @Parameter(name="itemId", description="The dashboard item on which the property will be set.", in=ParameterIn.PATH, required=true), @Parameter(name="propertyKey", description="The key of the dashboard item's property. The maximum length of the key is 255 bytes.", in=ParameterIn.PATH, required=true)})
    @ApiResponses(value={@ApiResponse(description="Returned if the dashboard item property is successfully updated.", responseCode="200"), @ApiResponse(description="Returned if the dashboard item property is successfully created.", responseCode="201"), @ApiResponse(description="Returned if the dashboard item id is invalid.", responseCode="400"), @ApiResponse(description="Returned if the calling user does not have permission to administer the dashboard item.", responseCode="403"), @ApiResponse(description="Returned if the dashboard item with given id does not exist or user does not have permissions to view it.", responseCode="404")})
    public Response setProperty(@PathParam(value="dashboardId") String dashboardId, @PathParam(value="itemId") String itemId, @PathParam(value="propertyKey") String propertyKey, @Context HttpServletRequest request) {
        return (Response)this.validateDashboardContainsItem(dashboardId, itemId).left().on(input -> this.delegate.setProperty(itemId, propertyKey, request));
    }

    @GET
    @Path(value="/{propertyKey}")
    @Operation(summary="Get a property from a dashboard item", description="Returns the value of the property with a given key from the dashboard item identified by the id.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="dashboardId", description="The dashboard id.", in=ParameterIn.PATH, required=true), @Parameter(name="itemId", description="The dashboard item from which the property will be returned.", in=ParameterIn.PATH, required=true), @Parameter(name="propertyKey", description="The key of the property to return.", in=ParameterIn.PATH, required=true)})
    @ApiResponses(value={@ApiResponse(description="Returned if the dashboard item property was found.", responseCode="200", content={@Content(schema=@Schema(implementation=EntityPropertyBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the dashboard item id is invalid.", responseCode="400"), @ApiResponse(description="Returned if the dashboard item with given id does not exist or user does not have permissions to view it.", responseCode="404")})
    public Response getProperty(@PathParam(value="dashboardId") String dashboardId, @PathParam(value="itemId") String itemId, @PathParam(value="propertyKey") String propertyKey) {
        return (Response)this.validateDashboardContainsItem(dashboardId, itemId).left().on(input -> this.delegate.withSelfFunction(EntityPropertyBeanSelfFunctions.dashboardItemPropertySelfBiFunction((String)dashboardId)).getProperty(itemId, propertyKey));
    }

    @DELETE
    @Path(value="/{propertyKey}")
    @Operation(summary="Delete a property from a dashboard item", description="Removes the property from the dashboard item identified by the key or by the id.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="dashboardId", description="The dashboard id.", in=ParameterIn.PATH, required=true), @Parameter(name="itemId", description="The dashboard item from which the property will be removed.", in=ParameterIn.PATH, required=true), @Parameter(name="propertyKey", description="The key of the property to remove.", in=ParameterIn.PATH, required=true)})
    @ApiResponses(value={@ApiResponse(description="Returned if the dashboard item property was removed successfully.", responseCode="204"), @ApiResponse(description="Returned if the dashboard item id is invalid.", responseCode="400"), @ApiResponse(description="Returned if the calling user does not have permission to edit the dashboard item.", responseCode="403"), @ApiResponse(description="Returned if the dashboard item with given id does not exist or user does not have permissions to view it.", responseCode="404")})
    public Response deleteProperty(@PathParam(value="dashboardId") String dashboardId, @PathParam(value="itemId") String itemId, @PathParam(value="propertyKey") String propertyKey) {
        return (Response)this.validateDashboardContainsItem(dashboardId, itemId).left().on(input -> this.delegate.deleteProperty(itemId, propertyKey));
    }

    private Either<Response, String> validateDashboardContainsItem(String dashboardId, String itemId) {
        String userName = this.authenticationContext.getUser() != null ? this.authenticationContext.getUser().getUsername() : null;
        Either notFoundResponse = Either.left((Object)this.notFoundResponse(dashboardId, itemId));
        try {
            Option dashboardForGadget = Option.option((Object)((DashboardState)this.dashboardService.getDashboardForGadget(GadgetId.valueOf((String)itemId), userName).getOrNull()));
            if (dashboardForGadget.isEmpty() || !((DashboardState)dashboardForGadget.get()).getId().value().equals(dashboardId)) {
                return notFoundResponse;
            }
            return Either.right((Object)itemId);
        }
        catch (PermissionException ex) {
            return notFoundResponse;
        }
        catch (RuntimeException ex) {
            log.warn(String.format("unexpected exception when retrieving dashboard item %s in dashboard %s", itemId, dashboardId), (Throwable)ex);
            return notFoundResponse;
        }
    }

    private Response notFoundResponse(String dashboardId, String itemId) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorCollection.of(this.i18nHelper.getText("rest.dashboard.item.not.found", dashboardId, itemId))).build();
    }
}

