/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.cluster;

import com.atlassian.jira.cluster.Node;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public final class NodeBean {
    @JsonProperty
    private final String nodeId;
    @JsonProperty
    private final Node.NodeState state;
    @JsonProperty
    private final Long lastStateChangeTimestamp;
    @JsonProperty
    private final String ip;
    @JsonProperty
    private final Long cacheListenerPort;
    @JsonProperty
    private final Long nodeBuildNumber;
    @JsonProperty
    private final String nodeVersion;
    @JsonProperty
    private final boolean alive;

    NodeBean(Node node, boolean alive) {
        this.nodeId = node.getNodeId();
        this.state = node.getState();
        this.lastStateChangeTimestamp = node.getTimestamp();
        this.ip = node.getIp();
        this.cacheListenerPort = node.getCacheListenerPort();
        this.nodeBuildNumber = node.getNodeBuildNumber();
        this.nodeVersion = node.getNodeVersion();
        this.alive = alive;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public Node.NodeState getState() {
        return this.state;
    }

    public Long getLastStateChangeTimestamp() {
        return this.lastStateChangeTimestamp;
    }

    public String getIp() {
        return this.ip;
    }

    public Long getCacheListenerPort() {
        return this.cacheListenerPort;
    }

    public Long getNodeBuildNumber() {
        return this.nodeBuildNumber;
    }

    public String getNodeVersion() {
        return this.nodeVersion;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeBean nodeBean = (NodeBean)o;
        return this.alive == nodeBean.alive && Objects.equals(this.nodeId, nodeBean.nodeId) && this.state == nodeBean.state && Objects.equals(this.lastStateChangeTimestamp, nodeBean.lastStateChangeTimestamp) && Objects.equals(this.ip, nodeBean.ip) && Objects.equals(this.cacheListenerPort, nodeBean.cacheListenerPort) && Objects.equals(this.nodeBuildNumber, nodeBean.nodeBuildNumber) && Objects.equals(this.nodeVersion, nodeBean.nodeVersion);
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.state, this.lastStateChangeTimestamp, this.ip, this.cacheListenerPort, this.nodeBuildNumber, this.nodeVersion, this.alive);
    }

    public String toString() {
        return "NodeBean{nodeId='" + this.nodeId + "', state=" + this.state + ", lastStateChangeTimestamp=" + this.lastStateChangeTimestamp + ", ip='" + this.ip + "', cacheListenerPort=" + this.cacheListenerPort + ", nodeBuildNumber=" + this.nodeBuildNumber + ", nodeVersion='" + this.nodeVersion + "', alive=" + this.alive + "}";
    }
}

