/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.cluster;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.ClusterStateException;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.cluster.ClusterResourceEvent;
import com.atlassian.jira.rest.v2.cluster.NodeBean;
import com.atlassian.jira.rest.v2.cluster.NodeBeanCollector;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Produces(value={"application/json"})
@Path(value="cluster")
@LicensedOnly
public final class ClusterResource {
    public static final int METHOD_NOT_ALLOWED = 405;
    private final ClusterManager clusterManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final GlobalPermissionManager globalPermissionManager;
    private final I18nHelper i18n;
    private final EventPublisher eventPublisher;
    private final NodeBeanCollector nodeBeanCollector;

    @Inject
    public ClusterResource(ClusterManager clusterManager, JiraAuthenticationContext jiraAuthenticationContext, GlobalPermissionManager globalPermissionManager, I18nHelper i18n, EventPublisher eventPublisher) {
        this.clusterManager = clusterManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.globalPermissionManager = globalPermissionManager;
        this.i18n = i18n;
        this.eventPublisher = eventPublisher;
        this.nodeBeanCollector = new NodeBeanCollector(clusterManager);
    }

    @Path(value="/nodes")
    @GET
    @Operation(summary="Get all cluster nodes", description="Returns all nodes in cluster.", security={@SecurityRequirement(name="basic")})
    @ApiResponses(value={@ApiResponse(description="Returns a list of all nodes in the cluster.", responseCode="200", content={@Content(schema=@Schema(implementation=NodeBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the user doesn't have admin permissions", responseCode="401"), @ApiResponse(description="Returned if you call this method, but don't have Jira Data Center", responseCode="405")})
    public Response getAllNodes() {
        if (!this.isAdmin()) {
            return this.createErrorResponse(Response.Status.UNAUTHORIZED, "rest.settings.baseurl.permission.denied");
        }
        if (!this.clusterManager.isClustered()) {
            return this.createErrorResponse(405, "rest.error.not.clustered");
        }
        Response response = this.constructAllNodesResponse();
        this.eventPublisher.publish((Object)new ClusterResourceEvent("getAllNodes"));
        return response;
    }

    @Path(value="node/{nodeId}")
    @DELETE
    @Operation(summary="Delete a cluster node", description="Delete the node from the cluster if state of node is OFFLINE.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="nodeId", description="ID of the node to delete", in=ParameterIn.PATH, required=true)
    @ApiResponses(value={@ApiResponse(description="Removal was successful", responseCode="204"), @ApiResponse(description="Returned if the user doesn't have admin permissions", responseCode="401"), @ApiResponse(description="Returned if the node with this nodeID doesn't exist", responseCode="404"), @ApiResponse(description="Returned if you call this method, but don't have Jira Data Center", responseCode="405"), @ApiResponse(description="Returned if the server can't delete the node", responseCode="500")})
    public Response deleteNode(@PathParam(value="nodeId") String nodeId) {
        if (!this.isAdmin()) {
            return this.createErrorResponse(Response.Status.UNAUTHORIZED, "rest.settings.baseurl.permission.denied");
        }
        if (!this.clusterManager.isClustered()) {
            return this.createErrorResponse(405, "rest.error.not.clustered");
        }
        if (!this.clusterManager.isNodePresent(nodeId)) {
            return this.createErrorResponse(Response.Status.NOT_FOUND, "rest.error.node.not.found");
        }
        if (!this.clusterManager.isNodeOffline(nodeId)) {
            return this.createErrorResponse(Response.Status.BAD_REQUEST, "rest.error.node.not.valid");
        }
        try {
            this.clusterManager.removeIfOffline(nodeId);
            this.eventPublisher.publish((Object)new ClusterResourceEvent("deleteNode"));
        }
        catch (ClusterStateException e) {
            return Response.serverError().build();
        }
        return Response.ok().build();
    }

    @Path(value="index-snapshot/{nodeId}")
    @PUT
    @Operation(summary="Request node index snapshot", description="Request current index from node (the request is processed asynchronously)", security={@SecurityRequirement(name="basic")})
    @Parameter(name="nodeId", description="ID of the node to request index from", in=ParameterIn.PATH, required=true)
    @ApiResponses(value={@ApiResponse(description="Request was successful", responseCode="200"), @ApiResponse(description="Returned if the user doesn't have admin permissions", responseCode="401"), @ApiResponse(description="Returned if the node with this nodeID doesn't exist", responseCode="404"), @ApiResponse(description="Returned if you call this method, but don't have Jira Data Center", responseCode="405")})
    public Response requestCurrentIndexFromNode(@PathParam(value="nodeId") String nodeId) {
        if (!this.isAdmin()) {
            return this.createErrorResponse(Response.Status.UNAUTHORIZED, "rest.settings.baseurl.permission.denied");
        }
        if (!this.clusterManager.isClustered()) {
            return this.createErrorResponse(405, "rest.error.not.clustered");
        }
        if (!this.clusterManager.isNodePresent(nodeId)) {
            return this.createErrorResponse(Response.Status.NOT_FOUND, "rest.error.node.not.found");
        }
        try {
            this.clusterManager.requestCurrentIndexFromNode(nodeId);
            return Response.ok().build();
        }
        catch (IllegalArgumentException e) {
            return this.createErrorResponse(Response.Status.BAD_REQUEST, e.getMessage());
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)ErrorCollection.of(e.getMessage())).build();
        }
    }

    @Path(value="node/{nodeId}/offline")
    @PUT
    @Operation(summary="Update node state to offline", description="Change the node's state to offline if the node is reporting as active, but is not alive.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="nodeId", description="ID of the node to change state", in=ParameterIn.PATH, required=true)
    @ApiResponses(value={@ApiResponse(description="State change was successful", responseCode="200"), @ApiResponse(description="Returned if the user doesn't have admin permissions", responseCode="401"), @ApiResponse(description="Returned if the node with this nodeID doesn't exist", responseCode="404"), @ApiResponse(description="Returned if you call this method, but don't have Jira Data Center", responseCode="405"), @ApiResponse(description="Returned if the server can't change the node's state", responseCode="500")})
    public Response changeNodeStateToOffline(@PathParam(value="nodeId") String nodeId) {
        if (!this.isAdmin()) {
            return this.createErrorResponse(Response.Status.UNAUTHORIZED, "rest.settings.baseurl.permission.denied");
        }
        if (!this.clusterManager.isClustered()) {
            return this.createErrorResponse(405, "rest.error.not.clustered");
        }
        if (!this.clusterManager.isNodePresent(nodeId)) {
            return this.createErrorResponse(Response.Status.NOT_FOUND, "rest.error.node.not.found");
        }
        if (this.clusterManager.isNodeAlive(nodeId)) {
            return this.createErrorResponse(Response.Status.BAD_REQUEST, "rest.error.node.not.valid.only.offline");
        }
        try {
            this.clusterManager.moveToOffline(nodeId);
        }
        catch (ClusterStateException e) {
            return Response.serverError().build();
        }
        this.eventPublisher.publish((Object)new ClusterResourceEvent("changeNodeStateToOffline"));
        return Response.ok().build();
    }

    private Response createErrorResponse(Response.Status status, String msg) {
        return this.buildResponse(Response.status((Response.Status)status), msg);
    }

    private Response createErrorResponse(int status, String msg) {
        return this.buildResponse(Response.status((int)status), msg);
    }

    private Response buildResponse(Response.ResponseBuilder response, String msg) {
        return response.entity((Object)ErrorCollection.of(this.i18n.getText(msg))).cacheControl(CacheControl.never()).build();
    }

    private boolean isAdmin() {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, user);
    }

    private Response constructAllNodesResponse() {
        List<NodeBean> list = this.nodeBeanCollector.collect();
        return Response.ok(list).cacheControl(CacheControl.never()).build();
    }
}

