/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin.workflowscheme;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.admin.workflowscheme.AssignableRestWorkflowScheme;
import com.atlassian.jira.rest.v2.admin.workflowscheme.DefaultBean;
import com.atlassian.jira.rest.v2.admin.workflowscheme.DraftRestWorkflowScheme;
import com.atlassian.jira.rest.v2.admin.workflowscheme.IssueTypeMappingBean;
import com.atlassian.jira.rest.v2.admin.workflowscheme.RestWorkflowScheme;
import com.atlassian.jira.rest.v2.admin.workflowscheme.WorkflowMappingBean;
import com.atlassian.jira.rest.v2.admin.workflowscheme.WorkflowSchemeBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Function;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.net.URI;
import java.util.Collection;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="workflowscheme")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@WebSudoRequired
@AdminOnly
public class WorkflowSchemeResource {
    private final AssignableRestWorkflowScheme.Factory factory;
    private final WorkflowManager workflowManager;
    private final IssueTypeManager issueTypeManager;
    private final JiraAuthenticationContext authenticationContext;

    @Inject
    public WorkflowSchemeResource(AssignableRestWorkflowScheme.Factory factory, WorkflowManager workflowManager, IssueTypeManager issueTypeManager, JiraAuthenticationContext authenticationContext) {
        this.factory = factory;
        this.workflowManager = workflowManager;
        this.issueTypeManager = issueTypeManager;
        this.authenticationContext = authenticationContext;
    }

    @GET
    @Path(value="{id}")
    @Operation(summary="Get requested workflow scheme by ID", description="Returns the requested workflow scheme to the caller.")
    @Parameters(value={@Parameter(name="id", description="The id of the scheme.", required=true), @Parameter(name="returnDraftIfExists", description="When true indicates that a scheme's draft, if it exists, should be queried instead of the scheme itself.", required=false)})
    @ApiResponses(value={@ApiResponse(description="Returned if the scheme exists and the caller has permission to see it.", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorkflowSchemeBean.class))}), @ApiResponse(description="Returned if there is no user or if the user has not entered a websudo session.", responseCode="401"), @ApiResponse(description="Returned if the requested scheme does not exist.", responseCode="404")})
    public Response getById(@PathParam(value="id") long id, @QueryParam(value="returnDraftIfExists") @DefaultValue(value="false") boolean returnDraftIfExists) {
        return this.withScheme(id, this.draftMaybe(returnDraftIfExists, (Function<RestWorkflowScheme, Response>)((Function)input -> WorkflowSchemeResource.responseOk(input.asBean()))));
    }

    @POST
    @Operation(summary="Create a new workflow scheme", description="Create a new workflow scheme. The body contains a representation of the new scheme. Values not passed are assumed to be set to their defaults.")
    @RequestBody(description="The body contains a representation of the new scheme. Values not passed are assumed to be set to their defaults.", required=true, content={@Content(schema=@Schema(implementation=WorkflowSchemeBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="The newly created scheme.", responseCode="201"), @ApiResponse(description="Returned if there is no user or if the user has not entered a websudo session.", responseCode="401")})
    public Response createScheme(WorkflowSchemeBean bean) {
        ServiceOutcome<AssignableRestWorkflowScheme> outcome = this.factory.create(bean);
        if (outcome.isValid()) {
            return WorkflowSchemeResource.responseCreated(((AssignableRestWorkflowScheme)outcome.getReturnedValue()).asBean());
        }
        return WorkflowSchemeResource.responseError(outcome);
    }

    @DELETE
    @Path(value="{id}")
    @Operation(summary="Delete the specified workflow scheme", description="Delete the passed workflow scheme.")
    @Parameter(name="id", description="The id of the scheme.", required=true)
    @ApiResponses(value={@ApiResponse(description="If the scheme was deleted.", responseCode="204"), @ApiResponse(description="Returned if the requested scheme is active (i.e. being used by Jira).", responseCode="400"), @ApiResponse(description="Returned if there is no user or if the user has not entered a websudo session.", responseCode="401"), @ApiResponse(description="Returned if the requested scheme does not exist.", responseCode="404")})
    public Response deleteScheme(@PathParam(value="id") long id) {
        ServiceOutcome<AssignableRestWorkflowScheme> outcome = this.factory.getById(id);
        if (!outcome.isValid()) {
            return WorkflowSchemeResource.responseError(outcome);
        }
        return WorkflowSchemeResource.response(((AssignableRestWorkflowScheme)outcome.getReturnedValue()).delete());
    }

    @PUT
    @Path(value="{id}")
    @Operation(summary="Update a specified workflow scheme", description="Update the passed workflow scheme. The body of the request is a representation of the workflow scheme. Values not passed are assumed to indicate no change for that field.\nThe passed representation can have its updateDraftIfNeeded flag set to true to indicate that the draft\nshould be created and/or updated when the actual scheme cannot be edited (e.g. when the scheme is being used by\na project). Values not appearing the body will not be touched.")
    @Parameter(name="id", description="The id of the scheme.", required=true)
    @RequestBody(description="The body of the request is a representation of the workflow scheme. Values not passed are assumed to indicate no change for that field.", required=true, content={@Content(schema=@Schema(implementation=WorkflowSchemeBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="The updated scheme.", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorkflowSchemeBean.class))}), @ApiResponse(description="Returned if there is no user or if the user has not entered a websudo session.", responseCode="401"), @ApiResponse(description="Returned if the requested scheme does not exist.", responseCode="404")})
    public Response update(@PathParam(value="id") long id, WorkflowSchemeBean bean) {
        return this.withScheme(id, this.buildResponse(input -> input.update(bean)));
    }

    @GET
    @Path(value="{id}/draft")
    @Operation(summary="Get requested draft workflow scheme by ID", description="Returns the requested draft workflow scheme to the caller.")
    @Parameter(name="id", description="The id of the parent scheme.", required=true)
    @ApiResponses(value={@ApiResponse(description="Returned if the scheme exists and the caller has permission to see it.", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorkflowSchemeBean.class))}), @ApiResponse(description="Returned if there is no user or if the user has not entered a websudo session.", responseCode="401"), @ApiResponse(description="Returned if the requested draft scheme does not exist.", responseCode="404")})
    public Response getDraftById(@PathParam(value="id") long id) {
        return this.withDraft(id, (Function<? super DraftRestWorkflowScheme, Response>)((Function)input -> WorkflowSchemeResource.responseOk(input.asBean())));
    }

    @DELETE
    @Path(value="{id}/draft")
    @Operation(summary="Delete the specified draft workflow scheme", description="Delete the passed draft workflow scheme.")
    @Parameter(name="id", description="The id of the parent scheme.", required=true)
    @ApiResponses(value={@ApiResponse(description="If the scheme was deleted.", responseCode="204"), @ApiResponse(description="Returned if there is no user or if the user has not entered a websudo session.", responseCode="401"), @ApiResponse(description="Returned if the requested draft scheme or parent scheme does not exist.", responseCode="404")})
    public Response deleteDraftById(@PathParam(value="id") long id) {
        return this.withDraft(id, (Function<? super DraftRestWorkflowScheme, Response>)((Function)input -> WorkflowSchemeResource.response(input.delete())));
    }

    @POST
    @Path(value="{id}/createdraft")
    @Operation(summary="Create a draft for a workflow scheme", description="Create a draft for the passed scheme. The draft will be a copy of the state of the parent.")
    @Parameter(name="id", description="The id of the parent scheme.", required=true)
    @ApiResponses(value={@ApiResponse(description="The newly created scheme.", responseCode="201", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorkflowSchemeBean.class))}), @ApiResponse(description="Returned if there is no user or if the user has not entered a websudo session.", responseCode="401"), @ApiResponse(description="Returned if the requested scheme does not exist.", responseCode="404")})
    public Response createDraftForParent(@PathParam(value="id") long id) {
        ServiceOutcome<AssignableRestWorkflowScheme> outcome = this.factory.getById(id);
        if (!outcome.isValid()) {
            return WorkflowSchemeResource.responseError(outcome);
        }
        ServiceOutcome<DraftRestWorkflowScheme> draftOutcome = ((AssignableRestWorkflowScheme)outcome.getReturnedValue()).createDraftScheme();
        if (!draftOutcome.isValid()) {
            return WorkflowSchemeResource.responseError(draftOutcome);
        }
        return WorkflowSchemeResource.responseCreated(((DraftRestWorkflowScheme)draftOutcome.getReturnedValue()).asBean());
    }

    @PUT
    @Path(value="{id}/draft")
    @Operation(summary="Update a draft workflow scheme", description="Update a draft workflow scheme. The draft will created if necessary. The body of the request is a representation of the workflow scheme. Values not passed are assumed to indicate no change for that field.")
    @Parameter(name="id", description="The id of the parent scheme.", required=true)
    @RequestBody(description="The body of the request is a representation of the workflow scheme. Values not passed are assumed to indicate no change for that field.", required=true, content={@Content(schema=@Schema(implementation=WorkflowSchemeBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="The updated/created scheme.", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorkflowSchemeBean.class))}), @ApiResponse(description="Returned if there is no user or if the user has not entered a websudo session.", responseCode="401"), @ApiResponse(description="Returned if the requested scheme does not exist.", responseCode="404")})
    public Response updateDraft(@PathParam(value="id") long id, WorkflowSchemeBean bean) {
        return this.withScheme(id, this.buildResponse(input -> input.updateDraft(bean)));
    }

    @GET
    @Path(value="{id}/workflow")
    @Operation(summary="Get workflow mappings for a scheme", description="Returns the workflow mappings or requested mapping to the caller for the passed scheme.")
    @Parameters(value={@Parameter(name="id", description="The id of the scheme.", required=true), @Parameter(name="returnDraftIfExists", description="When true indicates that a scheme's draft, if it exists, should be queried instead of the scheme itself."), @Parameter(name="workflowName", description="The workflow mapping to return. Null can be passed to return all mappings. Must be a valid workflow name.")})
    @ApiResponses(value={@ApiResponse(description="Returned on success.", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorkflowSchemeBean.class))}), @ApiResponse(description="Returned if there is no user or if the user has not entered a websudo session.", responseCode="401"), @ApiResponse(description="Returned if either the requested scheme or workflow does not exist.", responseCode="404")})
    public Response getWorkflow(@PathParam(value="id") long id, @QueryParam(value="workflowName") String workflowName, @QueryParam(value="returnDraftIfExists") @DefaultValue(value="false") boolean returnDraftIfExists) {
        return this.withScheme(id, this.checkWorkflow(workflowName, true, this.draftMaybe(returnDraftIfExists, (Function<RestWorkflowScheme, Response>)((Function)input -> WorkflowSchemeResource.responseOk(workflowName == null ? input.asWorkflowBeans() : input.asWorkflowBean(workflowName))))));
    }

    @GET
    @Path(value="{id}/draft/workflow")
    @Operation(summary="Get draft workflow mappings", description="Returns the draft workflow mappings or requested mapping to the caller.")
    @Parameters(value={@Parameter(name="id", description="The id of the parent scheme.", required=true), @Parameter(name="workflowName", description="The workflow mapping to return. Null can be passed to return all mappings. Must be a valid workflow name.")})
    @ApiResponses(value={@ApiResponse(description="Returned on success.", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorkflowSchemeBean.class))}), @ApiResponse(description="Returned if there is no user or if the user has not entered a websudo session.", responseCode="401"), @ApiResponse(description="Returned if either the requested scheme or workflow does not exist.", responseCode="404")})
    public Response getDraftWorkflow(@PathParam(value="id") long id, @QueryParam(value="workflowName") String workflowName) {
        return this.withDraft(id, this.checkWorkflow(workflowName, true, input -> WorkflowSchemeResource.responseOk(workflowName == null ? input.asWorkflowBeans() : input.asWorkflowBean(workflowName))));
    }

    @DELETE
    @Path(value="{id}/workflow")
    @Operation(summary="Delete a workflow mapping from a scheme", description="Delete the passed workflow from the workflow scheme.")
    @Parameters(value={@Parameter(name="id", description="The id of the scheme.", required=true), @Parameter(name="workflowName", description="The name of the workflow to delete.", required=true), @Parameter(name="updateDraftIfNeeded", description="Flag to indicate if a draft should be created if necessary to delete the workflow from the scheme.", required=true)})
    @ApiResponses(value={@ApiResponse(description="The scheme with the workflow deleted.", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorkflowSchemeBean.class))}), @ApiResponse(description="Returned if there is no user or if the user has not entered a websudo session.", responseCode="401"), @ApiResponse(description="Returned if the requested scheme or workflow does not exist.", responseCode="404")})
    public Response deleteWorkflowMapping(@PathParam(value="id") long id, @QueryParam(value="workflowName") String workflowName, @QueryParam(value="updateDraftIfNeeded") boolean updateDraftIfNeeded) {
        return this.withScheme(id, this.checkWorkflow(workflowName, false, this.buildResponse(input -> input.deleteWorkflow(workflowName, updateDraftIfNeeded))));
    }

    @DELETE
    @Path(value="{id}/draft/workflow")
    @Operation(summary="Delete a workflow mapping from a draft scheme", description="Delete the passed workflow from the draft workflow scheme.")
    @Parameters(value={@Parameter(name="id", description="The id of the parent scheme.", required=true), @Parameter(name="workflowName", description="The name of the workflow to delete.", required=true)})
    @ApiResponses(value={@ApiResponse(description="The scheme with the workflow deleted.", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorkflowSchemeBean.class))}), @ApiResponse(description="Returned if there is no user or if the user has not entered a websudo session.", responseCode="401"), @ApiResponse(description="Returned if the requested scheme or workflow does not exist.", responseCode="404")})
    public Response deleteDraftWorkflowMapping(@PathParam(value="id") long id, @QueryParam(value="workflowName") String workflowName) {
        return this.withDraft(id, this.checkWorkflow(workflowName, false, this.buildResponse(input -> input.deleteWorkflow(workflowName))));
    }

    @PUT
    @Path(value="{id}/workflow")
    @Operation(summary="Update a workflow mapping in a scheme", description="Update the scheme to include the passed mapping. The body is a representation of the workflow mapping. Values not passed are assumed to indicate no change for that field.\nThe passed representation can have its updateDraftIfNeeded flag set to true to indicate that the draft\nshould be created/updated when the actual scheme cannot be edited.")
    @Parameters(value={@Parameter(name="id", description="The id of the scheme.", required=true), @Parameter(name="workflowName", description="The name of the workflow mapping to update.", required=true)})
    @RequestBody(description="The body is a representation of the workflow mapping. Values not passed are assumed to indicate no change for that field.", required=true, content={@Content(schema=@Schema(implementation=WorkflowMappingBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="The updated scheme.", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorkflowSchemeBean.class))}), @ApiResponse(description="Returned if there is no user or if the user has not entered a websudo session.", responseCode="401")})
    public Response updateWorkflowMapping(@PathParam(value="id") long id, @QueryParam(value="workflowName") String workflowName, WorkflowMappingBean updateBean) {
        return this.withScheme(id, this.checkWorkflow(workflowName, false, this.buildResponse(input -> {
            updateBean.setWorkflow(workflowName);
            return input.updateWorkflowMappings(updateBean);
        })));
    }

    @PUT
    @Path(value="{id}/draft/workflow")
    @Operation(summary="Update a workflow mapping in a draft scheme", description="Update the draft scheme to include the passed mapping. The body is a representation of the workflow mapping. Values not passed are assumed to indicate no change for that field.")
    @Parameters(value={@Parameter(name="id", description="The id of the parent scheme.", required=true), @Parameter(name="workflowName", description="The name of the workflow mapping to update.", required=true)})
    @RequestBody(description="The body is a representation of the workflow mapping. Values not passed are assumed to indicate no change for that field.", required=true, content={@Content(schema=@Schema(implementation=WorkflowMappingBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="The updated scheme.", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorkflowSchemeBean.class))}), @ApiResponse(description="Returned if there is no user or if the user has not entered a websudo session.", responseCode="401")})
    public Response updateDraftWorkflowMapping(@PathParam(value="id") long id, @QueryParam(value="workflowName") String workflowName, WorkflowMappingBean updateBean) {
        return this.withDraft(id, this.checkWorkflow(workflowName, false, this.buildResponse(input -> {
            updateBean.setWorkflow(workflowName);
            return input.updateWorkflowMappings(updateBean);
        })));
    }

    @GET
    @Path(value="{id}/issuetype/{issueType}")
    @Operation(summary="Get issue type mapping for a scheme", description="Returns the issue type mapping for the passed workflow scheme.")
    @Parameters(value={@Parameter(name="id", description="The id of the scheme.", required=true), @Parameter(name="returnDraftIfExists", description="When true indicates that a scheme's draft, if it exists, should be queried instead of the scheme itself."), @Parameter(name="issueType", description="The issue type to query.", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returned on success.", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=IssueTypeMappingBean.class))}), @ApiResponse(description="Returned if there is no user or if the user has not entered a websudo session.", responseCode="401"), @ApiResponse(description="Returned if either the requested scheme or issue type does not exist.", responseCode="404")})
    public Response getIssueType(@PathParam(value="id") long id, @PathParam(value="issueType") String issueType, @QueryParam(value="returnDraftIfExists") @DefaultValue(value="false") boolean returnDraftIfExists) {
        return this.withScheme(id, this.checkIssueType(issueType, this.draftMaybe(returnDraftIfExists, (Function<RestWorkflowScheme, Response>)((Function)input -> WorkflowSchemeResource.responseOk(input.asIssueTypeBean(issueType))))));
    }

    @GET
    @Path(value="{id}/draft/issuetype/{issueType}")
    @Operation(summary="Get issue type mapping for a draft scheme", description="Returns the issue type mapping for the passed draft workflow scheme.")
    @Parameters(value={@Parameter(name="id", description="The id of the parent scheme.", required=true), @Parameter(name="issueType", description="The issue type to query.", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returned on success.", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=IssueTypeMappingBean.class))}), @ApiResponse(description="Returned if there is no user or if the user has not entered a websudo session.", responseCode="401"), @ApiResponse(description="Returned if either the requested scheme or issue type does not exist.", responseCode="404")})
    public Response getDraftIssueType(@PathParam(value="id") long id, @PathParam(value="issueType") String issueType) {
        return this.withDraft(id, this.checkIssueType(issueType, input -> WorkflowSchemeResource.responseOk(input.asIssueTypeBean(issueType))));
    }

    @DELETE
    @Path(value="{id}/issuetype/{issueType}")
    @Operation(summary="Delete an issue type mapping from a scheme", description="Remove the specified issue type mapping from the scheme.")
    @Parameters(value={@Parameter(name="id", description="The id of the scheme.", required=true), @Parameter(name="issueType", description="The issue type to remove.", required=true), @Parameter(name="updateDraftIfNeeded", description="When true will create and return a draft when the workflow scheme cannot be edited (e.g. when it is being used by a project).", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returned on success.", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorkflowSchemeBean.class))}), @ApiResponse(description="Returned if there is no user or if the user has not entered a websudo session.", responseCode="401"), @ApiResponse(description="Returned if either the requested scheme or issue type does not exist.", responseCode="404")})
    public Response deleteIssueType(@PathParam(value="id") long id, @PathParam(value="issueType") String issueType, @QueryParam(value="updateDraftIfNeeded") boolean updateDraftIfNeeded) {
        return this.withScheme(id, this.checkIssueType(issueType, this.buildResponse(input -> input.removeIssueType(issueType, updateDraftIfNeeded))));
    }

    @DELETE
    @Path(value="{id}/draft/issuetype/{issueType}")
    @Operation(summary="Delete an issue type mapping from a draft scheme", description="Remove the specified issue type mapping from the draft scheme.")
    @Parameters(value={@Parameter(name="id", description="The parent of the draft scheme.", required=true), @Parameter(name="issueType", description="The issue type to remove.", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returned on success.", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorkflowSchemeBean.class))}), @ApiResponse(description="Returned if either the requested scheme or issue type does not exist.", responseCode="404"), @ApiResponse(description="Returned if there is no user or if the user has not entered a websudo session.", responseCode="401")})
    public Response deleteDraftIssueType(@PathParam(value="id") long id, @PathParam(value="issueType") String issueType) {
        return this.withDraft(id, this.checkIssueType(issueType, this.buildResponse(input -> input.removeIssueType(issueType))));
    }

    @PUT
    @Path(value="{id}/issuetype/{issueType}")
    @Operation(summary="Set an issue type mapping for a scheme", description="Set the issue type mapping for the passed scheme. The passed representation can have its updateDraftIfNeeded flag set to true to indicate that\nthe draft should be created/updated when the actual scheme cannot be edited.")
    @Parameters(value={@Parameter(name="id", description="The id of the scheme.", required=true), @Parameter(name="issueType", description="The issue type being set.", required=true)})
    @RequestBody(description="The new mapping for the issue type.", required=true, content={@Content(schema=@Schema(implementation=IssueTypeMappingBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Returned on success.", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorkflowSchemeBean.class))}), @ApiResponse(description="Returned if there is no user or if the user has not entered a websudo session.", responseCode="401"), @ApiResponse(description="Returned if either the requested scheme or issue type does not exist.", responseCode="404")})
    public Response setIssueType(@PathParam(value="id") long id, @PathParam(value="issueType") String issueType, IssueTypeMappingBean mappingBean) {
        return this.withScheme(id, this.checkIssueType(issueType, this.buildResponse(input -> {
            mappingBean.setIssueType(issueType);
            return input.updateIssueTypeMappings(mappingBean);
        })));
    }

    @PUT
    @Path(value="{id}/draft/issuetype/{issueType}")
    @Operation(summary="Set an issue type mapping for a draft scheme", description="Set the issue type mapping for the passed draft scheme. The passed representation can have its updateDraftIfNeeded flag set to true to indicate that\nthe draft should be created/updated when the actual scheme cannot be edited.")
    @Parameters(value={@Parameter(name="id", description="The id of the parent scheme.", required=true), @Parameter(name="issueType", description="The issue type being set.", required=true)})
    @RequestBody(description="The new mapping for the issue type.", required=true, content={@Content(schema=@Schema(implementation=IssueTypeMappingBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Returned on success.", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorkflowSchemeBean.class))}), @ApiResponse(description="Returned if there is no user or if the user has not entered a websudo session.", responseCode="401"), @ApiResponse(description="Returned if either the requested scheme or issue type does not exist.", responseCode="404")})
    public Response setDraftIssueType(@PathParam(value="id") long id, @PathParam(value="issueType") String issueType, IssueTypeMappingBean mappingBean) {
        return this.withDraft(id, this.checkIssueType(issueType, this.buildResponse(input -> {
            mappingBean.setIssueType(issueType);
            return input.updateIssueTypeMappings(mappingBean);
        })));
    }

    @GET
    @Path(value="{id}/default")
    @Operation(summary="Get default workflow for a scheme", description="Return the default workflow from the passed workflow scheme.")
    @Parameters(value={@Parameter(name="id", description="The id of the scheme.", required=true), @Parameter(name="returnDraftIfExists", description="When true indicates that a scheme's draft, if it exists, should be queried instead of the scheme itself.")})
    @ApiResponses(value={@ApiResponse(description="Returned on success.", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorkflowSchemeBean.class))}), @ApiResponse(description="Returned if there is no user or if the user has not entered a websudo session.", responseCode="401"), @ApiResponse(description="Returned if the workflow scheme does not exist.", responseCode="404")})
    public Response getDefault(@PathParam(value="id") long id, @QueryParam(value="returnDraftIfExists") @DefaultValue(value="false") boolean returnDraftIfExists) {
        return this.withScheme(id, this.draftMaybe(returnDraftIfExists, (Function<RestWorkflowScheme, Response>)((Function)input -> WorkflowSchemeResource.responseOk(input.asDefaultBean()))));
    }

    @GET
    @Path(value="{id}/draft/default")
    @Operation(summary="Get default workflow for a draft scheme", description="Return the default workflow from the passed draft workflow scheme to the caller.")
    @Parameter(name="id", description="The id of the parent scheme.", required=true)
    @ApiResponses(value={@ApiResponse(description="Returned on success.", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorkflowSchemeBean.class))}), @ApiResponse(description="Returned if there is no user or if the user has not entered a websudo session.", responseCode="401"), @ApiResponse(description="Returned if the workflow scheme does not exist.", responseCode="404")})
    public Response getDraftDefault(@PathParam(value="id") long id) {
        return this.withDraft(id, (Function<? super DraftRestWorkflowScheme, Response>)((Function)input -> WorkflowSchemeResource.responseOk(input.asDefaultBean())));
    }

    @DELETE
    @Path(value="{id}/default")
    @Operation(summary="Remove default workflow from a scheme", description="Remove the default workflow from the passed workflow scheme.")
    @Parameters(value={@Parameter(name="id", description="The id of the scheme.", required=true), @Parameter(name="updateDraftIfNeeded", description="When true will create and return a draft when the workflow scheme cannot be edited (e.g. when it is being used by a project).", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returned on success.", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorkflowSchemeBean.class))}), @ApiResponse(description="Returned if there is no user or if the user has not entered a websudo session.", responseCode="401"), @ApiResponse(description="Returned if the scheme does not exist.", responseCode="404")})
    public Response deleteDefault(@PathParam(value="id") long id, @QueryParam(value="updateDraftIfNeeded") boolean updateDraftIfNeeded) {
        return this.withScheme(id, this.buildResponse(input -> input.removeDefault(updateDraftIfNeeded)));
    }

    @DELETE
    @Path(value="{id}/draft/default")
    @Operation(summary="Remove default workflow from a draft scheme", description="Remove the default workflow from the passed draft workflow scheme.")
    @Parameter(name="id", description="The id of the parent scheme.", required=true)
    @ApiResponses(value={@ApiResponse(description="Returned on success.", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorkflowSchemeBean.class))}), @ApiResponse(description="Returned if there is no user or if the user has not entered a websudo session.", responseCode="401"), @ApiResponse(description="Returned if the scheme does not exist.", responseCode="404")})
    public Response deleteDraftDefault(@PathParam(value="id") long id) {
        return this.withDraft(id, this.buildResponse(DraftRestWorkflowScheme::removeDefault));
    }

    @PUT
    @Path(value="{id}/default")
    @Operation(summary="Update default workflow for a scheme", description="Set the default workflow for the passed workflow scheme. The passed representation can have its\nupdateDraftIfNeeded flag set to true to indicate that the draft should be created/updated when the actual scheme\ncannot be edited.")
    @Parameter(name="id", description="The id of the scheme.", required=true)
    @RequestBody(description="The new default.", required=true, content={@Content(schema=@Schema(implementation=DefaultBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Returned on success.", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorkflowSchemeBean.class))}), @ApiResponse(description="Returned if there is no user or if the user has not entered a websudo session.", responseCode="401"), @ApiResponse(description="Returned if the scheme does not exist.", responseCode="404")})
    public Response updateDefault(@PathParam(value="id") long id, DefaultBean bean) {
        return this.withScheme(id, this.buildResponse(input -> input.updateDefault(bean)));
    }

    @PUT
    @Path(value="{id}/draft/default")
    @Operation(summary="Update default workflow for a draft scheme", description="Set the default workflow for the passed draft workflow scheme.")
    @Parameter(name="id", description="The id of the parent scheme.", required=true)
    @RequestBody(description="The new default.", required=true, content={@Content(schema=@Schema(implementation=DefaultBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Returned on success.", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorkflowSchemeBean.class))}), @ApiResponse(description="Returned if there is no user or if the user has not entered a websudo session.", responseCode="401"), @ApiResponse(description="Returned if the scheme does not exist.", responseCode="404")})
    public Response updateDraftDefault(@PathParam(value="id") long id, DefaultBean bean) {
        return this.withDraft(id, this.buildResponse(input -> input.updateDefault(bean)));
    }

    private static Response response(ServiceOutcome<?> outcome) {
        if (outcome.isValid()) {
            if (outcome.getReturnedValue() == null) {
                return WorkflowSchemeResource.responseNoContent();
            }
            return WorkflowSchemeResource.responseOk(outcome.getReturnedValue());
        }
        return WorkflowSchemeResource.responseError(outcome);
    }

    private static Response responseNoContent() {
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    private static Response responseOk(Object entity) {
        return Response.ok((Object)entity).cacheControl(CacheControl.never()).build();
    }

    private static Response responseCreated(WorkflowSchemeBean entity) {
        return Response.created((URI)entity.getSelf()).entity((Object)entity).cacheControl(CacheControl.never()).build();
    }

    private static Response responseError(ServiceOutcome<?> outcome) {
        com.atlassian.jira.util.ErrorCollection errorCollection = outcome.getErrorCollection();
        ErrorCollection.Reason reason = ErrorCollection.Reason.getWorstReason((Collection)errorCollection.getReasons());
        if (reason == null) {
            reason = ErrorCollection.Reason.SERVER_ERROR;
        }
        return Response.status((int)reason.getHttpStatusCode()).entity((Object)ErrorCollection.of(errorCollection)).cacheControl(CacheControl.never()).build();
    }

    private Response responseError(Response.Status reason, String key, Object ... args) {
        String msg = this.authenticationContext.getI18nHelper().getText(key, (Object)args);
        return Response.status((Response.Status)reason).entity((Object)ErrorCollection.of(msg)).cacheControl(CacheControl.never()).build();
    }

    private Response withScheme(long id, Function<? super AssignableRestWorkflowScheme, Response> function) {
        ServiceOutcome<AssignableRestWorkflowScheme> outcome = this.factory.getById(id);
        if (!outcome.isValid()) {
            return WorkflowSchemeResource.responseError(outcome);
        }
        return (Response)function.apply(outcome.getReturnedValue());
    }

    private Response withDraft(long parentId, Function<? super DraftRestWorkflowScheme, Response> function) {
        ServiceOutcome<AssignableRestWorkflowScheme> outcome = this.factory.getById(parentId);
        if (!outcome.isValid()) {
            return WorkflowSchemeResource.responseError(outcome);
        }
        ServiceOutcome<DraftRestWorkflowScheme> draftOutcome = ((AssignableRestWorkflowScheme)outcome.getReturnedValue()).getDraftScheme();
        if (!draftOutcome.isValid()) {
            return WorkflowSchemeResource.responseError(draftOutcome);
        }
        return (Response)function.apply(draftOutcome.getReturnedValue());
    }

    private <I> Function<I, Response> checkIssueType(String issueType, Function<I, Response> function) {
        return input -> {
            if (issueType == null || this.issueTypeManager.getIssueType(issueType) == null) {
                return this.responseError(Response.Status.NOT_FOUND, "rest.error.workflowscheme.issuetype.does.not.exist", issueType);
            }
            return (Response)function.apply(input);
        };
    }

    private <I> Function<I, Response> checkWorkflow(String workflow, boolean allowNull, Function<I, Response> function) {
        return input -> {
            if (workflow == null) {
                if (!allowNull) {
                    return this.responseError(Response.Status.NOT_FOUND, "rest.error.workflowscheme.workflow.not.passed", workflow);
                }
            } else if (this.workflowManager.getWorkflow(workflow) == null) {
                return this.responseError(Response.Status.NOT_FOUND, "rest.error.workflowscheme.workflow.does.not.exist", workflow);
            }
            return (Response)function.apply(input);
        };
    }

    private <I> Function<I, Response> buildResponse(Function<I, ServiceOutcome<? extends RestWorkflowScheme>> function) {
        return input -> {
            ServiceOutcome outcome = (ServiceOutcome)function.apply(input);
            if (outcome.isValid()) {
                return WorkflowSchemeResource.responseOk(((RestWorkflowScheme)outcome.getReturnedValue()).asBean());
            }
            return WorkflowSchemeResource.responseError(outcome);
        };
    }

    private Function<AssignableRestWorkflowScheme, Response> draftMaybe(boolean draft, Function<RestWorkflowScheme, Response> function) {
        return input -> {
            if (draft) {
                return (Response)function.apply((Object)input.getDraftMaybe());
            }
            return (Response)function.apply(input);
        };
    }
}

