/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin.workflowscheme;

import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeJsonBean;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.google.common.collect.Maps;
import io.swagger.v3.oas.annotations.media.Schema;
import java.net.URI;
import java.util.Map;

public class WorkflowSchemeBean {
    @JsonProperty
    @Schema(example="10000")
    private Long id;
    @JsonProperty
    @Schema(example="My Workflow Scheme")
    private String name;
    @JsonProperty
    @Schema(example="This is a workflow scheme")
    private String description;
    @JsonProperty
    @Schema(example="DefaultWorkflowName")
    private String defaultWorkflow;
    @JsonProperty
    @Schema(example="{\"IsueTypeId\":\"WorkflowName\",\"IsueTypeId2\":\"WorkflowName\"}")
    private Map<String, String> issueTypeMappings;
    @JsonProperty
    @Schema(example="ParentsDefaultWorkflowName")
    private String originalDefaultWorkflow;
    @JsonProperty
    @Schema(example="{\"IssueTypeId\":\"WorkflowName2\"}")
    private Map<String, String> originalIssueTypeMappings;
    @JsonProperty
    @Schema(example="false")
    private Boolean draft;
    @JsonProperty
    private UserBean lastModifiedUser;
    @JsonProperty
    @Schema(example="Today 12:45")
    private String lastModified;
    @JsonProperty
    @Schema(example="http://www.example.com/jira/rest/api/2/workflowscheme/10000")
    private URI self;
    @JsonProperty
    @Schema(example="true")
    private Boolean updateDraftIfNeeded;
    @JsonProperty
    @Schema(example="{\"IsueTypeId\":{\"name\":\"IssueTypeName\",\"description\":\"IssueTypeDescription\"}}")
    private Map<String, IssueTypeJsonBean> issueTypes;
    @JsonIgnore
    @Schema(example="false")
    private boolean nameSet;
    @JsonIgnore
    @Schema(example="false")
    private boolean descriptionSet;
    @JsonIgnore
    @Schema(example="false")
    private boolean defaultSet;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDefaultWorkflow() {
        return this.defaultWorkflow;
    }

    public void setDefaultWorkflow(String defaultWorkflow) {
        this.defaultSet = true;
        this.defaultWorkflow = defaultWorkflow;
    }

    @JsonSetter(value="defaultWorkflow")
    public void setDefaultWorkflowJson(String defaultWorkflow) {
        this.defaultSet = defaultWorkflow != null;
        this.defaultWorkflow = defaultWorkflow;
    }

    public String getDescription() {
        return this.description;
    }

    @JsonSetter(value="description")
    public void setDescription(String description) {
        this.descriptionSet = description != null;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    @JsonSetter(value="name")
    public void setName(String name) {
        this.nameSet = name != null;
        this.name = name;
    }

    public URI getSelf() {
        return this.self;
    }

    public void setSelf(URI self) {
        this.self = self;
    }

    public Boolean isDraft() {
        return this.draft;
    }

    public void setDraft(Boolean draft) {
        this.draft = draft;
    }

    public void setLastModifiedUser(UserBean lastModifiedUser) {
        this.lastModifiedUser = lastModifiedUser;
    }

    public UserBean getLastModifiedUser() {
        return this.lastModifiedUser;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public Boolean isUpdateDraftIfNeeded() {
        return this.updateDraftIfNeeded;
    }

    public void setUpdateDraftIfNeeded(Boolean createDraftIfNeeded) {
        this.updateDraftIfNeeded = createDraftIfNeeded;
    }

    public boolean isDefaultSet() {
        return this.defaultSet;
    }

    public boolean isDescriptionSet() {
        return this.descriptionSet;
    }

    public boolean isNameSet() {
        return this.nameSet;
    }

    public String getOriginalDefaultWorkflow() {
        return this.originalDefaultWorkflow;
    }

    public void setOriginalDefaultWorkflow(String originalDefaultWorkflow) {
        this.originalDefaultWorkflow = originalDefaultWorkflow;
    }

    public Map<String, String> getIssueTypeMappings() {
        return this.issueTypeMappings;
    }

    public void setIssueTypeMappings(Map<String, String> issueTypeMappings) {
        this.issueTypeMappings = issueTypeMappings;
    }

    public Map<String, String> getOriginalIssueTypeMappings() {
        return this.originalIssueTypeMappings;
    }

    public void setOriginalIssueTypeMappings(Map<String, String> originalIssueTypeMappings) {
        this.originalIssueTypeMappings = originalIssueTypeMappings;
    }

    void addIssueTypeMapping(String issueType, String workflow) {
        if (this.issueTypeMappings == null) {
            this.issueTypeMappings = Maps.newHashMap();
        }
        this.issueTypeMappings.put(issueType, workflow);
    }

    void addOriginalIssueTypeMapping(String issueType, String workflow) {
        if (this.originalIssueTypeMappings == null) {
            this.originalIssueTypeMappings = Maps.newHashMap();
        }
        this.originalIssueTypeMappings.put(issueType, workflow);
    }

    public Map<String, IssueTypeJsonBean> getIssueTypes() {
        return this.issueTypes;
    }

    public void setIssueTypes(Map<String, IssueTypeJsonBean> issueTypes) {
        this.issueTypes = issueTypes;
    }
}

