/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin.workflowscheme;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.workflow.WorkflowSchemeService;
import com.atlassian.jira.rest.util.ProjectFinder;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.v2.EndpointUsageEvent;
import com.atlassian.jira.rest.v2.admin.workflowscheme.WorkflowSchemeBean;
import com.atlassian.jira.rest.v2.admin.workflowscheme.WorkflowSchemeBeanFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.DraftWorkflowScheme;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="project/{projectKeyOrId}/workflowscheme")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@LicensedOnly
public class ProjectWorkflowSchemeResource {
    private final Logger logger = LoggerFactory.getLogger(ProjectWorkflowSchemeResource.class);
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ResponseFactory responses;
    private final ProjectFinder projectFinder;
    private final WorkflowSchemeService workflowSchemeService;
    private final WorkflowSchemeBeanFactory workflowSchemeBeanFactory;
    private final EventPublisher eventPublisher;

    @Inject
    public ProjectWorkflowSchemeResource(JiraAuthenticationContext jiraAuthenticationContext, ResponseFactory responses, WorkflowSchemeService workflowSchemeService, ProjectFinder projectFinder, WorkflowSchemeBeanFactory workflowSchemeBeanFactory, EventPublisher eventPublisher) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.responses = responses;
        this.workflowSchemeService = workflowSchemeService;
        this.projectFinder = projectFinder;
        this.workflowSchemeBeanFactory = workflowSchemeBeanFactory;
        this.eventPublisher = eventPublisher;
    }

    @GET
    @Operation(summary="Get workflow scheme for project", description="Returns the workflow scheme that is associated with requested project.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="projectKeyOrId", description="The key or id of the project", required=true)
    @ApiResponses(value={@ApiResponse(description="Returned if requested project exist and has associated workflow scheme, and the user has permission to see it.", responseCode="200", content={@Content(schema=@Schema(implementation=WorkflowSchemeBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the requested user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the requested user does not have permission to administer Jira.", responseCode="403"), @ApiResponse(description="Returned if the requested project does not exist.", responseCode="404")})
    public Response getWorkflowSchemeForProject(@PathParam(value="projectKeyOrId") String projectKeyOrId) {
        this.logger.info("Getting workflowScheme for projectKeyOrId={}", (Object)projectKeyOrId);
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        ProjectService.GetProjectResult projectResult = this.projectFinder.getGetProjectForActionByIdOrKey(user, projectKeyOrId, ProjectAction.VIEW_ARCHIVED_PROJECT);
        if (!projectResult.isValid()) {
            return this.createErrorResponse((ServiceResult)projectResult);
        }
        ServiceOutcome workflowSchemeOutcome = this.workflowSchemeService.getSchemeForProject(user, projectResult.getProject());
        if (!workflowSchemeOutcome.isValid()) {
            return this.createErrorResponse((ServiceResult)workflowSchemeOutcome);
        }
        AssignableWorkflowScheme workflowScheme = (AssignableWorkflowScheme)workflowSchemeOutcome.getReturnedValue();
        ServiceOutcome draftWorkflowScheme = this.workflowSchemeService.getDraftWorkflowScheme(user, workflowScheme);
        if (!draftWorkflowScheme.isValid()) {
            return this.createErrorResponse((ServiceResult)draftWorkflowScheme);
        }
        WorkflowSchemeBean workflowSchemeBean = this.workflowSchemeBeanFactory.asBean(workflowScheme, (DraftWorkflowScheme)draftWorkflowScheme.getReturnedValue());
        this.publishAnalytics("project.getWorkflowScheme", projectResult.getProject().getId());
        return this.responses.okNoCache(workflowSchemeBean);
    }

    private Response createErrorResponse(ServiceResult result) {
        return this.responses.errorResponse(result.getErrorCollection());
    }

    private void publishAnalytics(String endpoint, Long projectId) {
        this.eventPublisher.publish((Object)new EndpointUsageEvent(endpoint, true, projectId, "project"));
    }
}

