/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin.workflowscheme;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.workflow.WorkflowSchemeService;
import com.atlassian.jira.rest.v2.admin.workflowscheme.DefaultBean;
import com.atlassian.jira.rest.v2.admin.workflowscheme.IssueTypeMappingBean;
import com.atlassian.jira.rest.v2.admin.workflowscheme.RestWorkflowScheme;
import com.atlassian.jira.rest.v2.admin.workflowscheme.WorkflowMappingBean;
import com.atlassian.jira.rest.v2.admin.workflowscheme.WorkflowSchemeBean;
import com.atlassian.jira.rest.v2.admin.workflowscheme.WorkflowSchemeBeanFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.DraftWorkflowScheme;
import com.atlassian.jira.workflow.WorkflowScheme;
import java.util.Map;

public class DraftRestWorkflowScheme
extends RestWorkflowScheme {
    private final WorkflowSchemeService workflowSchemeService;
    private final ApplicationUser user;
    private AssignableWorkflowScheme parent;
    private DraftWorkflowScheme child;

    public DraftRestWorkflowScheme(WorkflowSchemeService workflowSchemeService, ApplicationUser user, WorkflowSchemeBeanFactory beanFactory, AssignableWorkflowScheme parent, DraftWorkflowScheme child) {
        super(beanFactory);
        this.workflowSchemeService = workflowSchemeService;
        this.user = user;
        this.parent = parent;
        this.child = child;
    }

    @Override
    WorkflowScheme getScheme() {
        return this.child;
    }

    @Override
    WorkflowSchemeBean asBean() {
        return this.beanFactory.asBean(this.parent, this.child);
    }

    @Override
    ServiceOutcome<Void> delete() {
        return this.workflowSchemeService.deleteWorkflowScheme(this.user, (WorkflowScheme)this.child);
    }

    @Override
    ServiceOutcome<? extends RestWorkflowScheme> update(WorkflowSchemeBean bean) {
        AssignableWorkflowScheme newParent;
        ServiceOutcome validateOutcome;
        AssignableWorkflowScheme.Builder parentBuilder = this.parent.builder();
        if (bean.isNameSet()) {
            parentBuilder.setName(bean.getName());
        }
        if (bean.isDescriptionSet()) {
            parentBuilder.setDescription(bean.getDescription());
        }
        if (!(validateOutcome = this.workflowSchemeService.validateUpdateWorkflowScheme(this.user, newParent = parentBuilder.build())).isValid()) {
            return ServiceOutcomeImpl.error((ServiceOutcome)validateOutcome);
        }
        Map<String, String> map = DraftRestWorkflowScheme.getWorkflowMap((WorkflowScheme)this.child, bean);
        DraftWorkflowScheme newChild = ((DraftWorkflowScheme.Builder)this.child.builder().setMappings(map)).build();
        ServiceOutcome draftSchemeOutcome = this.workflowSchemeService.updateWorkflowScheme(this.user, newChild);
        if (!draftSchemeOutcome.isValid()) {
            return ServiceOutcomeImpl.error((ServiceOutcome)draftSchemeOutcome);
        }
        this.child = (DraftWorkflowScheme)draftSchemeOutcome.getReturnedValue();
        ServiceOutcome parentOutcome = this.workflowSchemeService.updateWorkflowScheme(this.user, newParent);
        if (!parentOutcome.isValid()) {
            return ServiceOutcomeImpl.error((ServiceOutcome)parentOutcome);
        }
        this.parent = (AssignableWorkflowScheme)parentOutcome.getReturnedValue();
        return ServiceOutcomeImpl.ok((Object)this);
    }

    ServiceOutcome<DraftRestWorkflowScheme> deleteWorkflow(String workflowName) {
        DraftWorkflowScheme build = ((DraftWorkflowScheme.Builder)this.child.builder().removeWorkflow(workflowName)).build();
        return this.doUpdateMappings(build);
    }

    ServiceOutcome<DraftRestWorkflowScheme> updateWorkflowMappings(WorkflowMappingBean bean) {
        DraftWorkflowScheme.Builder builder = this.child.builder();
        this.mergeWorkflowMappings((WorkflowScheme.Builder<?>)builder, bean);
        return this.doUpdateMappings(builder.build());
    }

    ServiceOutcome<? extends RestWorkflowScheme> removeIssueType(String issueType) {
        DraftWorkflowScheme.Builder builder = this.child.builder();
        builder.removeMapping(issueType);
        return this.doUpdateMappings(builder.build());
    }

    ServiceOutcome<? extends RestWorkflowScheme> updateIssueTypeMappings(IssueTypeMappingBean bean) {
        DraftWorkflowScheme.Builder builder = this.child.builder();
        this.mergeIssueTypeMapping((WorkflowScheme.Builder<?>)builder, bean);
        return this.doUpdateMappings(builder.build());
    }

    ServiceOutcome<? extends RestWorkflowScheme> removeDefault() {
        return this.doUpdateMappings(((DraftWorkflowScheme.Builder)this.child.builder().removeDefault()).build());
    }

    ServiceOutcome<? extends RestWorkflowScheme> updateDefault(DefaultBean bean) {
        DraftWorkflowScheme.Builder builder = this.child.builder();
        DraftRestWorkflowScheme.setDefaultMapping(builder, bean);
        return this.doUpdateMappings(builder.build());
    }

    private ServiceOutcome<DraftRestWorkflowScheme> doUpdateMappings(DraftWorkflowScheme build) {
        if (build.getMappings().equals(this.child.getMappings())) {
            return ServiceOutcomeImpl.ok((Object)this);
        }
        ServiceOutcome outcome = this.workflowSchemeService.updateWorkflowScheme(this.user, build);
        if (!outcome.isValid()) {
            return ServiceOutcomeImpl.error((ServiceOutcome)outcome);
        }
        this.child = (DraftWorkflowScheme)outcome.getReturnedValue();
        return ServiceOutcomeImpl.ok((Object)this);
    }
}

