/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin.permissionscheme;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.PermissionGrant;
import com.atlassian.jira.permission.PermissionGrantInput;
import com.atlassian.jira.permission.PermissionScheme;
import com.atlassian.jira.permission.PermissionSchemeAttributeManager;
import com.atlassian.jira.permission.PermissionSchemeInput;
import com.atlassian.jira.permission.PermissionSchemeService;
import com.atlassian.jira.permission.data.PermissionGrantAsPureData;
import com.atlassian.jira.rest.api.permission.PermissionGrantBean;
import com.atlassian.jira.rest.api.permission.PermissionGrantBeanExpander;
import com.atlassian.jira.rest.api.permission.PermissionGrantsBean;
import com.atlassian.jira.rest.api.permission.PermissionSchemeAttributeBean;
import com.atlassian.jira.rest.api.permission.PermissionSchemeBean;
import com.atlassian.jira.rest.api.permission.PermissionSchemeBeansFactory;
import com.atlassian.jira.rest.api.permission.PermissionSchemeExpandParam;
import com.atlassian.jira.rest.api.permission.PermissionSchemesBean;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ErrorCollections;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.Either;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="permissionscheme")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@WebSudoRequired
@LicensedOnly
public final class PermissionSchemeResource {
    public static final String RESOURCE_PATH = "permissionscheme";
    public static final String ENTITY_PATH = "permission";
    private static final Logger logger = LoggerFactory.getLogger(PermissionSchemeResource.class);
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionSchemeBeansFactory beansFactory;
    private final PermissionGrantBeanExpander permissionGrantBeanExpander;
    private final PermissionSchemeService permissionSchemeService;
    private final I18nHelper i18n;
    private final ResponseFactory responseFactory;
    private final GlobalPermissionManager globalPermissionManager;
    private final PermissionSchemeAttributeManager permissionSchemeAttributeManager;

    @Inject
    public PermissionSchemeResource(JiraAuthenticationContext authenticationContext, PermissionSchemeBeansFactory beansFactory, PermissionGrantBeanExpander permissionGrantBeanExpander, PermissionSchemeService permissionSchemeService, I18nHelper i18n, ResponseFactory responseFactory, GlobalPermissionManager globalPermissionManager, @ComponentImport PermissionSchemeAttributeManager permissionSchemeAttributeManager) {
        this.authenticationContext = authenticationContext;
        this.beansFactory = beansFactory;
        this.permissionGrantBeanExpander = permissionGrantBeanExpander;
        this.permissionSchemeService = permissionSchemeService;
        this.i18n = i18n;
        this.responseFactory = responseFactory;
        this.globalPermissionManager = globalPermissionManager;
        this.permissionSchemeAttributeManager = permissionSchemeAttributeManager;
    }

    @GET
    @Operation(summary="Get all permission schemes", description="Returns a list of all permission schemes. By default only shortened beans are returned. If you want to include permissions of all the schemes, then specify the permissions expand parameter. Permissions will be included also if you specify any other expand parameter.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="expand", description="Use expand to include full beans in the response. This parameter accepts a comma-separated list of expandable elements. Use 'permissions' to include permissions in the response.", schema=@Schema(type="string", allowableValues={"permissions"}))
    @ApiResponses(value={@ApiResponse(description="List of all permission schemes", responseCode="200", content={@Content(schema=@Schema(implementation=PermissionSchemesBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if user is not logged in.", responseCode="401"), @ApiResponse(description="Returned if user is not allowed to view permission schemes.", responseCode="403"), @ApiResponse(description="Returned if the scheme doesn't exist.", responseCode="404")})
    public Response getPermissionSchemes(@QueryParam(value="expand") String expand) {
        return (Response)this.withParsedExpandParameter(expand).left().on(expands -> {
            ServiceOutcome permissionSchemes = this.permissionSchemeService.getPermissionSchemes(this.getUser());
            return (Response)this.responseFactory.validateOutcome(permissionSchemes).left().on(permissionSchemes1 -> {
                ImmutableList result = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)permissionSchemes1, scheme -> this.beansFactory.toBean((PermissionScheme)scheme, (List<PermissionSchemeExpandParam>)expands)));
                return this.responseFactory.okNoCache(new PermissionSchemesBean((Iterable<PermissionSchemeBean>)result));
            });
        });
    }

    @GET
    @Path(value="{schemeId}")
    @Operation(summary="Get a permission scheme by ID", description="Returns a permission scheme identified by the given id.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="schemeId", description="The id of the permission scheme.", schema=@Schema(type="integer")), @Parameter(name="expand", description="Use expand to include full beans in the response. This parameter accepts a comma-separated list of expandable elements. Use 'permissions' to include permissions in the response.", schema=@Schema(type="string", allowableValues={"permissions"}))})
    @ApiResponses(value={@ApiResponse(description="Permission scheme", responseCode="200", content={@Content(schema=@Schema(implementation=PermissionSchemeBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if user is not logged in.", responseCode="401"), @ApiResponse(description="Returned if user is not allowed to view permission schemes.", responseCode="403"), @ApiResponse(description="Returned if the scheme doesn't exist.", responseCode="404")})
    public Response getPermissionScheme(@PathParam(value="schemeId") Long id, @QueryParam(value="expand") String expand) {
        return (Response)this.withParsedExpandParameter(expand).left().on(expands -> (Response)this.responseFactory.validateOutcome(this.permissionSchemeService.getPermissionScheme(this.getUser(), id)).left().on(scheme -> this.responseFactory.okNoCache(this.beansFactory.toBean((PermissionScheme)scheme, (List<PermissionSchemeExpandParam>)expands))));
    }

    @DELETE
    @Path(value="{schemeId}")
    @Operation(summary="Delete a permission scheme by ID", description="Deletes a permission scheme identified by the given id.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="schemeId", description="The id of the permission scheme.", schema=@Schema(type="integer"))
    @ApiResponses(value={@ApiResponse(description="Returned if the permission scheme is successfully deleted.", responseCode="204"), @ApiResponse(description="Returned if user is not logged in.", responseCode="401"), @ApiResponse(description="Returned if user is not allowed to delete permission schemes.", responseCode="403")})
    public Response deletePermissionScheme(@PathParam(value="schemeId") Long id) {
        return this.responseFactory.serviceResultToNoContentResponse(this.permissionSchemeService.deletePermissionScheme(this.getUser(), id));
    }

    @POST
    @Operation(summary="Create a new permission scheme", description="Create a new permission scheme. This method can create schemes with a defined permission set, or without.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="expand", description="Use expand to include full beans in the response. This parameter accepts a comma-separated list of expandable elements. Use 'permissions' to include permissions in the response.", schema=@Schema(type="string", allowableValues={"permissions"}))
    @ApiResponses(value={@ApiResponse(description="Returned if the scheme is created successfully.", responseCode="201", content={@Content(schema=@Schema(implementation=PermissionSchemeBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if user is not logged in.", responseCode="401"), @ApiResponse(description="Returned if user is not allowed to create permission schemes.", responseCode="403")})
    public Response createPermissionScheme(PermissionSchemeBean permissionScheme, @QueryParam(value="expand") String expand) {
        return (Response)this.withParsedExpandParameter(expand).left().on(expands -> (Response)this.toResponse(this.beansFactory.fromBean(permissionScheme)).left().on(input -> {
            ServiceOutcome createdScheme = this.permissionSchemeService.createPermissionScheme(this.getUser(), input);
            return (Response)this.responseFactory.validateOutcome(createdScheme).left().on(scheme -> {
                PermissionSchemeBean created = this.beansFactory.toBean((PermissionScheme)scheme, (List<PermissionSchemeExpandParam>)expands);
                return this.responseFactory.created(created.getSelf(), created);
            });
        }));
    }

    @PUT
    @Path(value="{schemeId}")
    @Operation(summary="Update a permission scheme", description="Updates a permission scheme. If the permissions list is present then it will be set in the permission scheme, which basically means it will overwrite any permission grants that existed in the permission scheme. Sending an empty list will remove all permission grants from the permission scheme. To update just the name and description, do not send permissions list at all. To add or remove a single permission grant instead of updating the whole list at once use the {schemeId}/permission/ resource.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="schemeId", description="The id of the permission scheme.", schema=@Schema(type="integer")), @Parameter(name="expand", description="Use expand to include full beans in the response. This parameter accepts a comma-separated list of expandable elements. Use 'permissions' to include permissions in the response.", schema=@Schema(type="string", allowableValues={"permissions"}))})
    @ApiResponses(value={@ApiResponse(description="Returned if the scheme is updated successfully.", responseCode="200", content={@Content(schema=@Schema(implementation=PermissionSchemeBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if user is not logged in.", responseCode="401"), @ApiResponse(description="Returned if user is not allowed to edit permission schemes.", responseCode="403"), @ApiResponse(description="Returned if the permission is not found.", responseCode="404")})
    public Response updatePermissionScheme(@PathParam(value="schemeId") Long schemeId, PermissionSchemeBean permissionScheme, @QueryParam(value="expand") String expand) {
        return (Response)this.withParsedExpandParameter(expand).left().on(expands -> this.updatePermissionScheme(schemeId, (PermissionScheme oldScheme) -> this.beansFactory.fromBean(permissionScheme).map(newScheme -> {
            if (permissionScheme.getPermissions() == null) {
                return PermissionSchemeInput.builder((PermissionScheme)oldScheme).setName(newScheme.getName()).setDescription((String)newScheme.getDescription().getOrNull()).build();
            }
            return newScheme;
        }), (PermissionScheme updatedScheme) -> this.responseFactory.okNoCache(this.beansFactory.toBean((PermissionScheme)updatedScheme, (List<PermissionSchemeExpandParam>)expands))));
    }

    @GET
    @Path(value="{permissionSchemeId}/attribute/{attributeKey}")
    @ExperimentalApi
    @Operation(summary="Get scheme attribute by key", description="Returns the attribute for a permission scheme specified by permission scheme id and attribute key.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="permissionSchemeId", description="The id of the permission scheme.", schema=@Schema(type="integer")), @Parameter(name="attributeKey", description="The key of the permission scheme attribute.", schema=@Schema(type="string"))})
    @ApiResponses(value={@ApiResponse(description="Permission scheme attribute", responseCode="200", content={@Content(schema=@Schema(implementation=PermissionSchemeAttributeBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the user is not an admin.", responseCode="403"), @ApiResponse(description="Returned if there is no such attribute.", responseCode="404")})
    public Response getSchemeAttribute(@PathParam(value="permissionSchemeId") Long schemeId, @PathParam(value="attributeKey") String key) {
        return this.asAdmin(() -> {
            Either schemeValidation = this.responseFactory.validateOutcome(this.permissionSchemeService.getPermissionScheme(this.getUser(), schemeId));
            if (schemeValidation.isLeft()) {
                return (Response)schemeValidation.left().get();
            }
            Optional value = this.permissionSchemeAttributeManager.getAttribute(schemeId, key);
            if (value.isPresent()) {
                return this.responseFactory.okNoCache(new PermissionSchemeAttributeBean(key, (String)value.get()));
            }
            return this.responseFactory.errorResponse(ErrorCollections.create((String)this.i18n.getText("rest.permissionscheme.attribute.not.found"), (ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND));
        });
    }

    @PUT
    @Path(value="{permissionSchemeId}/attribute/{key}")
    @Consumes(value={"text/plain"})
    @ExperimentalApi
    @Operation(summary="Update or insert a scheme attribute", description="Updates or inserts the attribute for a permission scheme specified by permission scheme id. The attribute consists of the key and the value. The value will be converted to Boolean using Boolean#valueOf.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="permissionSchemeId", description="The id of the permission scheme.", schema=@Schema(type="integer")), @Parameter(name="key", description="The key of the permission scheme attribute.", schema=@Schema(type="string"))})
    @ApiResponses(value={@ApiResponse(description="Returned if the attribute is updated successfully.", responseCode="204"), @ApiResponse(description="Returned if the user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the user is not an admin.", responseCode="403"), @ApiResponse(description="Returned if there was an error related to attribute upsert.", responseCode="500")})
    public Response setSchemeAttribute(@PathParam(value="permissionSchemeId") Long schemeId, @PathParam(value="key") String key, String value) {
        return this.asAdmin(() -> {
            Either schemeValidation = this.responseFactory.validateOutcome(this.permissionSchemeService.getPermissionScheme(this.getUser(), schemeId));
            if (schemeValidation.isLeft()) {
                return (Response)schemeValidation.left().get();
            }
            String booleanValue = Boolean.toString(Boolean.parseBoolean(value));
            try {
                this.permissionSchemeAttributeManager.setAttribute(schemeId, key, booleanValue);
                return this.responseFactory.noContent();
            }
            catch (Exception e) {
                String errorMessage = this.i18n.getText("rest.permissionscheme.attribute.update.error");
                logger.error(String.format("%s Details: '%s'", errorMessage, e.getMessage()));
                return this.responseFactory.errorResponse(ErrorCollections.create((String)errorMessage, (ErrorCollection.Reason)ErrorCollection.Reason.SERVER_ERROR));
            }
        });
    }

    @GET
    @Path(value="{schemeId}/permission")
    @Operation(summary="Get all permission grants of a scheme", description="Returns all permission grants of the given permission scheme.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="schemeId", description="The id of the permission scheme.", schema=@Schema(type="integer")), @Parameter(name="expand", description="Use expand to include full beans in the response. This parameter accepts a comma-separated list of expandable elements. Use 'permissions' to include permissions in the response.", schema=@Schema(type="string", allowableValues={"permissions"}))})
    @ApiResponses(value={@ApiResponse(description="Permission grants", responseCode="200", content={@Content(schema=@Schema(implementation=PermissionGrantsBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if user is not logged in.", responseCode="401"), @ApiResponse(description="Returned if user is not allowed to view permission schemes.", responseCode="403"), @ApiResponse(description="Returned if the scheme doesn't exist.", responseCode="404")})
    public Response getPermissionSchemeGrants(@PathParam(value="schemeId") Long schemeId, @QueryParam(value="expand") String expand) {
        return (Response)this.withParsedExpandParameter(expand).left().on(expands -> (Response)this.responseFactory.validateOutcome(this.permissionSchemeService.getPermissionScheme(this.getUser(), schemeId)).left().on(scheme -> this.responseFactory.okNoCache(new PermissionGrantsBean((Iterable<PermissionGrantBean>)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)scheme.getPermissions(), grant -> this.beansFactory.toBean((PermissionGrant)grant, schemeId, (List<PermissionSchemeExpandParam>)expands)))))));
    }

    @POST
    @Path(value="{schemeId}/permission")
    @Operation(summary="Create a permission grant in a scheme", description="Creates a permission grant in a permission scheme.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="schemeId", description="The id of the permission scheme.", schema=@Schema(type="integer")), @Parameter(name="expand", description="Use expand to include full beans in the response. This parameter accepts a comma-separated list of expandable elements. Use 'permissions' to include permissions in the response.", schema=@Schema(type="string", allowableValues={"permissions"}))})
    @ApiResponses(value={@ApiResponse(description="Returned if the scheme permission is created successfully.", responseCode="201", content={@Content(schema=@Schema(implementation=PermissionGrantBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if user is not logged in.", responseCode="401"), @ApiResponse(description="Returned if user is not allowed to edit permission schemes.", responseCode="403")})
    public Response createPermissionGrant(@PathParam(value="schemeId") Long schemeId, PermissionGrantBean grantBean, @QueryParam(value="expand") String expand) {
        return (Response)this.withParsedExpandParameter(expand).left().on(expands -> this.asAdmin(() -> (Response)this.toResponse(this.beansFactory.fromBean(grantBean)).left().on(newPermission -> this.updatePermissionScheme(schemeId, (PermissionScheme oldScheme) -> this.validateThatNewPermissionDoesNotAlreadyExist((PermissionScheme)oldScheme, (PermissionGrantInput)newPermission).map(input -> PermissionSchemeInput.builder((PermissionScheme)oldScheme).addPermission(input).build()), (PermissionScheme newScheme) -> {
            PermissionGrant createdPermission = (PermissionGrant)Iterables.find((Iterable)newScheme.getPermissions(), (Predicate)PermissionGrantAsPureData.equalToModuloId((PermissionGrantInput)newPermission));
            PermissionGrantBean createdPermissionBean = this.beansFactory.toBean(createdPermission, schemeId, (List<PermissionSchemeExpandParam>)expands);
            return this.responseFactory.created(createdPermissionBean.getSelf(), createdPermissionBean);
        }))));
    }

    @DELETE
    @Path(value="{schemeId}/permission/{permissionId}")
    @Operation(summary="Delete a permission grant from a scheme", description="Deletes a permission grant from a permission scheme.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="schemeId", description="The id of the permission scheme.", schema=@Schema(type="integer")), @Parameter(name="permissionId", description="The id of the permission grant.", schema=@Schema(type="integer"))})
    @ApiResponses(value={@ApiResponse(description="Returned if the permission grant is deleted successfully.", responseCode="204"), @ApiResponse(description="Returned if user is not logged in.", responseCode="401"), @ApiResponse(description="Returned if user is not allowed to edit permission schemes.", responseCode="403")})
    public Response deletePermissionSchemeEntity(@PathParam(value="schemeId") Long schemeId, @PathParam(value="permissionId") Long permissionId) {
        return this.asAdmin(() -> this.updatePermissionScheme(schemeId, (PermissionScheme scheme) -> {
            if (!this.findPermissionGrant((PermissionScheme)scheme, permissionId).isPresent()) {
                return Either.left((Object)ErrorCollections.create((String)this.i18n.getText("rest.permissionscheme.permission.grant.does.not.exist", permissionId.toString()), (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED));
            }
            Iterable newPermissionSet = Iterables.filter((Iterable)scheme.getPermissions(), grant -> !grant.getId().equals(permissionId));
            return Either.right((Object)PermissionSchemeInput.builder((PermissionScheme)scheme).setOriginalPermissions(newPermissionSet).build());
        }, (PermissionScheme input) -> this.responseFactory.noContent()));
    }

    private Response updatePermissionScheme(Long schemeId, java.util.function.Function<PermissionScheme, Either<ErrorCollection, PermissionSchemeInput>> oldToNew, java.util.function.Function<PermissionScheme, Response> newSchemeToResponse) {
        return (Response)this.responseFactory.validateOutcome(this.permissionSchemeService.getPermissionScheme(this.getUser(), schemeId)).left().on(scheme -> (Response)this.toResponse((Either)oldToNew.apply((PermissionScheme)scheme)).left().on(newScheme -> (Response)this.responseFactory.validateOutcome(this.permissionSchemeService.updatePermissionScheme(this.getUser(), schemeId, newScheme)).left().on(newSchemeToResponse::apply)));
    }

    @GET
    @Path(value="{schemeId}/permission/{permissionId}")
    @Operation(summary="Get a permission grant by ID", description="Returns a permission grant identified by the given id.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="schemeId", description="The id of the permission scheme.", schema=@Schema(type="integer")), @Parameter(name="permissionId", description="The id of the permission grant.", schema=@Schema(type="integer")), @Parameter(name="expand", description="Use expand to include full beans in the response. This parameter accepts a comma-separated list of expandable elements. Use 'permissions' to include permissions in the response.", schema=@Schema(type="string", allowableValues={"permissions"}))})
    @ApiResponses(value={@ApiResponse(description="Permission grant", responseCode="200", content={@Content(schema=@Schema(implementation=PermissionGrantBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if user is not logged in.", responseCode="401"), @ApiResponse(description="Returned if user is not allowed to view permission schemes.", responseCode="403"), @ApiResponse(description="Returned if the scheme doesn't exist.", responseCode="404")})
    public Response getPermissionSchemeGrant(@PathParam(value="schemeId") Long schemeId, @PathParam(value="permissionId") Long permissionId, @QueryParam(value="expand") String expand) {
        return (Response)this.withParsedExpandParameter(expand).left().on(expands -> (Response)this.responseFactory.validateOutcome(this.permissionSchemeService.getPermissionScheme(this.getUser(), schemeId)).left().on(permissionScheme -> {
            com.google.common.base.Optional<PermissionGrant> maybeEntity = this.findPermissionGrant((PermissionScheme)permissionScheme, permissionId);
            if (maybeEntity.isPresent()) {
                return this.responseFactory.okNoCache(this.beansFactory.toBean((PermissionGrant)maybeEntity.get(), schemeId, (List<PermissionSchemeExpandParam>)expands));
            }
            return this.responseFactory.errorResponse(ErrorCollections.create((String)this.i18n.getText("rest.permissionscheme.permission.grant.does.not.exist", permissionId.toString()), (ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND));
        }));
    }

    private com.google.common.base.Optional<PermissionGrant> findPermissionGrant(PermissionScheme permissionScheme, Long permissionId) {
        return Iterables.tryFind((Iterable)permissionScheme.getPermissions(), grant -> grant.getId().equals(permissionId));
    }

    private ApplicationUser getUser() {
        return this.authenticationContext.getUser();
    }

    private Either<Response, List<PermissionSchemeExpandParam>> withParsedExpandParameter(String parameter) {
        return this.toResponse(this.permissionGrantBeanExpander.parseExpandQuery(parameter));
    }

    private <T> Either<Response, T> toResponse(Either<ErrorCollection, T> either) {
        return this.responseFactory.toResponse(either);
    }

    private Either<ErrorCollection, PermissionGrantInput> validateThatNewPermissionDoesNotAlreadyExist(PermissionScheme oldScheme, PermissionGrantInput newPermission) {
        if (Iterables.contains((Iterable)Iterables.transform((Iterable)oldScheme.getPermissions(), (Function)PermissionGrantAsPureData.TO_PURE_DATA), (Object)PermissionGrantAsPureData.of((PermissionGrantInput)newPermission))) {
            return Either.left((Object)ErrorCollections.create((String)this.i18n.getText("rest.permissionscheme.permission.already.exists", newPermission.getPermission().permissionKey(), newPermission.getHolder().getType().toString(), (String)newPermission.getHolder().getParameter().getOrNull(), oldScheme.getId().toString()), (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED));
        }
        return Either.right((Object)newPermission);
    }

    public Response asAdmin(RestAction action) {
        if (this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, this.getUser())) {
            return action.perform();
        }
        return this.responseFactory.errorResponse(ErrorCollections.create((String)this.i18n.getText("rest.permissionscheme.forbidden"), (ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN));
    }

    private static interface RestAction {
        public Response perform();
    }
}

