/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin.permissionscheme;

import com.atlassian.jira.permission.PermissionGrant;
import com.atlassian.jira.permission.PermissionGrantInput;
import com.atlassian.jira.permission.PermissionHolder;
import com.atlassian.jira.permission.PermissionHolderType;
import com.atlassian.jira.permission.PermissionScheme;
import com.atlassian.jira.permission.PermissionSchemeInput;
import com.atlassian.jira.permission.data.CustomPermissionHolderType;
import com.atlassian.jira.rest.api.permission.PermissionGrantBean;
import com.atlassian.jira.rest.api.permission.PermissionGrantBeanExpander;
import com.atlassian.jira.rest.api.permission.PermissionHolderBean;
import com.atlassian.jira.rest.api.permission.PermissionHolderTypeMapping;
import com.atlassian.jira.rest.api.permission.PermissionSchemeBean;
import com.atlassian.jira.rest.api.permission.PermissionSchemeBeansFactory;
import com.atlassian.jira.rest.api.permission.PermissionSchemeExpandParam;
import com.atlassian.jira.rest.util.SelfLinkBuilder;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ErrorCollections;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Eithers;
import io.atlassian.fugue.Option;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public final class PermissionSchemeBeansFactoryImpl
implements PermissionSchemeBeansFactory {
    private final PermissionGrantBeanExpander expander;
    private final SelfLinkBuilder.SelfLink selfLink;
    private final I18nHelper i18n;

    @Autowired
    public PermissionSchemeBeansFactoryImpl(SelfLinkBuilder selfLinkBuilder, PermissionGrantBeanExpander expander, I18nHelper i18n) {
        this.expander = expander;
        this.i18n = i18n;
        this.selfLink = selfLinkBuilder.path("permissionscheme");
    }

    @Override
    public PermissionSchemeBean toBean(PermissionScheme scheme, List<PermissionSchemeExpandParam> expands) {
        URI self = this.selfLink.path(scheme.getId().toString(), new String[0]).toUri();
        PermissionSchemeBean.Builder bean = PermissionSchemeBean.builder().setId(scheme.getId()).setName(scheme.getName()).setSelf(self).setDescription(Strings.emptyToNull((String)scheme.getDescription()));
        if (!expands.isEmpty()) {
            bean.setPermissions(Iterables.transform((Iterable)scheme.getPermissions(), schemeEntity -> this.toBean((PermissionGrant)schemeEntity, scheme.getId(), expands)));
        }
        return bean.build();
    }

    @Override
    public PermissionGrantBean toBean(PermissionGrant permissionGrant, Long schemeId, List<PermissionSchemeExpandParam> expands) {
        URI self = this.selfLink.path(schemeId.toString(), "permission", permissionGrant.getId().toString()).toUri();
        PermissionHolderType type = permissionGrant.getHolder().getType();
        String holderType = PermissionHolderTypeMapping.toRestType(type);
        PermissionHolderBean holderBean = PermissionHolderBean.holderBean(holderType, (String)permissionGrant.getHolder().getParameter().getOrNull());
        return PermissionGrantBean.builder().setId(permissionGrant.getId()).setSelf(self).setHolder(this.expander.expand(holderBean, permissionGrant.getHolder().getType(), expands)).setPermission(permissionGrant.getPermission().permissionKey()).build();
    }

    @Override
    public Either<ErrorCollection, PermissionSchemeInput> fromBean(PermissionSchemeBean permissionScheme) {
        return this.validated(permissionScheme).flatMap(validatedPermissionScheme -> this.fromBean(validatedPermissionScheme.getPermissions()).map(permissionGrants -> PermissionSchemeInput.builder((String)validatedPermissionScheme.getName()).setDescription(validatedPermissionScheme.getDescription()).setPermissions((Iterable)permissionGrants).build()));
    }

    @Override
    public Either<ErrorCollection, Collection<PermissionGrantInput>> fromBean(@Nullable List<PermissionGrantBean> nullablePermissions) {
        List<PermissionGrantBean> permissions = nullablePermissions != null ? nullablePermissions : Collections.emptyList();
        return Eithers.sequenceRight((Iterable)Iterables.transform(permissions, this::fromBean)).map(ImmutableList::copyOf);
    }

    @Override
    public Either<ErrorCollection, PermissionGrantInput> fromBean(PermissionGrantBean grantBean) {
        return this.validated(grantBean).map(validatedGrantBean -> PermissionGrantInput.newGrant((PermissionHolder)PermissionHolder.holder((PermissionHolderType)((PermissionHolderType)this.getActorType((PermissionGrantBean)validatedGrantBean).get()), (String)validatedGrantBean.getHolder().getParameter()), (ProjectPermissionKey)new ProjectPermissionKey(validatedGrantBean.getPermission())));
    }

    private Either<ErrorCollection, PermissionSchemeBean> validated(PermissionSchemeBean bean) {
        if (Strings.isNullOrEmpty((String)bean.getName())) {
            return Either.left((Object)ErrorCollections.validationError((String)"name", (String)this.i18n.getText("rest.missing.field", "name")));
        }
        return Either.right((Object)bean);
    }

    private Either<ErrorCollection, PermissionGrantBean> validated(PermissionGrantBean bean) {
        Option<PermissionHolderType> actorType = this.getActorType(bean);
        PermissionHolderBean holder = (PermissionHolderBean)MoreObjects.firstNonNull((Object)bean.getHolder(), (Object)new PermissionHolderBean());
        ErrorCollection errors = ErrorCollections.empty();
        if (actorType.isEmpty()) {
            errors.addError("holder.type", this.i18n.getText("rest.permissionscheme.input.error.unrecognized.holder.type", holder.getType()));
        } else if (((PermissionHolderType)actorType.get()).requiresParameter() && Strings.isNullOrEmpty((String)holder.getParameter())) {
            errors.addError("holder.parameter", this.i18n.getText("rest.permissionscheme.input.error.holder.parameter.required", holder.getType()));
        } else if (!((PermissionHolderType)actorType.get()).requiresParameter() && !Strings.isNullOrEmpty((String)holder.getParameter())) {
            errors.addError("holder.parameter", this.i18n.getText("rest.permissionscheme.input.error.holder.parameter.unexpected", holder.getType()));
        }
        if (Strings.isNullOrEmpty((String)bean.getPermission())) {
            errors.addError("permission", this.i18n.getText("rest.missing.field", "permission"));
        }
        return errors.hasAnyErrors() ? Either.left((Object)errors) : Either.right((Object)bean);
    }

    private Option<PermissionHolderType> getActorType(PermissionGrantBean grantBean) {
        return Option.option((Object)grantBean.getHolder()).flatMap(holder -> Option.option((Object)holder.getType()).map(holderType -> PermissionHolderTypeMapping.fromRestType(holderType).orElse(CustomPermissionHolderType.permissionHolderType((String)holderType, (String)holder.getParameter()))));
    }
}

