/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin.mail;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.mail.EmailTypesService;
import com.atlassian.jira.mail.MailTemplatesService;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.admin.mail.EmailTypesJsonBean;
import com.atlassian.jira.security.xsrf.XsrfCheckResult;
import com.atlassian.jira.security.xsrf.XsrfInvocationChecker;
import com.atlassian.jira.template.CustomTemplatesFeatureAvailabilityCheck;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.exception.XsrfCheckFailedException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.io.InputStream;
import java.util.Collection;
import java.util.function.Function;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="email-templates")
@LicensedOnly
public class EmailTemplatesResource {
    private final MailTemplatesService mailTemplatesService;
    private final EmailTypesService emailTypesService;
    private final CustomTemplatesFeatureAvailabilityCheck customTemplatesFeatureAvailabilityCheck;
    private final XsrfInvocationChecker xsrfChecker;

    @Inject
    public EmailTemplatesResource(@ComponentImport MailTemplatesService importer, @ComponentImport EmailTypesService emailTypesService, @ComponentImport CustomTemplatesFeatureAvailabilityCheck customTemplatesFeatureAvailabilityCheck, @ComponentImport XsrfInvocationChecker xsrfChecker) {
        this.mailTemplatesService = (MailTemplatesService)Assertions.notNull((String)"mailTemplatesService", (Object)importer);
        this.emailTypesService = emailTypesService;
        this.customTemplatesFeatureAvailabilityCheck = customTemplatesFeatureAvailabilityCheck;
        this.xsrfChecker = xsrfChecker;
    }

    @POST
    @Consumes(value={"application/zip"})
    @Produces(value={"application/json"})
    @Operation(summary="Update email templates with zip file", description="Extracts given zip file to temporary templates folder. If the folder already exists it will replace it's content", security={@SecurityRequirement(name="basic")})
    @ApiResponses(value={@ApiResponse(description="Templates has extracted", responseCode="200"), @ApiResponse(description="User is not a system admin", responseCode="403"), @ApiResponse(description="IOException happen or any unexpected exception is thrown", responseCode="500")})
    public Response uploadEmailTemplates(InputStream fileInputStream) {
        this.xsrfCheck();
        if (!this.customTemplatesFeatureAvailabilityCheck.isLicensedForCustomEmailTemplates()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.never()).build();
        }
        ServiceOutcome result = this.mailTemplatesService.uploadEmailTemplates(fileInputStream);
        return this.mapServiceOutcomeToResponse(result, Function.identity());
    }

    @POST
    @Path(value="/apply")
    @Produces(value={"application/json"})
    @Operation(summary="Update email templates with previously uploaded pack", description="Replaces the current email templates pack with previously uploaded one, if exists.", security={@SecurityRequirement(name="basic")})
    @ApiResponses(value={@ApiResponse(description="Templates were replaced", responseCode="200"), @ApiResponse(description="There were no templates previously uploaded", responseCode="400"), @ApiResponse(description="Exception happened during applying process", responseCode="500")})
    public Response applyEmailTemplates() {
        this.xsrfCheck();
        if (!this.customTemplatesFeatureAvailabilityCheck.isLicensedForCustomEmailTemplates()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.never()).build();
        }
        ServiceOutcome result = this.mailTemplatesService.applyEmailTemplates();
        return this.mapServiceOutcomeToResponse(result, Function.identity());
    }

    @POST
    @Path(value="/revert")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Operation(summary="Update email templates to default", description="Replaces the current email templates pack with default templates, which are copied over from Jira binaries.", security={@SecurityRequirement(name="basic")})
    @ApiResponses(value={@ApiResponse(description="Templates were restored to default", responseCode="200"), @ApiResponse(description="User is not a system admin", responseCode="403"), @ApiResponse(description="Any unexpected exception is thrown", responseCode="500")})
    public Response revertEmailTemplatesToDefault() {
        this.xsrfCheck();
        if (!this.customTemplatesFeatureAvailabilityCheck.isLicensedForCustomEmailTemplates()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.never()).build();
        }
        ServiceOutcome result = this.mailTemplatesService.revertEmailTemplatesToDefault();
        return this.mapServiceOutcomeToResponse(result, Function.identity());
    }

    @GET
    @Produces(value={"application/zip"})
    @Operation(summary="Get email templates as zip file", description="Creates a zip file containing email templates at local home and returns the file.", security={@SecurityRequirement(name="basic")})
    @ApiResponses(value={@ApiResponse(description="Zipping was successful", responseCode="200"), @ApiResponse(description="User is not a system admin", responseCode="403"), @ApiResponse(description="IOException happen or any unexpected exception was thrown", responseCode="500")})
    public Response downloadEmailTemplates() {
        if (!this.customTemplatesFeatureAvailabilityCheck.isLicensedForCustomEmailTemplates()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.never()).build();
        }
        ServiceOutcome serviceOutcome = this.mailTemplatesService.getEmailTemplatesZip();
        Response response = this.mapServiceOutcomeToResponse(serviceOutcome, Function.identity());
        if (!serviceOutcome.isValid()) {
            return Response.fromResponse((Response)response).type("application/json").build();
        }
        return response;
    }

    @GET
    @Path(value="types")
    @Produces(value={"application/json"})
    @Operation(summary="Get email types for templates", description="Returns a list of root templates mapped with Event Types. The list can be used to decide which test emails to send.", security={@SecurityRequirement(name="basic")})
    @ApiResponses(value={@ApiResponse(description="Reading email types was successful", responseCode="200"), @ApiResponse(description="User is not a system admin", responseCode="403"), @ApiResponse(description="Any unexpected exception is thrown", responseCode="500")})
    public Response getEmailTypes() {
        if (!this.customTemplatesFeatureAvailabilityCheck.isLicensedForCustomEmailTemplates()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.never()).build();
        }
        ServiceOutcome emailTypesOutcome = this.emailTypesService.getEmailTypes();
        return this.mapServiceOutcomeToResponse(emailTypesOutcome, EmailTypesJsonBean::of);
    }

    private <X, Y> Response mapServiceOutcomeToResponse(ServiceOutcome<X> outcome, Function<X, Y> toResponseEntityMapper) {
        if (outcome.isValid()) {
            Y responseEntity = toResponseEntityMapper.apply(outcome.get());
            return Response.ok(responseEntity).build();
        }
        return this.mapInvalidServiceResultToResponse((ServiceResult)outcome);
    }

    private Response mapInvalidServiceResultToResponse(ServiceResult result) {
        ErrorCollection.Reason worstReason = ErrorCollection.Reason.getWorstReason((Collection)result.getErrorCollection().getReasons());
        if (worstReason == null) {
            worstReason = ErrorCollection.Reason.SERVER_ERROR;
        }
        return Response.status((int)worstReason.getHttpStatusCode()).entity((Object)ErrorCollection.of(result.getErrorCollection())).cacheControl(CacheControl.never()).build();
    }

    private void xsrfCheck() throws XsrfCheckFailedException, NullPointerException {
        XsrfCheckResult xsrfCheckResult = this.xsrfChecker.checkWebRequestInvocation(ExecutingHttpRequest.get());
        if (xsrfCheckResult.isRequired() && !xsrfCheckResult.isValid()) {
            throw new XsrfCheckFailedException();
        }
    }
}

