/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.v2.admin.WorkflowBean;
import com.atlassian.jira.rest.v2.admin.WorkflowTransitionResource;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Path(value="workflow")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@LicensedOnly
public class WorkflowsResource {
    private final WorkflowManager workflowManager;
    private final DateTimeFormatter dateTimeFormatter;
    private final UserManager userManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PermissionManager permissionManager;
    private final WorkflowTransitionResource.Factory transitionFactory;

    @Inject
    public WorkflowsResource(WorkflowManager workflowManager, DateTimeFormatter dateTimeFormatter, UserManager userManager, JiraAuthenticationContext jiraAuthenticationContext, PermissionManager permissionManager, WorkflowTransitionResource.Factory transitionFactory) {
        this.workflowManager = workflowManager;
        this.dateTimeFormatter = dateTimeFormatter;
        this.userManager = userManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.permissionManager = permissionManager;
        this.transitionFactory = transitionFactory;
    }

    @GET
    @Operation(summary="Get all workflows", description="Returns all workflows. The \u00e2\u0080\u009clastModifiedDate\u00e2\u0080\u009d is returned in Jira Complete Date/Time Format (dd/MMM/yy h:mm by default), but can also be returned as a relative date.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="workflowName", description="an optional String containing workflow name. If not passed then all workflows are returned", in=ParameterIn.QUERY)
    @ApiResponses(value={@ApiResponse(description="Returned if the currently authenticated user has administration permission. Contains a full representation of every workflow.", responseCode="200"), @ApiResponse(description="Returned if the currently authenticated user does not have administration permission.", responseCode="401")})
    public Response getAllWorkflows(@QueryParam(value="workflowName") String workflowName) {
        this.verifyUserHasAdminPermission();
        if (StringUtils.isBlank((CharSequence)workflowName)) {
            return Response.ok(this.actuallyGetAllWorkflows()).cacheControl(CacheControl.never()).build();
        }
        JiraWorkflow jiraWorkflow = this.workflowManager.getWorkflow(workflowName);
        if (jiraWorkflow == null) {
            return Response.ok((Object)ImmutableList.of()).cacheControl(CacheControl.never()).build();
        }
        return Response.ok((Object)this.jiraWorkflowToWorkflowBean(jiraWorkflow)).cacheControl(CacheControl.never()).build();
    }

    @Path(value="transitions")
    @Operation(summary="Return transitions sub-resource", description="Return a sub-resource to handle transitions.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="workflowName", description="the name of the workflow to use.", in=ParameterIn.QUERY), @Parameter(name="workflowMode", description="the mode of the workflow to use. Default value is LIVE.", in=ParameterIn.QUERY)})
    @ApiResponses(value={@ApiResponse(description="Returned if the currently authenticated user has administration permission. Contains a full representation of every workflow.", responseCode="200", content={@Content(schema=@Schema(implementation=WorkflowTransitionResource.class))}), @ApiResponse(description="Returned if the currently authenticated user does not have administration permission.", responseCode="401")})
    public WorkflowTransitionResource getWorkflowTransitions(@QueryParam(value="workflowName") String workflowName, @QueryParam(value="workflowMode") String workflowMode) {
        this.verifyUserHasAdminPermission();
        return this.transitionFactory.getResource(workflowName, WorkflowTransitionResource.WorkflowMode.getMode(workflowMode));
    }

    private void verifyUserHasAdminPermission() {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        if (!this.permissionManager.hasPermission(0, user)) {
            throw new NotAuthorisedWebException();
        }
    }

    private Iterable<WorkflowBean> actuallyGetAllWorkflows() {
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)this.workflowManager.getWorkflows(), this::jiraWorkflowToWorkflowBean));
    }

    private WorkflowBean jiraWorkflowToWorkflowBean(JiraWorkflow jiraWorkflow) {
        String name = jiraWorkflow.getName();
        String description = jiraWorkflow.getDescription();
        int steps = jiraWorkflow.getDescriptor().getSteps().size();
        boolean isDefault = jiraWorkflow.isDefault();
        String updateDate = jiraWorkflow.getUpdatedDate() != null ? this.dateTimeFormatter.forLoggedInUser().format(jiraWorkflow.getUpdatedDate()) : null;
        ApplicationUser updateAuthor = jiraWorkflow.getUpdateAuthor();
        String updateAuthorName = this.userManager.isUserExisting(updateAuthor) ? updateAuthor.getDisplayName() : null;
        return new WorkflowBean(name, description, updateDate, updateAuthorName, steps, isDefault);
    }
}

